/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class ExistenceCheckNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "existenceCheck";
    private static final String PARAM_FILE = "file";
    private static final String PARAM_VARIABLE = "variable";

    public ExistenceCheckNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    protected NodeHandlerResults createNodeHandlerResults() {
        return new DefaultNodeHandlerResults();
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        String origVar = node.getAttributeValue(PARAM_VARIABLE);
        String var = session.replaceVariables(origVar);
        if (!DProUtil.isValidVariableName(var)) {
            ResourceBundle msg = runner.getErrorBundle();
            String desc = msg.getString("Error.InvalidVarName.fmt.txt");
            desc = MessageFormat.format(desc, this.getHandledNodeType(), origVar, var);
            throw new InvalidContractException(desc, contract);
        }
        String existance = "true";
        List children = node.getChildren();
        for (Element child : children) {
            FileSet fs;
            FileList fl;
            String orig;
            String name = child.getName();
            if (PARAM_FILE.equals(name)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                orig = child.getAttributeValue("container");
                ContainerContext cc = this.getContainerContextChecked(orig, session, runner, contract);
                String file = child.getText();
                file = session.replaceVariables(file);
                try {
                    if (ProviderFactory.isLocalProvider(cc.getProviderName())) {
                        File f = new File(cc.getDirectory(), file);
                        existance = f.exists() ? "true" : "false";
                        continue;
                    }
                    if (cc.getFileExists(file)) continue;
                    existance = "false";
                    break;
                }
                catch (RemoteException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new InvalidContractException(contract, (Throwable)e);
                }
            }
            if ("fileListRef".equals(name)) {
                FileList fl2;
                Provider p;
                if (!this.checkIfAttribute(child, session, contract) || (p = ProviderFactory.getProvider((fl2 = this.getFileListChecked(orig = child.getAttributeValue("refId"), session, runner, contract, true)).getProvider())).getFileListExists(fl2)) continue;
                existance = "false";
                break;
            }
            if (!"fileSetRef".equals(name) || !this.checkIfAttribute(child, session, contract) || !(fl = (fs = this.getFileSetChecked(orig = child.getAttributeValue("refId"), session, runner, contract, true)).getMatchingFiles()).isEmpty()) continue;
            existance = "false";
            break;
        }
        session.setVariableValue(var, existance);
        NodeHandlerResults res = this.createNodeHandlerResults();
        return res;
    }
}

