/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.messages.ResultsMessageImpl;
import com.sas.dpro.contract.parser.AbstractResultsActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.controller.HonorContractContext;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;

public class EndResultsNodeHandler
extends AbstractResultsActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "endResults";

    public EndResultsNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        String orig = node.getAttributeValue("id");
        String id = session.replaceVariables(orig);
        StringBuilder paramXML = new StringBuilder("<params>\n");
        XMLOutputter outputter = new XMLOutputter();
        for (Element child : node.getChildren()) {
            String childName = child.getName();
            if (!"params".equals(childName)) continue;
            for (Element e : child.getChildren()) {
                String eName = e.getName();
                if (!"param".equals(eName)) continue;
                orig = e.getAttributeValue("name");
                String paramName = session.replaceVariables(orig);
                e.setAttribute("name", paramName);
                orig = e.getText();
                String value = session.replaceVariables(orig);
                e.setText(value);
                String str = outputter.outputString(e);
                paramXML.append('\t').append(str).append('\n');
            }
        }
        paramXML.append("</params>").append("\n\n");
        HonorContractContext hcc = session.getHonorContractContext();
        ResultsMessageImpl rm = new ResultsMessageImpl(hcc, 3);
        rm.setResultID(id);
        rm.setResultXML(paramXML.toString());
        session.getMessageQueue().enqueue(rm);
        DefaultNodeHandlerResults results = new DefaultNodeHandlerResults();
        return results;
    }
}

