/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.DirList;
import com.sas.dpro.common.DirSet;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.SerializableMap;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultInternalServiceNodeHandler;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class EchoNodeHandler
extends DefaultInternalServiceNodeHandler {
    private static final String EMPTY_STRING = "";
    private static final String MSG = "com.sas.dpro.contract.parser.EchoNodeHandler";

    public EchoNodeHandler() {
        super("Echo");
    }

    private void errorMultipleMessages(String type1, String type2, File contract) throws InvalidContractException {
        ResourceBundle msg = ResourceBundle.getBundle(MSG);
        String desc = msg.getString("Error.MultipleMessageTypes.fmt.txt");
        desc = MessageFormat.format(desc, type1, type2);
        throw new InvalidContractException(desc, contract);
    }

    @Override
    protected void handleExtra(Element node, ContractRunner runner, ContractSession session, File contract, SerializableMap params) throws IOException, InvalidContractException {
        String text;
        String fileSetID;
        String fileListID;
        String fileName;
        String dirSetID;
        String msgSpecified = null;
        String fileEncoding = null;
        String destFileEncoding = null;
        String dirListID = (String)params.get("dirList");
        if (dirListID != null) {
            DirList dl = this.getDirListChecked(dirListID, session, runner, contract, false);
            params.put("dirList", dl);
            msgSpecified = "dirList";
        }
        if ((dirSetID = (String)params.get("dirSet")) != null) {
            if (msgSpecified != null) {
                this.errorMultipleMessages(msgSpecified, "dirSet", contract);
            }
            DirSet ds = this.getDirSetChecked(dirSetID, session, runner, contract, false);
            params.put("dirSet", ds);
            msgSpecified = "dirSet";
        }
        if ((fileName = (String)params.get("file")) != null) {
            if (msgSpecified != null) {
                this.errorMultipleMessages(msgSpecified, "file", contract);
            }
            msgSpecified = "file";
        }
        if ((fileListID = (String)params.get("fileList")) != null) {
            if (msgSpecified != null) {
                this.errorMultipleMessages(msgSpecified, "fileList", contract);
            }
            FileList fl = this.getFileListChecked(fileListID, session, runner, contract, false);
            params.put("fileList", fl);
            msgSpecified = "fileList";
        }
        if ((fileSetID = (String)params.get("fileSet")) != null) {
            if (msgSpecified != null) {
                this.errorMultipleMessages(msgSpecified, "fileSet", contract);
            }
            FileSet fs = this.getFileSetChecked(fileSetID, session, runner, contract, false);
            params.put("fileSet", fs);
            msgSpecified = "fileSet";
        }
        if ((text = node.getText()) != null && !EMPTY_STRING.equals(text)) {
            if (msgSpecified != null) {
                this.errorMultipleMessages(msgSpecified, "Text", contract);
            }
            text = session.replaceVariables(text);
            params.put("message", text);
            msgSpecified = "Text";
        }
        if (msgSpecified == null) {
            params.put("message", EMPTY_STRING);
        }
        if ((fileEncoding = (String)params.get("fileEncoding")) != null) {
            if (msgSpecified == null || !msgSpecified.equals("file")) {
                ResourceBundle msg = ResourceBundle.getBundle(MSG);
                String desc = msg.getString("Error.InputFileEncoding.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType(), "fileEncoding", "file");
                throw new InvalidContractException(desc, contract);
            }
            params.put("fileEncoding", fileEncoding);
        }
        if ((destFileEncoding = (String)params.get("destEncoding")) != null) {
            String dest = (String)params.get("dest");
            if (dest == null || !dest.startsWith("file:///")) {
                ResourceBundle msg = ResourceBundle.getBundle(MSG);
                String desc = msg.getString("Error.OutputFileEncoding.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType(), "destEncoding");
                throw new InvalidContractException(desc, contract);
            }
            params.put("destEncoding", destFileEncoding);
        }
    }

    @Override
    protected void postProcessing(ContractRunner runner, ContractSession session, File contract, SerializableMap params, DefaultNodeHandlerResults results) throws ServiceFailedException, InvalidContractException {
        String dest = (String)params.get("dest");
        if (dest != null && dest.startsWith("variable:///")) {
            String orig = dest.substring("variable:///".length());
            String varName = session.replaceVariables(orig);
            if (!DProUtil.isValidVariableName(varName)) {
                ResourceBundle msg = runner.getErrorBundle();
                String desc = msg.getString("Error.InvalidVarName.fmt.txt");
                desc = MessageFormat.format(desc, "Echo", orig, varName);
                throw new InvalidContractException(desc, contract);
            }
            String value = null;
            if (results.getServiceResults() != null) {
                value = results.getServiceResults().getStdout();
            }
            session.setVariableValue(varName, value);
        }
    }
}

