/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.ContractSyntaxException;
import com.sas.dpro.common.DirSet;
import com.sas.dpro.common.DirSetImpl;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.common.PatternSetImpl;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.DirListNodeHandler;
import com.sas.dpro.contract.parser.FileSetNodeHandler;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import org.jdom2.Element;

public class DirSetNodeHandler
extends DirListNodeHandler {
    public static final String HANDLED_NODE_TYPE = "dirSet";

    public DirSetNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    protected DirSet getDirSet(Element node, ContractRunner runner, ContractSession session, File contract) throws RemoteException, ContractSyntaxException, InvalidContractException {
        String orig = node.getAttributeValue("container");
        ContainerContext cc = this.getContainerContextChecked(orig, session, runner, contract);
        String provider = cc.getProviderName();
        String dir = cc.getDirectory();
        orig = node.getAttributeValue("subDir");
        if (orig != null) {
            String subdir = session.replaceVariables(orig);
            try {
                dir = this.addSubDir(dir, subdir, runner, contract);
            }
            catch (IOException ioe) {
                throw new InvalidContractException(ioe);
            }
        }
        String id = node.getAttributeValue("id");
        id = session.replaceVariables(id);
        this.ensureNonNullAttr(id, runner, contract, "id");
        DirSetImpl dirSet = new DirSetImpl(dir, provider, id);
        FileSetNodeHandler.parseIncludeExcludes(node, runner, session, contract, this.getHandledNodeType(), (PatternSetImpl)dirSet);
        return dirSet;
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        DirSet dirSet = this.getDirSet(node, runner, session, contract);
        session.addDirSet(dirSet);
        return new DefaultNodeHandlerResults();
    }
}

