/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.ContractNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class DirNameNodeHandler
implements ContractNodeHandler {
    public static final String HANDLED_NODE_TYPE = "dirName";
    private static final String ATTR_CONTAINER = "container";
    private static final String ATTR_FILE = "file";
    private static final String ATTR_VARIABLE = "variable";

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        String varName = node.getAttributeValue(ATTR_VARIABLE);
        varName = session.replaceVariables(varName);
        String fileName = node.getAttributeValue(ATTR_FILE);
        fileName = session.replaceVariables(fileName);
        String container = node.getAttributeValue(ATTR_CONTAINER);
        ContainerContext cc = session.getContainerContext(container = session.replaceVariables(container));
        if (cc == null) {
            ResourceBundle msg = runner.getErrorBundle();
            String desc = msg.getString("Error.NoSuchContainerContext.fmt.txt");
            desc = MessageFormat.format(desc, HANDLED_NODE_TYPE, container);
            throw new NodeHandlerException(desc);
        }
        try {
            fileName = cc.getAbsoluteFilePath(fileName);
        }
        catch (Exception e) {
            throw new NodeHandlerException(e);
        }
        File file = new File(fileName);
        session.setVariableValue(varName, file.getParent());
        return new DefaultNodeHandlerResults();
    }
}

