/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.common.SerializableHashMap;
import com.sas.dpro.common.SerializableMap;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.contract.parser.AbstractServiceNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.provider.ServiceRequestParmsImpl;
import com.sas.dpro.service.ServiceParmsImpl;
import com.sas.dpro.service.ServiceResults;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class DefaultInternalServiceNodeHandler
extends AbstractServiceNodeHandler {
    private static final String ERROR_MSG = "com.sas.dpro.contract.parser.DefaultInternalServiceNodeHandler";

    public DefaultInternalServiceNodeHandler(String handledNodeType) {
        super(handledNodeType);
    }

    protected ContainerContext getContainer(ContractSession session, String nodeName, SerializableMap params) throws InvalidContractException {
        ContainerContext container = session.getDefaultContainer();
        Object temp = params.get("container");
        if (temp != null && (container = session.getContainerContext((String)temp)) == null) {
            ResourceBundle msg = this.getErrorBundle();
            String key = "Error.NoSuchContainer.fmt.txt";
            String desc = DProUtil.formatString(msg, key, nodeName, temp);
            throw new InvalidContractException(desc);
        }
        return container;
    }

    protected ResourceBundle getErrorBundle() {
        return ResourceBundle.getBundle(ERROR_MSG);
    }

    protected SerializableMap handleAttributes(List attributeList, ContractRunner runner, ContractSession session, File contract) throws IOException, InvalidContractException {
        SerializableHashMap params = new SerializableHashMap();
        for (Attribute a : attributeList) {
            String name = a.getName();
            String value = session.replaceVariables(a.getValue());
            params.put(name, value);
        }
        return params;
    }

    protected void handleChildNodes(List childNodeList, ContractRunner runner, ContractSession session, File contract, SerializableMap params) throws IOException, InvalidContractException {
    }

    protected void handleExtra(Element node, ContractRunner runner, ContractSession session, File contract, SerializableMap params) throws IOException, InvalidContractException {
    }

    @Override
    public final NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        if (!this.checkIfAttribute(node, session, contract)) {
            return new DefaultNodeHandlerResults();
        }
        List attributeList = node.getAttributes();
        SerializableMap params = this.handleAttributes(attributeList, runner, session, contract);
        this.handleChildNodes(node.getChildren(), runner, session, contract, params);
        this.handleExtra(node, runner, session, contract, params);
        ServiceResults sr = null;
        sr = this.runService(runner, session, contract, node, params);
        DefaultNodeHandlerResults res = new DefaultNodeHandlerResults(sr);
        this.postProcessing(runner, session, contract, params, res);
        return res;
    }

    protected void postProcessing(ContractRunner runner, ContractSession session, File contract, SerializableMap params, DefaultNodeHandlerResults results) throws ServiceFailedException, InvalidContractException {
    }

    protected final ServiceResults runService(ContractRunner runner, ContractSession session, File contract, Element node, SerializableMap params) throws IOException, RemoteException, InvalidContractException, ServiceFailedException {
        ContainerContext container = this.getContainer(session, node.getName(), params);
        params.remove("container");
        String rcStr = (String)params.remove("rc");
        String rcVar = (String)params.remove("rcVar");
        String failIfFailStr = (String)params.remove("failIfFailure");
        String failIfTimeoutStr = (String)params.remove("failIfTimeOut");
        String serviceName = node.getName();
        String providerName = container.getProviderName();
        String timeoutStr = (String)params.remove("timeOut");
        long timeout = this.getTimeoutChecked(timeoutStr, runner, contract);
        Provider p = ProviderFactory.getProvider(providerName);
        ServiceRequestParmsImpl srp = new ServiceRequestParmsImpl();
        srp.setClientDPROVersion(runner.getClientDPROVersion());
        srp.setContainerContext(container);
        srp.setFailIfFailure(Boolean.parseBoolean(failIfFailStr));
        srp.setFailIfTimeout(Boolean.parseBoolean(failIfTimeoutStr));
        srp.setReturnServiceResults(true);
        srp.setServiceName(serviceName);
        ServiceParmsImpl sp = new ServiceParmsImpl();
        sp.params = params;
        srp.setServiceParameters(sp);
        srp.setTimeout(timeout);
        ServiceResults res = p.serviceRequest(srp);
        String rc = res.getStatusString();
        if (rcVar != null) {
            session.setVariableValue(rcVar, rc);
        }
        this.checkReturnCode(serviceName, runner, contract, res, rcStr);
        return res;
    }
}

