/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.messages.CreateReportMessageImpl;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.controller.HonorContractContext;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import org.jdom2.Element;

public class CreateReportNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "createReport";
    private static final String ELEM_DIR = "dir";
    private static final String ELEM_FROM_RESULTS = "fromResults";
    private static final String ELEM_REPORT_TYPE = "reportType";
    private static final String PARAM_CLEAN = "clean";
    private static final String PARAM_DELETE_RESULTS = "delete";
    private static final String PARAM_INCLUDE_RESULTS_OUTPUT = "includeResultsOutput";
    private static final String PARAM_INCLUDE_RESULTS_XML = "includeResultsXML";
    private static final String PARAM_RESULTS = "results";
    private static final String PARAM_REPORT_ENCODING = "fileEncoding";
    private static final String PARAM_REPORT_ID = "reportID";

    public CreateReportNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        if (!this.checkIfAttribute(node, session, contract)) {
            return new DefaultNodeHandlerResults();
        }
        String orig = node.getAttributeValue(PARAM_RESULTS);
        String resultsID = session.replaceVariables(orig);
        boolean deleteResults = true;
        orig = node.getAttributeValue(PARAM_REPORT_ID);
        String reportID = session.replaceVariables(orig);
        orig = node.getAttributeValue(PARAM_REPORT_ENCODING);
        String reportEncoding = session.replaceVariables(orig);
        String dir = null;
        boolean clean = true;
        String reportType = null;
        boolean includeResultsOutput = true;
        boolean includeResultsXML = true;
        for (Element child : node.getChildren()) {
            String value;
            String childName = child.getName();
            if (ELEM_FROM_RESULTS.equals(childName)) {
                orig = child.getAttributeValue(PARAM_RESULTS);
                resultsID = session.replaceVariables(orig);
                orig = child.getAttributeValue(PARAM_DELETE_RESULTS);
                if (orig == null) continue;
                String val = session.replaceVariables(orig);
                deleteResults = runner.ensureBoolean(val, this.getHandledNodeType(), PARAM_DELETE_RESULTS, orig);
                continue;
            }
            if (ELEM_DIR.equals(childName)) {
                orig = child.getText();
                dir = session.replaceVariables(orig);
                orig = child.getAttributeValue(PARAM_CLEAN);
                if (orig == null) continue;
                value = session.replaceVariables(orig);
                clean = runner.ensureBoolean(value, this.getHandledNodeType(), PARAM_CLEAN, orig);
                continue;
            }
            if (PARAM_INCLUDE_RESULTS_OUTPUT.equals(childName)) {
                orig = child.getText();
                value = session.replaceVariables(orig);
                includeResultsOutput = runner.ensureBoolean(value, this.getHandledNodeType(), PARAM_INCLUDE_RESULTS_OUTPUT, orig);
                orig = child.getAttributeValue(PARAM_INCLUDE_RESULTS_XML);
                if (orig == null) continue;
                value = session.replaceVariables(orig);
                includeResultsXML = runner.ensureBoolean(value, this.getHandledNodeType(), PARAM_INCLUDE_RESULTS_XML, orig);
                continue;
            }
            if (!ELEM_REPORT_TYPE.equals(childName)) continue;
            orig = child.getText();
            reportType = session.replaceVariables(orig);
        }
        HonorContractContext hcc = session.getHonorContractContext();
        CreateReportMessageImpl crm = new CreateReportMessageImpl(hcc, resultsID, reportID);
        crm.setReportDirectory(dir);
        crm.setCleanReportDirectory(clean);
        crm.setDeleteResults(deleteResults);
        crm.setIncludeResults(includeResultsOutput);
        crm.setIncludeResultsXML(includeResultsXML);
        crm.setReportFileEncoding(reportEncoding);
        crm.setReportType(reportType);
        session.getMessageQueue().enqueue(crm);
        return new DefaultNodeHandlerResults();
    }
}

