/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.ContractSyntaxException;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.ErrorInfo;
import com.sas.dpro.common.ErrorInfoImpl;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.Macro;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.common.WorkUnit;
import com.sas.dpro.contract.messages.ContractCompletedMessage;
import com.sas.dpro.contract.messages.ContractCompletedMessageImpl;
import com.sas.dpro.contract.messages.ServiceCompletedMessageImpl;
import com.sas.dpro.contract.messages.WorkUnitCompletedMessageImpl;
import com.sas.dpro.contract.parser.AbstractContractNodeHandler;
import com.sas.dpro.contract.parser.ContractEntityResolver;
import com.sas.dpro.contract.parser.ContractNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.NodeHandlerManager;
import com.sas.dpro.contract.parser.NodeHandlerManagerImpl;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.controller.HonorContractContext;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.service.ServiceResults;
import com.sas.dpro.service.standard.Mail;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.EntityResolver;

public class ContractRunnerImpl
implements ContractRunner {
    private ContractSession session;
    private File contract;
    private String contractCode;
    private String clientVersion;
    private NodeHandlerManager nodeHandlerManager;
    private Set importableFileListSet;
    private Set importableFileSetSet;
    private Set importableMacroSet;
    private Set importableVarSet;
    private static final String DEFAULT_TIMEOUT = "defaultTimeOut";
    private static final String ELEM_FILE_LIST = "fileList";
    private static final String ELEM_FILE_LISTS = "fileLists";
    private static final String ELEM_FILE_SET = "fileSet";
    private static final String ELEM_FILE_SETS = "fileSets";
    private static final String ELEM_IMPORTABLES = "importables";
    private static final String ELEM_MACRO = "macro";
    private static final String ELEM_MACRO_GROUP = "macros";
    private static final String ELEM_MACROS = "macros";
    private static final String ELEM_MAIN_METHOD = "main";
    private static final String ELEM_VARIABLE = "variable";
    private static final String ELEM_VARIABLES = "variables";
    private static final String NOTIFY_ON_ERROR = "notifyOnError";
    private static final String VERSION = "version";
    private static final String ERROR_MSG = "com.sas.dpro.contract.parser.ContractRunner";

    public ContractRunnerImpl(ContractSession session, String clientVersion) {
        this.session = session;
        this.clientVersion = clientVersion;
        this.nodeHandlerManager = new NodeHandlerManagerImpl();
    }

    private ContractCompletedMessage checkThreadInterruption() {
        ContractCompletedMessage ccm = null;
        if (Thread.currentThread().isInterrupted()) {
            if (this.session.getContractTimedOut()) {
                ccm = this.createTimeoutCCM();
            } else {
                ResourceBundle msg = this.getErrorBundle();
                String desc = msg.getString("Error.ThreadInterrupted.fmt.txt");
                String providerName = this.session.getHonorContractContext().getProviderName();
                if (providerName == null) {
                    providerName = "server-local";
                }
                String contractFile = null;
                if (this.contract != null) {
                    contractFile = this.contract.getAbsolutePath();
                }
                desc = MessageFormat.format(desc, contractFile, providerName);
                ccm = this.createErrorCCM(new InterruptedException(desc));
            }
        }
        return ccm;
    }

    private ContractCompletedMessage createErrorCCM(Throwable t) {
        ContractCompletedMessageImpl ccm = new ContractCompletedMessageImpl(this.session.getHonorContractContext());
        ErrorInfoImpl ei = new ErrorInfoImpl(ProviderFactory.getLocalProviderName(), t);
        ccm.setErrorInfo(ei);
        return ccm;
    }

    private SAXBuilder createSAXBuilder() throws IOException {
        boolean validate = true;
        SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", validate);
        if (validate) {
            builder.setFeature("http://apache.org/xml/features/validation/schema", true);
            builder.setEntityResolver((EntityResolver)new ContractEntityResolver());
        }
        return builder;
    }

    private ContractCompletedMessage createSuccessCCM() {
        ContractCompletedMessageImpl ccm = new ContractCompletedMessageImpl(this.session.getHonorContractContext());
        this.setImportableValues(ccm);
        return ccm;
    }

    private ContractCompletedMessage createTimeoutCCM() {
        ContractCompletedMessageImpl ccm = new ContractCompletedMessageImpl(this.session.getHonorContractContext());
        ccm.setTimeout(true);
        return ccm;
    }

    @Override
    public boolean ensureBoolean(String value, String tag, String attr, String orig) throws InvalidContractException {
        String b;
        if (value == null) {
            value = "false";
        }
        if (!"true".equals(b = value.toLowerCase().trim()) && !"false".equals(b)) {
            String desc = this.getErrorBundle().getString("Error.InvalidBoolean.fmt.txt");
            desc = MessageFormat.format(desc, attr, tag, orig, value);
            throw new InvalidContractException(desc);
        }
        return Boolean.parseBoolean(b);
    }

    @Override
    public String getClientDPROVersion() {
        return this.clientVersion;
    }

    @Override
    public ResourceBundle getErrorBundle() {
        return ResourceBundle.getBundle(ERROR_MSG);
    }

    @Override
    public Pattern getPattern(String handledNodeName, String regex, String orig, String attrName, boolean ignoreCase, File contract) throws InvalidContractException {
        int flags = 0;
        if (ignoreCase) {
            flags |= 0x42;
        }
        try {
            return Pattern.compile(regex, flags);
        }
        catch (PatternSyntaxException pse) {
            ResourceBundle msg = this.getErrorBundle();
            String desc = msg.getString("Error.InvalidRegexPattern.fmt.txt");
            desc = MessageFormat.format(desc, handledNodeName, attrName, regex, orig);
            throw new InvalidContractException(desc, contract, pse);
        }
    }

    @Override
    public boolean getSupportsDPROVersion(String version) {
        if (version == null) {
            version = "1.6.00";
        }
        return version.startsWith("1.5") || version.startsWith("1.6");
    }

    private void handleImportableFileListsNode(Element node, ContractSession session, File contract) throws ContractSyntaxException {
        if (!AbstractContractNodeHandler.checkIfAttribute(node, ELEM_FILE_LISTS, session, contract)) {
            return;
        }
        for (Element e : node.getChildren()) {
            String name = e.getName();
            if (!ELEM_FILE_LIST.equals(name) || !AbstractContractNodeHandler.checkIfAttribute(e, ELEM_FILE_LIST, session, contract)) continue;
            String orig = e.getAttributeValue("refId");
            String refId = session.replaceVariables(orig);
            if (this.importableFileListSet == null) {
                this.importableFileListSet = new TreeSet();
            }
            this.importableFileListSet.add(refId);
        }
    }

    private void handleImportableFileSetsNode(Element node, ContractSession session, File contract) throws ContractSyntaxException {
        if (!AbstractContractNodeHandler.checkIfAttribute(node, ELEM_FILE_SETS, session, contract)) {
            return;
        }
        for (Element e : node.getChildren()) {
            String name = e.getName();
            if (!ELEM_FILE_SET.equals(name) || !AbstractContractNodeHandler.checkIfAttribute(e, ELEM_FILE_SET, session, contract)) continue;
            String orig = e.getAttributeValue("refId");
            String refId = session.replaceVariables(orig);
            if (this.importableFileSetSet == null) {
                this.importableFileSetSet = new TreeSet();
            }
            this.importableFileSetSet.add(refId);
        }
    }

    private void handleImportableMacrosNode(Element node, ContractSession session, File contract) throws ContractSyntaxException {
        if (!AbstractContractNodeHandler.checkIfAttribute(node, "macros", session, contract)) {
            return;
        }
        for (Element e : node.getChildren()) {
            String name = e.getName();
            if (!ELEM_MACRO.equals(name) || !AbstractContractNodeHandler.checkIfAttribute(e, ELEM_MACRO, session, contract)) continue;
            String orig = e.getAttributeValue("refId");
            String refId = session.replaceVariables(orig);
            if (this.importableMacroSet == null) {
                this.importableMacroSet = new TreeSet();
            }
            this.importableMacroSet.add(refId);
        }
    }

    private void handleImportableVarsNode(Element node, ContractSession session, File contract) throws ContractSyntaxException {
        if (!AbstractContractNodeHandler.checkIfAttribute(node, ELEM_VARIABLES, session, contract)) {
            return;
        }
        for (Element e : node.getChildren()) {
            String name = e.getName();
            if (!ELEM_VARIABLE.equals(name) || !AbstractContractNodeHandler.checkIfAttribute(e, ELEM_VARIABLE, session, contract)) continue;
            String var = e.getText();
            var = session.replaceVariables(var);
            if (this.importableVarSet == null) {
                this.importableVarSet = new TreeSet();
            }
            this.importableVarSet.add(var);
        }
    }

    private static final boolean isServiceTag(String tag) {
        return tag != null && tag.length() > 0 && Character.isUpperCase(tag.charAt(0));
    }

    private void notifyViaEmail(String addresses, ContractCompletedMessage ccm) {
        if (addresses != null && addresses.length() > 0 && ccm != null) {
            StringBuilder body = new StringBuilder();
            StringBuilder htmlBody = new StringBuilder("<html><body>");
            String[] attachments = null;
            ContainerContext[] attachmentCCs = null;
            HonorContractContext hcc = ccm.getHonorContractContext();
            StringBuilder generalInfo = new StringBuilder();
            generalInfo.append("Contract: ").append(hcc.getContract()).append('\n');
            generalInfo.append("Server:   ").append(hcc.getProviderName()).append('\n');
            generalInfo.append("Server DPRO version: ").append(hcc.getProviderDPROVersion()).append('\n');
            generalInfo.append("Client DPRO version: ").append(hcc.getClientDPROVersion()).append('\n');
            generalInfo.append('\n');
            StringBuilder generalInfoHTML = new StringBuilder();
            generalInfoHTML.append("Contract: ").append(hcc.getContract()).append("<br>");
            generalInfoHTML.append("Server:   ").append(hcc.getProviderName()).append("<br>");
            generalInfoHTML.append("Server DPRO version: ").append(hcc.getProviderDPROVersion()).append("<br>");
            generalInfoHTML.append("Client DPRO version: ").append(hcc.getClientDPROVersion()).append("<br>");
            generalInfoHTML.append("<br>");
            if (ccm.isError()) {
                String command;
                String stackTrace;
                String error;
                String server;
                ErrorInfo ei = ccm.getErrorInfo();
                body.append("A DPRO contract terminated with an error:\n\n");
                body.append((CharSequence)generalInfo);
                if (ei == null) {
                    body.append("<No error info available!>\n");
                } else {
                    server = ei.getErrorDPROServer();
                    error = ei.getErrorMessage();
                    stackTrace = ei.getErrorStackTrace();
                    command = ei.getCommandExecuted();
                    body.append("Server: ").append(server).append('\n');
                    body.append("Error: ").append(error).append('\n');
                    if (command != null) {
                        body.append("Command: ").append(command).append('\n');
                    }
                    body.append("Details: ").append(stackTrace).append('\n');
                }
                htmlBody.append("A DPRO contract terminated with an error:<p>");
                htmlBody.append((CharSequence)generalInfoHTML);
                if (ei == null) {
                    htmlBody.append("<em>&lt;No error info available!&gt;</em><br>");
                } else {
                    server = ei.getErrorDPROServer();
                    error = ei.getErrorMessage();
                    stackTrace = ei.getErrorStackTrace();
                    command = ei.getCommandExecuted();
                    htmlBody.append("Server: ").append(server).append("<br>");
                    htmlBody.append("Error: ").append(error).append("<br>");
                    if (command != null) {
                        htmlBody.append("Command: ").append(command).append("<br>");
                    }
                    htmlBody.append("Details: ").append("<br><pre>").append(stackTrace).append("</pre>");
                }
            } else if (ccm.isTimeout()) {
                body.append("A DPRO contract timed out:\n\n");
                body.append((CharSequence)generalInfo);
                htmlBody.append("A DPRO contract timed out:<p>");
                htmlBody.append((CharSequence)generalInfoHTML);
            } else {
                body.append("The DPRO contract terminated normally.");
                body.append((CharSequence)generalInfo);
                htmlBody.append("The DPRO contract terminated normally.<p>");
                htmlBody.append((CharSequence)generalInfoHTML);
            }
            htmlBody.append("</body></html>");
            String smtpServer = null;
            String to = addresses;
            String from = "\"Deployment Tester Server\" <noreply@sas.com>";
            String cc = null;
            String bcc = null;
            String subject = "DPRO Server Error Notification";
            try {
                Mail.send(smtpServer, to, from, cc, bcc, subject, body.toString(), htmlBody.toString(), attachments, attachmentCCs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public ContractCompletedMessage runContract(File contract) {
        this.contract = contract;
        this.contractCode = null;
        if (!contract.exists()) {
            ResourceBundle msg = this.getErrorBundle();
            String key = "Error.FileDoesNotExist.fmt.txt";
            String desc = DProUtil.formatString(msg, key, contract.getAbsolutePath());
            return this.createErrorCCM(new InvalidContractException(desc, contract));
        }
        if (!contract.isFile()) {
            ResourceBundle msg = this.getErrorBundle();
            String key = "Error.InvalidFile.fmt.txt";
            String desc = DProUtil.formatString(msg, key, contract.getAbsolutePath());
            return this.createErrorCCM(new InvalidContractException(desc, contract));
        }
        try {
            SAXBuilder builder = this.createSAXBuilder();
            Document contract_xml = builder.build(contract);
            return this.runContractCode(contract_xml);
        }
        catch (IOException ioe) {
            return this.createErrorCCM(ioe);
        }
        catch (InvalidContractException ice) {
            return this.createErrorCCM(ice);
        }
        catch (ServiceFailedException sfe) {
            return this.createErrorCCM(sfe);
        }
        catch (NodeHandlerException nhe) {
            return this.createErrorCCM(nhe);
        }
        catch (JDOMException je) {
            return this.createErrorCCM(je);
        }
    }

    @Override
    public ContractCompletedMessage runContract(String xml) {
        this.contract = null;
        this.contractCode = xml;
        try {
            BufferedReader r = new BufferedReader(new StringReader(xml));
            SAXBuilder builder = this.createSAXBuilder();
            Document contract_xml = builder.build((Reader)r);
            r.close();
            ContractCompletedMessage ccm = this.runContractCode(contract_xml);
            return ccm;
        }
        catch (IOException ioe) {
            return this.createErrorCCM(ioe);
        }
        catch (InvalidContractException ice) {
            return this.createErrorCCM(ice);
        }
        catch (ServiceFailedException sfe) {
            return this.createErrorCCM(sfe);
        }
        catch (NodeHandlerException nhe) {
            return this.createErrorCCM(nhe);
        }
        catch (JDOMException je) {
            return this.createErrorCCM(je);
        }
    }

    private ContractCompletedMessage runContractCode(Document contract_xml) throws IOException, InvalidContractException, ServiceFailedException, NodeHandlerException, JDOMException {
        Element root = contract_xml.getRootElement();
        String version = root.getAttributeValue(VERSION);
        if (version == null || !"1.0".equals(version)) {
            ResourceBundle msg = this.getErrorBundle();
            String key = "Error.UnsupportedVersion.fmt.txt";
            String desc = DProUtil.formatString(msg, key, version);
            return this.createErrorCCM(new InvalidContractException(desc, this.contract));
        }
        String schemaVersion = null;
        List attrs = root.getAttributes();
        for (Attribute attr : attrs) {
            if (!attr.getName().endsWith("SchemaLocation")) continue;
            String value = attr.getValue();
            if (value.endsWith("contract-1.6.xsd")) {
                schemaVersion = "1.6";
                continue;
            }
            if (value.endsWith("contract-1.5.xsd")) {
                schemaVersion = "1.5";
                continue;
            }
            ResourceBundle msg = this.getErrorBundle();
            String key = "Error.UnknownSchema.fmt.txt";
            String desc = DProUtil.formatString(msg, key, value);
            return this.createErrorCCM(new InvalidContractException(desc, this.contract));
        }
        if (schemaVersion == null) {
            ResourceBundle msg = this.getErrorBundle();
            String key = "Error.SchemaRequired.txt";
            String desc = msg.getString(key);
            return this.createErrorCCM(new InvalidContractException(desc, this.contract));
        }
        String timeout = root.getAttributeValue(DEFAULT_TIMEOUT);
        if (timeout != null) {
            try {
                int secs = Integer.parseInt(timeout);
                this.session.setTimeout(secs);
            }
            catch (NumberFormatException secs) {
                // empty catch block
            }
        }
        String orig = root.getAttributeValue(NOTIFY_ON_ERROR);
        String emails = this.session.replaceVariables(orig);
        ContractCompletedMessage error = this.checkThreadInterruption();
        if (error != null) {
            this.notifyViaEmail(emails, error);
            return error;
        }
        for (Element child : root.getChildren()) {
            String name = child.getName();
            if (ELEM_IMPORTABLES.equals(name)) {
                for (Element e : child.getChildren()) {
                    name = e.getName();
                    if (ELEM_FILE_LISTS.equals(name)) {
                        this.handleImportableFileListsNode(e, this.session, this.contract);
                        continue;
                    }
                    if (ELEM_FILE_SETS.equals(name)) {
                        this.handleImportableFileSetsNode(e, this.session, this.contract);
                        continue;
                    }
                    if ("macros".equals(name)) {
                        this.handleImportableMacrosNode(e, this.session, this.contract);
                        continue;
                    }
                    if (!ELEM_VARIABLES.equals(name)) continue;
                    this.handleImportableVarsNode(e, this.session, this.contract);
                }
                continue;
            }
            if (ELEM_MACRO.equals(name)) {
                ContractNodeHandler handler = this.nodeHandlerManager.getContractNodeHandler(schemaVersion, name);
                handler.handleNode(child, this, this.session, this.contract);
                continue;
            }
            if ("macros".equals(name)) {
                for (Element child2 : child.getChildren()) {
                    name = child2.getName();
                    if (!ELEM_MACRO.equals(name)) continue;
                    ContractNodeHandler handler = this.nodeHandlerManager.getContractNodeHandler(schemaVersion, name);
                    handler.handleNode(child2, this, this.session, this.contract);
                }
                continue;
            }
            if (!ELEM_MAIN_METHOD.equals(name)) continue;
            try {
                ContractCompletedMessage errorCCM = this.runContractCodeImpl(schemaVersion, child, false);
                if (errorCCM == null) continue;
                this.notifyViaEmail(emails, errorCCM);
                return errorCCM;
            }
            catch (TerminatedEarlyException terminatedEarlyException) {
            }
        }
        ContractCompletedMessage ccm = this.createSuccessCCM();
        return ccm;
    }

    private ContractCompletedMessage runContractCodeImpl(String schemaVersion, Element root, boolean inChooseStatement) throws IOException, InvalidContractException, ServiceFailedException, NodeHandlerException, JDOMException, TerminatedEarlyException {
        List children = root.getChildren();
        int i = 0;
        while (i < children.size()) {
            Element element;
            String elementName;
            ContractNodeHandler handler;
            if ((handler = this.nodeHandlerManager.getContractNodeHandler(schemaVersion, elementName = (element = (Element)children.get(i++)).getName())) != null) {
                ContractCompletedMessage error;
                long startNanos = System.nanoTime();
                NodeHandlerResults nhr = handler.handleNode(element, this, this.session, this.contract);
                long runNanos = System.nanoTime() - startNanos;
                nhr.setExecutionTime(runNanos);
                if (ContractRunnerImpl.isServiceTag(elementName)) {
                    ServiceResults sr = nhr.getServiceResults();
                    ServiceCompletedMessageImpl m = new ServiceCompletedMessageImpl(this.session.getHonorContractContext(), sr);
                    this.session.addServiceResults(m);
                    continue;
                }
                if (nhr.getStopContract()) {
                    error = nhr.getStoppedContractCompletedMessage();
                    if (error != null) {
                        return error;
                    }
                    throw new TerminatedEarlyException();
                }
                if (inChooseStatement && nhr.getShouldParseChildren(this.session, 1)) {
                    error = this.runContractCodeImpl(schemaVersion, element, false);
                    if (error == null) break;
                    return error;
                }
                int iter = 0;
                while (nhr.getShouldParseChildren(this.session, ++iter)) {
                    boolean choose = nhr.isChooseStatement();
                    ContractCompletedMessage error2 = this.runContractCodeImpl(schemaVersion, element, choose);
                    if (error2 != null) {
                        return error2;
                    }
                    error2 = this.checkThreadInterruption();
                    if (error2 == null) continue;
                    return error2;
                }
                if (nhr.isWorkUnit()) {
                    HonorContractContext hcc = this.session.getHonorContractContext();
                    WorkUnit wu = this.session.endWorkUnit();
                    WorkUnitCompletedMessageImpl wucm = new WorkUnitCompletedMessageImpl(hcc, wu);
                    this.session.getMessageQueue().enqueue(wucm);
                }
                if ((error = this.checkThreadInterruption()) == null) continue;
                return error;
            }
            ResourceBundle msg = this.getErrorBundle();
            String key = "Error.TagNotSupported.fmt.txt";
            String desc = DProUtil.formatString(msg, key, elementName);
            return this.createErrorCCM(new ContractSyntaxException(desc, this.contract));
        }
        return null;
    }

    private void setImportableValues(ContractCompletedMessage ccm) {
        int pos;
        if (this.importableFileListSet != null && !this.importableFileListSet.isEmpty()) {
            FileList[] fls = new FileList[this.importableFileListSet.size()];
            pos = 0;
            for (String refId : this.importableFileListSet) {
                FileList fl = this.session.getFileList(refId);
                fls[pos++] = fl;
            }
            ccm.setImportableFileLists(fls);
        }
        if (this.importableFileSetSet != null && !this.importableFileSetSet.isEmpty()) {
            FileSet[] fss = new FileSet[this.importableFileSetSet.size()];
            pos = 0;
            for (String refId : this.importableFileSetSet) {
                FileSet fs = this.session.getFileSet(refId);
                fss[pos++] = fs;
            }
            ccm.setImportableFileSets(fss);
        }
        if (this.importableMacroSet != null && !this.importableMacroSet.isEmpty()) {
            Macro[] macros = new Macro[this.importableMacroSet.size()];
            pos = 0;
            for (String refId : this.importableMacroSet) {
                Macro m = this.session.getMacro(refId);
                macros[pos++] = m;
            }
            ccm.setImportableMacros(macros);
        }
        if (this.importableVarSet != null && !this.importableVarSet.isEmpty()) {
            String[] varArray = new String[this.importableVarSet.size()];
            pos = 0;
            for (String var : this.importableVarSet) {
                String value = this.session.getVariableValue(var);
                varArray[pos++] = value != null ? var + '=' + value : var;
            }
            ccm.setImportableVars(varArray);
        }
    }

    static class TerminatedEarlyException
    extends Exception {
        private static final long serialVersionUID = 1L;

        TerminatedEarlyException() {
        }
    }
}

