/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DirSet;
import com.sas.dpro.common.DirSetImpl;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.FileSetImpl;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.PatternSetImpl;
import com.sas.dpro.common.SerializableMap;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultInternalServiceNodeHandler;
import com.sas.dpro.contract.parser.FileSetNodeHandler;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class ChmodNodeHandler
extends DefaultInternalServiceNodeHandler {
    public static final String HANDLED_NODE_TYPE = "Chmod";
    private static final String ATTR_DIR_SET = "dirSet";
    private static final String ATTR_DIR_SET_REF = "dirSetRef";
    private static final String ATTR_FILE_SET = "fileSet";
    private static final String ATTR_FILE_SET_REF = "fileSetRef";
    private static final String MSG = "com.sas.dpro.contract.parser.ChmodNodeHandler";

    public ChmodNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    @Override
    protected void handleChildNodes(List childNodeList, ContractRunner runner, ContractSession session, File contract, SerializableMap params) throws IOException, InvalidContractException {
        ArrayList<FileSet> fsList = null;
        ArrayList<DirSet> dsList = null;
        ArrayList<Integer> orderList = new ArrayList<Integer>(1);
        for (Element child : childNodeList) {
            String orig;
            String id;
            String subdir;
            String orig2;
            String root;
            String providerName;
            ContainerContext cc;
            String name = child.getName();
            if (ATTR_FILE_SET.equals(name)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                cc = this.getContainer(session, HANDLED_NODE_TYPE, params);
                providerName = cc.getProviderName();
                root = cc.getDirectory();
                orig2 = child.getAttributeValue("subDir");
                if (orig2 != null) {
                    subdir = session.replaceVariables(orig2);
                    root = this.addSubDir(root, subdir, runner, contract);
                }
                id = null;
                FileSetImpl fileSet = new FileSetImpl(root, providerName, id);
                FileSetNodeHandler.parseIncludeExcludes(child, runner, session, contract, this.getHandledNodeType(), (PatternSetImpl)fileSet);
                if (fsList == null) {
                    fsList = new ArrayList(1);
                }
                fsList.add(fileSet);
                orderList.add(new Integer(0));
                continue;
            }
            if (ATTR_FILE_SET_REF.equals(name)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                orig = child.getAttributeValue("refId");
                FileSet fs = this.getFileSetChecked(orig, session, runner, contract, true);
                if (fsList == null) {
                    fsList = new ArrayList<FileSet>(1);
                }
                fsList.add(fs);
                orderList.add(new Integer(0));
                continue;
            }
            if (ATTR_DIR_SET.equals(name)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                cc = this.getContainer(session, this.getHandledNodeType(), params);
                providerName = cc.getProviderName();
                root = cc.getDirectory();
                orig2 = child.getAttributeValue("subDir");
                if (orig2 != null) {
                    subdir = session.replaceVariables(orig2);
                    root = this.addSubDir(root, subdir, runner, contract);
                }
                id = null;
                DirSetImpl dirSet = new DirSetImpl(root, providerName, id);
                FileSetNodeHandler.parseIncludeExcludes(child, runner, session, contract, this.getHandledNodeType(), (PatternSetImpl)dirSet);
                if (dsList == null) {
                    dsList = new ArrayList(1);
                }
                dsList.add(dirSet);
                orderList.add(new Integer(1));
                continue;
            }
            if (!ATTR_DIR_SET_REF.equals(name) || !this.checkIfAttribute(child, session, contract)) continue;
            orig = child.getAttributeValue("refId");
            DirSet ds = this.getDirSetChecked(orig, session, runner, contract, true);
            if (dsList == null) {
                dsList = new ArrayList<DirSet>(1);
            }
            dsList.add(ds);
            orderList.add(new Integer(1));
        }
        if (fsList != null) {
            int count = fsList.size();
            FileSet[] fsArray = new FileSet[count];
            fsArray = fsList.toArray(fsArray);
            params.put("_inputFileSets", fsArray);
        }
        if (dsList != null) {
            int count = dsList.size();
            DirSet[] dsArray = new DirSet[count];
            dsArray = dsList.toArray(dsArray);
            params.put("_inputDirSets", dsArray);
            count = orderList.size();
            int[] orderArray = new int[count];
            for (int i = 0; i < count; ++i) {
                orderArray[i] = (Integer)orderList.get(i);
            }
            params.put("_inputOrder", orderArray);
        }
    }

    @Override
    protected void handleExtra(Element node, ContractRunner runner, ContractSession session, File contract, SerializableMap params) throws IOException, InvalidContractException {
        boolean failIfNoInput = true;
        String orig = node.getAttributeValue("failIfNoInput");
        if (orig != null) {
            String value = session.replaceVariables(orig);
            failIfNoInput = runner.ensureBoolean(value, this.getHandledNodeType(), "failIfNoInput", orig);
        }
        if (failIfNoInput && params.get("_inputDirSets") == null && params.get("_inputFileSets") == null) {
            ResourceBundle msg = ResourceBundle.getBundle(MSG);
            String desc = msg.getString("Error.NoInputFiles.fmt.txt");
            desc = MessageFormat.format(desc, this.getHandledNodeType());
            throw new InvalidContractException(desc, contract);
        }
    }
}

