/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class ChangeCaseNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "changeCase";
    public static final String CASE_LOWER = "lower";
    public static final String CASE_TOGGLE = "toggle";
    public static final String CASE_UPPER = "upper";
    private static final String ATTR_RESULT_VAR = "resultVar";
    private static final String ATTR_TO_CASE = "toCase";
    private static final String ATTR_VAR = "variable";

    public ChangeCaseNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        String orig = node.getAttributeValue(ATTR_VAR);
        String var = this.getVariableNameChecked(orig, true, session, runner, contract);
        String value = session.getVariableValue(var);
        orig = node.getAttributeValue(ATTR_TO_CASE);
        String toCase = session.replaceVariables(orig);
        if (CASE_LOWER.equals(toCase)) {
            value = value.toLowerCase();
        } else if (CASE_UPPER.equals(toCase)) {
            value = value.toUpperCase();
        } else if (CASE_TOGGLE.equals(toCase)) {
            value = ChangeCaseNodeHandler.toggleCase(value);
        } else {
            ResourceBundle msg = runner.getErrorBundle();
            String desc = msg.getString("Error.InvalidAttribute.fmt.txt");
            desc = MessageFormat.format(desc, this.getHandledNodeType(), ATTR_TO_CASE, toCase, orig);
            throw new InvalidContractException(desc, contract);
        }
        String resultVar = var;
        orig = node.getAttributeValue(ATTR_RESULT_VAR);
        if (orig != null) {
            resultVar = this.getVariableNameChecked(orig, false, session, runner, contract);
        }
        session.setVariableValue(resultVar, value);
        return new DefaultNodeHandlerResults();
    }

    public static final String toggleCase(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int count = str.length();
        for (int i = 0; i < count; ++i) {
            char ch = str.charAt(i);
            if (Character.isUpperCase(ch)) {
                sb.append(Character.toLowerCase(ch));
                continue;
            }
            if (Character.isLowerCase(ch)) {
                sb.append(Character.toUpperCase(ch));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

