/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.ContractNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import org.jdom2.Element;

class BaseNameNodeHandler
implements ContractNodeHandler {
    public static final String HANDLED_NODE_TYPE = "baseName";
    private static final String ATTR_FILE = "file";
    private static final String ATTR_SUFFIX = "suffix";
    private static final String ATTR_VARIABLE = "variable";

    BaseNameNodeHandler() {
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        String varName = node.getAttributeValue(ATTR_VARIABLE);
        varName = session.replaceVariables(varName);
        String fileName = node.getAttributeValue(ATTR_FILE);
        fileName = session.replaceVariables(fileName);
        fileName = new File(fileName).getName();
        String suffix = node.getAttributeValue(ATTR_SUFFIX);
        if (suffix != null && (suffix = session.replaceVariables(suffix)).length() > 0) {
            if (suffix.charAt(0) != '.') {
                suffix = '.' + suffix;
            }
            if (fileName.endsWith(suffix)) {
                fileName = fileName.substring(0, fileName.length() - suffix.length());
            }
        }
        session.setVariableValue(varName, fileName);
        DefaultNodeHandlerResults results = new DefaultNodeHandlerResults();
        return results;
    }
}

