/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.ContractSyntaxException;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.DirList;
import com.sas.dpro.common.DirSet;
import com.sas.dpro.common.FileCollection;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.Macro;
import com.sas.dpro.common.Mapper;
import com.sas.dpro.common.MapperImpl;
import com.sas.dpro.common.MapperUtil;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.common.RCRules;
import com.sas.dpro.contract.parser.ContractNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.ExpressionParser;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.service.ServiceResults;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import org.jdom2.Element;

abstract class AbstractContractNodeHandler
implements ContractNodeHandler {
    protected static final String ATTR_COMMON_CHARSET = "characterSet";
    protected static final String ATTR_COMMON_CONTAINER = "container";
    private static final String ATTR_IF = "if";
    protected static final String ATTR_COMMON_REFID = "refId";
    protected static final String ATTR_COMMON_SUBDIR = "subDir";
    protected static final String ATTR_COMMON_TIMEOUT = "timeOut";
    private static final String ATTR_FAIL_IF_EMPTY = "failIfEmpty";
    private static final String ATTR_FROM = "from";
    private static final String ATTR_TO = "to";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_FULL_PATHS = "fullPaths";
    protected static final String PARAM_COMMON_FILE_LIST = "fileList";
    protected static final String PARAM_COMMON_FILE_LIST_REF = "fileListRef";
    protected static final String PARAM_COMMON_FILE_SET_REF = "fileSetRef";
    private static final String PARAM_MAPPER = "mapper";
    private String handledNodeType;

    public AbstractContractNodeHandler(String handledNodeType) {
        this.handledNodeType = handledNodeType;
    }

    private int addFileCollectionImpl(Element node, FileCollection fc, ContractSession session, ContractRunner runner, File contract, List argList, String keyPart) throws InvalidContractException {
        boolean doFail = true;
        String orig = node.getAttributeValue(ATTR_FAIL_IF_EMPTY);
        if (orig != null) {
            String failIfEmpty = session.replaceVariables(orig);
            doFail = runner.ensureBoolean(failIfEmpty, this.getHandledNodeType(), node.getName(), orig);
        }
        if (doFail && fc.isEmpty()) {
            ResourceBundle msg = runner.getErrorBundle();
            String key = "Error.Empty" + keyPart + ".fmt.txt";
            String desc = msg.getString(key);
            String refId = session.replaceVariables(orig);
            desc = MessageFormat.format(desc, node.getName(), refId, orig);
            throw new InvalidContractException(desc, contract);
        }
        boolean fullPaths = true;
        String fullPathStr = node.getAttributeValue(ATTR_FULL_PATHS);
        if (fullPathStr != null) {
            String val = session.replaceVariables(fullPathStr);
            fullPaths = runner.ensureBoolean(val, node.getName(), ATTR_FULL_PATHS, fullPathStr);
        }
        for (int i = 0; i < fc.getSize(); ++i) {
            argList.add(fullPaths ? fc.getAbsolute(i) : fc.get(i));
        }
        return fc.getSize();
    }

    protected String addSubDir(String dir, String subdir, ContractRunner runner, File contract) throws InvalidContractException, IOException {
        return AbstractContractNodeHandler.addSubDir(this.getHandledNodeType(), dir, subdir, runner, contract);
    }

    protected static String addSubDir(String handledNodeType, String dir, String subdir, ContractRunner runner, File contract) throws InvalidContractException, IOException {
        AbstractContractNodeHandler.ensureSubdirIsBelowParent(handledNodeType, dir, subdir, runner, contract);
        dir = dir.endsWith("/") || dir.endsWith("\\") ? dir + subdir : dir + '/' + subdir;
        return dir;
    }

    protected boolean checkIfAttribute(Element elem, ContractSession session, File contract) throws ContractSyntaxException {
        return AbstractContractNodeHandler.checkIfAttribute(elem, this.getHandledNodeType(), session, contract);
    }

    public static boolean checkIfAttribute(Element elem, String handledNodeType, ContractSession session, File contract) throws ContractSyntaxException {
        boolean value = true;
        String orig = elem.getAttributeValue(ATTR_IF);
        if (orig != null) {
            value = ExpressionParser.getInstance().parseBooleanExpression(orig, handledNodeType, session);
        }
        return value;
    }

    protected RCRules createRCRules(String rcStr, File contract) throws InvalidContractException {
        return RCRules.create(rcStr, contract);
    }

    protected void ensureNonNullAttr(String value, ContractRunner runner, File contract, String attrName) throws ContractSyntaxException {
        AbstractContractNodeHandler.ensureNonNullAttr(value, runner, contract, attrName, this.getHandledNodeType());
    }

    protected static void ensureNonNullAttr(String value, ContractRunner runner, File contract, String attrName, String handledNodeType) throws ContractSyntaxException {
        if (value == null) {
            ResourceBundle msg = runner.getErrorBundle();
            String key = "Error.AttributeMissing.fmt.txt";
            String desc = DProUtil.formatString(msg, key, attrName, handledNodeType);
            throw new ContractSyntaxException(desc, contract);
        }
    }

    protected void ensureSubdirIsBelowParent(String dir, String subdir, ContractRunner runner, File contract) throws InvalidContractException, IOException {
        AbstractContractNodeHandler.ensureSubdirIsBelowParent(this.getHandledNodeType(), dir, subdir, runner, contract);
    }

    protected static void ensureSubdirIsBelowParent(String handledNodeType, String dir, String subdir, ContractRunner runner, File contract) throws InvalidContractException, IOException {
        File childFile;
        File dirFile;
        if (dir != null && subdir != null && !DProUtil.isParentDir(dirFile = new File(dir).getAbsoluteFile(), childFile = new File(dirFile, subdir))) {
            ResourceBundle msg = runner.getErrorBundle();
            String key = "Error.SubdirAboveParent.fmt.txt";
            String desc = DProUtil.formatString(msg, key, handledNodeType, dir, subdir);
            throw new InvalidContractException(desc, contract);
        }
    }

    protected boolean getBoolean(String orig, ContractSession session, boolean defaultVal) {
        boolean val = defaultVal;
        if (orig != null) {
            String temp = session.replaceVariables(orig);
            val = Boolean.parseBoolean(temp);
        }
        return val;
    }

    protected Charset getCharsetChecked(String orig, ContractSession session, ContractRunner runner, File contract) throws InvalidContractException {
        return AbstractContractNodeHandler.getCharsetChecked(this.getHandledNodeType(), orig, session, runner, contract);
    }

    protected static Charset getCharsetChecked(String handledNodeType, String orig, ContractSession session, ContractRunner runner, File contract) throws InvalidContractException {
        Charset cs = null;
        String charset = session.replaceVariables(orig);
        if (charset != null && ("UTF-8BOM".equalsIgnoreCase(charset) || "UTF8BOM".equalsIgnoreCase(charset))) {
            charset = "UTF-8";
        }
        if (charset == null || charset.equals("default")) {
            cs = Charset.defaultCharset();
        } else {
            try {
                cs = Charset.forName(charset);
            }
            catch (IllegalCharsetNameException e) {
                ResourceBundle msg = runner.getErrorBundle();
                String key = "Error.IllegalCharsetName.fmt.txt";
                String desc = DProUtil.formatString(msg, key, handledNodeType, charset, orig);
                throw new InvalidContractException(desc, contract, e);
            }
            catch (UnsupportedCharsetException uce) {
                ResourceBundle msg = runner.getErrorBundle();
                String key = "Error.UnsupportedCharset.fmt.txt";
                String desc = DProUtil.formatString(msg, key, handledNodeType, charset, orig);
                throw new InvalidContractException(desc, contract, uce);
            }
        }
        return cs;
    }

    protected ContainerContext getContainerContextChecked(String orig, ContractSession session, ContractRunner runner, File contract) throws InvalidContractException {
        return AbstractContractNodeHandler.getContainerContextChecked(this.getHandledNodeType(), orig, session, runner, contract);
    }

    protected static ContainerContext getContainerContextChecked(String handledNodeType, String orig, ContractSession session, ContractRunner runner, File contract) throws InvalidContractException {
        String container = session.replaceVariables(orig);
        ContainerContext cc = session.getContainerContext(container);
        if (cc == null) {
            ResourceBundle msg = runner.getErrorBundle();
            String key = "Error.NoSuchContainerContext.fmt.txt";
            String desc = DProUtil.formatString(msg, key, handledNodeType, container);
            throw new InvalidContractException(desc, contract);
        }
        return cc;
    }

    protected DirList getDirListChecked(String orig, ContractSession session, ContractRunner runner, File contract, boolean replaceVars) throws InvalidContractException {
        DirList dl = null;
        if (replaceVars) {
            String refid = session.replaceVariables(orig);
            dl = session.getDirList(refid);
            if (dl == null) {
                ResourceBundle msg = runner.getErrorBundle();
                String desc = msg.getString("Error.NoSuchDirList.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType(), refid, orig);
                throw new InvalidContractException(desc, contract);
            }
        } else {
            dl = session.getDirList(orig);
            if (dl == null) {
                ResourceBundle msg = runner.getErrorBundle();
                String desc = msg.getString("Error.NoSuchDirList2.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType(), orig);
                throw new InvalidContractException(desc, contract);
            }
        }
        return dl;
    }

    protected DirSet getDirSetChecked(String orig, ContractSession session, ContractRunner runner, File contract, boolean replaceVars) throws InvalidContractException {
        DirSet ds = null;
        if (replaceVars) {
            String refid = session.replaceVariables(orig);
            ds = session.getDirSet(refid);
            if (ds == null) {
                ResourceBundle msg = runner.getErrorBundle();
                String desc = msg.getString("Error.NoSuchDirSet.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType(), refid, orig);
                throw new InvalidContractException(desc, contract);
            }
        } else {
            ds = session.getDirSet(orig);
            if (ds == null) {
                ResourceBundle msg = runner.getErrorBundle();
                String desc = msg.getString("Error.NoSuchDirSet2.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType(), orig);
                throw new InvalidContractException(desc, contract);
            }
        }
        return ds;
    }

    protected FileList getFileListChecked(String orig, ContractSession session, ContractRunner runner, File contract, boolean replaceVars) throws InvalidContractException {
        FileList fl = null;
        if (replaceVars) {
            String refid = session.replaceVariables(orig);
            fl = session.getFileList(refid);
            if (fl == null) {
                ResourceBundle msg = runner.getErrorBundle();
                String desc = msg.getString("Error.NoSuchFileList.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType(), refid, orig);
                throw new InvalidContractException(desc, contract);
            }
        } else {
            fl = session.getFileList(orig);
            if (fl == null) {
                ResourceBundle msg = runner.getErrorBundle();
                String desc = msg.getString("Error.NoSuchFileList2.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType(), orig);
                throw new InvalidContractException(desc, contract);
            }
        }
        return fl;
    }

    protected FileSet getFileSetChecked(String orig, ContractSession session, ContractRunner runner, File contract, boolean replaceVars) throws InvalidContractException {
        FileSet fs = null;
        if (replaceVars) {
            String refid = session.replaceVariables(orig);
            fs = session.getFileSet(refid);
            if (fs == null) {
                ResourceBundle msg = runner.getErrorBundle();
                String desc = msg.getString("Error.NoSuchFileSet.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType(), refid, orig);
                throw new InvalidContractException(desc, contract);
            }
        } else {
            fs = session.getFileSet(orig);
            if (fs == null) {
                ResourceBundle msg = runner.getErrorBundle();
                String desc = msg.getString("Error.NoSuchFileSet2.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType(), orig);
                throw new InvalidContractException(desc, contract);
            }
        }
        return fs;
    }

    public String getHandledNodeType() {
        return this.handledNodeType;
    }

    protected Macro getMacroChecked(String orig, ContractSession session, ContractRunner runner, File contract, boolean replaceVars) throws InvalidContractException {
        Macro m = null;
        if (replaceVars) {
            String refid = session.replaceVariables(orig);
            m = session.getMacro(refid);
            if (m == null) {
                ResourceBundle msg = runner.getErrorBundle();
                String key = "Error.NoSuchMacro.fmt.txt";
                String desc = DProUtil.formatString(msg, key, this.getHandledNodeType(), refid, orig);
                throw new InvalidContractException(desc, contract);
            }
        } else {
            m = session.getMacro(orig);
            if (m == null) {
                ResourceBundle msg = runner.getErrorBundle();
                String key = "Error.NoSuchMacro2.fmt.txt";
                String desc = DProUtil.formatString(msg, key, this.getHandledNodeType(), orig);
                throw new InvalidContractException(desc, contract);
            }
        }
        return m;
    }

    protected ServiceResults getServiceResultsChecked(String orig, ContractSession session, ContractRunner runner, File contract) throws InvalidContractException {
        String id = session.replaceVariables(orig);
        ServiceResults sr = session.getServiceResultsByID(id);
        if (sr == null) {
            ResourceBundle msg = runner.getErrorBundle();
            String desc = msg.getString("Error.NoSuchServiceResults.fmt.txt");
            desc = MessageFormat.format(desc, this.getHandledNodeType(), id, orig);
            throw new InvalidContractException(desc, contract);
        }
        return sr;
    }

    protected long getTimeoutChecked(String timeoutStr, ContractRunner runner, File contract) throws InvalidContractException {
        long timeout = -1L;
        if (timeoutStr != null) {
            try {
                timeout = Long.parseLong(timeoutStr);
                if (timeout != -1L && timeout < 0L) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException nfe) {
                String desc = runner.getErrorBundle().getString("Error.InvalidTimeout.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType(), timeoutStr);
                throw new InvalidContractException(desc, contract, nfe);
            }
        }
        return timeout;
    }

    protected String getVariableNameChecked(String orig, boolean mustBeDefined, ContractSession session, ContractRunner runner, File contract) throws InvalidContractException {
        String varName = session.replaceVariables(orig);
        if (!DProUtil.isValidVariableName(varName)) {
            ResourceBundle msg = runner.getErrorBundle();
            String desc = msg.getString("Error.InvalidVarName.fmt.txt");
            desc = MessageFormat.format(desc, this.getHandledNodeType(), orig, varName);
            throw new InvalidContractException(desc, contract);
        }
        if (DProUtil.isReadOnlyVariable(varName)) {
            ResourceBundle msg = runner.getErrorBundle();
            String desc = msg.getString("Error.ReadOnlyVariable.fmt.txt");
            desc = MessageFormat.format(desc, this.getHandledNodeType(), varName, orig);
            throw new InvalidContractException(desc, contract);
        }
        if (mustBeDefined && null == session.getVariableValue(varName)) {
            ResourceBundle msg = runner.getErrorBundle();
            String desc = msg.getString("Error.UndefinedVariable.fmt.txt");
            desc = MessageFormat.format(desc, this.getHandledNodeType(), varName, orig);
            throw new InvalidContractException(desc, contract);
        }
        return varName;
    }

    private Mapper handleMapperElem(Element mapperElem, ContractRunner runner, ContractSession session, File contract) throws InvalidContractException {
        if (!this.checkIfAttribute(mapperElem, session, contract)) {
            return null;
        }
        String orig = mapperElem.getAttributeValue(ATTR_TYPE);
        String type = session.replaceVariables(orig);
        int typeInt = MapperUtil.getMapperType(type);
        if (typeInt == -1) {
            ResourceBundle msg = runner.getErrorBundle();
            String desc = msg.getString("Error.InvalidMapperType.fmt.txt");
            desc = MessageFormat.format(desc, this.getHandledNodeType(), type, orig);
            throw new InvalidContractException(desc, contract);
        }
        MapperImpl mapper = new MapperImpl(typeInt);
        orig = mapperElem.getAttributeValue(ATTR_FROM);
        String from = session.replaceVariables(orig);
        mapper.setFrom(from);
        orig = mapperElem.getAttributeValue(ATTR_TO);
        String to = session.replaceVariables(orig);
        mapper.setTo(to);
        return mapper;
    }

    protected int parseAddDirListContentsNode(Element node, List argList, ContractSession session, ContractRunner runner, File contract) throws IOException, InvalidContractException, NodeHandlerException {
        if (!this.checkIfAttribute(node, session, contract)) {
            return 0;
        }
        String orig = node.getAttributeValue(ATTR_COMMON_REFID);
        DirList dl = this.getDirListChecked(orig, session, runner, contract, true);
        return this.addFileCollectionImpl(node, dl, session, runner, contract, argList, "DirList");
    }

    protected int parseAddDirSetContentsNode(Element node, List argList, ContractSession session, ContractRunner runner, File contract) throws IOException, InvalidContractException, NodeHandlerException {
        if (!this.checkIfAttribute(node, session, contract)) {
            return 0;
        }
        String orig = node.getAttributeValue(ATTR_COMMON_REFID);
        DirSet ds = this.getDirSetChecked(orig, session, runner, contract, true);
        DirList dl = ds.getMatchingDirs();
        return this.addFileCollectionImpl(node, dl, session, runner, contract, argList, "DirSet");
    }

    protected int parseAddFileListContentsNode(Element node, List argList, ContractSession session, ContractRunner runner, File contract) throws IOException, InvalidContractException, NodeHandlerException {
        if (!this.checkIfAttribute(node, session, contract)) {
            return 0;
        }
        String orig = node.getAttributeValue(ATTR_COMMON_REFID);
        FileList fl = this.getFileListChecked(orig, session, runner, contract, true);
        return this.addFileCollectionImpl(node, fl, session, runner, contract, argList, "FileList");
    }

    protected int parseAddFileSetContentsNode(Element node, List argList, ContractSession session, ContractRunner runner, File contract) throws IOException, InvalidContractException, NodeHandlerException {
        if (!this.checkIfAttribute(node, session, contract)) {
            return 0;
        }
        String orig = node.getAttributeValue(ATTR_COMMON_REFID);
        FileSet fs = this.getFileSetChecked(orig, session, runner, contract, true);
        FileList fl = fs.getMatchingFiles();
        return this.addFileCollectionImpl(node, fl, session, runner, contract, argList, "FileSet");
    }

    protected int parseMappersNode(Element node, ContractRunner runner, ContractSession session, File contract, List mapperList) throws InvalidContractException {
        if (!this.checkIfAttribute(node, session, contract)) {
            return 0;
        }
        int added = 0;
        for (Element child : node.getChildren()) {
            Mapper m;
            String name = child.getName();
            if (!PARAM_MAPPER.equals(name) || (m = this.handleMapperElem(child, runner, session, contract)) == null) continue;
            mapperList.add(m);
            ++added;
        }
        return added;
    }

    protected int parseVarList(Element node, ContractRunner runner, ContractSession session, File contract, List varList) throws InvalidContractException, IOException {
        if (!this.checkIfAttribute(node, session, contract)) {
            return 0;
        }
        int added = 0;
        for (Element child : node.getChildren()) {
            String childName = child.getName();
            if ("var".equals(childName)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                String name = child.getAttributeValue("name");
                varList.add(session.replaceVariables(name));
                String value = child.getText();
                varList.add(session.replaceVariables(value));
                ++added;
                continue;
            }
            if (!"file".equals(childName) || !this.checkIfAttribute(child, session, contract)) continue;
            ContainerContext cc = session.getDefaultContainer();
            String contID = child.getAttributeValue(ATTR_COMMON_CONTAINER);
            if (contID != null) {
                cc = this.getContainerContextChecked(contID, session, runner, contract);
            }
            String fileName = session.replaceVariables(child.getText());
            InputStream in = DProUtil.getFileContents(cc, fileName);
            Properties props = new Properties();
            props.load(in);
            in.close();
            Enumeration<Object> e = props.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = props.getProperty(name);
                varList.add(name);
                varList.add(value);
                ++added;
            }
        }
        return added;
    }

    protected String possiblyEncrypt(ContractRunner r, String elem, String text) throws IOException {
        String encrypted = text;
        if (encrypted != null && !SasPasswordString.isEncoded((String)encrypted)) {
            try {
                encrypted = SasPasswordString.encode((String)"sas002", (String)encrypted);
            }
            catch (SasPasswordEncodingException spee) {
                ResourceBundle msg = r.getErrorBundle();
                String key = "Error.EncryptingText.fmt.txt";
                text = spee.getMessage();
                if (text == null) {
                    text = spee.toString();
                }
                String desc = DProUtil.formatString(msg, key, this.getHandledNodeType(), elem, text);
                throw new IOException(desc);
            }
        }
        return encrypted;
    }
}

