/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.messages;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.ErrorInfo;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.Macro;
import com.sas.dpro.contract.messages.AbstractMessage;
import com.sas.dpro.contract.messages.ContractCompletedMessage;
import com.sas.dpro.controller.HonorContractContext;
import java.io.Serializable;

public class ContractCompletedMessageImpl
extends AbstractMessage
implements ContractCompletedMessage,
Serializable {
    private ErrorInfo errorInfo;
    private ContainerContext[] openContainers;
    private FileList[] importableFileLists;
    private FileSet[] importableFileSets;
    private Macro[] importableMacros;
    private String[] importableVars;
    private boolean timeout;
    private static final long serialVersionUID = 1L;

    public ContractCompletedMessageImpl(HonorContractContext hcc) {
        super(hcc);
    }

    @Override
    public String getContract() {
        return this.getHonorContractContext().getContract();
    }

    @Override
    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    @Override
    public FileList[] getImportableFileLists() {
        FileList[] temp = null;
        temp = this.importableFileLists == null ? new FileList[]{} : (FileList[])this.importableFileLists.clone();
        return temp;
    }

    @Override
    public FileSet[] getImportableFileSets() {
        FileSet[] temp = null;
        temp = this.importableFileSets == null ? new FileSet[]{} : (FileSet[])this.importableFileSets.clone();
        return temp;
    }

    @Override
    public Macro[] getImportableMacros() {
        Macro[] temp = null;
        temp = this.importableMacros == null ? new Macro[]{} : (Macro[])this.importableMacros.clone();
        return temp;
    }

    @Override
    public String[] getImportableVars() {
        String[] temp = null;
        temp = this.importableVars == null ? new String[]{} : (String[])this.importableVars.clone();
        return temp;
    }

    @Override
    public ContainerContext[] getLeftOpenContainers() {
        ContainerContext[] temp = null;
        if (this.openContainers == null) {
            temp = new ContainerContext[]{};
        } else {
            temp = new ContainerContext[this.openContainers.length];
            System.arraycopy(this.openContainers, 0, temp, 0, this.openContainers.length);
        }
        return temp;
    }

    @Override
    public boolean isError() {
        return this.errorInfo != null;
    }

    @Override
    public boolean isTimeout() {
        return this.timeout;
    }

    public void setErrorInfo(ErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
    }

    @Override
    public void setImportableFileLists(FileList[] fileLists) {
        this.importableFileLists = null;
        if (fileLists != null) {
            this.importableFileLists = (FileList[])fileLists.clone();
        }
    }

    @Override
    public void setImportableFileSets(FileSet[] fileSets) {
        this.importableFileSets = null;
        if (fileSets != null) {
            this.importableFileSets = (FileSet[])fileSets.clone();
        }
    }

    @Override
    public void setImportableMacros(Macro[] macros) {
        this.importableMacros = null;
        if (macros != null) {
            this.importableMacros = (Macro[])macros.clone();
        }
    }

    @Override
    public void setImportableVars(String[] vars) {
        this.importableVars = null;
        if (vars != null) {
            this.importableVars = (String[])vars.clone();
        }
    }

    @Override
    public void setLeftOpenContainers(ContainerContext[] openContainers) {
        this.openContainers = null;
        if (openContainers != null) {
            this.openContainers = (ContainerContext[])openContainers.clone();
        }
    }

    public void setTimeout(boolean timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        int leftOpenContainerCount = this.openContainers == null ? 0 : this.openContainers.length;
        int importableFileListCount = this.importableFileLists == null ? 0 : this.importableFileLists.length;
        int importableFileSetCount = this.importableFileSets == null ? 0 : this.importableFileSets.length;
        int importableMacroCount = this.importableMacros == null ? 0 : this.importableMacros.length;
        int importableVarCount = this.importableVars == null ? 0 : this.importableVars.length;
        return "[ContractCompletedMessageImpl: context=" + this.getHonorContractContext() + "; leftOpenContainerCount=" + leftOpenContainerCount + "; importableFileListCount=" + importableFileListCount + "; importableFileSetCount=" + importableFileSetCount + "; importableMacroCount=" + importableMacroCount + "; importableVarCount=" + importableVarCount + "; isError=" + this.isError() + "; isTimeout=" + this.isTimeout() + "]";
    }
}

