/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract;

import com.sas.dpro.common.FileParserBase;
import com.sas.dpro.contract.ContractInfoImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StoredContractLoader
extends FileParserBase {
    private String definitionFile;
    private List contractInfos;
    private static final String MSG = "com.sas.dpro.contract.StoredContractLoader";
    private static final ResourceBundle msg = ResourceBundle.getBundle("com.sas.dpro.contract.StoredContractLoader");
    private static final String DESCRIPTION = "description";
    private static final String DIR = "dir";
    private static final String DISPLAY_NAME = "displayName";
    private static final String FILE = "file";
    private static final String KEYWORD = "keyword";
    private static final String KEYWORDS = "keywords";
    private static final String STORED_CONTRACT = "StoredContract";
    private static final String PROPERTY_DEBUG = "com.sas.dpro.contract.StoredContractLoader.debug";

    private StoredContractLoader(String definitionFile) {
        this.definitionFile = definitionFile;
        this.contractInfos = new ArrayList();
    }

    private SAXBuilder createSAXBuilder() throws IOException {
        boolean validate = true;
        SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", validate);
        if (validate) {
            builder.setFeature("http://apache.org/xml/features/validation/schema", true);
            builder.setEntityResolver((EntityResolver)new StoredContractsFileEntityResolver());
        }
        return builder;
    }

    @Override
    protected String getDebugHeader() {
        return "[StoredContractLoader]";
    }

    @Override
    protected String getDebugProperty() {
        return PROPERTY_DEBUG;
    }

    @Override
    protected File getXMLFile() {
        return new File(this.definitionFile);
    }

    private List handleParse() throws IOException {
        SAXBuilder builder = this.createSAXBuilder();
        Document doc = null;
        try {
            doc = builder.build(this.definitionFile);
        }
        catch (JDOMException je) {
            je.printStackTrace();
            throw new IOException(je.getMessage());
        }
        Element root = doc.getRootElement();
        String version = root.getAttributeValue("version");
        if (version == null || !"1.0".equals(version)) {
            String desc = msg.getString("Error.UnsupportedVersion.fmt.txt");
            desc = MessageFormat.format(desc, version);
            throw new IOException(desc);
        }
        for (Element child : root.getChildren()) {
            String nodeName = child.getName();
            if ("loadPropertiesFile".equals(nodeName)) {
                this.handlePropertiesFileNode(child);
                continue;
            }
            if (STORED_CONTRACT.equals(nodeName)) {
                this.handleStoredContractNode(child);
                continue;
            }
            String desc = msg.getString("Error.UnknownElement.fmt.txt");
            desc = MessageFormat.format(desc, this.definitionFile, nodeName);
            throw new IOException(desc);
        }
        return this.contractInfos;
    }

    private void handleKeywordsNode(Element elem, StringBuilder keywords) throws IOException {
        for (Element child : elem.getChildren()) {
            String nodeName = child.getName();
            if (KEYWORD.equals(nodeName)) {
                String keyword = child.getText();
                keyword = this.replaceVariables(keyword);
                keywords.append(keyword).append(';');
                continue;
            }
            String desc = msg.getString("Error.UnknownElement.fmt.txt");
            desc = MessageFormat.format(desc, this.definitionFile, nodeName);
            throw new IOException(desc);
        }
    }

    private void handleStoredContractNode(Element elem) throws IOException {
        File contractFile;
        String desc;
        if (!this.shouldLoad(elem, STORED_CONTRACT)) {
            return;
        }
        String dir = null;
        String file = null;
        StringBuilder keywords = new StringBuilder();
        String description = null;
        String displayName = null;
        for (Element child : elem.getChildren()) {
            String nodeName = child.getName();
            if (DESCRIPTION.equals(nodeName)) {
                description = child.getText();
                description = this.replaceVariables(description);
                continue;
            }
            if (DIR.equals(nodeName)) {
                dir = child.getText();
                dir = this.replaceVariables(dir);
                dir = this.ensureAbsolute(dir);
                continue;
            }
            if (DISPLAY_NAME.equals(nodeName)) {
                displayName = child.getText();
                displayName = this.replaceVariables(displayName);
                continue;
            }
            if (FILE.equals(nodeName)) {
                file = child.getText();
                file = this.replaceVariables(file);
                continue;
            }
            if (KEYWORDS.equals(nodeName)) {
                this.handleKeywordsNode(child, keywords);
                continue;
            }
            String desc2 = msg.getString("Error.UnknownElement.fmt.txt");
            desc2 = MessageFormat.format(desc2, this.definitionFile, nodeName);
            throw new IOException(desc2);
        }
        if (file == null) {
            desc = msg.getString("Error.NoFileSpecified.fmt.txt");
            desc = MessageFormat.format(desc, this.definitionFile);
            throw new IOException(desc);
        }
        if (dir == null) {
            desc = msg.getString("Error.NoDirSpecified.fmt.txt");
            desc = MessageFormat.format(desc, this.definitionFile);
            throw new IOException(desc);
        }
        if (keywords.length() > 1) {
            keywords.setLength(keywords.length() - 1);
        }
        if (!(contractFile = new File(dir, file)).isFile()) {
            String desc3 = msg.getString("Error.ContractDoesNotExist.fmt.txt");
            desc3 = MessageFormat.format(desc3, this.definitionFile, contractFile.getAbsolutePath());
            throw new IOException(desc3);
        }
        ContractInfoImpl info = new ContractInfoImpl(dir, file);
        this.debugPrint("Adding stored contract: " + info.getFileFullPath());
        info.setDisplayName(displayName);
        info.setDescription(description);
        info.setKeywords(keywords.toString());
        this.debugPrint("... Display name: " + displayName);
        this.debugPrint("... Description: " + description);
        this.debugPrint("... Keywords: " + keywords.toString());
        this.contractInfos.add(info);
    }

    public static List parse(String definitionFile) throws IOException {
        StoredContractLoader loader = new StoredContractLoader(definitionFile);
        return loader.handleParse();
    }

    private static final class StoredContractsFileEntityResolver
    implements EntityResolver {
        private static final String SCHEMA_NAME_1_5 = "com/sas/schema/stored-contracts-1.5.xsd";
        private static final String SYSTEM_ID_1_5 = "http://www.sas.com/xml/schema/dpro/stored-contracts-1.5.xsd";
        private static final String SCHEMA_NAME_1_6 = "com/sas/schema/stored-contracts-1.6.xsd";
        private static final String SYSTEM_ID_1_6 = "http://www.sas.com/xml/schema/dpro/stored-contracts-1.6.xsd";

        private StoredContractsFileEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            InputSource retval = null;
            if (SYSTEM_ID_1_6.equals(systemId)) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                InputStream stream = cl.getResourceAsStream(SCHEMA_NAME_1_6);
                retval = new InputSource(stream);
            } else if (SYSTEM_ID_1_5.equals(systemId)) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                InputStream stream = cl.getResourceAsStream(SCHEMA_NAME_1_5);
                retval = new InputSource(stream);
            }
            return retval;
        }
    }
}

