/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.common;

import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.messages.ContractCompletedMessage;

public class RunActionFailedException
extends NodeHandlerException {
    private int submittedCount;
    private int ranCount;
    private int errorCount;
    private int timeoutCount;
    private ContractCompletedMessage[] ccms;
    private static final long serialVersionUID = 1L;

    public RunActionFailedException(Throwable cause) {
        super(cause);
    }

    public RunActionFailedException(String message) {
        super(message);
    }

    public RunActionFailedException(String message, Throwable cause) {
        super(message, cause);
    }

    public int getContractCleanCount() {
        return this.ranCount - this.errorCount - this.timeoutCount;
    }

    public ContractCompletedMessage[] getContractCompletedMessages() {
        return (ContractCompletedMessage[])this.ccms.clone();
    }

    public int getContractErrorCount() {
        return this.errorCount;
    }

    public int getContractRunCount() {
        return this.ranCount;
    }

    public int getContractSubmittedCount() {
        return this.submittedCount;
    }

    public int getContractTimeoutCount() {
        return this.timeoutCount;
    }

    public void setContractCompletedMessages(ContractCompletedMessage[] ccms) {
        if (ccms == null) {
            this.ccms = null;
        } else {
            int count = ccms.length;
            this.ccms = new ContractCompletedMessage[count];
            for (int i = 0; i < count; ++i) {
                this.ccms[i] = ccms[i];
            }
        }
    }

    public void setContractInfo(int submitted, int ran, int errors, int timeouts) {
        this.submittedCount = submitted;
        this.ranCount = ran;
        this.errorCount = errors;
        this.timeoutCount = timeouts;
    }
}

