/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.common;

import com.sas.dpro.common.InvalidContractException;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class RCRules {
    private List ranges = new ArrayList(1);
    private String origRules;
    private static final String MSG = "com.sas.dpro.common.RCRules";

    private RCRules() {
    }

    protected void addRange(RCRange range) {
        this.ranges.add(range);
    }

    public static RCRules create(String rules, File contract) throws InvalidContractException {
        RCRules rcRules = new RCRules();
        if (rules != null) {
            rcRules.origRules = rules;
            rules = rules.trim();
            String[] ruleRanges = rules.split(",");
            for (int i = 0; i < ruleRanges.length; ++i) {
                String ruleRange = ruleRanges[i];
                if (ruleRange.matches("\\d+")) {
                    rcRules.addRange(new RCRange(Integer.parseInt(ruleRange)));
                    continue;
                }
                if (ruleRange.matches("\\d+-\\d+")) {
                    int hyphen = ruleRange.indexOf("-");
                    int min = Integer.parseInt(ruleRange.substring(0, hyphen));
                    int max = Integer.parseInt(ruleRange.substring(hyphen + 1));
                    rcRules.addRange(new RCRange(min, max));
                    continue;
                }
                if (ruleRange.equalsIgnoreCase("any")) {
                    long min = Long.MIN_VALUE;
                    long max = Long.MAX_VALUE;
                    rcRules.addRange(new RCRange(min, max));
                    continue;
                }
                ResourceBundle msg = ResourceBundle.getBundle(MSG);
                String desc = msg.getString("Exception.BadRCSpec.fmt.txt");
                desc = MessageFormat.format(desc, ruleRange, rcRules.origRules);
                throw new InvalidContractException(desc, contract);
            }
        } else {
            rcRules.origRules = "0";
        }
        if (rcRules.ranges.size() == 0) {
            rcRules.addRange(new RCRange(0L));
        }
        return rcRules;
    }

    public String getRuleString() {
        return this.origRules;
    }

    public boolean isUnexpectedRC(int rc) {
        boolean unexpected = true;
        int count = this.ranges.size();
        for (int i = 0; i < count; ++i) {
            RCRange range = (RCRange)this.ranges.get(i);
            if (!range.contains(rc)) continue;
            unexpected = false;
            break;
        }
        return unexpected;
    }

    public String toString() {
        StringBuilder temp = new StringBuilder("[RCRules: ranges=");
        Iterator i = this.ranges.iterator();
        while (i.hasNext()) {
            RCRange range = (RCRange)i.next();
            temp.append(range.toString());
            if (!i.hasNext()) continue;
            temp.append(',');
        }
        temp.append(']');
        return temp.toString();
    }

    private static class RCRange {
        public long min;
        public long max;

        public RCRange(long value) {
            this(value, value);
        }

        public RCRange(long min, long max) {
            this.min = Math.min(min, max);
            this.max = Math.max(min, max);
        }

        public boolean contains(long rc) {
            return rc >= this.min && rc <= this.max;
        }

        public String toString() {
            return this.min == this.max ? "" + this.min : this.min + "-" + this.max;
        }
    }
}

