/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.common;

import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.InputPromptInfo;
import java.util.regex.Pattern;

public class InputPromptInfoImpl
implements InputPromptInfo {
    private String description;
    private String prompt;
    private String[] choices;
    private String[] choiceDescriptions;
    private Pattern inputFormat;
    private String inputErrorMessage;
    private boolean allowCancelInput;
    private boolean allowEmptyInput;
    private boolean trimWhitespace;

    public InputPromptInfoImpl(String desc, String prompt) {
        this.setDescription(desc);
        this.setPrompt(prompt);
        this.setAllowCancelInput(true);
        this.setAllowEmptyInput(false);
        this.setTrimWhitespace(false);
    }

    @Override
    public boolean getAllowCancelInput() {
        return this.allowCancelInput;
    }

    @Override
    public boolean getAllowEmptyInput() {
        return this.allowEmptyInput;
    }

    @Override
    public String[] getChoiceDescriptions() {
        return DProUtil.cloneStringArray(this.choiceDescriptions);
    }

    @Override
    public String[] getChoices() {
        return DProUtil.cloneStringArray(this.choices);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getInputErrorMessage() {
        return this.inputErrorMessage;
    }

    @Override
    public Pattern getInputFormat() {
        return this.inputFormat;
    }

    @Override
    public String getPrompt() {
        return this.prompt;
    }

    @Override
    public boolean getTrimWhitespace() {
        return this.trimWhitespace;
    }

    public void setAllowCancelInput(boolean allowCancel) {
        this.allowCancelInput = allowCancel;
    }

    public void setAllowEmptyInput(boolean allow) {
        this.allowEmptyInput = allow;
    }

    public void setChoices(String[] choices) {
        this.setChoices(choices, null);
    }

    public void setChoices(String[] choices, String[] descriptions) {
        this.choices = DProUtil.cloneStringArray(choices);
        this.choiceDescriptions = DProUtil.cloneStringArray(descriptions);
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setInputErrorMessage(String msg) {
        this.inputErrorMessage = msg;
    }

    public void setInputFormat(Pattern format) {
        this.inputFormat = format;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public void setTrimWhitespace(boolean trim) {
        this.trimWhitespace = trim;
    }
}

