/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.common;

import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileListImpl;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.InvalidProviderNameException;
import com.sas.dpro.common.PatternSetUtil;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class FileSetUtil
extends PatternSetUtil {
    private FileSetUtil() {
    }

    public static FileList getMatchingFiles(FileSet fileSet, String id) throws RemoteException, InvalidProviderNameException {
        boolean remote;
        boolean bl = remote = !ProviderFactory.isLocalProvider(fileSet.getProvider());
        if (remote) {
            Provider p = ProviderFactory.getProvider(fileSet.getProvider());
            if (id == null) {
                return p.getMatchingFiles(fileSet);
            }
            String version = p.getProviderDPROVersion();
            if (!version.startsWith("1.5")) {
                return p.getMatchingFiles(fileSet, id);
            }
            FileList fl = p.getMatchingFiles(fileSet);
            FileListImpl fl2 = new FileListImpl(fl.getRoot(), fl.getProvider(), id);
            for (int i = 0; i < fl.getSize(); ++i) {
                fl2.add(fl.get(i));
            }
            return fl2;
        }
        TreeSet set = new TreeSet();
        String root = fileSet.getRoot();
        File rootFile = new File(root);
        int includePatternCount = fileSet.getIncludePatternCount();
        if (includePatternCount == 0) {
            Pattern[] patterns = FileSetUtil.getPatternsForFilePath("**");
            FileSetUtil.getMatchingFilesImpl(rootFile, patterns, 0, set);
        } else {
            for (int i = 0; i < includePatternCount; ++i) {
                Pattern[] patterns = FileSetUtil.getPatternsForFilePath(fileSet.getIncludePattern(i));
                FileSetUtil.getMatchingFilesImpl(rootFile, patterns, 0, set);
            }
        }
        int excludePatternCount = fileSet.getExcludePatternCount();
        for (int i = 0; i < excludePatternCount; ++i) {
            Pattern[] patterns = FileSetUtil.getPatternsForFilePath(fileSet.getExcludePattern(i));
            FileSetUtil.removeMatchingFiles(root, patterns, set);
            if (set.isEmpty()) break;
        }
        if (id == null) {
            id = fileSet.getID();
        }
        FileListImpl fileList = new FileListImpl(fileSet.getRoot(), fileSet.getProvider(), id);
        int index = fileSet.getRoot().length() + 1;
        Iterator i = set.iterator();
        while (i.hasNext()) {
            String relativePath = ((File)i.next()).getAbsolutePath();
            relativePath = relativePath.substring(index);
            fileList.add(relativePath);
        }
        return fileList;
    }

    private static boolean getMatchingFilesImpl(File parent, Pattern[] patterns, int pos, SortedSet set) {
        boolean foundMatches = false;
        File[] children = parent.listFiles();
        int childCount = children == null ? 0 : children.length;
        for (int i = 0; i < childCount; ++i) {
            File child = children[i];
            if (patterns[pos] == null) {
                if (pos == patterns.length - 1) {
                    if (child.isFile()) {
                        set.add(child);
                        foundMatches = true;
                        continue;
                    }
                    foundMatches |= FileSetUtil.getMatchingFilesImpl(child, patterns, pos, set);
                    continue;
                }
                if (!child.isDirectory()) continue;
                if (patterns[pos + 1] != null) {
                    foundMatches |= FileSetUtil.getMatchingFilesImpl(child, patterns, pos + 1, set);
                    if (patterns[pos + 1].matcher(child.getName()).matches()) {
                        if (pos + 2 >= patterns.length) continue;
                        foundMatches |= FileSetUtil.getMatchingFilesImpl(child, patterns, pos + 2, set);
                        continue;
                    }
                    foundMatches |= FileSetUtil.getMatchingFilesImpl(child, patterns, pos, set);
                    continue;
                }
                foundMatches |= FileSetUtil.getMatchingFilesImpl(child, patterns, pos, set);
                continue;
            }
            if (!patterns[pos].matcher(child.getName()).matches()) continue;
            if (pos == patterns.length - 1) {
                if (!child.isFile()) continue;
                set.add(child);
                foundMatches = true;
                continue;
            }
            foundMatches |= FileSetUtil.getMatchingFilesImpl(child, patterns, pos + 1, set);
        }
        return foundMatches;
    }

    private static void removeMatchingFiles(String root, Pattern[] patterns, SortedSet set) {
        int patternCount;
        int n = patternCount = patterns == null ? 0 : patterns.length;
        if (patternCount == 0) {
            return;
        }
        char ch = root.charAt(root.length() - 1);
        if (ch != '\\' && ch != '/') {
            root = root + '/';
        }
        Iterator i = set.iterator();
        while (i.hasNext()) {
            String[] elems;
            File child = (File)i.next();
            String file = child.getAbsolutePath().substring(root.length());
            if (file.endsWith("/") || file.endsWith("\\")) {
                file = file.substring(0, file.length() - 1);
            }
            if (file.length() == 0 || !FileSetUtil.possiblyRemove(elems = file.split("\\\\|/"), 0, patterns, 0)) continue;
            i.remove();
        }
    }
}

