/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.common;

import com.sas.dpro.common.DirList;
import com.sas.dpro.common.DirListImpl;
import com.sas.dpro.common.DirSet;
import com.sas.dpro.common.InvalidProviderNameException;
import com.sas.dpro.common.PatternSetUtil;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class DirSetUtil
extends PatternSetUtil {
    public static DirList getMatchingDirs(DirSet dirSet) throws RemoteException, InvalidProviderNameException {
        boolean remote;
        boolean bl = remote = !ProviderFactory.isLocalProvider(dirSet.getProvider());
        if (remote) {
            Provider p = ProviderFactory.getProvider(dirSet.getProvider());
            return p.getMatchingDirs(dirSet);
        }
        TreeSet set = new TreeSet();
        String root = dirSet.getRoot();
        File rootFile = new File(root);
        int includePatternCount = dirSet.getIncludePatternCount();
        if (includePatternCount == 0) {
            Pattern[] patterns = DirSetUtil.getPatternsForFilePath("**");
            DirSetUtil.getMatchingDirsImpl(rootFile, patterns, 0, set);
        } else {
            for (int i = 0; i < includePatternCount; ++i) {
                Pattern[] patterns = DirSetUtil.getPatternsForFilePath(dirSet.getIncludePattern(i));
                DirSetUtil.getMatchingDirsImpl(rootFile, patterns, 0, set);
            }
        }
        int excludePatternCount = dirSet.getExcludePatternCount();
        for (int i = 0; i < excludePatternCount; ++i) {
            Pattern[] patterns = DirSetUtil.getPatternsForFilePath(dirSet.getExcludePattern(i));
            DirSetUtil.removeMatchingDirs(root, patterns, set);
            if (set.isEmpty()) break;
        }
        DirListImpl dirList = new DirListImpl(dirSet.getRoot(), dirSet.getProvider(), dirSet.getID());
        int index = dirSet.getRoot().length() + 1;
        Iterator i = set.iterator();
        while (i.hasNext()) {
            String relativePath = ((File)i.next()).getAbsolutePath();
            relativePath = relativePath.substring(index);
            dirList.add(relativePath);
        }
        return dirList;
    }

    private static boolean getMatchingDirsImpl(File parent, Pattern[] patterns, int pos, SortedSet set) {
        boolean foundMatches = false;
        File[] children = parent.listFiles();
        int childCount = children == null ? 0 : children.length;
        for (int i = 0; i < childCount; ++i) {
            File child = children[i];
            if (patterns[pos] == null) {
                if (pos == patterns.length - 1) {
                    if (!child.isDirectory()) continue;
                    set.add(child);
                    foundMatches = true;
                    DirSetUtil.getMatchingDirsImpl(child, patterns, pos, set);
                    continue;
                }
                if (!child.isDirectory()) continue;
                if (patterns[pos + 1] != null) {
                    foundMatches |= DirSetUtil.getMatchingDirsImpl(child, patterns, pos + 1, set);
                    if (patterns[pos + 1].matcher(child.getName()).matches()) {
                        if (pos + 2 >= patterns.length) continue;
                        foundMatches |= DirSetUtil.getMatchingDirsImpl(child, patterns, pos + 2, set);
                        continue;
                    }
                    foundMatches |= DirSetUtil.getMatchingDirsImpl(child, patterns, pos, set);
                    continue;
                }
                foundMatches |= DirSetUtil.getMatchingDirsImpl(child, patterns, pos, set);
                continue;
            }
            if (!patterns[pos].matcher(child.getName()).matches()) continue;
            if (pos == patterns.length - 1) {
                if (!child.isDirectory()) continue;
                set.add(child);
                foundMatches = true;
                continue;
            }
            foundMatches |= DirSetUtil.getMatchingDirsImpl(child, patterns, pos + 1, set);
        }
        return foundMatches;
    }

    private static void removeMatchingDirs(String root, Pattern[] patterns, SortedSet set) {
        int patternCount;
        int n = patternCount = patterns == null ? 0 : patterns.length;
        if (patternCount == 0) {
            return;
        }
        char ch = root.charAt(root.length() - 1);
        if (ch != '\\' && ch != '/') {
            root = root + '/';
        }
        Iterator i = set.iterator();
        while (i.hasNext()) {
            String[] elems;
            File child = (File)i.next();
            String fileName = child.getAbsolutePath().substring(root.length());
            if (fileName.endsWith("/") || fileName.endsWith("\\")) {
                fileName = fileName.substring(0, fileName.length() - 1);
            }
            if (fileName.length() == 0 || !DirSetUtil.possiblyRemove(elems = fileName.split("\\\\|/"), 0, patterns, 0)) continue;
            i.remove();
        }
    }
}

