/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.common;

import com.sas.dpro.client.AbstractClient;
import com.sas.dpro.common.AlreadyInitializedException;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.DirList;
import com.sas.dpro.common.DirSetImpl;
import com.sas.dpro.common.InvalidProviderNameException;
import com.sas.dpro.common.UninitializedEnvironmentError;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class DProEnvironment {
    public static final String ENV_VAR_PROD_INSTALLS = "dpro_prodInstallsFile";
    public static final String PROPERTY_IGNORE_DEFAULT_PROD_INSTALLS = "com.sas.dpro.ignoreDefaultProdInstalls";
    public static final String PROPERTY_PROD_INSTALLS = "com.sas.dpro.prodInstallsFile";
    private List servicesFileList;
    private List formattersFileList;
    private List contractsFileList;
    private List reportMakersFileList;
    private String installDirectory;
    private String configDirectory;
    private String reportsDirectory;
    private String resultsDirectory;
    private String workspaceDirectory;
    private List metadataServers;
    private ResourceBundle msg = ResourceBundle.getBundle("com.sas.dpro.common.DProEnvironment");
    static DProEnvironment INSTANCE;
    private static final String DEFAULT_INSTALL_DIRECTORY = ".";
    private static final String DEFAULT_CONFIG_DIRECTORY = "Config";
    private static final String REPORTS_DIR_NAME = "Reports";
    private static final String RESULTS_DIR_NAME = "Results";
    private static final String WORKSPACE_DIR_NAME = "workspace";
    private static final String DEFAULT_CONTRACTS_FILE = "DefaultStoredContracts.xml";
    private static final String DEFAULT_FORMATTERS_FILE = "DefaultFormatters.xml";
    private static final String DEFAULT_REPORT_MAKERS_FILE = "DefaultReportMakers.xml";
    private static final String DEFAULT_SERVICES_FILE = "DefaultServices.xml";
    private static final String PROD_INSTALLS_CONFIG_FILE = "prodinstalls.config";
    private static final String TEST_SUBDIR_DTEST = "dtest";
    private static final String PROD_INSTALLS_REC_PRODUCT = "product";
    private static final String PROD_INSTALLS_REC_DIR = "dir";
    private static final String PROD_INSTALLS_REC_DIRSET = "dir-set";
    private static final String LOCALE_EN = "en";
    private static final String MSG = "com.sas.dpro.common.DProEnvironment";

    protected DProEnvironment(Logger logger, String appDataSubdir, String dproClientInstallDir) throws IOException {
        String desc;
        this.servicesFileList = new ArrayList(1);
        this.formattersFileList = new ArrayList(1);
        this.contractsFileList = new ArrayList();
        this.reportMakersFileList = new ArrayList(1);
        this.metadataServers = new ArrayList(1);
        if (dproClientInstallDir != null) {
            this.installDirectory = dproClientInstallDir;
            File installDir = new File(this.installDirectory);
            this.installDirectory = installDir.getAbsolutePath();
            this.configDirectory = new File(installDir, DEFAULT_CONFIG_DIRECTORY).getAbsolutePath();
        } else {
            this.installDirectory = DEFAULT_INSTALL_DIRECTORY;
            this.configDirectory = DEFAULT_CONFIG_DIRECTORY;
        }
        try {
            this.installDirectory = new File(this.installDirectory).getCanonicalPath();
            this.configDirectory = new File(this.configDirectory).getCanonicalPath();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (!new File(this.installDirectory).isDirectory()) {
            desc = DProUtil.formatString(this.msg, "Log.InvalidDPROClientDir.fmt.txt", this.installDirectory);
            throw new IOException(desc);
        }
        if (!new File(this.configDirectory).isDirectory()) {
            desc = DProUtil.formatString(this.msg, "Log.InvalidDPROClientConfigDir.fmt.txt", this.configDirectory);
            throw new IOException(desc);
        }
        this.setDefaultWritableDirectories(appDataSubdir);
    }

    protected void addContractsFile(String fileName) {
        this.contractsFileList.add(fileName);
    }

    protected void addFormattersFile(String fileName) {
        this.formattersFileList.add(fileName);
    }

    protected void addReportMakersFile(String fileName) {
        this.reportMakersFileList.add(fileName);
    }

    protected void addServicesFile(String fileName) {
        this.servicesFileList.add(fileName);
    }

    protected void addServicesFromSASProducts(Logger logger) throws IOException {
        ArrayList<File> prodInstallFiles = new ArrayList<File>(1);
        if (!Boolean.getBoolean(PROPERTY_IGNORE_DEFAULT_PROD_INSTALLS)) {
            String configDir = DProEnvironment.getConfigDirectory();
            File file = new File(configDir, PROD_INSTALLS_CONFIG_FILE);
            prodInstallFiles.add(file);
        }
        String extraFiles = null;
        if (System.getProperty(PROPERTY_PROD_INSTALLS) != null) {
            extraFiles = System.getProperty(PROPERTY_PROD_INSTALLS);
        } else if (System.getenv(ENV_VAR_PROD_INSTALLS) != null && System.getenv(ENV_VAR_PROD_INSTALLS).length() > 0) {
            extraFiles = System.getenv(ENV_VAR_PROD_INSTALLS);
        }
        if (extraFiles != null) {
            String[] names = extraFiles.split("[:;]");
            for (int i = 0; i < names.length; ++i) {
                if (names[i].length() <= 0) continue;
                prodInstallFiles.add(new File(names[i]));
            }
        }
        for (File sasProductFile : prodInstallFiles) {
            String desc;
            if (logger != null) {
                desc = DProUtil.formatString(this.msg, "Log.ParsingProdInstallsFile.fmt.txt", sasProductFile.getAbsolutePath());
                logger.info(desc);
            }
            if (sasProductFile.isFile()) {
                this.handleParseConfigFile(sasProductFile, logger);
                continue;
            }
            if (logger == null) continue;
            desc = this.msg.getString("Log.FileNotFound.fmt.txt");
            desc = MessageFormat.format(desc, sasProductFile.getAbsolutePath());
            logger.warning(desc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    protected void handleParseConfigFile(File configFile, Logger logger) throws IOException {
        String line = null;
        try (BufferedReader r = new BufferedReader(new FileReader(configFile));){
            block5: while ((line = r.readLine()) != null) {
                String desc;
                String installDir;
                String prodName;
                String[] params;
                if (line.length() <= 0 || line.startsWith("#") || (params = line.split("\\|")).length <= 1) continue;
                String recordType = params[0];
                if (PROD_INSTALLS_REC_PRODUCT.equalsIgnoreCase(recordType) && params.length == 3) {
                    prodName = params[1];
                    installDir = params[2];
                    desc = this.msg.getString("Log.CheckingForTestSuite.fmt.txt");
                    desc = MessageFormat.format(desc, configFile.getName(), prodName);
                    logger.info(desc);
                    this.handleDTTestSuiteCheck(installDir, logger);
                    continue;
                }
                if (PROD_INSTALLS_REC_DIR.equalsIgnoreCase(recordType) && params.length == 3) {
                    prodName = params[1];
                    installDir = params[2];
                    desc = this.msg.getString("Log.CheckingForTestSuite.fmt.txt");
                    desc = MessageFormat.format(desc, configFile.getName(), prodName);
                    logger.info(desc);
                    this.handleDTTestSuiteCheckImpl(new File(installDir), logger);
                    continue;
                }
                if (PROD_INSTALLS_REC_DIRSET.equalsIgnoreCase(recordType) && params.length == 3) {
                    String root = params[1];
                    String pattern = params[2];
                    DirSetImpl ds = new DirSetImpl(root, null);
                    ds.addIncludePattern(pattern);
                    DirList dl = null;
                    try {
                        dl = ds.getMatchingDirs();
                    }
                    catch (InvalidProviderNameException ipne) {
                        ipne.printStackTrace();
                    }
                    int count = dl == null ? 0 : dl.getSize();
                    int i = 0;
                    while (true) {
                        if (i >= count) continue block5;
                        String dirName = dl.getAbsolute(i);
                        String desc2 = this.msg.getString("Log.CheckingForTestSuite.fmt.txt");
                        String prodName2 = this.msg.getString("Log.Unknown.txt");
                        desc2 = MessageFormat.format(desc2, configFile.getName(), prodName2);
                        logger.info(desc2);
                        this.handleDTTestSuiteCheckImpl(new File(dirName), logger);
                        ++i;
                    }
                }
                String desc3 = this.msg.getString("Log.UnsupportedRecord.fmt.txt");
                desc3 = MessageFormat.format(desc3, configFile.getName(), line);
                logger.severe(desc3);
            }
            return;
        }
    }

    protected void addStoredContractDefinitionFile(String fileName) {
        this.contractsFileList.add(fileName);
    }

    private void ensureDirExists(String type, String dirName) throws IOException {
        File dir = new File(dirName);
        if (!dir.isDirectory() && !dir.mkdirs()) {
            String desc = DProUtil.formatString(this.msg, "Log.ErrorCreatingDir.fmt.txt", type, dirName);
            throw new IOException(desc);
        }
    }

    public static String getConfigDirectory() {
        DProEnvironment.verifyEnvironment();
        return DProEnvironment.INSTANCE.configDirectory;
    }

    protected ResourceBundle getDProEnvironmentBundle() {
        return this.msg;
    }

    public static String[] getFormattersFiles() {
        DProEnvironment.verifyEnvironment();
        return DProEnvironment.getStringArrayFromList(DProEnvironment.INSTANCE.formattersFileList);
    }

    public static String getInstallDirectory() {
        DProEnvironment.verifyEnvironment();
        return DProEnvironment.INSTANCE.installDirectory;
    }

    public static String[] getReportMakersFiles() {
        DProEnvironment.verifyEnvironment();
        return DProEnvironment.getStringArrayFromList(DProEnvironment.INSTANCE.reportMakersFileList);
    }

    public static String getReportsDirectory() {
        DProEnvironment.verifyEnvironment();
        return DProEnvironment.INSTANCE.reportsDirectory;
    }

    public static String getResultsDirectory() {
        DProEnvironment.verifyEnvironment();
        return DProEnvironment.INSTANCE.resultsDirectory;
    }

    public static String[] getServicesFiles() {
        DProEnvironment.verifyEnvironment();
        return DProEnvironment.getStringArrayFromList(DProEnvironment.INSTANCE.servicesFileList);
    }

    public static String[] getStoredContractDefinitionFiles() {
        DProEnvironment.verifyEnvironment();
        return DProEnvironment.getStringArrayFromList(DProEnvironment.INSTANCE.contractsFileList);
    }

    protected static final String[] getStringArrayFromList(List list) {
        if (list == null) {
            return new String[0];
        }
        String[] array = new String[list.size()];
        array = list.toArray(array);
        return array;
    }

    private boolean getTestSuiteFileExists(File file, String keyRoot, Logger logger) {
        boolean exists;
        boolean bl = exists = file != null ? file.isFile() : false;
        if (logger != null) {
            String key = keyRoot + (exists ? ".Found.fmt.txt" : ".NotFound.fmt.txt");
            String desc = DProUtil.formatString(this.msg, key, file == null ? "null" : file.getAbsolutePath());
            logger.info(desc);
        }
        return exists;
    }

    public static String getWorkspaceDirectory() {
        DProEnvironment.verifyEnvironment();
        return DProEnvironment.INSTANCE.workspaceDirectory;
    }

    protected boolean handleDTTestSuiteCheck(String installDir, Logger logger) {
        if (installDir == null) {
            return false;
        }
        boolean foundSomething = false;
        File parentDir = new File(installDir, TEST_SUBDIR_DTEST);
        if (parentDir.isDirectory()) {
            int childCount;
            File[] children = parentDir.listFiles();
            int n = childCount = children == null ? 0 : children.length;
            if (childCount == 1 && LOCALE_EN.equals(children[0])) {
                childCount = (children = children[0].listFiles()) == null ? 0 : children.length;
            }
            for (int i = 0; i < childCount; ++i) {
                File child = children[i];
                if (!child.isDirectory()) continue;
                foundSomething |= this.handleDTTestSuiteCheckImpl(child, logger);
            }
        } else {
            String desc = DProUtil.formatString(this.msg, "Log.NoTestSuites.fmt.txt", parentDir.getAbsolutePath());
            logger.info(desc);
        }
        return foundSomething;
    }

    private boolean handleDTTestSuiteCheckImpl(File dir, Logger logger) {
        File reportMakersFile;
        File contractsFile;
        File formattersFile;
        boolean foundSomething = false;
        if (!dir.isDirectory()) {
            if (logger != null) {
                String desc = DProUtil.formatString(this.msg, "Log.TestSuiteDir.DNE.fmt.txt", dir.getAbsolutePath());
                logger.info(desc);
            }
            return false;
        }
        String desc = DProUtil.formatString(this.msg, "Log.TestSuiteDir.Exists.fmt.txt", dir.getAbsolutePath());
        logger.info(desc);
        File servicesFile = new File(dir, "Services.xml");
        if (this.getTestSuiteFileExists(servicesFile, "Log.ServicesFile", logger)) {
            this.addServicesFile(servicesFile.getAbsolutePath());
            foundSomething = true;
        }
        if (this.getTestSuiteFileExists(formattersFile = new File(dir, "Formatters.xml"), "Log.FormattersFile", logger)) {
            this.addFormattersFile(formattersFile.getAbsolutePath());
            foundSomething = true;
        }
        if (this.getTestSuiteFileExists(contractsFile = new File(dir, "StoredContracts.xml"), "Log.StoredContractsFile", logger)) {
            this.addContractsFile(contractsFile.getAbsolutePath());
            foundSomething = true;
        }
        if (this.getTestSuiteFileExists(reportMakersFile = new File(dir, "ReportMakers.xml"), "Log.ReportMakersFile", logger)) {
            this.addReportMakersFile(reportMakersFile.getAbsolutePath());
            foundSomething = true;
        }
        return foundSomething;
    }

    public static synchronized void initialize(Logger logger, String appDataSubdir, String dproClientInstallDir, AbstractClient client) throws AlreadyInitializedException, IOException {
        if (DProEnvironment.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        INSTANCE = new DProEnvironment(logger, appDataSubdir, dproClientInstallDir);
        String configDirectory = DProEnvironment.getConfigDirectory();
        File configDir = new File(configDirectory);
        if (configDir.isDirectory()) {
            File rmFile;
            File contractsFile;
            File formattersFile;
            File servicesFile = new File(configDir, DEFAULT_SERVICES_FILE);
            if (servicesFile.isFile()) {
                INSTANCE.addServicesFile(servicesFile.getAbsolutePath());
            }
            if ((formattersFile = new File(configDir, DEFAULT_FORMATTERS_FILE)).isFile()) {
                INSTANCE.addFormattersFile(formattersFile.getAbsolutePath());
            }
            if ((contractsFile = new File(configDir, DEFAULT_CONTRACTS_FILE)).isFile()) {
                INSTANCE.addStoredContractDefinitionFile(contractsFile.getAbsolutePath());
            }
            if ((rmFile = new File(configDir, DEFAULT_REPORT_MAKERS_FILE)).isFile()) {
                INSTANCE.addReportMakersFile(rmFile.getAbsolutePath());
            }
            INSTANCE.addServicesFromSASProducts(logger);
        } else {
            String desc = DProEnvironment.INSTANCE.msg.getString("Log.ConfigDirNotFound.fmt.txt");
            desc = MessageFormat.format(desc, configDirectory);
            logger.severe(desc);
        }
    }

    public static boolean isInitialized() {
        return INSTANCE != null;
    }

    public Iterator metadataServerIterator() {
        return this.metadataServers.iterator();
    }

    private void setDefaultWritableDirectories(String appDataSubdir) throws IOException {
        File parentDir = null;
        if (appDataSubdir == null) {
            parentDir = new File(this.installDirectory);
        } else {
            boolean isUnix = File.separatorChar == '/';
            String appData = null;
            appData = isUnix ? System.getProperty("user.home") + "/.SASAppData" : System.getenv("APPDATA") + "\\SAS";
            parentDir = new File(appData, appDataSubdir);
        }
        this.reportsDirectory = new File(parentDir, REPORTS_DIR_NAME).getAbsolutePath();
        this.resultsDirectory = new File(parentDir, RESULTS_DIR_NAME).getAbsolutePath();
        this.workspaceDirectory = new File(parentDir, WORKSPACE_DIR_NAME).getAbsolutePath();
        this.ensureDirExists(REPORTS_DIR_NAME, this.reportsDirectory);
        this.ensureDirExists(RESULTS_DIR_NAME, this.resultsDirectory);
        this.ensureDirExists(WORKSPACE_DIR_NAME, this.workspaceDirectory);
    }

    private static void verifyEnvironment() throws UninitializedEnvironmentError {
        if (INSTANCE == null) {
            throw new UninitializedEnvironmentError();
        }
    }
}

