/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.common;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.InvalidProviderNameException;
import com.sas.dpro.common.ProviderNotAvailableException;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import java.io.Serializable;
import java.rmi.RemoteException;

public class ContainerContextImpl
implements ContainerContext,
Serializable {
    private long timeCreated;
    private boolean wasNewlyCreated;
    private String contractID;
    private long contractSessionID;
    private String directory;
    private String providerName;
    private int lifespan;
    private String clientVersion;
    private String providerVersion;
    private static final int MAX_LIFESPAN = 2;
    private static final int MIN_LIFESPAN = 0;
    private static final long serialVersionUID = 1L;

    public ContainerContextImpl(String contractID, long contractSessionID, String providerName, String clientVersion) {
        this.contractID = contractID;
        this.contractSessionID = contractSessionID;
        this.providerName = providerName;
        this.timeCreated = System.currentTimeMillis();
        this.wasNewlyCreated = true;
        this.lifespan = 2;
        this.clientVersion = clientVersion;
    }

    private static final boolean areEqual(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof ContainerContext) {
            ContainerContext sc = (ContainerContext)obj;
            boolean clientVersionEqual = ContainerContextImpl.areEqual(this.clientVersion, sc.getClientDPROVersion());
            boolean isLocalP = ProviderFactory.isLocalProvider(this.providerName);
            boolean providerNamesEqual = isLocalP ? ProviderFactory.isLocalProvider(sc.getProviderName()) : this.providerName.equals(sc.getProviderName());
            equal = clientVersionEqual && ContainerContextImpl.areEqual(this.contractID, sc.getContractID()) && this.contractSessionID == sc.getContractSessionID() && providerNamesEqual && this.timeCreated == sc.getTimeCreated();
        }
        return equal;
    }

    @Override
    public String getAbsoluteFilePath(String path) throws Exception {
        Provider p = ProviderFactory.getProvider(this.getProviderName());
        return p.getAbsoluteFilePath(this, path);
    }

    @Override
    public String getClientDPROVersion() {
        return this.clientVersion;
    }

    @Override
    public String getContractID() {
        return this.contractID;
    }

    @Override
    public long getContractSessionID() {
        return this.contractSessionID;
    }

    @Override
    public String getDirectory() {
        return this.directory;
    }

    @Override
    public boolean getFileExists(String file) throws ProviderNotAvailableException, RemoteException {
        boolean exists = false;
        try {
            Provider p = ProviderFactory.getProvider(this.getProviderName());
            exists = p.getFileExists(this, file);
        }
        catch (ProviderNotAvailableException pnae) {
            throw pnae;
        }
        catch (InvalidProviderNameException ipne) {
            ipne.printStackTrace();
        }
        return exists;
    }

    @Override
    public long getFileSize(String file) throws ProviderNotAvailableException, RemoteException {
        long size = -1L;
        try {
            Provider p = ProviderFactory.getProvider(this.getProviderName());
            size = p.getFileSize(this, file);
        }
        catch (ProviderNotAvailableException pnae) {
            throw pnae;
        }
        catch (InvalidProviderNameException ipne) {
            ipne.printStackTrace();
        }
        return size;
    }

    @Override
    public int getLifespan() {
        return this.lifespan;
    }

    @Override
    public String getProviderDPROVersion() {
        return this.providerVersion;
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public long getTimeCreated() {
        return this.timeCreated;
    }

    @Override
    public boolean getWasNewlyCreated() {
        return this.wasNewlyCreated;
    }

    public int hashCode() {
        return (int)this.contractSessionID;
    }

    @Override
    public boolean isTemporary() {
        return this.lifespan != 0;
    }

    public void setClientDPROVersion(String version) {
        this.clientVersion = version;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void setLifespan(int lifespan) {
        if (lifespan < 0 || lifespan > 2) {
            throw new IllegalArgumentException();
        }
        this.lifespan = lifespan;
    }

    public void setProviderDPROVersion(String version) {
        this.providerVersion = version;
    }

    public void setWasNewlyCreated(boolean newlyCreated) {
        this.wasNewlyCreated = newlyCreated;
    }

    public String toString() {
        return "[ContainerContextImpl: timeCreated=" + this.timeCreated + ", contractID=" + this.contractID + ", directory=" + this.directory + ", providerName=" + this.providerName + ", lifespan=" + this.lifespan + "]";
    }
}

