/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.simplesqlmodel;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.definitions.DateDefinitionInterface;
import com.sas.prompts.definitions.DateRangeDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.simplesqlmodel.ObjectValueOperand;
import com.sas.prompts.simplesqlmodel.PromptValueOperand;
import com.sas.storage.simplesqlmodel.BooleanOperand;
import com.sas.storage.simplesqlmodel.DateOperand;
import com.sas.storage.simplesqlmodel.DoubleOperand;
import com.sas.storage.simplesqlmodel.Expression;
import com.sas.storage.simplesqlmodel.FormattedOperator;
import com.sas.storage.simplesqlmodel.IntegerOperand;
import com.sas.storage.simplesqlmodel.OperandInterface;
import com.sas.storage.simplesqlmodel.SelectStatement;
import com.sas.storage.simplesqlmodel.SpecialValueOperand;
import com.sas.storage.simplesqlmodel.StringOperand;
import com.sas.storage.simplesqlmodel.TimeOperand;
import com.sas.storage.simplesqlmodel.TimestampOperand;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.SupportedSpecialValuesInterface;
import com.sas.util.ValueItem;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class SQLModelPromptUtil {
    private static TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");

    public static List createOperandsFromPromptValue(List operandList, Object promptValue, PromptDefinitionInterface promptDefinition) {
        boolean addNottedOperand = false;
        if (operandList == null) {
            operandList = new ArrayList<Object>();
        }
        if (promptValue instanceof String) {
            operandList.add((SpecialValueOperand)new StringOperand((String)promptValue));
        } else if (promptValue instanceof String[]) {
            operandList.add((SpecialValueOperand)new StringOperand(((String[])promptValue)[0]));
            operandList.add((SpecialValueOperand)new StringOperand(((String[])promptValue)[1]));
        } else if (promptValue instanceof Boolean) {
            operandList.add((SpecialValueOperand)new BooleanOperand(((Boolean)promptValue).booleanValue()));
        } else if (promptValue instanceof Boolean[]) {
            operandList.add((SpecialValueOperand)new BooleanOperand(((Boolean[])promptValue)[0].booleanValue()));
            operandList.add((SpecialValueOperand)new BooleanOperand(((Boolean[])promptValue)[1].booleanValue()));
        } else if (promptValue instanceof Integer) {
            operandList.add((SpecialValueOperand)new IntegerOperand(((Integer)promptValue).intValue()));
        } else if (promptValue instanceof Integer[]) {
            operandList.add((SpecialValueOperand)new IntegerOperand(((Integer[])promptValue)[0].intValue()));
            operandList.add((SpecialValueOperand)new IntegerOperand(((Integer[])promptValue)[1].intValue()));
        } else if (promptValue instanceof Double) {
            operandList.add((SpecialValueOperand)new DoubleOperand(((Double)promptValue).doubleValue()));
        } else if (promptValue instanceof Double[]) {
            operandList.add((SpecialValueOperand)new DoubleOperand(((Double[])promptValue)[0].doubleValue()));
            operandList.add((SpecialValueOperand)new DoubleOperand(((Double[])promptValue)[1].doubleValue()));
        } else if (promptValue instanceof DatePeriod) {
            operandList = SQLModelPromptUtil.createDateOperands(operandList, (Date)promptValue, promptDefinition);
        } else if (promptValue instanceof Timestamp) {
            operandList.add((SpecialValueOperand)new TimestampOperand((Date)promptValue));
        } else if (promptValue instanceof Time) {
            operandList.add((SpecialValueOperand)new TimeOperand((Date)promptValue));
        } else if (promptValue instanceof Date) {
            operandList = SQLModelPromptUtil.createDateOperands(operandList, (Date)promptValue, promptDefinition);
        } else if (promptValue instanceof Date[] || promptValue instanceof Time[] || promptValue instanceof Timestamp[]) {
            List tempOperandList = new ArrayList(4);
            tempOperandList = SQLModelPromptUtil.createDateOperands(tempOperandList, ((Date[])promptValue)[0], promptDefinition);
            tempOperandList = SQLModelPromptUtil.createDateOperands(tempOperandList, ((Date[])promptValue)[1], promptDefinition);
            operandList.add((SpecialValueOperand)tempOperandList.get(0));
            operandList.add((SpecialValueOperand)tempOperandList.get(3));
        } else if (promptValue instanceof List) {
            List promptValueList = (List)promptValue;
            int n = promptValueList.size();
            for (int i = 0; i < n; ++i) {
                SQLModelPromptUtil.createOperandsFromPromptValue(operandList, promptValueList.get(i), promptDefinition);
            }
        } else if (promptValue instanceof MissingValues) {
            if (promptDefinition instanceof DateDefinitionInterface || promptDefinition instanceof DateRangeDefinitionInterface) {
                SQLModelPromptUtil.createDateOperands(operandList, promptValue, promptDefinition);
            } else {
                operandList.add(new SpecialValueOperand(promptValue));
            }
        } else if (promptValue instanceof SpecialValues) {
            if (promptValue.equals(SpecialValues.ALL) && promptDefinition instanceof ValueProviderDefinitionInterface && ((ValueProviderDefinitionInterface)((Object)promptDefinition)).getValueProvider() instanceof StaticValueProvider) {
                SupportedSpecialValuesInterface svDefinition;
                SupportedSpecialValues supportedSpecialValues;
                StaticValueProvider staticVP = (StaticValueProvider)((ValueProviderDefinitionInterface)((Object)promptDefinition)).getValueProvider();
                try {
                    List valueItems = (List)staticVP.getValues(Locale.US);
                    for (ValueItem item : valueItems) {
                        SQLModelPromptUtil.createOperandsFromPromptValue(operandList, item.getValue(), promptDefinition);
                    }
                }
                catch (ValueProviderException e) {
                    e.printStackTrace();
                }
                if (promptDefinition instanceof SupportedSpecialValuesInterface && (supportedSpecialValues = (svDefinition = (SupportedSpecialValuesInterface)promptDefinition).getSupportedSpecialValues()) != null && supportedSpecialValues.isMissingValuesSupported()) {
                    if (promptDefinition instanceof TextDefinitionInterface) {
                        operandList.add(new SpecialValueOperand((Object)MissingValues._BLANK_));
                    } else {
                        operandList.add(new SpecialValueOperand((Object)MissingValues.Dot));
                    }
                }
            } else if (promptValue.equals(SpecialValues.OTHER) && promptDefinition instanceof ValueProviderDefinitionInterface && ((ValueProviderDefinitionInterface)((Object)promptDefinition)).getValueProvider() instanceof StaticValueProvider) {
                addNottedOperand = true;
                StaticValueProvider staticVP = (StaticValueProvider)((ValueProviderDefinitionInterface)((Object)promptDefinition)).getValueProvider();
                try {
                    List valueItems = (List)staticVP.getValues(Locale.US);
                    for (ValueItem item : valueItems) {
                        SQLModelPromptUtil.createOperandsFromPromptValue(operandList, item.getValue(), promptDefinition);
                    }
                }
                catch (ValueProviderException e) {
                    e.printStackTrace();
                }
            } else {
                operandList.add(new SpecialValueOperand(promptValue));
            }
        } else if (promptValue instanceof DataSourceInterface || promptValue instanceof DataSourceColumnInterface) {
            operandList.add((SpecialValueOperand)new ObjectValueOperand(promptValue));
        } else {
            throw new IllegalStateException("Unable to convert operand data type for expression : " + promptValue);
        }
        if (addNottedOperand) {
            operandList.add((SpecialValueOperand)FormattedOperator.NOT_FLAG_OPERAND);
        }
        return operandList;
    }

    private static List createDateOperands(List operandList, Object promptValue, PromptDefinitionInterface promptDefinition) {
        if (operandList == null) {
            operandList = new ArrayList<Object>();
        }
        if (promptValue instanceof DatePeriod) {
            DatePeriod dp = (DatePeriod)promptValue;
            DateTypes periodType = dp.getPeriodType();
            Date start = dp.getStartOfPeriod();
            Date end = dp.getEndOfPeriod();
            if (periodType == DateTypes.TIMESTAMP) {
                operandList.add(new TimestampOperand(start));
                operandList.add(new TimestampOperand(end));
            } else if (periodType == DateTypes.TIME || periodType == DateTypes.HOUR || periodType == DateTypes.MINUTE) {
                operandList.add(new TimeOperand(start));
                operandList.add(new TimeOperand(end));
            } else {
                operandList.add(new DateOperand(start));
                operandList.add(new DateOperand(end));
            }
        } else if (promptValue instanceof Timestamp) {
            operandList.add(new TimestampOperand((Date)promptValue));
        } else if (promptValue instanceof Time) {
            operandList.add(new TimeOperand((Date)promptValue));
        } else if (promptValue instanceof MissingValues) {
            operandList.add(new SpecialValueOperand(promptValue));
            operandList.add(new SpecialValueOperand(promptValue));
        } else {
            operandList.add(new DateOperand((Date)promptValue));
            operandList.add(new DateOperand((Date)promptValue));
        }
        return operandList;
    }

    public static List getDependentPrompts(SelectStatement selectStatement, List dependentPrompts) {
        if (dependentPrompts == null) {
            dependentPrompts = new ArrayList();
        }
        List columns = selectStatement.getColumns();
        SQLModelPromptUtil.getDependentPrompts(columns, dependentPrompts);
        OperandInterface whereOperand = selectStatement.getWhereClause().getCondition();
        SQLModelPromptUtil.getDependentPrompt(whereOperand, dependentPrompts);
        return dependentPrompts;
    }

    private static void getDependentPrompt(OperandInterface operand, List dependentPrompts) {
        if (operand instanceof Expression) {
            SQLModelPromptUtil.getDependentPrompts((Expression)operand, dependentPrompts);
        } else if (operand instanceof PromptValueOperand) {
            dependentPrompts.add(((PromptValueOperand)operand).getPromptDefinition());
        }
    }

    private static void getDependentPrompts(List operands, List dependentPrompts) {
        int n = operands.size();
        for (int i = 0; i < n; ++i) {
            OperandInterface operand = (OperandInterface)operands.get(i);
            SQLModelPromptUtil.getDependentPrompt(operand, dependentPrompts);
        }
    }

    private static void getDependentPrompts(Expression expression, List dependentPrompts) {
        List operands = expression.getOperands();
        SQLModelPromptUtil.getDependentPrompts(operands, dependentPrompts);
    }
}

