/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.script.impl;

import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.MutablePromptDefinitionV2Interface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.script.ValueChangeContext;
import com.sas.prompts.script.impl.DefaultValidationContext;
import com.sas.util.log.LoggerFactoryInterface;
import java.util.HashMap;
import org.apache.logging.log4j.Logger;

public final class DefaultValueChangeContext
implements ValueChangeContext {
    private DefaultValidationContext valContext;
    private PromptValuesInterface promptValues;

    public DefaultValueChangeContext(PromptValuesInterface promptValues, LoggerFactoryInterface factory) {
        this.promptValues = promptValues;
        this.valContext = new DefaultValidationContext(promptValues, factory);
    }

    @Override
    public Object getPromptValueForPromptID(String promptID) {
        return this.valContext.getPromptValueForPromptID(promptID);
    }

    @Override
    public Object getPromptValueForPromptName(String promptName) {
        return this.valContext.getPromptValueForPromptName(promptName);
    }

    @Override
    public String getPromptNameForPromptID(String promptID) {
        return this.valContext.getPromptNameForPromptID(promptID);
    }

    @Override
    public Logger getLog4JLogger() {
        return this.valContext.getLog4JLogger();
    }

    @Override
    public String getLog4JOutput() {
        return this.valContext.getLog4JOutput();
    }

    @Override
    public void setPromptValueForPromptName(String promptName, Object value) throws InvalidPromptValueException {
        this.promptValues.setPromptValue(this.promptValues.getPromptDefinition(promptName, true), value);
    }

    @Override
    public void setPromptValueForPromptID(String promptID, Object value) throws InvalidPromptValueException {
        PromptDefinitionInterface prompt = PromptUtil.findPromptDefinitionByID(this.promptValues, promptID);
        if (null != prompt) {
            this.promptValues.setPromptValue(prompt, value);
        } else {
            this.valContext.getLogger().warn("setPromptValueForPromptID(), Could not set a value for this ID: " + promptID);
        }
    }

    @Override
    public void setPromptAttributeForPromptID(String promptID, Object value, String attributeName) {
        PromptDefinitionInterface prompt = PromptUtil.findPromptDefinitionByID(this.promptValues, promptID);
        if (null != prompt && prompt instanceof MutablePromptDefinitionV2Interface) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put(attributeName, value);
            ((MutablePromptDefinitionV2Interface)prompt).configureAttributes(options, null);
        } else {
            this.valContext.getLogger().warn("setPromptAttributeForPromptID(), Could not set attribute for this ID: " + promptID);
        }
    }

    @Override
    public void setPromptAttributeForPromptName(String promptName, Object value, String attributeName) {
        PromptDefinitionInterface prompt = this.promptValues.getPromptDefinition(promptName, true);
        if (null != prompt && prompt instanceof MutablePromptDefinitionV2Interface) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put(attributeName, value);
            ((MutablePromptDefinitionV2Interface)prompt).configureAttributes(options, null);
        } else {
            this.valContext.getLogger().warn("setPromptAttributeForPromptID(), Could not set attribute for this prompt: " + promptName);
        }
    }
}

