/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.script;

import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.script.ScriptCommand;
import com.sas.prompts.script.ScriptHolder;
import com.sas.prompts.script.ValidationContext;
import com.sas.prompts.script.ValueChangeContext;
import com.sas.prompts.script.impl.DefaultValidationContext;
import com.sas.prompts.script.impl.DefaultValueChangeContext;
import com.sas.util.ValidateArg;
import com.sas.util.anno.NotNull;
import com.sas.util.log.LoggerFactoryInterface;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ScriptCommandFactory {
    public static ScriptCommand newScriptCommand(@NotNull ScriptHolder scriptHolder, LoggerFactoryInterface factory) {
        ScriptCommand retVal = null;
        try {
            Class<?> clazz = Class.forName("com.sas.prompts.script.util.RemoteScriptCommandFactory");
            Method method = clazz.getDeclaredMethod("newScriptCommand", ScriptHolder.class, LoggerFactoryInterface.class);
            retVal = (ScriptCommand)method.invoke(null, scriptHolder, factory);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e.getMessage());
        }
        return retVal;
    }

    public static ValidationContext newValidationContext(@NotNull PromptValuesInterface promptValues, LoggerFactoryInterface factory) {
        ValidateArg.notNull((Object)promptValues, (String)"promptValues");
        return new DefaultValidationContext(promptValues, factory);
    }

    public static ValueChangeContext newValueChangeContext(@NotNull PromptValuesInterface promptValues, LoggerFactoryInterface factory) {
        ValidateArg.notNull((Object)promptValues, (String)"promptValues");
        return new DefaultValueChangeContext(promptValues, factory);
    }
}

