/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.groups.shared;

import com.sas.codepolicy.SASScope;
import com.sas.prompts.AttributeDependencyInterface;
import com.sas.prompts.MutableIdentifiablePromptInterface;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.PromptIdentifierFactory;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.SharedPromptFactory;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.PromptGroupLayoutInterface;
import com.sas.prompts.groups.PromptGroupV2Interface;
import com.sas.prompts.groups.shared.MutableSharedPromptGroupInterface;
import com.sas.prompts.groups.shared.RB;
import com.sas.prompts.script.PromptAction;
import com.sas.prompts.script.ScriptHolder;
import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.uiconfig.ApplicationContext;
import com.sas.uiconfig.ContextEnabledObject;
import com.sas.uiconfig.UIConfigurationInterface;
import com.sas.util.AttributeDescriptor;
import com.sas.util.AttributeGroup;
import com.sas.util.LocalizableString;
import com.sas.util.ValidateArg;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.MetadataDescriptor;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import com.sas.util.xmlpersist.impl.LocalizedText;
import com.sas.util.xmlpersist.impl.PersistHelper;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import com.sas.util.xmlpersist.impl.PromptObjectFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@SASScope
public class SharedPromptGroup
extends AbstractPersistence
implements MutableSharedPromptGroupInterface,
MultiLocaleProperties,
MutableIdentifiablePromptInterface,
ContextEnabledObject {
    protected PromptGroupV2Interface internalPromptGroup;
    private transient ApplicationContext applicationContext;
    private String sharedPromptLocation;
    private LocalizableString label;
    private LocalizableString description;
    private static final long serialVersionUID = -6773074617370330246L;
    private String promptID;
    public static final String RB_KEY = "SharedPromptGroup.";
    private static final String InternalPromptGroup = "InternalPromptGroup";

    public SharedPromptGroup() {
    }

    public SharedPromptGroup(String sharedPromptLocation, SharedPromptFactory factory) throws BackingStoreException {
        this.setSharedPromptLocation(sharedPromptLocation, factory);
    }

    private PromptGroupV2Interface getInternalPromptGroup() {
        if (null == this.internalPromptGroup) {
            this.internalPromptGroup = new PromptGroup();
        }
        return this.internalPromptGroup;
    }

    @Override
    public String getSharedPromptGroupLocation() {
        return this.sharedPromptLocation;
    }

    @Override
    public void setSharedPromptGroupLocation(String sharedPromptLocation) {
        this.setLocationOfInternalPromptGroup(sharedPromptLocation);
    }

    @Override
    public void setSharedPromptLocation(String sharedPromptLocation, SharedPromptFactory factory) throws BackingStoreException {
        ValidateArg.notNull((Object)factory, (String)"factory");
        this.setLocationOfInternalPromptGroup(sharedPromptLocation);
        this.internalPromptGroup = (PromptGroupV2Interface)factory.getGroupFromFolder(sharedPromptLocation);
    }

    protected final void setLocationOfInternalPromptGroup(String sharedPromptLocation) {
        ValidateArg.notNull((Object)sharedPromptLocation, (String)"sharedPromptLocation");
        this.sharedPromptLocation = PersistHelper.parseSBIPUrl((String)sharedPromptLocation);
        this.getLogger2().debug("setSharedPromptGroupLocation()", sharedPromptLocation);
    }

    @Override
    public String getPromptGroupLabel(Locale locale) {
        String retVal = null;
        retVal = this.label == null ? this.getInternalPromptGroup().getPromptGroupLabel(locale) : PromptUtil.getDelegatedText(this.label, locale, this.getApplicationContext());
        if (null == retVal) {
            retVal = "";
        }
        this.getLogger2().debug("getPromptGroupLabel()", retVal);
        return retVal;
    }

    @Override
    public void setPromptGroupLabel(String label, Locale locale) {
        if (this.label == null) {
            this.label = new LocalizableString();
        }
        this.label.setText(label, locale);
    }

    @Override
    public String getPromptGroupDescription(Locale locale) {
        String retVal = null;
        retVal = this.description == null ? this.getInternalPromptGroup().getPromptGroupDescription(locale) : PromptUtil.getDelegatedText(this.description, locale, this.getApplicationContext());
        if (null == retVal) {
            retVal = "";
        }
        this.getLogger2().debug("getPromptGroupDescrip()", retVal);
        return retVal;
    }

    @Override
    public void setPromptGroupDescription(String description, Locale locale) {
        if (this.description == null) {
            this.description = new LocalizableString();
        }
        this.description.setText(description, locale);
    }

    @Override
    public boolean hasPromptDefinition(PromptDefinitionInterface promptDefinition) {
        return this.getInternalPromptGroup().hasPromptDefinition(promptDefinition);
    }

    @Override
    public List<?> getPromptDefinitionsAndSubgroups(List list, boolean recursive, boolean includeDefinitions, boolean includeSubgroups) {
        return this.getInternalPromptGroup().getPromptDefinitionsAndSubgroups(list, recursive, includeDefinitions, includeSubgroups);
    }

    @Override
    public PromptGroupInterface findPromptSubgroup(PromptDefinitionInterface promptDefinition) {
        return this.getInternalPromptGroup().findPromptSubgroup(promptDefinition);
    }

    @Override
    public List<?> getPromptDefinitionsAndSubgroups() {
        return this.getInternalPromptGroup().getPromptDefinitionsAndSubgroups();
    }

    @Override
    public List<PromptDefinitionInterface> getPromptDefinitions(boolean recursive) {
        return this.getInternalPromptGroup().getPromptDefinitions(recursive);
    }

    @Override
    public List<PromptGroupInterface> getPromptSubgroups(boolean recursive) {
        return this.getInternalPromptGroup().getPromptSubgroups(recursive);
    }

    @Override
    public void addPromptDefinition(PromptDefinitionInterface promptDefinition) {
        this.getInternalPromptGroup().addPromptDefinition(promptDefinition);
    }

    @Override
    public void addPromptDefinition(PromptDefinitionInterface promptDefinition, int index) {
        this.getInternalPromptGroup().addPromptDefinition(promptDefinition, index);
    }

    @Override
    public void addPromptDefinitions(List<PromptDefinitionInterface> promptDefinitions) {
        this.getInternalPromptGroup().addPromptDefinitions(promptDefinitions);
    }

    @Override
    public void removePromptDefinition(PromptDefinitionInterface promptDefinition) {
        this.getInternalPromptGroup().removePromptDefinition(promptDefinition);
    }

    @Override
    public void addPromptSubgroup(PromptGroupInterface promptSubgroup) {
        this.getInternalPromptGroup().addPromptSubgroup(promptSubgroup);
    }

    @Override
    public void addPromptSubgroup(PromptGroupInterface promptSubgroup, int index) {
        this.getInternalPromptGroup().addPromptSubgroup(promptSubgroup, index);
    }

    @Override
    public void removePromptSubgroup(PromptGroupInterface promptSubgroup) {
        this.getInternalPromptGroup().removePromptSubgroup(promptSubgroup);
    }

    @Override
    public int indexOfPromptDefinitionOrSubgroup(Object promptDefintionOrSubGroup) {
        return this.getInternalPromptGroup().indexOfPromptDefinitionOrSubgroup(promptDefintionOrSubGroup);
    }

    @Override
    public boolean isPromptGroupHidden() {
        return this.getInternalPromptGroup().isPromptGroupHidden();
    }

    @Override
    public void setPromptGroupHidden(boolean hidden) {
        this.getInternalPromptGroup().setPromptGroupHidden(hidden);
    }

    @Override
    public PromptGroupInterface copy(PromptGroupInterface newGroup) {
        if (newGroup == null) {
            try {
                newGroup = (PromptGroupInterface)PromptObjectFactory.getInstance().newObject(this.getDefinitionElementName());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e.getMessage());
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
        if (newGroup instanceof MutableSharedPromptGroupInterface) {
            try {
                ((MutableSharedPromptGroupInterface)newGroup).setPromptGroupLabels((LocalizableString)this.getPromptGroupLabels().clone());
                ((MutableSharedPromptGroupInterface)newGroup).setPromptGroupDescriptions((LocalizableString)this.getPromptGroupDescriptions().clone());
            }
            catch (CloneNotSupportedException cnse) {
                this.getLogger2().error(cnse.getMessage(), (Throwable)cnse);
            }
            ((MutableSharedPromptGroupInterface)newGroup).setPromptGroupHidden(this.isPromptGroupHidden());
            if (null != this.sharedPromptLocation && newGroup instanceof SharedPromptGroup) {
                ((SharedPromptGroup)newGroup).setLocationOfInternalPromptGroup(this.sharedPromptLocation);
            }
            ((SharedPromptGroup)newGroup).internalPromptGroup = this.internalPromptGroup;
        }
        return newGroup;
    }

    public String getVersion() {
        return this.getInternalPromptGroup().getVersion();
    }

    @Override
    public LocalizableString getPromptGroupLabels() {
        if (this.label == null) {
            return this.getInternalPromptGroup().getPromptGroupLabels();
        }
        return this.label;
    }

    @Override
    public LocalizableString getPromptGroupDescriptions() {
        if (this.description == null) {
            return this.getInternalPromptGroup().getPromptGroupDescriptions();
        }
        return this.description;
    }

    @Override
    public void setPromptGroupLabels(LocalizableString labels) {
        this.label = labels;
    }

    @Override
    public void setPromptGroupDescriptions(LocalizableString descriptions) {
        this.description = descriptions;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(String promptName, boolean recursive) {
        return this.getInternalPromptGroup().getPromptDefinition(promptName, recursive);
    }

    @Override
    public void removeAll() {
        this.getInternalPromptGroup().removeAll();
    }

    @Override
    public void removeAllPromptDefinitions(boolean recursive) {
        this.getInternalPromptGroup().removeAllPromptDefinitions(recursive);
    }

    @Override
    public void removeAllPromptSubgroups() {
        this.getInternalPromptGroup().removeAllPromptSubgroups();
    }

    @Override
    public boolean replacePromptDefintion(PromptDefinitionInterface promptDefinition, PromptDefinitionInterface newPromptDefinition, boolean recursive) {
        return this.getInternalPromptGroup().replacePromptDefintion(promptDefinition, newPromptDefinition, recursive);
    }

    @Override
    public boolean replacePromptSubgroup(PromptGroupInterface promptSubgroup, PromptGroupInterface newPromptSubgroup, boolean recursive) {
        return this.getInternalPromptGroup().replacePromptSubgroup(promptSubgroup, newPromptSubgroup, recursive);
    }

    @Override
    public boolean containsSubgroup(PromptGroupInterface subGroupCandidate, boolean recursive) {
        return this.getInternalPromptGroup().containsSubgroup(subGroupCandidate, recursive);
    }

    public void consumeAttributes(AttributesProvider provider) {
        Map map;
        PromptsReadingContext prContext;
        Map optionsMap;
        PromptsReadingContext reader;
        super.consumeAttributes(provider);
        this.getLogger2().debug("running consumeAttributes");
        this.setSharedPromptGroupLocation(provider.consumeAttr("sharedPromptLocation"));
        if (null != this.getSharedPromptGroupLocation() && null != (reader = provider.getReadingContext()) && null != (optionsMap = reader.getOptionsMap()) && !optionsMap.containsKey("writeExternal")) {
            this.getLogger2().debug("Retrieving internal group from:", this.getSharedPromptGroupLocation());
            try {
                this.internalPromptGroup = (PromptGroupV2Interface)reader.getObjectFromMetadata("PromptGroup", this.getSharedPromptGroupLocation());
                if (null == this.internalPromptGroup) {
                    this.getLogger2().error(RB.getStringResource(RB_KEY, "error.noGroup.log"));
                } else {
                    this.getLogger2().debug("Retrieved internal prompt group from metadata");
                    if (!this.getDefinitionElementName().endsWith(this.internalPromptGroup.getDefinitionElementName())) {
                        reader.addMissingResource((Object)this, (Object)this.getSharedPromptGroupLocation());
                        this.getLogger2().debug("consumeAttributes() missing resource as internal group is wrong type:", this.internalPromptGroup.getDefinitionElementName());
                    }
                }
            }
            catch (BackingStoreException e) {
                this.getLogger2().error(e.getMessage());
                reader.addMissingResource((Object)this, (Object)this.getSharedPromptGroupLocation());
            }
        }
        if (null != (prContext = provider.getReadingContext()) && null != prContext.getOptionsMap() && (map = prContext.getOptionsMap()).containsKey("com.sas.uiconfig.ApplicationContext")) {
            this.setApplicationContext((ApplicationContext)map.get("com.sas.uiconfig.ApplicationContext"));
        }
    }

    public void consumeElementText(String text) {
    }

    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        PromptGroupV2Interface prompt;
        ArrayList list4;
        ArrayList list3;
        super.consumeRelatedObjects(roHolder);
        ArrayList list2 = roHolder.consumeObjects("Label");
        if (!list2.isEmpty()) {
            for (LocalizedText text : list2) {
                this.setPromptGroupLabel(text.getText(), text.getLocale());
                this.getLogger2().debug("consumeRelObjects, setting label to:", text.getText());
            }
        }
        if (!(list3 = roHolder.consumeObjects("Description")).isEmpty()) {
            for (LocalizedText text : list3) {
                this.setPromptGroupDescription(text.getText(), text.getLocale());
                this.getLogger2().debug("consumeRelObjects, setting descrip to:", text.getText());
            }
        }
        if (null == this.internalPromptGroup && !(list4 = roHolder.consumeObjects(InternalPromptGroup)).isEmpty() && null != (prompt = (PromptGroupV2Interface)list4.get(0))) {
            this.internalPromptGroup = prompt;
            this.getLogger2().debug("read the internal group from XML due to readExternal() call.");
        }
    }

    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        Map optionsMap;
        List list;
        super.writeDefinition(element, writingContext);
        this.getLogger2().debug("Writing to DOM for a shared definition.");
        if (null != this.getSharedPromptGroupLocation()) {
            XmlUtil.setAttr((Element)element, (String)"sharedPromptLocation", (String)("URL::" + this.getSharedPromptGroupLocation()));
        }
        if (null != this.getSharedPromptGroupLocation()) {
            MetadataDescriptor md = PersistenceFactory.newMetadataDescriptor(null);
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("SBIP_URL", this.getSharedPromptGroupLocation());
            md.setAdditionalInfo(info);
            md.setType("PROMPT_GROUP");
            writingContext.addMetadataDescriptor(md);
        }
        if (null != this.label && !(list = PersistHelper.getAllText((LocalizableString)this.label, null)).isEmpty()) {
            this.getLogger2().debug("Writing labels.");
            SharedPromptGroup.writeRelatedObjects((List)list, (Node)element, (PromptsWritingContext)writingContext, (String)"Label");
        }
        if (null != this.description && !(list = PersistHelper.getAllText((LocalizableString)this.description, null)).isEmpty()) {
            this.getLogger2().debug("Writing descriptions.");
            SharedPromptGroup.writeRelatedObjects((List)list, (Node)element, (PromptsWritingContext)writingContext, (String)"Description");
        }
        if (null != (optionsMap = writingContext.getOptionsMap()) && optionsMap.containsKey("writeExternal")) {
            this.getLogger2().debug("Writing internal group due to writeExternal() call.");
            ArrayList<PromptGroupV2Interface> list2 = new ArrayList<PromptGroupV2Interface>(1);
            list2.add(this.internalPromptGroup);
            SharedPromptGroup.writeRelatedObjects(list2, (Node)element, (PromptsWritingContext)writingContext, (String)InternalPromptGroup);
        }
    }

    public String getDefinitionElementName() {
        return "SharedPromptGroup";
    }

    public void replace(Object referencedObject, Object replacementObject) {
    }

    public List getReferencedResources(Class type, boolean recursive) {
        return this.internalPromptGroup.getReferencedResources(type, recursive);
    }

    public String toString() {
        return "Label:" + this.getPromptGroupLabel(Locale.getDefault()) + " Desc: " + this.getPromptGroupDescription(Locale.getDefault());
    }

    public Collection getLocales() {
        if (null != this.label) {
            return this.label.getLocales();
        }
        return Collections.emptyList();
    }

    public PropertyList getLocalizableProperties(Locale locale) {
        ValidateArg.notNull((Object)locale, (String)"locale");
        PropertyList propertyList = new PropertyList();
        this.getLogger2().debug("getLocalizableProperties, if any, for", this.getPromptGroupLabel(locale));
        if (null != this.label) {
            propertyList.addProperty("Label", this.label.getText(locale));
        }
        if (null != this.description) {
            propertyList.addProperty("Description", this.description.getText(locale));
        }
        return propertyList;
    }

    public void setLocalizableProperties(Locale locale, PropertyMap map) {
        ValidateArg.notNull((Object)locale, (String)"locale");
        ValidateArg.notNull((Object)map, (String)"property map");
        this.getLogger2().debug("setLocalizableProperties on group labeled:", this.getPromptGroupLabel(locale));
        this.getLogger2().debug("setting label, description for", locale.toString());
        if (map.containsProperty("Label")) {
            this.setPromptGroupLabel(map.getProperty("Label"), locale);
        }
        if (map.containsProperty("Description")) {
            this.setPromptGroupDescription(map.getProperty("Description"), locale);
        }
    }

    public PropertyList getLocalizableProperties() {
        return this.getLocalizableProperties(Locale.getDefault());
    }

    public void setLocalizableProperties(PropertyMap map) {
        this.setLocalizableProperties(Locale.getDefault(), map);
    }

    public void beginLocalization() {
    }

    public void endLocalization() {
    }

    @Override
    public void addPromptDefinitionCombination(PromptDefinitionInterface promptDefinitionToCombine1, PromptDefinitionInterface promptDefinitionToCombine2) {
    }

    @Override
    public boolean isClearPromptValuesWhenHidden() {
        return this.getInternalPromptGroup().isClearPromptValuesWhenHidden();
    }

    @Override
    public List<AttributeDependencyInterface> getDependentPromptsForAttributes() {
        return this.getInternalPromptGroup().getDependentPromptsForAttributes();
    }

    @Override
    public boolean isIgnorePromptValuesWhenHidden() {
        return this.getInternalPromptGroup().isIgnorePromptValuesWhenHidden();
    }

    @Override
    public List<PromptDefinitionInterface> getPromptDefinitionCombinations(PromptDefinitionInterface promptDefinition) {
        return this.getInternalPromptGroup().getPromptDefinitionCombinations(promptDefinition);
    }

    @Override
    public PromptGroupLayoutInterface getPromptGroupLayout() {
        return this.getInternalPromptGroup().getPromptGroupLayout();
    }

    @Override
    public ScriptHolder getScript(PromptAction promptAction) {
        return this.getInternalPromptGroup().getScript(promptAction);
    }

    @Override
    public Collection<ScriptHolder> getScripts() {
        return this.getInternalPromptGroup().getScripts();
    }

    @Override
    public boolean isPromptGroupDisabled() {
        return this.getInternalPromptGroup().isPromptGroupDisabled();
    }

    @Override
    public void removePromptDefinitionCombination(PromptDefinitionInterface promptDefinitionToCombine1, PromptDefinitionInterface promptDefinitionToCombine2) {
    }

    @Override
    public void removeScript(PromptAction promptAction) {
    }

    @Override
    public UIConfigurationInterface getUIConfiguration() {
        return this.getInternalPromptGroup().getUIConfiguration();
    }

    @Override
    public void setUIConfiguration(UIConfigurationInterface uiConfig) {
        this.getInternalPromptGroup().setUIConfiguration(uiConfig);
    }

    @Override
    public void setClearPromptValuesWhenHidden(boolean clearPromptValuesWhenHidden) {
    }

    @Override
    public void setDependentPromptsForAttributes(List<AttributeDependencyInterface> dependencies) {
    }

    @Override
    public void setIgnorePromptValuesWhenHidden(boolean ignorePromptValuesWhenHidden) {
    }

    @Override
    public void setPromptGroupDisabled(boolean disabled) {
    }

    @Override
    public void setPromptGroupLayout(PromptGroupLayoutInterface layout) {
    }

    @Override
    public void setScript(ScriptHolder scriptHolder) {
    }

    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        Locale locale = PromptConfigurationFactory.getLocaleOption(context);
        if (options.containsKey("label")) {
            this.setPromptGroupLabel(PromptConfigurationFactory.getStringOption((String)"label", options, context), locale);
        }
        if (options.containsKey("description")) {
            this.setPromptGroupDescription(PromptConfigurationFactory.getStringOption((String)"description", options, context), locale);
        }
    }

    @Override
    public boolean isTransparent() {
        return this.getInternalPromptGroup().isTransparent();
    }

    @Override
    public void setTransparent(boolean transparent) {
    }

    @Override
    public List<AttributeDescriptor> getAttributeDescriptors(Locale locale) {
        ArrayList<AttributeDescriptor> attributeList = new ArrayList<AttributeDescriptor>();
        AttributeGroup general = new AttributeGroup("General");
        attributeList.add((AttributeDescriptor)general);
        general.getAttributes().add(new AttributeDescriptor("Label".toLowerCase(), "Label".toLowerCase(), "String", (Object)this.getPromptGroupLabel(locale), null, true, true));
        general.getAttributes().add(new AttributeDescriptor("Description".toLowerCase(), "Description".toLowerCase(), "String", (Object)this.getPromptGroupDescription(locale), null, true, true));
        return attributeList;
    }

    @Override
    public synchronized String getPromptID() {
        if (this.promptID == null) {
            this.promptID = PromptIdentifierFactory.getPromptIdentifier("PromptGroup");
        }
        return this.promptID;
    }

    @Override
    public synchronized void setPromptID(String promptID) {
        if (promptID == "_SAS_PROMPT_ID_RESET") {
            this.promptID = null;
        } else if (this.promptID == null) {
            this.promptID = promptID;
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        if (null != this.internalPromptGroup && this.internalPromptGroup instanceof ContextEnabledObject) {
            ((ContextEnabledObject)this.internalPromptGroup).setApplicationContext(applicationContext);
        }
    }
}

