/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.groups;

import com.sas.codepolicy.SASScope;
import com.sas.prompts.AttributeDependencyInterface;
import com.sas.prompts.MutableIdentifiablePromptInterface;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.PromptDefinitionCombination;
import com.sas.prompts.PromptDefinitionReference;
import com.sas.prompts.PromptHelp;
import com.sas.prompts.PromptIdentifierFactory;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.definitions.ModalGroupDefinition;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.PromptGroupLayoutInterface;
import com.sas.prompts.groups.PromptGroupV3Interface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.groups.shared.SharedPromptGroup;
import com.sas.prompts.script.PromptAction;
import com.sas.prompts.script.ScriptHolder;
import com.sas.prompts.uiconfig.BaseUIConfiguration;
import com.sas.prompts.uiconfig.CollapsibleGroupUIConfiguration;
import com.sas.prompts.uiconfig.TitledGroupUIConfiguration;
import com.sas.prompts.uiconfig.UIConfigurationFactory;
import com.sas.prompts.util.PromptContentHandler;
import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.SubstitutionProperties;
import com.sas.storage.editableproperties.UnexpectedSubstitutionException;
import com.sas.uiconfig.ApplicationContext;
import com.sas.uiconfig.ContextEnabledObject;
import com.sas.uiconfig.UIConfigurationInterface;
import com.sas.util.AttributeConfigurationInterface;
import com.sas.util.AttributeDescriptor;
import com.sas.util.AttributeGroup;
import com.sas.util.ListFactory;
import com.sas.util.LocalizableString;
import com.sas.util.UsageVersion;
import com.sas.util.Util;
import com.sas.util.ValidateArg;
import com.sas.util.anno.NotNull;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PersistConstants;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import com.sas.util.xmlpersist.impl.LocalizedText;
import com.sas.util.xmlpersist.impl.PersistHelper;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
public class PromptGroup
extends AbstractPersistence
implements PromptGroupV3Interface,
MultiLocaleProperties,
AttributeConfigurationInterface,
MutableIdentifiablePromptInterface,
ContextEnabledObject,
SubstitutionProperties {
    @SASScope
    public static final String PROMPT_GROUP_XML_WRITE_REFS_NOT_DEFINITIONS = "PROMPT_GROUP_XML_WRITE_REFS_NOT_DEFINITIONS";
    private static final long serialVersionUID = 5268185798001640902L;
    private List promptDefinitionsAndSubgroups;
    private PromptHelp _promptHelp;
    private boolean hidden = false;
    private boolean disabled = false;
    private boolean transparent;
    private String locPropVersion = "2.0";
    private LocalizableString label;
    private LocalizableString description;
    private Map<PromptAction, ScriptHolder> scripts;
    private List<AttributeDependencyInterface> attributeDependencies;
    private boolean clearPromptValuesWhenHidden;
    private boolean ignorePromptValuesWhenHidden;
    private String promptID;
    private UIConfigurationInterface uiConfig;
    private PromptGroupLayoutInterface layout;
    private CopyOnWriteArrayList<PromptDefinitionCombination> combinations = new CopyOnWriteArrayList();
    private transient ApplicationContext applicationContext;

    public PromptGroup() {
        this.promptDefinitionsAndSubgroups = ListFactory.newList();
        this.label = new LocalizableString();
        this.description = new LocalizableString();
        this.scripts = new ConcurrentHashMap<PromptAction, ScriptHolder>();
    }

    public PromptGroup(List promptDefinitionsAndSubgroups) {
        this();
        if (null != promptDefinitionsAndSubgroups && !promptDefinitionsAndSubgroups.isEmpty()) {
            for (Object object : promptDefinitionsAndSubgroups) {
                if (!(object instanceof PromptGroupInterface) && !(object instanceof PromptDefinitionInterface)) continue;
                this.promptDefinitionsAndSubgroups.add(object);
            }
        }
    }

    @Override
    public PromptHelp getPromptHelp() {
        return this._promptHelp;
    }

    public void setPromptHelp(PromptHelp promptHelp) {
        this._promptHelp = promptHelp;
    }

    @SASScope
    public String getDefinitionElementName() {
        return "PromptGroup";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PromptDefinitionInterface getPromptDefinition(String promptName, boolean recursive) {
        List list = this.promptDefinitionsAndSubgroups;
        synchronized (list) {
            int n = this.promptDefinitionsAndSubgroups.size();
            for (int i = 0; i < n; ++i) {
                Object item = this.promptDefinitionsAndSubgroups.get(i);
                if (item instanceof PromptDefinitionInterface) {
                    String name = ((PromptDefinitionInterface)item).getPromptName();
                    if (!Util.equal((Object)name, (Object)promptName)) continue;
                    return (PromptDefinitionInterface)item;
                }
                if (item instanceof PromptGroupInterface) {
                    PromptDefinitionInterface pdi;
                    if (!recursive || (pdi = ((PromptGroupInterface)item).getPromptDefinition(promptName, recursive)) == null) continue;
                    return pdi;
                }
                throw new IllegalStateException("PromptGroup should only contain PromptDefinitionInterfaces and PromptGroupInterfaces: " + item.getClass().getName());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPromptDefinitionsAndSubgroups(List definitions, boolean recursive, boolean includeDefinitions, boolean includeSubgroups) {
        if (definitions == null) {
            definitions = new LinkedList();
        }
        List list = this.promptDefinitionsAndSubgroups;
        synchronized (list) {
            int n = this.promptDefinitionsAndSubgroups.size();
            for (int i = 0; i < n; ++i) {
                Object item = this.promptDefinitionsAndSubgroups.get(i);
                if (item instanceof PromptDefinitionInterface) {
                    if (!includeDefinitions) continue;
                    definitions.add(item);
                    continue;
                }
                if (item instanceof PromptGroupInterface) {
                    if (includeSubgroups) {
                        definitions.add(item);
                    }
                    if (!recursive) continue;
                    ((PromptGroupInterface)item).getPromptDefinitionsAndSubgroups(definitions, recursive, includeDefinitions, includeSubgroups);
                    continue;
                }
                throw new IllegalStateException("PromptGroup should only contain PromptDefinitionInterfaces and PromptGroupInterfaces: " + item.getClass().getName());
            }
        }
        return definitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPromptDefinition(PromptDefinitionInterface promptDefinition) {
        if (null != promptDefinition) {
            List list = this.promptDefinitionsAndSubgroups;
            synchronized (list) {
                int n = this.promptDefinitionsAndSubgroups.size();
                for (int i = 0; i < n; ++i) {
                    Object item = this.promptDefinitionsAndSubgroups.get(i);
                    if (item instanceof PromptDefinitionInterface) {
                        if (promptDefinition == item) {
                            return true;
                        }
                        if (!(item instanceof PromptGroupInterface)) continue;
                        return ((PromptGroupInterface)item).hasPromptDefinition(promptDefinition);
                    }
                    if (item instanceof PromptGroupInterface) {
                        if (!((PromptGroupInterface)item).hasPromptDefinition(promptDefinition)) continue;
                        return true;
                    }
                    throw new IllegalStateException("PromptGroup should only contain PromptDefinitionInterfaces and PromptGroupInterfaces: " + item.getClass().getName());
                }
            }
        }
        return false;
    }

    public List getPromptDefinitionsAndSubgroups() {
        return this.getPromptDefinitionsAndSubgroups(null, false, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PromptGroupInterface findPromptSubgroup(PromptDefinitionInterface promptDefinition) {
        List list = this.promptDefinitionsAndSubgroups;
        synchronized (list) {
            if (this.promptDefinitionsAndSubgroups.contains(promptDefinition)) {
                return this;
            }
            int n = this.promptDefinitionsAndSubgroups.size();
            for (int i = 0; i < n; ++i) {
                PromptGroupInterface subgroupFoundIn;
                Object item = this.promptDefinitionsAndSubgroups.get(i);
                if (!(item instanceof PromptGroupInterface) || (subgroupFoundIn = ((PromptGroupInterface)item).findPromptSubgroup(promptDefinition)) == null) continue;
                return subgroupFoundIn;
            }
        }
        return null;
    }

    @Override
    public List<PromptDefinitionInterface> getPromptDefinitions(boolean recursive) {
        return this.getPromptDefinitionsAndSubgroups(null, recursive, true, false);
    }

    @Override
    public List<PromptGroupInterface> getPromptSubgroups(boolean recursive) {
        return this.getPromptDefinitionsAndSubgroups(null, recursive, false, true);
    }

    @Override
    public void addPromptDefinition(PromptDefinitionInterface promptDefinition) {
        if (null != promptDefinition) {
            this.promptDefinitionsAndSubgroups.add(promptDefinition);
        }
    }

    @Override
    public void addPromptDefinition(PromptDefinitionInterface promptDefinition, int index) {
        if (null != promptDefinition) {
            this.addDefinitionOrSubGroup(promptDefinition, index);
        }
    }

    @Override
    public void addPromptDefinitions(List<PromptDefinitionInterface> promptDefinitions) {
        if (null != promptDefinitions && !promptDefinitions.isEmpty()) {
            for (PromptDefinitionInterface element : promptDefinitions) {
                this.addPromptDefinition(element);
            }
        }
    }

    @Override
    public void removePromptDefinition(PromptDefinitionInterface promptDefinition) {
        if (this.promptDefinitionsAndSubgroups.contains(promptDefinition)) {
            this.promptDefinitionsAndSubgroups.remove(promptDefinition);
        }
    }

    @Override
    public void addPromptSubgroup(PromptGroupInterface promptSubgroup) {
        if (null != promptSubgroup) {
            this.promptDefinitionsAndSubgroups.add(promptSubgroup);
        }
    }

    @Override
    public void addPromptSubgroup(PromptGroupInterface promptSubgroup, int index) {
        if (null != promptSubgroup) {
            this.addDefinitionOrSubGroup(promptSubgroup, index);
        }
    }

    private void addDefinitionOrSubGroup(Object newObject, int index) {
        if (index == -1) {
            this.promptDefinitionsAndSubgroups.add(newObject);
            return;
        }
        if (index < -1) {
            throw new IllegalArgumentException("The index of " + index + " needs to be >= -1.");
        }
        if (index == 0) {
            this.promptDefinitionsAndSubgroups.add(0, newObject);
            return;
        }
        int size = this.promptDefinitionsAndSubgroups.size();
        if (index > size) {
            throw new IllegalArgumentException("The index of " + index + " needs to be <= " + size + ".");
        }
        this.promptDefinitionsAndSubgroups.add(index, newObject);
    }

    @Override
    public void removePromptSubgroup(PromptGroupInterface promptSubgroup) {
        if (promptSubgroup != null) {
            this.promptDefinitionsAndSubgroups.remove(promptSubgroup);
        }
    }

    @Override
    public int indexOfPromptDefinitionOrSubgroup(Object promptDefintionOrSubGroup) {
        return this.promptDefinitionsAndSubgroups.indexOf(promptDefintionOrSubGroup);
    }

    @Override
    public String getPromptGroupLabel(Locale locale) {
        return PromptUtil.getDelegatedText(this.label, locale, this.getApplicationContext());
    }

    @Override
    public void setPromptGroupLabel(String newLabel, Locale locale) {
        this.label.setText(newLabel, locale);
    }

    @Override
    public String getPromptGroupDescription(Locale locale) {
        return PromptUtil.getDelegatedText(this.description, locale, this.getApplicationContext());
    }

    @Override
    public void setPromptGroupDescription(String newDesc, Locale locale) {
        this.description.setText(newDesc, locale);
    }

    @Override
    public LocalizableString getPromptGroupLabels() {
        try {
            return (LocalizableString)this.label.clone();
        }
        catch (CloneNotSupportedException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public LocalizableString getPromptGroupDescriptions() {
        try {
            return (LocalizableString)this.description.clone();
        }
        catch (CloneNotSupportedException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void setPromptGroupLabels(LocalizableString labels) {
        try {
            this.label = (LocalizableString)labels.clone();
        }
        catch (CloneNotSupportedException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setPromptGroupDescriptions(LocalizableString descriptions) {
        try {
            this.description = (LocalizableString)descriptions.clone();
        }
        catch (CloneNotSupportedException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isPromptGroupHidden() {
        return this.hidden;
    }

    @Override
    public void setPromptGroupHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean isPromptGroupDisabled() {
        return this.disabled;
    }

    @Override
    public void setPromptGroupDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String toString() {
        return "Group: " + this.label.getText(PersistConstants.DEFAULT_LOCALE);
    }

    @Override
    @SASScope
    public PromptGroupInterface copy(PromptGroupInterface newGroup) {
        if (newGroup == null) {
            newGroup = new PromptGroup();
        }
        if (newGroup instanceof PromptGroup) {
            try {
                ((PromptGroup)newGroup).setPromptGroupLabels((LocalizableString)this.getPromptGroupLabels().clone());
                ((PromptGroup)newGroup).setPromptGroupDescriptions((LocalizableString)this.getPromptGroupDescriptions().clone());
            }
            catch (CloneNotSupportedException cnse) {
                this.getLogger2().error(cnse.getMessage(), (Throwable)cnse);
            }
            ((PromptGroup)newGroup).setPromptGroupHidden(this.isPromptGroupHidden());
        }
        return newGroup;
    }

    @Override
    public void removeAll() {
        if (this.promptDefinitionsAndSubgroups != null) {
            this.promptDefinitionsAndSubgroups.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllPromptDefinitions(boolean recursive) {
        List list = this.promptDefinitionsAndSubgroups;
        synchronized (list) {
            int i;
            for (i = this.promptDefinitionsAndSubgroups.size() - 1; i >= 0; --i) {
                Object item = this.promptDefinitionsAndSubgroups.get(i);
                if (!(item instanceof PromptDefinitionInterface) || item instanceof ModalGroupDefinition) continue;
                this.promptDefinitionsAndSubgroups.remove(i);
            }
            if (recursive) {
                int n = this.promptDefinitionsAndSubgroups.size();
                for (i = 0; i < n; ++i) {
                    Object item = this.promptDefinitionsAndSubgroups.get(i);
                    if (!(item instanceof PromptGroupInterface)) continue;
                    PromptGroupInterface group = (PromptGroupInterface)item;
                    group.removeAllPromptDefinitions(recursive);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllPromptSubgroups() {
        List list = this.promptDefinitionsAndSubgroups;
        synchronized (list) {
            for (int i = this.promptDefinitionsAndSubgroups.size() - 1; i >= 0; --i) {
                Object item = this.promptDefinitionsAndSubgroups.get(i);
                if (!(item instanceof PromptGroupInterface)) continue;
                this.promptDefinitionsAndSubgroups.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replacePromptDefintion(PromptDefinitionInterface promptDefinition, PromptDefinitionInterface newPromptDefinition, boolean recursive) {
        List list = this.promptDefinitionsAndSubgroups;
        synchronized (list) {
            PromptGroupInterface group;
            int index;
            if (this.promptDefinitionsAndSubgroups.contains(promptDefinition) && (index = this.promptDefinitionsAndSubgroups.indexOf(promptDefinition)) != -1) {
                this.promptDefinitionsAndSubgroups.set(index, newPromptDefinition);
                return true;
            }
            if (recursive && (group = this.findPromptSubgroup(promptDefinition)) != null) {
                return group.replacePromptDefintion(promptDefinition, newPromptDefinition, recursive);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replacePromptSubgroup(PromptGroupInterface promptSubgroup, PromptGroupInterface newPromptSubgroup, boolean recursive) {
        List list = this.promptDefinitionsAndSubgroups;
        synchronized (list) {
            int index;
            if (this.promptDefinitionsAndSubgroups.contains(promptSubgroup) && (index = this.promptDefinitionsAndSubgroups.indexOf(promptSubgroup)) != -1) {
                this.promptDefinitionsAndSubgroups.set(index, newPromptSubgroup);
                return true;
            }
            if (recursive) {
                int n = this.promptDefinitionsAndSubgroups.size();
                for (int i = 0; i < n; ++i) {
                    PromptGroupInterface group;
                    Object item = this.promptDefinitionsAndSubgroups.get(i);
                    if (!(item instanceof PromptGroupInterface) || !(group = (PromptGroupInterface)item).replacePromptSubgroup(promptSubgroup, newPromptSubgroup, recursive)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isIgnorePromptValuesWhenHidden() {
        return this.ignorePromptValuesWhenHidden;
    }

    @Override
    public void setIgnorePromptValuesWhenHidden(boolean ignorePromptValuesWhenHidden) {
        this.ignorePromptValuesWhenHidden = ignorePromptValuesWhenHidden;
    }

    @Override
    public boolean isClearPromptValuesWhenHidden() {
        return this.clearPromptValuesWhenHidden;
    }

    @Override
    public void setClearPromptValuesWhenHidden(boolean clearPromptValuesWhenHidden) {
        this.clearPromptValuesWhenHidden = clearPromptValuesWhenHidden;
    }

    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        ArrayList uiConfigList;
        ArrayList list0;
        ArrayList scriptList;
        super.consumeRelatedObjects(roHolder);
        ArrayList list = roHolder.consumeObjects("DefinitionsAndSubgroups");
        if (!list.isEmpty()) {
            for (Object o : list) {
                if (o instanceof PromptGroupInterface) {
                    this.addPromptSubgroup((PromptGroupInterface)o);
                    this.getLogger2().debug("consumeRelatedObjects, addPromptSubgroup() to ", this.getPromptGroupLabel(PersistConstants.DEFAULT_LOCALE));
                }
                if (o instanceof PromptDefinitionInterface) {
                    this.addPromptDefinition((PromptDefinitionInterface)o);
                    this.getLogger2().debug("consumeRelatedObjects, addPromptDefinition() to ", this.getPromptGroupLabel(PersistConstants.DEFAULT_LOCALE));
                }
                if (!(o instanceof PromptDefinitionReference)) continue;
                this.addPromptDefinition(((PromptDefinitionReference)((Object)o)).getPromptDefinition());
                this.getLogger2().debug("consumeRelatedObjects, addPromptDefinition() by reference to ", this.getPromptGroupLabel(PersistConstants.DEFAULT_LOCALE));
            }
        }
        if (!(list = roHolder.consumeObjects("Layout")).isEmpty()) {
            PromptGroupLayoutInterface layout0 = (PromptGroupLayoutInterface)list.get(0);
            this.setPromptGroupLayout(layout0);
        }
        if (!(list = roHolder.consumeObjects("Label")).isEmpty()) {
            for (LocalizedText text : list) {
                this.setPromptGroupLabel(text.getText(), text.getLocale());
                this.getLogger2().debug("consumeObjects, setPGLabel() on ", this.getPromptGroupLabel(PersistConstants.DEFAULT_LOCALE));
            }
        }
        if (!(list = roHolder.consumeObjects("Description")).isEmpty()) {
            for (LocalizedText text : list) {
                this.setPromptGroupDescription(text.getText(), text.getLocale());
                this.getLogger2().debug("consumeObjects, setPGDescrp() on ", this.getPromptGroupLabel(PersistConstants.DEFAULT_LOCALE));
            }
        }
        this.combinations.addAll(roHolder.consumeObjects("Combinations"));
        ArrayList attrDependencyList = roHolder.consumeObjects("AttributeDependencies");
        if (attrDependencyList != null && attrDependencyList.size() != 0) {
            this.setDependentPromptsForAttributes(attrDependencyList);
            this.getLogger2().debug("consumeRelObjects, setDependentPromptsForAttributes() has size:", Integer.toString(attrDependencyList.size()));
        }
        if (!(scriptList = roHolder.consumeObjects("Scripts")).isEmpty()) {
            for (ScriptHolder holder : scriptList) {
                this.setScript(holder);
            }
            this.getLogger2().debug("consumeRelObjects, set some scripts.");
        }
        if (!(list0 = roHolder.consumeObjects("PromptHelp")).isEmpty()) {
            Iterator iter = list0.iterator();
            this.getLogger2().debug("consumeRelObjects, setPromptHelp() on");
            while (iter.hasNext()) {
                PromptHelp ph = (PromptHelp)iter.next();
                this.setPromptHelp(ph);
                this.getLogger2().debug("consumeRelObjects, setting label to:", ph.toString());
            }
        }
        if (!(uiConfigList = roHolder.consumeObjects("UIConfig")).isEmpty()) {
            for (UIConfigurationInterface tempUIConfig : uiConfigList) {
                this.setUIConfiguration(tempUIConfig);
            }
            this.getLogger2().debug("consumeRelObjects, set ui config");
        }
    }

    @SASScope
    public void consumeAttributes(AttributesProvider provider) {
        Map map;
        super.consumeAttributes(provider);
        this.setPromptID(provider.consumeAttr("promptId"));
        this.setPromptGroupHidden(provider.consumeBooleanAttr("hidden", false));
        this.setPromptGroupDisabled(provider.consumeBooleanAttr("disabled", false));
        this.setTransparent(provider.consumeBooleanAttr("transparent", false));
        this.setIgnorePromptValuesWhenHidden(provider.consumeBooleanAttr("ignorePromptValuesWhenHidden", false));
        this.setClearPromptValuesWhenHidden(provider.consumeBooleanAttr("clearPromptValuesWhenHidden", false));
        PromptsReadingContext prContext = provider.getReadingContext();
        if (null != prContext && null != prContext.getOptionsMap() && (map = prContext.getOptionsMap()).containsKey("com.sas.uiconfig.ApplicationContext")) {
            this.applicationContext = (ApplicationContext)map.get("com.sas.uiconfig.ApplicationContext");
        }
    }

    @SASScope
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        ArrayList<Object> list0;
        List<PromptDefinitionCombination> list;
        super.writeDefinition(element, writingContext);
        XmlUtil.setAttr((Element)element, (String)"promptId", (String)this.getPromptID());
        XmlUtil.setBooleanAttr((Element)element, (String)"hidden", (boolean)this.isPromptGroupHidden(), (boolean)false);
        XmlUtil.setBooleanAttr((Element)element, (String)"disabled", (boolean)this.isPromptGroupDisabled(), (boolean)false);
        XmlUtil.setBooleanAttr((Element)element, (String)"transparent", (boolean)this.isTransparent(), (boolean)false);
        XmlUtil.setBooleanAttr((Element)element, (String)"clearPromptValuesWhenHidden", (boolean)this.isClearPromptValuesWhenHidden(), (boolean)false);
        XmlUtil.setBooleanAttr((Element)element, (String)"ignorePromptValuesWhenHidden", (boolean)this.isIgnorePromptValuesWhenHidden(), (boolean)false);
        this.writeDefinitionsAndGroups(element, writingContext);
        this.writeLayout(element, writingContext);
        if (!this.combinations.isEmpty()) {
            list = new ArrayList();
            for (PromptDefinitionCombination pdc : this.combinations) {
                list.add(pdc);
            }
            this.getLogger2().debug("Writing combinations.");
            PromptGroup.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"Combinations");
        }
        if (!(list = PersistHelper.getAllText((LocalizableString)this.label, null)).isEmpty()) {
            this.getLogger2().debug("Writing labels.");
            PromptGroup.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"Label");
        }
        if (!(list = PersistHelper.getAllText((LocalizableString)this.description, null)).isEmpty()) {
            this.getLogger2().debug("Writing descriptions.");
            PromptGroup.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"Description");
        }
        if (this.getDependentPromptsForAttributes() != null && this.getDependentPromptsForAttributes().size() > 0) {
            list0 = new ArrayList<Object>();
            list0.addAll(this.getDependentPromptsForAttributes());
            PromptGroup.writeRelatedObjects(list0, (Node)element, (PromptsWritingContext)writingContext, (String)"AttributeDependencies");
        }
        if (!this.scripts.isEmpty()) {
            this.getLogger2().debug("writing script holders.");
            list0 = new ArrayList();
            for (ScriptHolder sh : this.scripts.values()) {
                list0.add(sh);
            }
            PromptGroup.writeRelatedObjects(list0, (Node)element, (PromptsWritingContext)writingContext, (String)"Scripts");
        }
        if (this.uiConfig != null) {
            list0 = new ArrayList(1);
            list0.add((PersistenceInterface)this.uiConfig);
            PromptGroup.writeRelatedObjects(list0, (Node)element, (PromptsWritingContext)writingContext, (String)"UIConfig");
        }
        if (this._promptHelp != null) {
            list0 = new ArrayList(1);
            list0.add(this._promptHelp);
            PromptGroup.writeRelatedObjects(list0, (Node)element, (PromptsWritingContext)writingContext, (String)"PromptHelp");
        }
    }

    @SASScope
    protected void writeDefinitionsAndGroups(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        if (!this.promptDefinitionsAndSubgroups.isEmpty()) {
            Map writingContextOptionsMap = writingContext.getOptionsMap();
            boolean writeRefsNotDefinitions = false;
            if (writingContextOptionsMap != null && writingContextOptionsMap.containsKey(PROMPT_GROUP_XML_WRITE_REFS_NOT_DEFINITIONS)) {
                writeRefsNotDefinitions = true;
            }
            if (writeRefsNotDefinitions) {
                this.getLogger2().debug("Writing subgroups and references for definitions.");
                PromptGroup.writeRelatedObjects((List)this.getWritableReferencesForDefinitionsAndGroups(), (Node)element, (PromptsWritingContext)writingContext, (String)"DefinitionsAndSubgroups");
            } else {
                this.getLogger2().debug("Writing definitions and subgroups.");
                PromptGroup.writeRelatedObjects((List)this.promptDefinitionsAndSubgroups, (Node)element, (PromptsWritingContext)writingContext, (String)"DefinitionsAndSubgroups");
            }
        }
    }

    protected void writeLayout(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        if (this.layout != null) {
            this.getLogger2().debug("Writing layout info");
            ArrayList<PromptGroupLayoutInterface> list = new ArrayList<PromptGroupLayoutInterface>();
            list.add(this.layout);
            PromptGroup.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"Layout");
        }
    }

    protected List getWritableLayoutInfo(boolean writeRefsNotDefinitions) {
        ArrayList outputList = new ArrayList();
        return outputList;
    }

    @SASScope
    protected List getWritableReferencesForDefinitionsAndGroups() {
        ArrayList outputList = new ArrayList(this.promptDefinitionsAndSubgroups.size());
        for (Object o : this.promptDefinitionsAndSubgroups) {
            if (o instanceof PromptDefinitionInterface) {
                o = new PromptDefinitionReference((PromptDefinitionInterface)o, "DO_NOT_PERSIST_VALUE");
            }
            outputList.add(o);
        }
        return outputList;
    }

    @SASScope
    public List getReferencedResources(Class type, boolean recursive) {
        ArrayList<PromptDefinitionInterface> retVal = new ArrayList<PromptDefinitionInterface>();
        List<PromptDefinitionInterface> out = this.getPromptDefinitions(true);
        for (PromptDefinitionInterface element : out) {
            if (type != null && type.isAssignableFrom(element.getClass())) {
                retVal.add(element);
            }
            retVal.addAll(element.getReferencedResources(type, recursive));
        }
        this.getLogger2().debug("getReferencedResources() From these prompt definitions:", Integer.toString(out.size()));
        this.getLogger2().debug("we are returning list of size:", Integer.toString(retVal.size()));
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsSubgroup(PromptGroupInterface subGroupCandidate, boolean recursive) {
        List list = this.promptDefinitionsAndSubgroups;
        synchronized (list) {
            if (this.promptDefinitionsAndSubgroups.contains(subGroupCandidate)) {
                return true;
            }
            if (recursive) {
                int n = this.promptDefinitionsAndSubgroups.size();
                for (int i = 0; i < n; ++i) {
                    boolean found;
                    Object item = this.promptDefinitionsAndSubgroups.get(i);
                    if (!(item instanceof PromptGroupInterface) || !(found = ((PromptGroupInterface)item).containsSubgroup(subGroupCandidate, recursive))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @SASScope
    public Collection getLocales() {
        return this.label.getLocales();
    }

    @SASScope
    public PropertyList getLocalizableProperties(Locale locale) {
        ValidateArg.notNull((Object)locale, (String)"locale");
        PropertyList propertyList = new PropertyList();
        this.getLogger2().debug("getLocalizableProperties, adding properties for", this.getPromptGroupLabel(locale));
        this.getLogger2().debug(" adding label, description for", locale.toString());
        propertyList.addProperty("Label", this.getPromptGroupLabel(locale));
        propertyList.addProperty("Description", this.getPromptGroupDescription(locale));
        propertyList.addComment("Do not translate the version.");
        propertyList.addProperty("version", this.locPropVersion);
        this.extractPromptsLocProps(this, locale, propertyList);
        List<PromptGroupInterface> subs = this.getPromptSubgroups(false);
        for (int i = 0; i < subs.size(); ++i) {
            PromptGroupInterface group = subs.get(i);
            if (!(group instanceof MultiLocaleProperties)) continue;
            propertyList.addComment("a subgroup");
            propertyList.addProperty("PromptGroup", i, ((MultiLocaleProperties)group).getLocalizableProperties(locale));
        }
        return propertyList;
    }

    @SASScope
    public void setLocalizableProperties(Locale locale, PropertyMap map) {
        ValidateArg.notNull((Object)locale, (String)"locale");
        if (map == null) {
            return;
        }
        this.getLogger2().debug("setLocalizableProperties on group labeled:", this.getPromptGroupLabel(locale));
        String version = map.getProperty("version");
        if (null == version || !version.startsWith(this.locPropVersion)) {
            this.getLogger2().error("Cannot set localizable properties if version < " + this.locPropVersion);
            return;
        }
        this.getLogger2().debug("setting label, description for", locale.toString());
        if (map.containsProperty("Label")) {
            this.setPromptGroupLabel(map.getProperty("Label"), locale);
        }
        if (map.containsProperty("Description")) {
            this.setPromptGroupDescription(map.getProperty("Description"), locale);
        }
        this.applyLocPropsToPrompts(this, locale, map);
        List<PromptGroupInterface> subs = this.getPromptSubgroups(false);
        for (int i = 0; i < subs.size(); ++i) {
            PropertyMap sub;
            PromptGroupInterface group = subs.get(i);
            if (!(group instanceof MultiLocaleProperties) || null == (sub = map.getNestedProperties("PromptGroup", i))) continue;
            ((MultiLocaleProperties)group).setLocalizableProperties(locale, sub);
        }
    }

    public PropertyList getLocalizableProperties() {
        return this.getLocalizableProperties(Locale.getDefault());
    }

    public void setLocalizableProperties(PropertyMap map) {
        this.setLocalizableProperties(Locale.getDefault(), map);
    }

    @SASScope
    public void beginLocalization() {
    }

    @SASScope
    public void endLocalization() {
    }

    private void applyLocPropsToPrompts(PromptGroupInterface promptGroup, Locale locale, PropertyMap map) {
        List<PromptDefinitionInterface> promptsList = promptGroup.getPromptDefinitions(false);
        for (int i = 0; i < promptsList.size(); ++i) {
            PromptDefinitionInterface o = promptsList.get(i);
            if (!(o instanceof MultiLocaleProperties) || !map.containsIndexedNestedProperty("PromptDefinition", i)) continue;
            MultiLocaleProperties prompt = (MultiLocaleProperties)o;
            PropertyMap sub = map.getNestedProperties("PromptDefinition", i);
            if (null == sub) continue;
            prompt.setLocalizableProperties(locale, sub);
        }
    }

    private void extractPromptsLocProps(PromptGroupInterface group, Locale locale, PropertyList nestedList) {
        List<PromptDefinitionInterface> promptsList = group.getPromptDefinitions(false);
        for (int i = 0; i < promptsList.size(); ++i) {
            PromptDefinitionInterface promptDef;
            String promptName;
            PromptDefinitionInterface o = promptsList.get(i);
            if (!(o instanceof MultiLocaleProperties)) continue;
            MultiLocaleProperties prompt = (MultiLocaleProperties)o;
            String comment = "a prompt";
            if (o instanceof PromptDefinitionInterface && (promptName = (promptDef = o).getPromptName()) != null && promptName.length() > 0) {
                comment = "Prompt " + promptName;
            }
            nestedList.addComment(comment);
            nestedList.addProperty("PromptDefinition", i, prompt.getLocalizableProperties(locale));
        }
    }

    @Override
    public void setPromptGroupLayout(PromptGroupLayoutInterface layout) {
        this.layout = layout;
    }

    @Override
    public PromptGroupLayoutInterface getPromptGroupLayout() {
        return this.layout;
    }

    @Override
    public void addPromptDefinitionCombination(@NotNull PromptDefinitionInterface promptDefinitionToCombine1, @NotNull PromptDefinitionInterface promptDefinitionToCombine2) {
        ValidateArg.notNull((Object)promptDefinitionToCombine1, (String)"promptDefinitionToCombine1");
        ValidateArg.notNull((Object)promptDefinitionToCombine2, (String)"promptDefinitionToCombine2");
        this.combinations.add(new PromptDefinitionCombination(promptDefinitionToCombine1, promptDefinitionToCombine2));
    }

    @Override
    public List<PromptDefinitionInterface> getPromptDefinitionCombinations(PromptDefinitionInterface promptDefinition) {
        ValidateArg.notNull((Object)promptDefinition, (String)"promptDefinition");
        ArrayList<PromptDefinitionInterface> combinationMatches = new ArrayList<PromptDefinitionInterface>();
        for (PromptDefinitionCombination possibleMatch : this.combinations) {
            PromptDefinitionInterface otherDefinition;
            if (!possibleMatch.isCombinedWith(promptDefinition) || combinationMatches.contains(otherDefinition = possibleMatch.getOtherDefinition(promptDefinition))) continue;
            combinationMatches.add(otherDefinition);
            this.getLogger2().debug("getPromptDefinitionCombos found match of ", otherDefinition.getPromptName());
        }
        return combinationMatches;
    }

    @Override
    public void removePromptDefinitionCombination(@NotNull PromptDefinitionInterface promptDefinitionToCombine1, @NotNull PromptDefinitionInterface promptDefinitionToCombine2) {
        ValidateArg.notNull((Object)promptDefinitionToCombine1, (String)"promptDefinitionToCombine1");
        ValidateArg.notNull((Object)promptDefinitionToCombine2, (String)"promptDefinitionToCombine2");
        this.combinations.remove((Object)new PromptDefinitionCombination(promptDefinitionToCombine1, promptDefinitionToCombine2));
    }

    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        Object deps;
        Object scripts;
        Map localizations;
        Locale locale = PromptConfigurationFactory.getLocaleOption(context);
        if (options.containsKey("localizations") && (localizations = (Map)options.get("localizations")) != null) {
            Set entries = localizations.entrySet();
            for (Map.Entry entry : entries) {
                Locale l;
                Set entries2;
                Object value;
                if (entry.getKey() == null) continue;
                if ("label".equals(entry.getKey())) {
                    value = entry.getValue();
                    if (value instanceof Map) {
                        entries2 = ((Map)value).entrySet();
                        for (Map.Entry entry2 : entries2) {
                            l = XmlUtil.xmlToLocale((String)((String)entry2.getKey()));
                            this.setPromptGroupLabel((String)entry2.getValue(), l);
                        }
                        continue;
                    }
                    if (!(value instanceof LocalizableString)) continue;
                    this.setPromptGroupLabels((LocalizableString)value);
                    continue;
                }
                if (!"description".equals(entry.getKey())) continue;
                value = entry.getValue();
                if (value instanceof Map) {
                    entries2 = ((Map)value).entrySet();
                    for (Map.Entry entry2 : entries2) {
                        l = XmlUtil.xmlToLocale((String)((String)entry2.getKey()));
                        this.setPromptGroupDescription((String)entry2.getValue(), l);
                    }
                    continue;
                }
                if (!(value instanceof LocalizableString)) continue;
                this.setPromptGroupDescriptions((LocalizableString)value);
            }
        }
        if (options.containsKey("promptId")) {
            this.setPromptID(PromptConfigurationFactory.getStringOption((String)"promptId", options, context));
        }
        if (options.containsKey("hidden")) {
            this.setPromptGroupHidden(PromptConfigurationFactory.getBoolOption((String)"hidden", options, context));
        }
        if (options.containsKey("disabled")) {
            this.setPromptGroupDisabled(PromptConfigurationFactory.getBoolOption((String)"disabled", options, context));
        }
        if (options.containsKey("transparent")) {
            this.setTransparent(PromptConfigurationFactory.getBoolOption((String)"transparent", options, context));
        }
        if (options.containsKey("clearPromptValuesWhenHidden")) {
            this.setClearPromptValuesWhenHidden(PromptConfigurationFactory.getBoolOption((String)"clearPromptValuesWhenHidden", options, context));
        }
        if (options.containsKey("ignorePromptValuesWhenHidden")) {
            this.setIgnorePromptValuesWhenHidden(PromptConfigurationFactory.getBoolOption((String)"ignorePromptValuesWhenHidden", options, context));
        }
        if (options.containsKey("label")) {
            this.setPromptGroupLabel(PromptConfigurationFactory.getStringOption((String)"label", options, context), locale);
        }
        if (options.containsKey("description")) {
            this.setPromptGroupDescription(PromptConfigurationFactory.getStringOption((String)"description", options, context), locale);
        }
        if (options.containsKey("UIConfig")) {
            Object uiConfig = options.get("UIConfig");
            if (uiConfig instanceof String) {
                String config = (String)uiConfig;
                this.setUIConfiguration(UIConfigurationFactory.newUIConfiguration(config));
            } else if (uiConfig instanceof UIConfigurationInterface) {
                this.setUIConfiguration((UIConfigurationInterface)uiConfig);
            } else {
                this.setUIConfiguration(null);
            }
        } else {
            this.setUIConfiguration(null);
        }
        if (options.containsKey("scripts") && (scripts = options.get("scripts")) instanceof Collection) {
            Collection scriptCollection = (Collection)scripts;
            for (Map.Entry script : scriptCollection) {
                if (!(script instanceof ScriptHolder)) continue;
                this.setScript((ScriptHolder)((Object)script));
            }
        }
        if (options.containsKey("PromptHelp")) {
            Object promptHelp = options.get("PromptHelp");
            this.setPromptHelp((PromptHelp)promptHelp);
        }
        if (options.containsKey("attributeDependencies") && (deps = options.get("attributeDependencies")) instanceof Collection && !((Collection)deps).isEmpty()) {
            Collection depsCollection = (Collection)deps;
            ArrayList<AttributeDependencyInterface> newAttDeps = new ArrayList<AttributeDependencyInterface>();
            for (Object attDep : depsCollection) {
                if (!(attDep instanceof AttributeDependencyInterface)) continue;
                newAttDeps.add((AttributeDependencyInterface)attDep);
            }
            this.setDependentPromptsForAttributes(newAttDeps);
        }
    }

    @Override
    public List<AttributeDependencyInterface> getDependentPromptsForAttributes() {
        if (this.attributeDependencies == null) {
            return Collections.emptyList();
        }
        return new CopyOnWriteArrayList<AttributeDependencyInterface>(this.attributeDependencies);
    }

    @Override
    public void setDependentPromptsForAttributes(List<AttributeDependencyInterface> dependencies) {
        this.attributeDependencies = dependencies;
    }

    @Override
    public boolean isTransparent() {
        return this.transparent;
    }

    @Override
    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    @Override
    public UIConfigurationInterface getUIConfiguration() {
        return this.uiConfig;
    }

    @Override
    public void setUIConfiguration(UIConfigurationInterface uiConfig) {
        this.uiConfig = uiConfig;
    }

    @Override
    public ScriptHolder getScript(PromptAction promptAction) {
        ValidateArg.notNull((Object)((Object)promptAction), (String)"promptAction");
        return this.scripts.get((Object)promptAction);
    }

    @Override
    public void setScript(ScriptHolder scriptHolder) {
        ValidateArg.notNull((Object)scriptHolder, (String)"scriptHolder");
        ValidateArg.notNull((Object)((Object)scriptHolder.getAction()), (String)"scriptHolder.getAction()");
        ValidateArg.notNull((Object)scriptHolder.getType(), (String)"scriptHolder.getType()");
        this.scripts.put(scriptHolder.getAction(), scriptHolder);
    }

    @Override
    public void removeScript(PromptAction promptAction) {
        this.scripts.remove((Object)promptAction);
    }

    @Override
    public Collection<ScriptHolder> getScripts() {
        return Collections.unmodifiableCollection(this.scripts.values());
    }

    public List getAttributeDescriptors(Locale myLocale) {
        Locale locale = null;
        locale = myLocale != null ? myLocale : Locale.getDefault();
        ArrayList<AttributeGroup> attributeList = new ArrayList<AttributeGroup>();
        AttributeGroup general = new AttributeGroup("General");
        AttributeGroup hiddenGroup = new AttributeGroup("Hidden");
        hiddenGroup.setVisible(false);
        general.getAttributes().add(new AttributeDescriptor("Label".toLowerCase(), "Label".toLowerCase(), "String", (Object)this.getPromptGroupLabel(locale), null, true, true));
        general.getAttributes().add(new AttributeDescriptor("Description".toLowerCase(), "Description".toLowerCase(), "String", (Object)this.getPromptGroupDescription(locale), null, true, true));
        general.getAttributes().add(new AttributeDescriptor("hidden", "hidden", "boolean", (Object)this.isPromptGroupHidden(), (Object)false, true, true));
        general.getAttributes().add(new AttributeDescriptor("disabled", "disabled", "boolean", (Object)this.isPromptGroupDisabled(), (Object)false, true, true));
        general.getAttributes().add(new AttributeDescriptor("transparent", "transparent", "boolean", (Object)this.isTransparent(), (Object)false, true, true));
        UIConfigurationInterface config = this.getUIConfiguration();
        if (config != null) {
            if (config instanceof TitledGroupUIConfiguration) {
                hiddenGroup.getAttributes().add(new AttributeDescriptor("UIConfig", "UIConfig", "String", (Object)"TitledGroupUIConfiguration", null, false, false));
            } else if (config instanceof CollapsibleGroupUIConfiguration) {
                hiddenGroup.getAttributes().add(new AttributeDescriptor("UIConfig", "UIConfig", "String", (Object)"CollapsibleGroupUIConfiguration", null, false, false));
            }
        }
        hiddenGroup.getAttributes().add(new AttributeDescriptor("promptId", "promptId", "String", (Object)this.getPromptID(), null, false, false));
        attributeList.add(general);
        attributeList.add(hiddenGroup);
        return attributeList;
    }

    @Override
    public synchronized String getPromptID() {
        if (this.promptID == null) {
            this.promptID = PromptIdentifierFactory.getPromptIdentifier("PromptGroup");
        }
        return this.promptID;
    }

    @Override
    public synchronized void setPromptID(String promptID) {
        if ("_SAS_PROMPT_ID_RESET".equals(promptID)) {
            this.promptID = null;
        } else if (this.promptID == null) {
            this.promptID = promptID;
        }
    }

    public String getVersion() {
        String tempVersion = super.getVersion();
        if (this.getUIConfiguration() instanceof BaseUIConfiguration && !((BaseUIConfiguration)this.getUIConfiguration()).getOptions().isEmpty()) {
            tempVersion = "2.2";
        } else if (null != this.getPromptHelp()) {
            tempVersion = "2.1";
        } else if (!this.getScripts().isEmpty() || !this.combinations.isEmpty() || !this.getDependentPromptsForAttributes().isEmpty() || this.isPromptGroupDisabled() || this.isClearPromptValuesWhenHidden() || this.isIgnorePromptValuesWhenHidden()) {
            tempVersion = "2.0";
        } else if (this.isTransparent() && !(this instanceof TransparentGroup) || null != this.getPromptGroupLayout() || null != this.getUIConfiguration()) {
            tempVersion = "1.1";
        }
        try {
            UsageVersion tempUV = UsageVersion.parseVersion((String)tempVersion);
            UsageVersion maxUV = this.getMaxVersion();
            if (maxUV.compareTo((Object)tempUV) > 0) {
                tempVersion = maxUV.toString();
            }
        }
        catch (ParseException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
        }
        this.getLogger2().debug("version is", tempVersion);
        return tempVersion;
    }

    protected final UsageVersion getMaxVersion() throws ParseException {
        UsageVersion max = PromptContentHandler.oldestVersion;
        this.getLogger2().debug("getMaxVersion() starts at:", max.toString());
        List<PromptDefinitionInterface> promptList = this.getPromptDefinitions(false);
        for (PromptDefinitionInterface prompt : promptList) {
            String version = prompt.getVersion();
            UsageVersion promptUV = UsageVersion.parseVersion((String)version);
            if (promptUV.compareTo((Object)max) <= 0) continue;
            max = promptUV;
        }
        this.getLogger2().debug("getMaxVersion() after prompts is:", max.toString());
        List<PromptGroupInterface> groupList = this.getPromptSubgroups(false);
        for (PromptGroupInterface group : groupList) {
            this.getLogger2().debug("getMaxVersion() recursing on groups.");
            UsageVersion groupUV = null;
            if (group instanceof SharedPromptGroup) {
                groupUV = UsageVersion.parseVersion((String)((SharedPromptGroup)group).getVersion());
            } else if (group instanceof PromptGroup) {
                groupUV = UsageVersion.parseVersion((String)((PromptGroup)group).getVersion());
            }
            if (null == groupUV || groupUV.compareTo((Object)max) <= 0) continue;
            max = groupUV;
        }
        this.getLogger2().debug("getMaxVersion() after groups is:", max.toString());
        return max;
    }

    public final ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public final void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.getLogger2().debug("setApplicationContext on", this.getPromptGroupLabel(Locale.getDefault()));
        for (PromptDefinitionInterface prompt : this.getPromptDefinitions(false)) {
            if (!(prompt instanceof ContextEnabledObject)) continue;
            ((ContextEnabledObject)prompt).setApplicationContext(applicationContext);
        }
        for (PromptGroupInterface group : this.getPromptSubgroups(false)) {
            if (!(group instanceof ContextEnabledObject)) continue;
            ((ContextEnabledObject)group).setApplicationContext(applicationContext);
        }
    }

    public final PropertyList getSubstitutionProperties() throws UnexpectedSubstitutionException {
        PropertyList propList = new PropertyList();
        List<PromptDefinitionInterface> list = this.getPromptDefinitions(true);
        if (!list.isEmpty()) {
            PropertyList propList4Prompts = new PropertyList();
            for (PromptDefinitionInterface prompt : list) {
                if (!(prompt instanceof SubstitutionProperties)) continue;
                this.getLogger2().debug("getSubstitutionProperties(), adding properties from a prompt named ", prompt.getPromptName());
                PropertyList nestedList = ((SubstitutionProperties)prompt).getSubstitutionProperties();
                propList4Prompts.addProperty(prompt.getPromptID(), nestedList);
            }
            if (!propList4Prompts.isEmpty()) {
                propList.addComment("Properties for prompts held by this prompt group.");
                propList.addProperty(this.getPromptID(), propList4Prompts);
            }
        }
        return propList;
    }

    public final void setSubstitutionProperties(@NotNull PropertyMap map) throws UnexpectedSubstitutionException {
        ValidateArg.notNull((Object)map, (String)"map");
        List<PromptDefinitionInterface> list = this.getPromptDefinitions(true);
        if (map.containsNestedProperty(this.getPromptID())) {
            PropertyMap ourMap = map.getNestedProperties(this.getPromptID());
            for (PromptDefinitionInterface prompt : list) {
                if (!(prompt instanceof SubstitutionProperties) || !ourMap.containsNestedProperty(prompt.getPromptID())) continue;
                this.getLogger2().debug("setSubstitutionProperties, setting properties on prompt named", prompt.getPromptName());
                ((SubstitutionProperties)prompt).setSubstitutionProperties(ourMap.getNestedProperties(prompt.getPromptID()));
            }
        }
    }
}

