/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.groups;

import com.sas.codepolicy.SASScope;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.prompts.datatypes.values.ValueUtil;
import com.sas.prompts.definitions.ModalGroupDefinition;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.ModalChoiceGroupInterface;
import com.sas.prompts.groups.ModalGroupInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.PromptGroupV2Interface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.groups.TransparentGroupInterface;
import com.sas.prompts.util.MapText;
import com.sas.util.UserInfo;
import com.sas.util.UserInfoInterface;
import com.sas.util.Util;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
public class ModalGroup
extends TransparentGroup
implements ModalGroupInterface {
    private static final long serialVersionUID = 1299722033538486209L;
    private ModalGroupDefinition definition;

    public ModalGroup() {
        this.init();
    }

    public ModalGroup(List promptDefinitionsAndSubgroups) {
        super(promptDefinitionsAndSubgroups);
        this.init();
    }

    @Override
    @SASScope
    public String getDefinitionElementName() {
        return "ModalGroup";
    }

    private void init() {
        this.definition = new ModalGroupDefinition();
        super.addPromptDefinition(this.definition);
    }

    @Override
    public PromptDefinitionInterface getChoiceDefinition() {
        return this.definition;
    }

    @Override
    public void setPromptGroupLabel(String newLabel, Locale locale) {
        super.setPromptGroupLabel(newLabel, locale);
        this.definition.setPromptLabel(newLabel, locale);
    }

    @Override
    public void setPromptGroupDescription(String newDesc, Locale locale) {
        super.setPromptGroupDescription(newDesc, locale);
        this.definition.setPromptDescription(newDesc, locale);
    }

    @SASScope
    public boolean isPromptValueValid(Object value) {
        return this.getModalChoiceGroupForValue(value) != null;
    }

    @SASScope
    public Map getPromptValueValidationErrors(Object value, Locale locale) {
        Map errorMap = null;
        if (!this.isPromptValueValid(value)) {
            int VALUE_NOT_A_CHOICE_GROUP = 601;
            errorMap = this.addError(errorMap, VALUE_NOT_A_CHOICE_GROUP, "The value does not match any of the values for the choice groups");
        }
        return errorMap;
    }

    @Override
    @SASScope
    protected boolean allowSubgroup(PromptGroupInterface promptSubgroup) {
        return promptSubgroup instanceof TransparentGroupInterface || promptSubgroup instanceof PromptGroupV2Interface && ((PromptGroupV2Interface)promptSubgroup).isTransparent();
    }

    @Override
    public void addPromptSubgroup(PromptGroupInterface promptSubgroup) {
        if (this.allowSubgroup(promptSubgroup)) {
            super.addPromptSubgroup(promptSubgroup);
            return;
        }
        throw new IllegalArgumentException("Subgroups are not allowed on a modal group");
    }

    @Override
    public void addPromptSubgroup(PromptGroupInterface promptSubgroup, int index) {
        if (this.allowSubgroup(promptSubgroup)) {
            super.addPromptSubgroup(promptSubgroup, index);
            return;
        }
        throw new IllegalArgumentException("Subgroup type not allowed on a modal group" + promptSubgroup);
    }

    @Override
    public void addPromptDefinition(PromptDefinitionInterface promptDefinition, int index) {
        if (promptDefinition instanceof ModalGroupDefinition) {
            this.addPromptDefinition(promptDefinition);
        }
    }

    @Override
    public void addPromptDefinition(PromptDefinitionInterface promptDefinition) {
        if (promptDefinition instanceof ModalGroupDefinition) {
            if (this.definition != null) {
                this.removePromptDefinition(this.definition);
            }
            this.definition = (ModalGroupDefinition)promptDefinition;
        }
        super.addPromptDefinition(promptDefinition, 0);
    }

    public void addPromptDefinitions(List promptDefinitions) {
        throw new IllegalArgumentException("Prompt Definitions are not allowed on a modal group");
    }

    @Override
    @SASScope
    public void removeAll() {
        super.removeAll();
        this.addPromptDefinition(this.getChoiceDefinition());
        this.getChoiceDefinition().clearDefaultValue();
    }

    @Override
    @SASScope
    public void removeAllPromptSubgroups() {
        super.removeAllPromptSubgroups();
        this.getChoiceDefinition().clearDefaultValue();
    }

    @Override
    @SASScope
    public void removePromptSubgroup(PromptGroupInterface promptSubgroup) {
        super.removePromptSubgroup(promptSubgroup);
        if (this.getChoiceDefinition().isDefaultValueSet() && promptSubgroup instanceof ModalChoiceGroupInterface && PromptUtil.isPromptValuesEqual(this.getChoiceDefinition().getDefaultValue(), ((ModalChoiceGroupInterface)promptSubgroup).getValue())) {
            this.getChoiceDefinition().clearDefaultValue();
        }
    }

    @Override
    @SASScope
    public boolean replacePromptSubgroup(PromptGroupInterface promptSubgroup, PromptGroupInterface newPromptSubgroup, boolean recursive) {
        boolean ret = super.replacePromptSubgroup(promptSubgroup, newPromptSubgroup, recursive);
        if (this.getChoiceDefinition().isDefaultValueSet() && promptSubgroup instanceof ModalChoiceGroupInterface && PromptUtil.isPromptValuesEqual(this.getChoiceDefinition().getDefaultValue(), ((ModalChoiceGroupInterface)promptSubgroup).getValue())) {
            this.getChoiceDefinition().clearDefaultValue();
        }
        return ret;
    }

    @Override
    public ModalChoiceGroupInterface getModalChoiceGroupForValue(Object value) {
        List<PromptGroupInterface> modalChoiceGroups = this.getPromptSubgroups(false);
        for (ModalChoiceGroupInterface modalChoiceGroupInterface : modalChoiceGroups) {
            if (!Util.equal((Object)value, (Object)modalChoiceGroupInterface.getValue())) continue;
            return modalChoiceGroupInterface;
        }
        return null;
    }

    @Override
    public PromptGroupInterface copy(PromptGroupInterface newGroup) {
        if (newGroup == null) {
            newGroup = new ModalGroup();
        }
        return super.copy(newGroup);
    }

    @SASScope
    protected Map addError(Map errors, int errorCode, String textReason) {
        if (errors == null) {
            errors = new HashMap<Integer, String>(1);
        }
        errors.put(new Integer(errorCode), textReason);
        return errors;
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        ArrayList list = roHolder.consumeObjects("DefaultValue");
        this.consumeDefaultValue(list);
        ArrayList userInfoList = roHolder.consumeObjects("UserInfo");
        Map map = MapText.convertMapTextListToMap((List)userInfoList);
        if (map != null) {
            this.definition.setUserInfo((UserInfoInterface)new UserInfo(map));
        }
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.definition.setPromptName(provider.consumeAttr("name"));
        this.getLogger2().debug("consumed attribute= name:", this.definition.getPromptName());
        boolean required = provider.consumeBooleanAttr("required", false);
        if (required) {
            this.definition.setMinimumValueCount(1);
            this.getLogger2().debug("consumed attribute= required: true");
        }
    }

    @Override
    @SASScope
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setAttr((Element)element, (String)"name", (String)this.definition.getPromptName());
        XmlUtil.setBooleanAttr((Element)element, (String)"required", (boolean)this.definition.isRequired(), (boolean)false);
    }

    private void consumeDefaultValue(List list) {
        if (!list.isEmpty()) {
            BasePersistedValue value = (BasePersistedValue)list.get(0);
            Object obj = value.getValue();
            this.definition.setDefaultValue(obj);
        }
    }

    private List writeDefaultValue() {
        Object defValue;
        ArrayList<PersistenceInterface> list = new ArrayList<PersistenceInterface>();
        if (this.definition.isDefaultValueSet() && (defValue = this.definition.getDefaultValue()) != null) {
            PersistenceInterface value = ValueUtil.getPersistableValue((Object)defValue);
            if (value == null) {
                this.getLogger2().error("Unable to get persistable value for " + defValue, "class=" + defValue.getClass().getName());
                this.getLogger2().error(this.getPromptGroupLabel(Locale.US));
                Thread.dumpStack();
            }
            list.add(value);
        }
        return list;
    }
}

