/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.el;

import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.el.resolvers.PromptELResolver;
import com.sas.prompts.el.resolvers.PublicMethodResolver;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.log4j.Log4JFactory2;
import de.odysseus.el.ExpressionFactoryImpl;
import de.odysseus.el.util.SimpleContext;
import java.util.Properties;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import javax.el.ValueExpression;

public class ELEvaluator {
    public static final String ELEVALUATOR_PROMPTVALUES = "ELEvaluator_promptValues";
    public static ExpressionFactory expressionFactory = ELEvaluator.initExpressionFactory();
    protected LoggerFactoryInterface loggerFactory;
    protected CommonLoggerInterface logger;
    protected CompositeELResolver resolver;
    protected ELContext context;

    public ELEvaluator() {
        this(null);
    }

    public ELEvaluator(LoggerFactoryInterface loggerFactory) {
        ELResolver resolver = this.createDefaultResolver();
        this.setContext((ELContext)new SimpleContext(resolver));
    }

    public void addResolver(ELResolver elResolver) {
        if (elResolver == null) {
            throw new IllegalArgumentException("resolver must not be null");
        }
        ELResolver r = this.context.getELResolver();
        if (r instanceof CompositeELResolver) {
            ((CompositeELResolver)r).add(elResolver);
        }
    }

    public void setResolver(ELResolver elResolver) {
        if (elResolver == null) {
            throw new IllegalArgumentException("resolver must not be null");
        }
        this.setContext((ELContext)new SimpleContext(elResolver));
    }

    protected ELResolver createDefaultResolver() {
        this.resolver = new CompositeELResolver();
        this.resolver.add((ELResolver)new PublicMethodResolver());
        this.resolver.add((ELResolver)new PromptELResolver());
        this.resolver.add((ELResolver)new ArrayELResolver(true));
        this.resolver.add((ELResolver)new ListELResolver(true));
        this.resolver.add((ELResolver)new MapELResolver(true));
        this.resolver.add((ELResolver)new ResourceBundleELResolver());
        this.resolver.add((ELResolver)new BeanELResolver(true));
        return this.resolver;
    }

    private static ExpressionFactory initExpressionFactory() {
        if (expressionFactory == null) {
            Properties props = new Properties();
            props.put("javax.el.methodInvocations", "true");
            expressionFactory = new ExpressionFactoryImpl(props);
        }
        return expressionFactory;
    }

    public boolean evaluateBooleanExpression(PromptValuesInterface promptValues, String expression) {
        Object retValue = this.evaluateExpression(promptValues, expression, Boolean.class);
        return (Boolean)retValue;
    }

    public Object evaluateExpression(PromptValuesInterface promptValues, String expression, Class<?> expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException("Expression cannot be null");
        }
        if (!(expression = expression.trim()).startsWith("${")) {
            expression = "${" + expression;
        }
        if (!expression.endsWith("}")) {
            expression = expression + "}";
        }
        ((SimpleContext)this.context).setVariable(ELEVALUATOR_PROMPTVALUES, expressionFactory.createValueExpression((Object)promptValues, PromptValuesInterface.class));
        ValueExpression expr = expressionFactory.createValueExpression(this.context, expression, expectedType);
        return expr.getValue(this.context);
    }

    protected CommonLoggerInterface getLogger() {
        if (null == this.logger) {
            if (null != this.loggerFactory) {
                this.logger = this.loggerFactory.makeNewLoggerInstance(this.getClass().getName());
            }
            this.logger = new Log4JFactory2().makeNewLoggerInstance(this.getClass().getName());
        }
        return this.logger;
    }

    public ELContext getContext() {
        return this.context;
    }

    public void setContext(ELContext context) {
        this.context = context;
    }
}

