/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions.vr;

import com.sas.models.datasources.BaseDataSource;
import com.sas.prompts.datatypes.values.DataSourceValue;
import com.sas.storage.vr.dto.DataSource;
import com.sas.storage.vr.dto.MetadataItem;
import com.sas.storage.vr.dto.ValueDataTypeEnum;
import com.sas.util.ValidateArg;
import com.sas.util.anno.NotNull;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class PersistableMetadataItem
extends AbstractPersistence {
    private static final long serialVersionUID = 1L;
    private MetadataItem metadataItem = new MetadataItem();

    public MetadataItem getMetadataItem() {
        return this.metadataItem;
    }

    public void setMetadataItem(@NotNull MetadataItem metadataItem) {
        ValidateArg.notNull((Object)metadataItem, (String)"metadataItem");
        this.metadataItem = metadataItem;
    }

    public String getDefinitionElementName() {
        return "MetadataItem";
    }

    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        String dt = provider.consumeAttr("dataType");
        if (null != dt && dt.length() > 0) {
            this.metadataItem.setItemTypeToRetrieve(ValueDataTypeEnum.valueOf((String)dt));
        }
    }

    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        DataSourceValue dsv = (DataSourceValue)roHolder.consumeObject("DataSources");
        if (null != dsv) {
            DataSource source = new DataSource();
            BaseDataSource newDataSource = (BaseDataSource)dsv.getValue();
            if (null != newDataSource) {
                this.getLogger2().debug("consumed new BaseDataSource with location:", newDataSource.getDataSourceLocation());
                source.setDataSourceLocation(newDataSource.getDataSourceLocation());
                source.setDataSourceType(newDataSource.getDataSourceType());
                this.metadataItem.setDataSource(source);
            }
        }
    }

    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        if (null != this.metadataItem.getDataSource()) {
            BaseDataSource value = new BaseDataSource();
            value.setDataSourceLocation(this.metadataItem.getDataSource().getDataSourceLocation());
            value.setDataSourceType(this.metadataItem.getDataSource().getDataSourceType());
            DataSourceValue dsv = new DataSourceValue();
            dsv.setValue((Object)value);
            ArrayList<DataSourceValue> list = new ArrayList<DataSourceValue>();
            list.add(dsv);
            PersistableMetadataItem.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"DataSources");
        }
        if (null != this.metadataItem.getItemTypeToRetrieve()) {
            XmlUtil.setAttr((Element)element, (String)"dataType", (String)this.metadataItem.getItemTypeToRetrieve().toString());
        }
    }
}

