/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions.vr;

import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.vr.dto.ValueDataTypeEnum;
import com.sas.storage.vr.dto.WSColumnDefinition;
import com.sas.util.ValidateArg;
import com.sas.util.anno.NotNull;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import com.sas.util.xmlpersist.impl.LocalizablePersistableString;
import java.util.ArrayList;
import java.util.Locale;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class PersistableColumnDefinition
extends AbstractPersistence {
    private static final long serialVersionUID = 1L;
    private WSColumnDefinition _columnDefinition = new WSColumnDefinition();
    private LocalizablePersistableString columnHeader = new LocalizablePersistableString();

    public WSColumnDefinition getColumnDefinition(Locale locale) {
        Locale loc = Locale.getDefault();
        if (null == locale && null != this._columnDefinition.getLocale()) {
            loc = XmlUtil.xmlToLocale((String)this._columnDefinition.getLocale());
        } else if (null != locale) {
            loc = locale;
        }
        String text = this.columnHeader.getText(loc);
        if (null != text) {
            this._columnDefinition.setHeaderText(text);
            this._columnDefinition.setLocale(loc.toString());
        }
        return this._columnDefinition;
    }

    public void setColumnDefinition(@NotNull WSColumnDefinition columnDefinition) {
        ValidateArg.notNull((Object)columnDefinition, (String)"columnDefinition");
        if (null != columnDefinition.getHeaderText()) {
            Locale locale = XmlUtil.xmlToLocale((String)columnDefinition.getLocale());
            if (null != locale) {
                locale = Locale.getDefault();
                this.getLogger2().debug("setColumnDefinition, no locale available so using server's default locale.");
            }
            this.columnHeader.setText(columnDefinition.getHeaderText(), locale);
            this.getLogger2().debug("setColumnDefinition, header text to set to:", columnDefinition.getHeaderText());
        } else {
            this.getLogger2().debug("setColumnDefinition, no header text to set on columnHeader object.");
        }
        this._columnDefinition = columnDefinition;
    }

    public String getDefinitionElementName() {
        return "Column";
    }

    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this._columnDefinition.setValueColumn(provider.consumeBooleanAttr("valueColumn", false));
        this._columnDefinition.setAttributeName(provider.consumeAttr("attribute"));
        this._columnDefinition.setXPath(provider.consumeAttr("xPath"));
        this._columnDefinition.setDataType(ValueDataTypeEnum.valueOf((String)provider.consumeAttr("dataType")));
        this.getLogger2().debug("consumeAttributes(),xPath was set to:", this._columnDefinition.getXPath());
    }

    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        if (null != this._columnDefinition.getXPath() && !"".equals(this._columnDefinition.getXPath())) {
            this.getLogger2().debug("writing XPath:", this._columnDefinition.getXPath());
            XmlUtil.setAttr((Element)element, (String)"xPath", (String)this._columnDefinition.getXPath());
        }
        if (null != this._columnDefinition.getAttributeName() && !this._columnDefinition.getAttributeName().equals("")) {
            XmlUtil.setAttr((Element)element, (String)"attribute", (String)this._columnDefinition.getAttributeName());
        }
        if (this._columnDefinition.isValueColumn()) {
            XmlUtil.setBooleanAttr((Element)element, (String)"valueColumn", (boolean)true, (boolean)false);
        }
        if (null != this._columnDefinition.getDataType()) {
            XmlUtil.setAttr((Element)element, (String)"dataType", (String)this._columnDefinition.getDataType().toString());
        }
        this.getLogger2().debug("writing header text, if any.");
        ArrayList<LocalizablePersistableString> list0 = new ArrayList<LocalizablePersistableString>();
        list0.add(this.columnHeader);
        PersistableColumnDefinition.writeRelatedObjects(list0, (Node)element, (PromptsWritingContext)writingContext, (String)"Label");
    }

    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        LocalizablePersistableString header = (LocalizablePersistableString)roHolder.consumeObject("Label");
        if (null != header) {
            this.columnHeader = header;
            this.getLogger2().debug("consumed localized header text");
        }
    }

    public PropertyList getLocalizableProperties(Locale locale) {
        return this.columnHeader.getLocalizableProperties(locale);
    }

    public void setLocalizableProperties(Locale locale, PropertyMap map) {
        this.columnHeader.setLocalizableProperties(locale, map);
    }
}

