/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions.shared;

import com.sas.DeepCloneSupport;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeInterface;
import com.sas.prompts.AttributeDependencyInterface;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.HintPlacement;
import com.sas.prompts.LabelPlacement;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.PromptHelp;
import com.sas.prompts.PromptIdentifierFactory;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.SharedPromptFactory;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.MutablePromptDefinitionV2Interface;
import com.sas.prompts.definitions.MutablePromptDefinitionV3Interface;
import com.sas.prompts.definitions.PromptDefinition;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionV2Interface;
import com.sas.prompts.definitions.PromptDefinitionV3Interface;
import com.sas.prompts.definitions.shared.MutableSharedPromptDefinitionV3Interface;
import com.sas.prompts.definitions.shared.RB;
import com.sas.prompts.script.PromptAction;
import com.sas.prompts.script.ScriptHolder;
import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.uiconfig.ApplicationContext;
import com.sas.uiconfig.ContextEnabledObject;
import com.sas.uiconfig.UIConfigurationInterface;
import com.sas.util.AttributeConfigurationInterface;
import com.sas.util.AttributeDescriptor;
import com.sas.util.AttributeGroup;
import com.sas.util.LocalizableString;
import com.sas.util.MutableUserInfoInterface;
import com.sas.util.UserInfoInterface;
import com.sas.util.ValidateArg;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.MetadataDescriptor;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import com.sas.util.xmlpersist.impl.LocalizedText;
import com.sas.util.xmlpersist.impl.PersistHelper;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@SASScope
public abstract class SharedPromptDefinition
extends AbstractPersistence
implements MutableSharedPromptDefinitionV3Interface,
MutablePromptDefinitionInterface,
MultiLocaleProperties,
AttributeConfigurationInterface,
ContextEnabledObject {
    private static final String InternalPromptDefinition = "InternalPromptDefinition";
    protected PromptDefinitionV2Interface internalPromptDefinition;
    private static final long serialVersionUID = -7158642408721029176L;
    private String sharedPromptLocation;
    private String errorMessage;
    private String promptID;
    private String name;
    private LocalizableString label;
    private LocalizableString description;
    public static final String RB_KEY = "SharedPromptDefinition.";
    private transient ApplicationContext applicationContext;

    public SharedPromptDefinition() {
    }

    public SharedPromptDefinition(String sharedPromptLocation, SharedPromptFactory factory) throws BackingStoreException {
        this.setSharedPromptLocation(sharedPromptLocation, factory);
    }

    public SharedPromptDefinition(String promptName) {
        this.setPromptName(promptName);
    }

    private MutablePromptDefinitionV2Interface getInternalDefinition() {
        this.init();
        return (MutablePromptDefinitionV2Interface)this.internalPromptDefinition;
    }

    @Override
    public String getSharedPromptLocation() {
        return this.sharedPromptLocation;
    }

    protected abstract void init();

    @Override
    public void setSharedPromptLocation(String sharedPromptLocation) {
        ValidateArg.notNull((Object)sharedPromptLocation, (String)"sharedPromptLocation");
        this.sharedPromptLocation = PersistHelper.parseSBIPUrl((String)sharedPromptLocation);
        this.getLogger2().debug("setSharedPromptLocation()", sharedPromptLocation);
    }

    @Override
    public void setSharedPromptLocation(String sharedPromptLocation, SharedPromptFactory factory) throws BackingStoreException {
        ValidateArg.notNull((Object)factory, (String)"factory");
        this.setSharedPromptLocation(sharedPromptLocation);
        this.internalPromptDefinition = (PromptDefinitionV2Interface)factory.getDefinitionFromFolder(sharedPromptLocation);
        this.errorMessage = null;
    }

    @Override
    public String getPromptName() {
        if (this.name == null) {
            return this.getInternalDefinition().getPromptName();
        }
        return this.name;
    }

    @Override
    public void setPromptName(String name) {
        this.name = name;
    }

    @Override
    public String getPromptLabel(Locale locale) {
        if (this.label == null) {
            return this.getInternalDefinition().getPromptLabel(locale);
        }
        return PromptUtil.getDelegatedText(this.label, locale, this.getApplicationContext());
    }

    @Override
    public void setPromptLabel(String label, Locale locale) {
        if (this.label == null) {
            this.label = new LocalizableString();
        }
        this.label.setText(label, locale);
    }

    @Override
    public LocalizableString getPromptLabels() {
        if (this.label == null) {
            return this.getInternalDefinition().getPromptLabels();
        }
        return this.label;
    }

    @Override
    public void setPromptLabels(LocalizableString labels) {
        this.label = labels;
    }

    @Override
    public String getPromptDescription(Locale locale) {
        if (this.description == null) {
            return this.getInternalDefinition().getPromptDescription(locale);
        }
        return PromptUtil.getDelegatedText(this.description, locale, this.getApplicationContext());
    }

    @Override
    public void setPromptDescription(String description, Locale locale) {
        if (this.description == null) {
            this.description = new LocalizableString();
        }
        this.description.setText(description, locale);
    }

    @Override
    public LocalizableString getPromptDescriptions() {
        if (this.description == null) {
            return this.getInternalDefinition().getPromptDescriptions();
        }
        return this.description;
    }

    @Override
    public void setPromptDescriptions(LocalizableString descriptions) {
        this.description = descriptions;
    }

    @Override
    public PromptHelp getPromptHelp() {
        if (this.getInternalDefinition() instanceof MutablePromptDefinitionV3Interface) {
            return ((MutablePromptDefinitionV3Interface)this.getInternalDefinition()).getPromptHelp();
        }
        return null;
    }

    @Deprecated
    public Object clone(DeepCloneSupport support, boolean deeply) throws CloneNotSupportedException {
        SharedPromptDefinition clone = (SharedPromptDefinition)super.clone();
        if (!deeply) {
            return clone;
        }
        if (support == null) {
            support = new DeepCloneSupport();
        }
        support.register((Object)this, (Object)clone);
        if (clone.label != null) {
            clone.label = (LocalizableString)support.clone((Object)this.label, deeply);
        }
        if (clone.description != null) {
            clone.description = (LocalizableString)support.clone((Object)this.description, deeply);
        }
        if (clone.internalPromptDefinition != null) {
            clone.internalPromptDefinition = (PromptDefinition)support.clone((Object)this.internalPromptDefinition, deeply);
        }
        return clone;
    }

    public void consumeAttributes(AttributesProvider provider) {
        Map map;
        PromptsReadingContext prContext;
        super.consumeAttributes(provider);
        this.setPromptName(provider.consumeAttr("name"));
        if (this.name != null) {
            this.getLogger2().debug("running consumeAttributes for ", this.name);
        } else {
            this.getLogger2().debug("running consumeAttributes");
        }
        this.setPromptID(provider.consumeAttr("promptId"));
        this.setSharedPromptLocation(provider.consumeAttr("sharedPromptLocation"));
        if (null != this.getSharedPromptLocation()) {
            Map optionsMap;
            this.getLogger2().debug("Retrieving internal definition from:", this.getSharedPromptLocation());
            PromptsReadingContext reader = provider.getReadingContext();
            if (null != reader && null != (optionsMap = reader.getOptionsMap()) && !optionsMap.containsKey("writeExternal")) {
                this.getLogger2().debug("Retrieving internal definition from:", this.getSharedPromptLocation());
                try {
                    this.internalPromptDefinition = (PromptDefinitionV2Interface)reader.getObjectFromMetadata("Prompt", this.getSharedPromptLocation());
                    this.errorMessage = null;
                }
                catch (BackingStoreException e) {
                    this.getLogger2().error(e.getMessage());
                    reader.addMissingResource((Object)this, (Object)this.getSharedPromptLocation());
                    this.errorMessage = e.getMessage();
                }
                if (null == this.internalPromptDefinition) {
                    this.getLogger2().warn(RB.getStringResource(RB_KEY, "warn.noDefinition.log"));
                } else {
                    this.getLogger2().debug("Retrieved internal prompt definition from metadata");
                    if (!this.getDefinitionElementName().endsWith(this.internalPromptDefinition.getDefinitionElementName())) {
                        reader.addMissingResource((Object)this, (Object)this.getSharedPromptLocation());
                        this.getLogger2().debug("consumeAttributes() missing resource as internal def is wrong type:", this.internalPromptDefinition.getDefinitionElementName());
                    }
                }
            }
        }
        if (null != (prContext = provider.getReadingContext()) && null != prContext.getOptionsMap() && (map = prContext.getOptionsMap()).containsKey("com.sas.uiconfig.ApplicationContext")) {
            this.setApplicationContext((ApplicationContext)map.get("com.sas.uiconfig.ApplicationContext"));
        }
    }

    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        PromptDefinitionV2Interface prompt;
        ArrayList list4;
        ArrayList list3;
        super.consumeRelatedObjects(roHolder);
        ArrayList list2 = roHolder.consumeObjects("Label");
        if (!list2.isEmpty()) {
            Iterator iter = list2.iterator();
            this.getLogger2().debug("consumeRelObjects, setPromptLabel() on", this.name);
            while (iter.hasNext()) {
                LocalizedText text = (LocalizedText)iter.next();
                this.setPromptLabel(text.getText(), text.getLocale());
                this.getLogger2().debug("consumeRelObjects, setting label to:", text.getText());
            }
        }
        if (!(list3 = roHolder.consumeObjects("Description")).isEmpty()) {
            Iterator iter = list3.iterator();
            this.getLogger2().debug("consumeRelObjects, setPromptDescrp() on", this.name);
            while (iter.hasNext()) {
                LocalizedText text = (LocalizedText)iter.next();
                this.setPromptDescription(text.getText(), text.getLocale());
                this.getLogger2().debug("consumeRelObjects, setting descrip to:", text.getText());
            }
        }
        if (null == this.internalPromptDefinition && !(list4 = roHolder.consumeObjects(InternalPromptDefinition)).isEmpty() && null != (prompt = (PromptDefinitionV2Interface)list4.get(0))) {
            this.internalPromptDefinition = prompt;
            this.getLogger2().debug("read the internalPrompt from XML due to readExternal() call.");
        }
    }

    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        List list;
        super.writeDefinition(element, writingContext);
        this.getLogger2().debug("Writing to DOM for shared definition:", this.name);
        XmlUtil.setAttr((Element)element, (String)"name", (String)this.name);
        XmlUtil.setAttr((Element)element, (String)"promptId", (String)this.getPromptID());
        if (null != this.getSharedPromptLocation()) {
            XmlUtil.setAttr((Element)element, (String)"sharedPromptLocation", (String)("URL::" + this.getSharedPromptLocation()));
        }
        if (null != this.getSharedPromptLocation()) {
            MetadataDescriptor md = PersistenceFactory.newMetadataDescriptor(null);
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("SBIP_URL", this.getSharedPromptLocation());
            md.setAdditionalInfo(info);
            md.setType("PROMPT_DEFINITION");
            writingContext.addMetadataDescriptor(md);
        }
        if (null != this.label && !(list = PersistHelper.getAllText((LocalizableString)this.label, null)).isEmpty()) {
            this.getLogger2().debug("Writing labels.");
            SharedPromptDefinition.writeRelatedObjects((List)list, (Node)element, (PromptsWritingContext)writingContext, (String)"Label");
        }
        if (null != this.description && !(list = PersistHelper.getAllText((LocalizableString)this.description, null)).isEmpty()) {
            this.getLogger2().debug("Writing descriptions.");
            SharedPromptDefinition.writeRelatedObjects((List)list, (Node)element, (PromptsWritingContext)writingContext, (String)"Description");
        }
        Map optionsMap = writingContext.getOptionsMap();
        if (null != this.internalPromptDefinition && null != optionsMap && optionsMap.containsKey("writeExternal")) {
            this.getLogger2().debug("Writing internal prompt due to writeExternal() call.");
            ArrayList<PromptDefinitionV2Interface> list2 = new ArrayList<PromptDefinitionV2Interface>(1);
            list2.add(this.internalPromptDefinition);
            SharedPromptDefinition.writeRelatedObjects(list2, (Node)element, (PromptsWritingContext)writingContext, (String)InternalPromptDefinition);
        } else {
            this.getLogger2().info("Cannot write internal prompt in writeExternal() call. because it is missing.");
        }
    }

    @Override
    public String getHint(Locale locale) {
        return this.getInternalDefinition().getHint(locale);
    }

    public void setHint(String hint, Locale locale) {
        this.getInternalDefinition().setHint(hint, locale);
    }

    public void setHints(LocalizableString hints) {
        this.getInternalDefinition().setHints(hints);
    }

    @Override
    public LocalizableString getHints() {
        return this.getInternalDefinition().getHints();
    }

    @Override
    public synchronized String getPromptID() {
        if (this.promptID == null) {
            this.promptID = PromptIdentifierFactory.getPromptIdentifier("PromptDef");
        }
        return this.promptID;
    }

    @Override
    public synchronized void setPromptID(String promptID) {
        if (promptID == "_SAS_PROMPT_ID_RESET") {
            this.promptID = null;
        } else if (this.promptID == null) {
            this.promptID = promptID;
        }
    }

    @Override
    public Object getDefaultValue() {
        return this.getInternalDefinition().getDefaultValue();
    }

    @Override
    public Collection<PromptDefinitionInterface> getDependentPrompts(Locale locale, DynamicPromptValueContextInterface dynamicValueContext) {
        return this.getInternalDefinition().getDependentPrompts(locale, dynamicValueContext);
    }

    @Override
    public DataTypeInterface getPromptDataType() {
        return this.getInternalDefinition().getPromptDataType();
    }

    @Override
    public Collection<ValidationEntry> getPromptValueValidationErrors(Object value, Locale locale) {
        return this.getInternalDefinition().getPromptValueValidationErrors(value, locale);
    }

    @Override
    public Collection<ValidationEntry> validateDefinition(Locale locale) {
        Collection<ValidationEntry> errors = null;
        if (this.errorMessage != null) {
            errors = PromptUtil.addError(errors, 0x20000000000L, this.errorMessage);
        }
        errors = PromptUtil.addErrors(errors, this.getInternalDefinition().validateDefinition(locale));
        return errors;
    }

    @Override
    public boolean isDefaultValueSet() {
        return this.getInternalDefinition().isDefaultValueSet();
    }

    @Override
    public boolean isFixed() {
        return this.getInternalDefinition().isFixed();
    }

    @Override
    public boolean isHidden() {
        return this.getInternalDefinition().isHidden();
    }

    @Override
    public boolean isPromptValueValid(Object value) {
        return this.getInternalDefinition().isPromptValueValid(value, Locale.getDefault());
    }

    @Override
    public boolean isPromptValueValid(Object value, Locale locale) {
        return this.getInternalDefinition().isPromptValueValid(value, locale);
    }

    @Override
    public boolean isRequired() {
        return this.getInternalDefinition().isRequired();
    }

    @Override
    public boolean isStickyDefaultAllowed() {
        return this.getInternalDefinition().isStickyDefaultAllowed();
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        this.getInternalDefinition().setDefaultValue(defaultValue);
    }

    @Override
    public void clearDefaultValue() {
        this.getInternalDefinition().clearDefaultValue();
    }

    @Override
    public void setHidden(boolean hidden) {
        this.getInternalDefinition().setHidden(hidden);
    }

    @Override
    public MutableUserInfoInterface getMutableUserInfo() {
        return this.getInternalDefinition().getMutableUserInfo();
    }

    @Override
    public UserInfoInterface getUserInfo() {
        return this.getInternalDefinition().getUserInfo();
    }

    @Override
    public void setUserInfo(UserInfoInterface userInfo) {
        this.getInternalDefinition().setUserInfo(userInfo);
    }

    @Override
    public void addUserInfo(String key, String value) {
        this.getInternalDefinition().addUserInfo(key, value);
    }

    @Override
    public void removeUserInfo(String key) {
        this.getInternalDefinition().removeUserInfo(key);
    }

    @Override
    public void setFixed(boolean fixed) {
        this.getInternalDefinition().setFixed(fixed);
    }

    @Override
    public void setStickyDefaultAllowed(boolean stickyDefault) {
        this.getInternalDefinition().setStickyDefaultAllowed(stickyDefault);
    }

    public List getReferencedResources(Class type, boolean recursive) {
        return this.getInternalDefinition().getReferencedResources(type, recursive);
    }

    @Override
    public Collection<PromptDefinitionInterface> getAdditionalCascadeDependencies() {
        return this.getInternalDefinition().getAdditionalCascadeDependencies();
    }

    @Override
    public void setAdditionalCascadeDependencies(Collection<PromptDefinitionInterface> dependencies) {
    }

    @Override
    public boolean isDisplayDefaultValueAsBlank() {
        return this.getInternalDefinition().isDisplayDefaultValueAsBlank();
    }

    @Override
    public boolean isValueClearedForNonSelectedModalChoiceGroup() {
        return this.getInternalDefinition().isValueClearedForNonSelectedModalChoiceGroup();
    }

    public String getMacroVariableBaseName() {
        return this.getPromptName();
    }

    public void setMacroVariableBaseName(String baseName) {
        this.getInternalDefinition().setMacroVariableBaseName(baseName);
    }

    public int getMacroVariableOutputLevel() {
        return this.getInternalDefinition().getMacroVariableOutputLevel();
    }

    public void setMacroVariableOutputLevel(int outputLevel) {
        this.getInternalDefinition().setMacroVariableOutputLevel(outputLevel);
    }

    public String toString() {
        return "Name field: " + this.name + " location: " + this.getSharedPromptLocation();
    }

    public Object clone() throws CloneNotSupportedException {
        SharedPromptDefinition clone = (SharedPromptDefinition)super.clone();
        clone.label = (LocalizableString)this.label.clone();
        clone.description = (LocalizableString)this.description.clone();
        clone.internalPromptDefinition = this.internalPromptDefinition;
        return clone;
    }

    public Collection getLocales() {
        if (null != this.label) {
            return this.label.getLocales();
        }
        return Collections.emptyList();
    }

    public PropertyList getLocalizableProperties(Locale locale) {
        ValidateArg.notNull((Object)locale, (String)"locale");
        PropertyList propertyList = new PropertyList();
        this.getLogger2().debug("getLocalizableProperties for prompt", this.getPromptName());
        if (null != this.label) {
            propertyList.addProperty("Label", this.label.getText(locale));
        }
        if (null != this.description) {
            propertyList.addProperty("Description", this.description.getText(locale));
        }
        return propertyList;
    }

    public void setLocalizableProperties(Locale locale, PropertyMap map) {
        ValidateArg.notNull((Object)locale, (String)"locale");
        ValidateArg.notNull((Object)map, (String)"property map");
        this.getLogger2().debug("setLocalizableProperties on prompt:", this.getPromptName());
        if (map.containsProperty("Label")) {
            this.setPromptLabel(map.getProperty("Label"), locale);
        }
        if (map.containsProperty("Description")) {
            this.setPromptDescription(map.getProperty("Description"), locale);
        }
    }

    public PropertyList getLocalizableProperties() {
        return this.getLocalizableProperties(Locale.getDefault());
    }

    public void setLocalizableProperties(PropertyMap map) {
        this.setLocalizableProperties(Locale.getDefault(), map);
    }

    public void beginLocalization() {
    }

    public void endLocalization() {
    }

    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        Locale locale = PromptConfigurationFactory.getLocaleOption(context);
        if (options.containsKey("promptId")) {
            this.setPromptID(PromptConfigurationFactory.getStringOption((String)"promptId", options, context));
        }
        if (options.containsKey("name")) {
            this.setPromptName(PromptConfigurationFactory.getStringOption((String)"name", options, context));
        }
        if (options.containsKey("label")) {
            this.setPromptLabel(PromptConfigurationFactory.getStringOption((String)"label", options, context), locale);
        }
        if (options.containsKey("description")) {
            this.setPromptDescription(PromptConfigurationFactory.getStringOption((String)"description", options, context), locale);
        }
    }

    public List getAttributeDescriptors(Locale locale) {
        List internalDescriptors = this.getInternalDefinition().getAttributeDescriptors(locale);
        this.setAttributesNonEditable(internalDescriptors);
        return internalDescriptors;
    }

    private void setAttributesNonEditable(List internalDescriptors) {
        for (Object descriptorOrGroup : internalDescriptors) {
            if (descriptorOrGroup instanceof AttributeDescriptor) {
                AttributeDescriptor desc = (AttributeDescriptor)descriptorOrGroup;
                if (desc.getName().equals("promptId") || desc.getName().equals("name") || desc.getName().equals("label") || desc.getName().equals("description")) continue;
                desc.setEditable(false);
                continue;
            }
            if (!(descriptorOrGroup instanceof AttributeGroup)) continue;
            this.setAttributesNonEditable(((AttributeGroup)descriptorOrGroup).getAttributeDescriptors());
        }
    }

    @Override
    public List<AttributeDependencyInterface> getDependentPromptsForAttributes() {
        return this.getInternalDefinition().getDependentPromptsForAttributes();
    }

    @Override
    public String getCustomErrorMessage(Locale locale) {
        return this.getInternalDefinition().getCustomErrorMessage(locale);
    }

    public LocalizableString getCustomErrorMessages() {
        if (this.getInternalDefinition() instanceof PromptDefinition) {
            return ((PromptDefinition)this.getInternalDefinition()).getCustomErrorMessages();
        }
        return null;
    }

    @Override
    public ScriptHolder getScript(PromptAction promptAction) {
        return this.getInternalDefinition().getScript(promptAction);
    }

    @Override
    public Collection<ScriptHolder> getScripts() {
        return this.getInternalDefinition().getScripts();
    }

    @Override
    public UIConfigurationInterface getUIConfiguration() {
        return this.getInternalDefinition().getUIConfiguration();
    }

    @Override
    public String getInlineHint(Locale locale) {
        return this.getInternalDefinition().getInlineHint(locale);
    }

    @Override
    public LocalizableString getInlineHints() {
        return this.getInternalDefinition().getInlineHints();
    }

    @Override
    public LabelPlacement getLabelPlacement() {
        return this.getInternalDefinition().getLabelPlacement();
    }

    @Override
    public HintPlacement getHintPlacement() {
        MutablePromptDefinitionV2Interface pd = this.getInternalDefinition();
        if (pd instanceof PromptDefinitionV3Interface) {
            return ((PromptDefinitionV3Interface)((Object)pd)).getHintPlacement();
        }
        return null;
    }

    public final ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public final void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.getLogger2().debug("setApplicationContext on:", this.getPromptName());
        if (null != this.internalPromptDefinition && this.internalPromptDefinition instanceof ContextEnabledObject) {
            ((ContextEnabledObject)this.internalPromptDefinition).setApplicationContext(applicationContext);
            this.getLogger2().debug("setApplicationContext on internal prompt named: ", this.getPromptName());
        }
    }
}

