/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.RB;
import com.sas.text.Message;
import com.sas.util.MutableSupportedSpecialValuesInterface;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import com.sas.util.xmlpersist.impl.PersistableSupportedSpecialValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@SASScope
public class SupportedSpecialValuesDefinitionSupport
extends AbstractPersistence {
    public static final String RB_KEY = "SupportedSpecialValuesDefinitionSupport.";
    private SupportedSpecialValues supportedSpecialValues;
    private boolean allowMissing;

    public SupportedSpecialValuesDefinitionSupport() {
        this.init();
    }

    private void init() {
        this.supportedSpecialValues = new SupportedSpecialValues();
    }

    public boolean isPromptValueValid(Object value) {
        return this.valueValid(value) == 0L;
    }

    private long valueValid(Object value) {
        boolean specialValuePresent = false;
        boolean regularValuePresent = false;
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != null && !this.validIndividualValue(array[i])) {
                    return 1L;
                }
                if (array[i] instanceof SpecialValues) {
                    if (!specialValuePresent) {
                        specialValuePresent = true;
                        continue;
                    }
                    return 0x8000000L;
                }
                regularValuePresent = true;
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            for (Object element : collection) {
                if (element != null && !this.validIndividualValue(element)) {
                    return 1L;
                }
                if (element instanceof SpecialValues) {
                    if (!specialValuePresent) {
                        specialValuePresent = true;
                        continue;
                    }
                    return 0x8000000L;
                }
                regularValuePresent = true;
            }
        } else if (!this.validIndividualValue(value)) {
            return 1L;
        }
        if (specialValuePresent && regularValuePresent) {
            return 0x4000000L;
        }
        return 0L;
    }

    protected boolean validIndividualValue(Object value) {
        return value instanceof MissingValues && this.allowMissing || PromptUtil.isValueAllowedIfSpecial(this.supportedSpecialValues, value);
    }

    public Collection<ValidationEntry> getPromptValueValidationErrors(Object value, Locale locale) {
        Collection<ValidationEntry> errors = new ArrayList<ValidationEntry>();
        long returnValue = this.valueValid(value);
        errors = this.populateMapWithErrors(errors, returnValue, value, false, locale);
        return errors;
    }

    public Collection<ValidationEntry> validateDefinition(Object dv, Locale locale) {
        Collection<ValidationEntry> errors = Collections.emptyList();
        long returnValue = 0L;
        if (returnValue == 0L) {
            errors = this.populateMapWithErrors(errors, returnValue |= this.valueValid(dv), dv, true, locale);
        }
        return errors;
    }

    private Collection<ValidationEntry> populateMapWithErrors(Collection<ValidationEntry> errors, long errorCode, Object value, boolean defaultValue, Locale locale) {
        if ((errorCode & 1L) == 1L) {
            errors = defaultValue ? PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource("SupportedSpecialValuesDefinitionSupport.defaultSpecialValueNotSupported.fmt.txt", locale), (Object)this.getUnsupportedSpecialValue(value, locale))) : PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource("SupportedSpecialValuesDefinitionSupport.specialValueNotSupported.fmt.txt", locale), (Object)this.getUnsupportedSpecialValue(value, locale)));
        }
        if ((errorCode & 0x4000000L) == 0x4000000L) {
            errors = defaultValue ? PromptUtil.addError(errors, 0x4000000L, RB.getStringResource("SupportedSpecialValuesDefinitionSupport.defaultSpecialValueMixed.txt", locale)) : PromptUtil.addError(errors, 0x4000000L, RB.getStringResource("SupportedSpecialValuesDefinitionSupport.specialValueMixed.txt", locale));
        }
        if ((errorCode & 0x8000000L) == 0x8000000L) {
            errors = defaultValue ? PromptUtil.addError(errors, 0x8000000L, RB.getStringResource("SupportedSpecialValuesDefinitionSupport.moreThanOneSpecialValueSpecifiedForDefault.txt", locale)) : PromptUtil.addError(errors, 0x8000000L, RB.getStringResource("SupportedSpecialValuesDefinitionSupport.moreThanOneSpecialValueSpecified.txt", locale));
        }
        return errors;
    }

    private Object getUnsupportedSpecialValue(Object value, Locale locale) {
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                if (PromptUtil.isValueAllowedIfSpecial(this.supportedSpecialValues, array[i])) continue;
                return this.getStringValueFor(array[i], locale);
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            for (Object element : collection) {
                if (PromptUtil.isValueAllowedIfSpecial(this.supportedSpecialValues, element)) continue;
                return this.getStringValueFor(element, locale);
            }
        } else if (!PromptUtil.isValueAllowedIfSpecial(this.supportedSpecialValues, value)) {
            return this.getStringValueFor(value, locale);
        }
        return null;
    }

    private String getStringValueFor(Object value, Locale locale) {
        if (value == null) {
            return null;
        }
        if (value instanceof MissingValues) {
            return MissingValues.toDisplayString((MissingValues)((MissingValues)value), (Locale)locale);
        }
        if (value instanceof SpecialValues) {
            return SpecialValues.toDisplayString((SpecialValues)((SpecialValues)value), (Locale)locale);
        }
        return value.toString();
    }

    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
    }

    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        ArrayList list = roHolder.consumeObjects("SupportedSpecialValues");
        if (!list.isEmpty()) {
            this.getLogger2().debug("consumeRelObjects, setSupportedSpecialValues() ");
            SupportedSpecialValues ssv = (SupportedSpecialValues)list.get(0);
            this.setSupportedSpecialValues(ssv);
        }
    }

    public void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        if (null != this.supportedSpecialValues && (this.supportedSpecialValues.isAllSupported() || this.supportedSpecialValues.isNoneSupported() || this.supportedSpecialValues.isOtherSupported() || this.supportedSpecialValues.isMissingValuesSupported())) {
            PersistableSupportedSpecialValues pssv = new PersistableSupportedSpecialValues();
            pssv.setAllSupported(this.supportedSpecialValues.isAllSupported());
            pssv.setNoneSupported(this.supportedSpecialValues.isNoneSupported());
            pssv.setOtherSupported(this.supportedSpecialValues.isOtherSupported());
            pssv.setMissingValuesSupported(this.supportedSpecialValues.isMissingValuesSupported());
            pssv.setMissingValuesHiddenIfSupported(this.supportedSpecialValues.isMissingValuesHiddenIfSupported());
            ArrayList<PersistableSupportedSpecialValues> list = new ArrayList<PersistableSupportedSpecialValues>();
            list.add(pssv);
            this.getLogger2().debug("Writing supported special values element.");
            SupportedSpecialValuesDefinitionSupport.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"SupportedSpecialValues");
        }
    }

    public void configurePrompt(MutableSupportedSpecialValuesInterface prompt, Map options, Map context) {
        boolean allSupported = false;
        boolean otherSupported = false;
        boolean missingSupported = false;
        boolean missingValuesHiddenIfSupported = false;
        if (options.containsKey("allSupported")) {
            allSupported = PromptConfigurationFactory.getBoolOption((String)"allSupported", (Map)options, (Map)context);
        }
        if (options.containsKey("otherSupported")) {
            otherSupported = PromptConfigurationFactory.getBoolOption((String)"otherSupported", (Map)options, (Map)context);
        }
        if (options.containsKey("missingSupported")) {
            missingSupported = PromptConfigurationFactory.getBoolOption((String)"missingSupported", (Map)options, (Map)context);
        }
        if (options.containsKey("missingHiddenIfSupported")) {
            missingValuesHiddenIfSupported = PromptConfigurationFactory.getBoolOption((String)"missingHiddenIfSupported", (Map)options, (Map)context);
        }
        SupportedSpecialValues ssv = new SupportedSpecialValues();
        ssv.setAllSupported(allSupported);
        ssv.setOtherSupported(otherSupported);
        ssv.setMissingValuesSupported(missingSupported);
        ssv.setMissingValuesHiddenIfSupported(missingValuesHiddenIfSupported);
        this.setSupportedSpecialValues(ssv);
    }

    public SupportedSpecialValues getSupportedSpecialValues() {
        return (SupportedSpecialValues)this.supportedSpecialValues.clone();
    }

    public void setSupportedSpecialValues(SupportedSpecialValues supportedSpecialValues) {
        this.supportedSpecialValues = (SupportedSpecialValues)supportedSpecialValues.clone();
    }

    public void setAllowMissing(boolean allowMissing) {
        if (this.allowMissing != allowMissing) {
            this.allowMissing = allowMissing;
        }
    }
}

