/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.MetadataSourceType;
import com.sas.models.metadataSource.MetadataSource;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.prompts.datatypes.values.ValueUtil;
import com.sas.prompts.definitions.MutableMetadataSourceDefinitionV2Interface;
import com.sas.prompts.definitions.PromptDefinition;
import com.sas.prompts.definitions.RB;
import com.sas.prompts.definitions.SelectableDefinitionSupport;
import com.sas.text.Message;
import com.sas.util.AttributeDescriptor;
import com.sas.util.ValidateArg;
import com.sas.util.anno.NotNull;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@SASScope
public final class MetadataSourceDefinition
extends PromptDefinition
implements MutableMetadataSourceDefinitionV2Interface {
    public static final String RB_KEY = "MetadataSourceDefinition.";
    private static final long serialVersionUID = -4086628749982293419L;
    private final List<String> allowedMetadataSourceTypes = new ArrayList<String>();
    private SelectableDefinitionSupport selectableSupport;
    private String baseSelectionPath;
    private String startingSelectionPath;
    private int fileSelectionMode;

    public MetadataSourceDefinition() {
        this.init();
    }

    public MetadataSourceDefinition(String promptName) {
        super(promptName);
        this.init();
    }

    private void init() {
        this.selectableSupport = new SelectableDefinitionSupport(this);
        this.fileSelectionMode = 1;
    }

    @Override
    public boolean isRequired() {
        return this.selectableSupport.isRequired();
    }

    private long validateValue(Object value) {
        long returnValue = 0L;
        if (value != null) {
            if (!(value instanceof MetadataSource)) {
                returnValue |= 1L;
            } else if (!this.isMetadataSourceTypeAllowed(((MetadataSource)value).getMetadataType())) {
                returnValue |= 0x40000000L;
            }
        }
        return returnValue;
    }

    private boolean isMetadataSourceTypeAllowed(String metadataType) {
        boolean retVal = false;
        if (this.allowedMetadataSourceTypes.isEmpty()) {
            retVal = true;
        } else if (this.allowedMetadataSourceTypes.contains(metadataType)) {
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean isPromptValueValid(Object value, Locale locale) {
        long returnValue;
        return super.isPromptValueValid(value, locale) && (returnValue = this.validateValue(value)) == 0L;
    }

    @Override
    public Collection<ValidationEntry> getPromptValueValidationErrors(Object value, Locale locale) {
        Collection<ValidationEntry> errors = super.getPromptValueValidationErrors(value, locale);
        long returnValue = this.validateValue(value);
        this.populateMapWithErrors(errors, returnValue, value, false, locale);
        return errors;
    }

    @Override
    public Collection<ValidationEntry> validateDefinition(Locale locale) {
        Collection<ValidationEntry> errors = super.validateDefinition(locale);
        Object dv = this.isDefaultValueSet() ? this.getDefaultValue() : null;
        this.populateMapWithErrors(errors, this.validateValue(dv), dv, true, locale);
        return errors;
    }

    private Collection<ValidationEntry> populateMapWithErrors(Collection<ValidationEntry> errors, long errorCode, Object value, boolean defaultValue, Locale locale) {
        if ((errorCode & 1L) == 1L) {
            errors = defaultValue ? PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueNotAMetadataSource.fmt.txt", locale), (Object)value)) : PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "notAMetadataSource.fmt.txt", locale), (Object)value));
        }
        if ((errorCode & 0x40000000L) == 0x40000000L) {
            errors = defaultValue ? PromptUtil.addError(errors, 0x40000000L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueContainsDisallowedMetaDataSourceType.txt", locale), (Object)value)) : PromptUtil.addError(errors, 0x40000000L, Message.format((String)RB.getStringResource(RB_KEY, "metadataSourceContainsDisallowedType.txt", locale), (Object)value));
        }
        return errors;
    }

    @Override
    public DataTypeInterface getPromptDataType() {
        return MetadataSourceType.DEFAULT_INSTANCE;
    }

    @Override
    public void setAllowedMetadataSourceTypes(@NotNull List<String> list) {
        ValidateArg.notNull(list, (String)"list");
        this.allowedMetadataSourceTypes.clear();
        this.allowedMetadataSourceTypes.addAll(list);
    }

    @Override
    public List<String> getAllowedMetadataSourceTypes() {
        return Collections.unmodifiableList(this.allowedMetadataSourceTypes);
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.selectableSupport.consumeAttributes(provider);
        this.setBaseSelectionPath(provider.consumeAttr("baseSelectionPath"));
        this.setStartingSelectionPath(provider.consumeAttr("startingSelectionPath"));
        this.setFileSelectionMode(provider.consumeIntAttr("fileSelectionMode", 1));
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        ArrayList list = roHolder.consumeObjects("AllowedTypes");
        if (null != list && !list.isEmpty()) {
            this.getLogger2().debug("consumeRelObject, setAllowedMetadataSourceTypes() ");
            ArrayList<String> list2Set = new ArrayList<String>();
            for (BasePersistedValue value : list) {
                list2Set.add((String)value.getValue());
            }
            this.setAllowedMetadataSourceTypes(list2Set);
        }
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        this.selectableSupport.writeDefinition(element, writingContext);
        if (this.allowedMetadataSourceTypes != null && !this.allowedMetadataSourceTypes.isEmpty()) {
            ArrayList<PersistenceInterface> list = new ArrayList<PersistenceInterface>(this.allowedMetadataSourceTypes.size());
            for (String type : this.allowedMetadataSourceTypes) {
                list.add(ValueUtil.getPersistableValue((Object)type));
            }
            this.getLogger2().debug("Writing AllowedTypes element.");
            MetadataSourceDefinition.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"AllowedTypes");
        }
        XmlUtil.setAttr((Element)element, (String)"baseSelectionPath", (String)this.baseSelectionPath);
        XmlUtil.setAttr((Element)element, (String)"startingSelectionPath", (String)this.startingSelectionPath);
        XmlUtil.setIntAttr((Element)element, (String)"fileSelectionMode", (int)this.fileSelectionMode);
    }

    public String getDefinitionElementName() {
        return "MetadataSourceDefinition";
    }

    @Override
    public Collection<ValidationEntry> getIndivdualPromptValueValidationErrors(Object value, Locale locale) {
        long returnValue = this.validateValue(value);
        return this.populateMapWithErrors(null, returnValue, value, false, locale);
    }

    @Override
    public int getMaximumValueCount() {
        return this.selectableSupport.getMaximumValueCount();
    }

    @Override
    public int getMinimumValueCount() {
        return this.selectableSupport.getMinimumValueCount();
    }

    @Override
    public int getSelectionType() {
        return this.selectableSupport.getSelectionType();
    }

    @Override
    public boolean isSelectionOrdered() {
        return this.selectableSupport.isSelectionOrdered();
    }

    @Override
    public boolean validIndividualValue(Object value) {
        return this.validIndividualValue(value, Locale.getDefault());
    }

    public String getMacroVariableListDelimiter() {
        return this.selectableSupport.getMacroVariableListDelimiter();
    }

    public int getMacroVariableListFormat() {
        return this.selectableSupport.getMacroVariableListFormat();
    }

    public String getMacroVariableQuote() {
        return this.selectableSupport.getMacroVariableQuote();
    }

    @Override
    public void setMaximumValueCount(int maximumValueCount) {
        this.selectableSupport.setMaximumValueCount(maximumValueCount);
    }

    @Override
    public void setMinimumValueCount(int minimumValueCount) {
        this.selectableSupport.setMinimumValueCount(minimumValueCount);
    }

    @Override
    public void setSelectionOrdered(boolean selectionOrdered) {
        this.selectableSupport.setSelectionOrdered(selectionOrdered);
    }

    public void setMacroVariableListDelimiter(String delimiter) {
        this.selectableSupport.setMacroVariableListDelimiter(delimiter);
    }

    public void setMacroVariableListFormat(int listFormat) {
        this.selectableSupport.setMacroVariableListFormat(listFormat);
    }

    public void setMacroVariableQuote(String quote) {
        this.selectableSupport.setMacroVariableQuote(quote);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MetadataSourceDefinition clone = (MetadataSourceDefinition)super.clone();
        return clone;
    }

    @Override
    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        super.configureAttributes(options, context);
        this.selectableSupport.configurePrompt(this, options, context);
        if (options.containsKey("AllowedTypes") && options.get("AllowedTypes") instanceof List) {
            this.setAllowedMetadataSourceTypes((List)options.get("AllowedTypes"));
        }
    }

    public List getAttributeDescriptors(Locale myLocale) {
        List<?> attributeList = super.getAttributeDescriptors(myLocale);
        if (attributeList == null) {
            attributeList = new ArrayList();
        }
        List selList = this.selectableSupport.getAttributeDescriptors(myLocale);
        attributeList.addAll(selList);
        attributeList.add(new AttributeDescriptor("AllowedTypes", "AllowedTypes", "List<String>", this.getAllowedMetadataSourceTypes(), null, true, true));
        return attributeList;
    }

    @Override
    public String getVersion() {
        String tempVersion = super.getVersion();
        try {
            if (XmlUtil.compareVersionStrings((String)tempVersion, (String)"2.0") <= 0) {
                tempVersion = "2.0";
            }
        }
        catch (ParseException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
        }
        this.getLogger2().debug("version is:", tempVersion);
        return tempVersion;
    }

    @Override
    public boolean validIndividualValue(Object value, Locale locale) {
        long retVal = this.validateValue(value);
        return retVal == 0L;
    }

    @Override
    public void setFileSelectionMode(int fileSelectionMode) {
        this.fileSelectionMode = fileSelectionMode;
    }

    @Override
    public int getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    @Override
    public String getBaseSelectionPath() {
        return this.baseSelectionPath;
    }

    @Override
    public void setBaseSelectionPath(String baseSelectionPath) {
        this.baseSelectionPath = baseSelectionPath;
    }

    @Override
    public String getStartingSelectionPath() {
        return this.startingSelectionPath;
    }

    @Override
    public void setStartingSelectionPath(String startingSelectionPath) {
        this.startingSelectionPath = startingSelectionPath;
    }
}

