/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataSourceType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.MutableDataSourceDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinition;
import com.sas.prompts.definitions.RB;
import com.sas.text.Message;
import com.sas.util.AttributeDescriptor;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;

@SASScope(value="ALL")
public class DataSourceDefinition
extends PromptDefinition
implements MutableDataSourceDefinitionInterface {
    private static final String RB_KEY = "DataSourceDefinition.";
    private static final long serialVersionUID = -7640728107012007814L;
    private boolean required;
    private long allowedDataSourceTypes;

    public DataSourceDefinition() {
        this.init();
    }

    public DataSourceDefinition(String promptName) {
        super(promptName);
        this.init();
    }

    private void init() {
        this.required = false;
        this.allowedDataSourceTypes = -1L;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    private long validateValue(Object value) {
        long returnValue = 0L;
        if (value != null && !(value instanceof DataSourceInterface)) {
            returnValue |= 1L;
        } else if (value != null && !this.isDataSourceTypeAllowed(((DataSourceInterface)value).getDataSourceType())) {
            returnValue |= 0x40000000L;
        }
        return returnValue;
    }

    @Override
    public boolean isPromptValueValid(Object value, Locale locale) {
        long returnValue;
        return super.isPromptValueValid(value, locale) && (returnValue = this.validateValue(value)) == 0L;
    }

    @Override
    public Collection<ValidationEntry> getPromptValueValidationErrors(Object value, Locale locale) {
        Collection<ValidationEntry> errors = super.getPromptValueValidationErrors(value, locale);
        long returnValue = this.validateValue(value);
        this.populateMapWithErrors(errors, returnValue, value, false, locale);
        return errors;
    }

    @Override
    public Collection<ValidationEntry> validateDefinition(Locale locale) {
        Collection<ValidationEntry> errors = super.validateDefinition(locale);
        Object dv = this.isDefaultValueSet() ? this.getDefaultValue() : null;
        long returnValue = 0L;
        if (returnValue == 0L) {
            returnValue = this.validateValue(dv);
            this.populateMapWithErrors(errors, returnValue, dv, true, locale);
        }
        return errors;
    }

    private void populateMapWithErrors(Collection<ValidationEntry> errors, long errorCode, Object value, boolean defaultValue, Locale locale) {
        if ((errorCode & 1L) == 1L) {
            if (defaultValue) {
                PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueNotADataSource.fmt.txt", locale), (Object)value));
            } else {
                PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "notADataSource.fmt.txt", locale), (Object)value));
            }
        }
        if ((errorCode & 0x40000000L) == 0x40000000L) {
            if (defaultValue) {
                PromptUtil.addError(errors, 0x40000000L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueContainsDisallowedDataSourceType.txt", locale), (Object)value));
            } else {
                PromptUtil.addError(errors, 0x40000000L, Message.format((String)RB.getStringResource(RB_KEY, "dataSourcesContainsDisallowedType.txt", locale), (Object)value));
            }
        }
    }

    @Override
    public DataTypeInterface getPromptDataType() {
        return DataSourceType.DEFAULT_INSTANCE;
    }

    @Override
    public void setAllowedDataSourceTypes(long allowedDataSourceTypes) {
        if (this.allowedDataSourceTypes != allowedDataSourceTypes) {
            this.allowedDataSourceTypes = allowedDataSourceTypes;
        }
    }

    @Override
    public boolean isDataSourceTypeAllowed(long dataSourceType) {
        if (this.allowedDataSourceTypes == -1L) {
            return true;
        }
        return (this.allowedDataSourceTypes & dataSourceType) == dataSourceType;
    }

    @Override
    public long getAllowedDataSourceTypes() {
        return this.allowedDataSourceTypes;
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.setRequired(provider.consumeBooleanAttr("required", false));
        this.setAllowedDataSourceTypes(provider.consumeLongAttr("allowedDataSources", new Long(-1L)));
    }

    @Override
    @SASScope
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setBooleanAttr((Element)element, (String)"required", (boolean)this.isRequired(), (boolean)false);
        XmlUtil.setLongAttr((Element)element, (String)"allowedDataSources", (long)this.getAllowedDataSourceTypes(), (long)-1L);
    }

    @SASScope
    public String getDefinitionElementName() {
        return "DataSourceDefinition";
    }

    private long updateAllowedDataSource(long current, Map options, String key, long keyValue, Map context) {
        if (options.containsKey(key)) {
            boolean bool = PromptConfigurationFactory.getBoolOption((String)key, (Map)options, (Map)context);
            if (current == -1L) {
                if (!bool) {
                    current = 63L;
                    current &= keyValue ^ 0xFFFFFFFFFFFFFFFFL;
                }
            } else {
                current = bool ? (current |= keyValue) : (current &= keyValue ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
        return current;
    }

    public void configureAttributes(Map options, Map context) {
        super.configureAttributes(options, context);
        if (options.containsKey("required")) {
            this.setRequired(PromptConfigurationFactory.getBoolOption((String)"required", (Map)options, (Map)context));
        }
        long allowedSources = this.getAllowedDataSourceTypes();
        allowedSources = this.updateAllowedDataSource(allowedSources, options, "allowedDataSources_relationalInfoMap", 4L, context);
        allowedSources = this.updateAllowedDataSource(allowedSources, options, "allowedDataSources_physicalTable", 1L, context);
        allowedSources = this.updateAllowedDataSource(allowedSources, options, "allowedDataSources_olapInfoMap", 8L, context);
        allowedSources = this.updateAllowedDataSource(allowedSources, options, "allowedDataSources_olapCube", 2L, context);
        allowedSources = this.updateAllowedDataSource(allowedSources, options, "allowedDataSources_miningResult", 16L, context);
        allowedSources = this.updateAllowedDataSource(allowedSources, options, "allowedDataSources_externalTable", 32L, context);
        this.setAllowedDataSourceTypes(allowedSources);
    }

    public List getAttributeDescriptors(Locale locale) {
        List<?> attributeList = super.getAttributeDescriptors(locale);
        if (attributeList == null) {
            attributeList = new ArrayList();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        AttributeDescriptor typeAttribute = new AttributeDescriptor("promptType", "promptType", "String", (Object)this.getDefinitionElementName(), null, false, false);
        typeAttribute.setVisible(false);
        attributeList.add(typeAttribute);
        attributeList.add(new AttributeDescriptor("required", "required", "Boolean", (Object)this.isRequired(), true, true));
        long allowedTypes = this.getAllowedDataSourceTypes();
        boolean isCubeSourceAllowed = (allowedTypes & 2L) > 0L;
        boolean isRelationalTableSourceAllowed = (allowedTypes & 1L) > 0L;
        boolean isRelationalMapSourceAllowed = (allowedTypes & 4L) > 0L;
        boolean isOLAPMapSourceAllowed = (allowedTypes & 8L) > 0L;
        attributeList.add(new AttributeDescriptor("allowedDataSources_olapInfoMap", "OLAP InfoMap data source", "boolean", (Object)isOLAPMapSourceAllowed, true, true));
        attributeList.add(new AttributeDescriptor("allowedDataSources_olapCube", "OLAP Cube data source", "boolean", (Object)isCubeSourceAllowed, true, true));
        attributeList.add(new AttributeDescriptor("allowedDataSources_relationalInfoMap", "Relational InfoMap data source", "boolean", (Object)isRelationalMapSourceAllowed, true, true));
        attributeList.add(new AttributeDescriptor("allowedDataSources_physicalTable", "Table data source", "boolean", (Object)isRelationalTableSourceAllowed, true, true));
        return attributeList;
    }
}

