/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions;

import com.sas.codepolicy.SASScope;
import com.sas.models.FileLocation;
import com.sas.models.FileLocationInterface;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.prompts.datatypes.values.ValueUtil;
import com.sas.prompts.definitions.MutableFileSelectionInterface;
import com.sas.prompts.definitions.PromptDefinition;
import com.sas.prompts.definitions.RB;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.SubstitutionProperties;
import com.sas.text.Message;
import com.sas.util.AttributeDescriptor;
import com.sas.util.ListFactory;
import com.sas.util.ValidateArg;
import com.sas.util.anno.NotNull;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
public abstract class BaseFileDefinition
extends PromptDefinition
implements MutableFileSelectionInterface,
SubstitutionProperties {
    private static final String RB_KEY = "BaseFileDefinition.";
    private static final long serialVersionUID = 3938686475607631084L;
    private int fileSelectionMode;
    private boolean required;
    private List<String> fileTypes = new ArrayList<String>();
    private String logicalServerName;
    private static final String DIR_PATH = "DirPath";
    private static final String FILE_PATH = "FilePath";
    private static final String APPLICATION_SERVER = "ApplicationServer";

    public BaseFileDefinition() {
        this.init();
    }

    public BaseFileDefinition(String promptName) {
        super(promptName);
        this.init();
    }

    @SASScope
    protected void init() {
        this.required = false;
        this.fileSelectionMode = 1;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public boolean isPromptValueValid(Object value, Locale locale) {
        long returnValue;
        return super.isPromptValueValid(value, locale) && (returnValue = this.validateValue(value)) == 0L;
    }

    private long validateValue(Object value) {
        long returnValue = 0L;
        if (value != null && !(value instanceof FileLocationInterface)) {
            returnValue |= 1L;
        } else if (value != null) {
            FileLocationInterface fli = (FileLocationInterface)value;
            if (fli.isFile() && !this.isFileAllowed(fli.getFileLocation())) {
                returnValue |= 0x1000000000L;
            } else if (this.getFileSelectionMode() == 1) {
                if (!fli.isFile()) {
                    returnValue |= 0x2000000000L;
                }
            } else if (this.getFileSelectionMode() == 2 && !fli.isDirectory()) {
                returnValue |= 0x4000000000L;
            }
        }
        return returnValue;
    }

    private boolean isFileAllowed(String path) {
        List<String> ft = this.getFileTypes();
        if (ft == null || ft.isEmpty()) {
            return true;
        }
        int index = path.lastIndexOf(46);
        if (index != -1) {
            String ext = path.substring(index).trim();
            String extWithDot = path.substring(index + 1).trim();
            for (String type : ft) {
                if (!type.equalsIgnoreCase(ext) && !type.equalsIgnoreCase(extWithDot)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<ValidationEntry> getPromptValueValidationErrors(Object value, Locale locale) {
        Collection<ValidationEntry> errors = super.getPromptValueValidationErrors(value, locale);
        long returnValue = this.validateValue(value);
        errors = this.populateMapWithErrors(errors, returnValue, value, false, locale);
        return errors;
    }

    private Collection<ValidationEntry> populateMapWithErrors(Collection<ValidationEntry> errors, long errorCode, Object value, boolean defaultValue, Locale locale) {
        if ((errorCode & 1L) == 1L) {
            errors = defaultValue ? PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueNotAFile.fmt.txt", locale), (Object)value)) : PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "notAFile.fmt.txt", locale), (Object)value));
        }
        if ((errorCode & 0x1000000000L) == 0x1000000000L) {
            errors = defaultValue ? PromptUtil.addError(errors, 0x1000000000L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueContainsDisallowedFileType.txt", locale), (Object)value)) : PromptUtil.addError(errors, 0x1000000000L, Message.format((String)RB.getStringResource(RB_KEY, "disallowedFileType.txt", locale), (Object)value));
        }
        if ((errorCode & 0x2000000000L) == 0x2000000000L) {
            errors = defaultValue ? PromptUtil.addError(errors, 0x2000000000L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueIsADirectory.txt", locale), (Object)value)) : PromptUtil.addError(errors, 0x2000000000L, Message.format((String)RB.getStringResource(RB_KEY, "isADirectory.txt", locale), (Object)value));
        }
        if ((errorCode & 0x4000000000L) == 0x4000000000L) {
            errors = defaultValue ? PromptUtil.addError(errors, 0x4000000000L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueIsAFile.txt", locale), (Object)value)) : PromptUtil.addError(errors, 0x4000000000L, Message.format((String)RB.getStringResource(RB_KEY, "isAFile.txt", locale), (Object)value));
        }
        return errors;
    }

    @Override
    public String getLogicalServerName() {
        return this.logicalServerName;
    }

    @Override
    public void setLogicalServerName(String logicalServerName) {
        this.logicalServerName = logicalServerName;
    }

    @Override
    public List<String> getFileTypes() {
        ArrayList<String> retVal = new ArrayList<String>();
        retVal.addAll(this.fileTypes);
        return retVal;
    }

    @Override
    public void setFileTypes(List<String> fileTypes) {
        if (fileTypes != null) {
            this.fileTypes.addAll(fileTypes);
        }
    }

    @Override
    public int getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    @Override
    public void setFileSelectionMode(int fileSelectionMode) {
        this.fileSelectionMode = fileSelectionMode;
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        ArrayList list = roHolder.consumeObjects("FileTypes");
        if (!list.isEmpty()) {
            this.getLogger2().debug("consumeRelObjects, setFileTypes() ");
            List newFileTypeList = ListFactory.newList((int)list.size());
            for (BasePersistedValue value : list) {
                newFileTypeList.add(value.getValue());
            }
            this.setFileTypes(newFileTypeList);
        }
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.setRequired(provider.consumeBooleanAttr("required", false));
        this.setFileSelectionMode(provider.consumeIntAttr("fileSelectionMode", 1));
        this.setLogicalServerName(provider.consumeAttr("logicalServerName"));
    }

    @Override
    @SASScope
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setBooleanAttr((Element)element, (String)"required", (boolean)this.isRequired(), (boolean)false);
        XmlUtil.setAttr((Element)element, (String)"logicalServerName", (String)this.getLogicalServerName());
        XmlUtil.setIntAttr((Element)element, (String)"fileSelectionMode", (int)this.getFileSelectionMode(), (int)1);
        if (this.fileTypes != null && !this.fileTypes.isEmpty()) {
            ArrayList<PersistenceInterface> list = new ArrayList<PersistenceInterface>(this.fileTypes.size());
            for (String fileType : this.fileTypes) {
                list.add(ValueUtil.getPersistableValue((Object)fileType));
            }
            this.getLogger2().debug("Writing file types element.");
            BaseFileDefinition.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"FileTypes");
        }
    }

    @SASScope
    public PropertyList getSubstitutionProperties() {
        PropertyList propertyList = new PropertyList();
        this.getLogger2().debug("getSubstitutionProperties for prompt", this.getPromptName());
        if (this.isDefaultValueSet()) {
            PropertyList nested = new PropertyList();
            this.getLogger2().debug("default value is:", this.getPromptDataType().getValueAsString(this.getDefaultValue(), Locale.getDefault()));
            propertyList.addComment("These are properties for the default value.");
            if (((FileLocationInterface)this.getDefaultValue()).isFile()) {
                propertyList.addProperty(FILE_PATH, ((FileLocationInterface)this.getDefaultValue()).getFileLocation());
                nested.addProperty(APPLICATION_SERVER, ((FileLocationInterface)this.getDefaultValue()).getServerName());
                propertyList.addProperty(FILE_PATH, nested);
            } else {
                propertyList.addProperty(DIR_PATH, ((FileLocationInterface)this.getDefaultValue()).getFileLocation());
                nested.addProperty(APPLICATION_SERVER, ((FileLocationInterface)this.getDefaultValue()).getServerName());
                propertyList.addProperty(DIR_PATH, nested);
            }
        }
        if (null != this.logicalServerName) {
            this.getLogger2().debug("add property for logicalServerName");
            propertyList.addComment("This is the logical server name field.");
            propertyList.addProperty(APPLICATION_SERVER, this.logicalServerName);
        }
        return propertyList;
    }

    @SASScope
    public void setSubstitutionProperties(@NotNull PropertyMap map) {
        ValidateArg.notNull((Object)map, (String)"map");
        this.getLogger2().debug("setSubstitutionProperties for prompt", this.getPromptName());
        FileLocation file = null;
        if (map.containsProperty(FILE_PATH) || map.containsProperty(DIR_PATH)) {
            if (map.containsProperty(FILE_PATH)) {
                String path = map.getProperty(FILE_PATH);
                String server = map.getProperty("FilePath.ApplicationServer");
                file = new FileLocation(server, path, false);
                this.getLogger2().debug("setSubstitutionProperties for default value:", file.toString());
            } else if (map.containsProperty(DIR_PATH)) {
                String path = map.getProperty(DIR_PATH);
                String server = map.getProperty("DirPath.ApplicationServer");
                file = new FileLocation(server, path, true);
                this.getLogger2().debug("setSubstitutionProperties for default value:", file.toString());
            }
            this.setDefaultValue(file);
        }
        if (map.containsProperty(APPLICATION_SERVER)) {
            this.setLogicalServerName(map.getProperty(APPLICATION_SERVER));
            this.getLogger2().debug("setSubstitutionProperties for app server to:", this.logicalServerName);
        }
    }

    @Override
    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        Object fileTypes;
        super.configureAttributes(options, context);
        if (options.containsKey("required")) {
            this.setRequired(PromptConfigurationFactory.getBoolOption((String)"required", options, context));
        }
        if (options.containsKey("logicalServerName")) {
            this.setLogicalServerName(PromptConfigurationFactory.getStringOption((String)"logicalServerName", options, context));
        }
        if (options.containsKey("fileSelectionMode")) {
            this.setFileSelectionMode(PromptConfigurationFactory.getIntOption((String)"fileSelectionMode", options, context));
        }
        if (options.containsKey("FileTypes") && (fileTypes = options.get("FileTypes")) instanceof List) {
            ArrayList<String> types = new ArrayList<String>();
            for (Object obj : (List)fileTypes) {
                if (obj == null) continue;
                types.add(obj.toString());
            }
            this.setFileTypes(types);
        }
    }

    public List getAttributeDescriptors(Locale locale) {
        List<?> attributeList = super.getAttributeDescriptors(locale);
        AttributeDescriptor typeAttribute = new AttributeDescriptor("promptType", "promptType", "String", (Object)this.getDefinitionElementName(), null, false, false);
        typeAttribute.setVisible(false);
        attributeList.add(typeAttribute);
        attributeList.add(new AttributeDescriptor("logicalServerName", "logicalServerName", "String", (Object)this.getLogicalServerName(), true, true));
        attributeList.add(new AttributeDescriptor("fileSelectionMode", "fileSelectionMode", "String", (Object)this.getFileSelectionMode(), true, true));
        return attributeList;
    }
}

