/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts;

import com.sas.MissingValues;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeInterface;
import com.sas.models.AnnotatedValueInterface;
import com.sas.models.MutableAnnotatedValueInterface;
import com.sas.prompts.FindPromptValuesByPromptDefinitionIDVisitor;
import com.sas.prompts.FindPromptValuesByPromptDefinitionVisitor;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptDefinitionCombination;
import com.sas.prompts.PromptDefinitionReference;
import com.sas.prompts.PromptUserContextInterface;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeEvent;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.PromptValuesVisitorInterface;
import com.sas.prompts.RB;
import com.sas.prompts.ResultContainer;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.ModalGroupDefinition;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.ObjectDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionV2Interface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.groups.ModalChoiceGroupInterface;
import com.sas.prompts.groups.ModalGroupInterface;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.PromptGroupV2Interface;
import com.sas.prompts.script.PromptAction;
import com.sas.prompts.script.ScriptCommand;
import com.sas.prompts.script.ScriptCommandFactory;
import com.sas.prompts.script.ScriptHolder;
import com.sas.prompts.script.ValidationContext;
import com.sas.prompts.script.ValueChangeContext;
import com.sas.prompts.util.MapText;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderValueRetrievalInterface;
import com.sas.text.Message;
import com.sas.util.ListFactory;
import com.sas.util.MutableUserInfoInterface;
import com.sas.util.UserInfo;
import com.sas.util.UserInfoInterface;
import com.sas.util.Util;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
public class PromptValues
extends AbstractPersistence
implements PromptValuesInterface {
    private static final long serialVersionUID = -4379533114788613893L;
    public static final String RB_KEY = "PromptValues.";
    public static final String PROMPT_VALUES_XML_WRITE_ALL_DEFINITIONS = "PROMPT_VALUES_XML_WRITE_ALL_DEFINITIONS";
    private static final String PROMPT_VALUE_NOT_FOUND = "Prompt Value Not Found";
    public static final String _SAS_INTERNAL_ORDER_UNIMPORTANT = "_SAS_INTERNAL_ORDER_UNIMPORTANT";
    public static final String UNSET = "UNSET";
    private PromptGroupInterface promptGroup;
    private Map values;
    private List promptValuesDelegates;
    private List additionalCascadeDependencies;
    private MutableUserInfoInterface mutableUserInfo;
    private List combinations;
    private transient PromptUserContextInterface userContext;
    private EventListenerList listenerList = new EventListenerList();

    public PromptValues() {
        this(new PromptGroup());
    }

    public PromptValues(PromptGroupInterface promptGroup) {
        this(promptGroup, null);
    }

    public PromptValues(PromptGroupInterface promptGroup, PromptUserContextInterface userContext) {
        this.promptGroup = promptGroup;
        this.userContext = userContext;
    }

    public PromptValues(List promptDefinitions, PromptUserContextInterface userContext) {
        this(new PromptGroup(promptDefinitions), userContext);
    }

    @Override
    public void init(Map options) {
        PromptUtil.initializeValueProviders(this.promptGroup, options);
    }

    @Override
    public void setInitParameter(String key, Object value) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put(key, value);
        this.init(options);
    }

    @Override
    public PromptGroupInterface getPromptGroup() {
        return this.promptGroup;
    }

    @Override
    public void setPromptGroup(PromptGroupInterface promptGroup, boolean clearValuesNotInGroup) {
        if (clearValuesNotInGroup && this.values != null) {
            ArrayList<PromptDefinitionInterface> definitionsToClear = new ArrayList<PromptDefinitionInterface>();
            for (PromptDefinitionInterface definition : this.values.keySet()) {
                if (promptGroup.hasPromptDefinition(definition)) continue;
                definitionsToClear.add(definition);
            }
            for (PromptDefinitionInterface definition : definitionsToClear) {
                this.clearPromptValue(definition);
            }
        }
        this.promptGroup = promptGroup;
    }

    public PromptUserContextInterface getPromptUserContext() {
        return this.userContext;
    }

    @Override
    @SASScope
    public Object getPossiblyAnnotatedPromptValue(PromptDefinitionInterface promptDefinition) throws PromptValueNotFoundException {
        Object pv = PROMPT_VALUE_NOT_FOUND;
        PromptValuesInterface targetPromptValues = this.findPromptValuesForPromptDefinition(promptDefinition);
        if (targetPromptValues != this) {
            if (targetPromptValues == null) {
                throw new PromptValueNotFoundException(promptDefinition);
            }
            pv = targetPromptValues.getPossiblyAnnotatedPromptValue(promptDefinition);
        } else if (this.values == null || !this.values.containsKey(promptDefinition)) {
            if (this.userContext != null && promptDefinition.isStickyDefaultAllowed() && this.userContext.isStickyValueSet(promptDefinition)) {
                pv = this.userContext.getStickyValue(promptDefinition);
            } else if (promptDefinition.isDefaultValueSet()) {
                pv = promptDefinition.getDefaultValue();
            } else if (promptDefinition instanceof ValueProviderDefinitionInterface && ((ValueProviderDefinitionInterface)((Object)promptDefinition)).getValueProvider() instanceof ValueProviderValueRetrievalInterface) {
                try {
                    pv = ((ValueProviderValueRetrievalInterface)((ValueProviderDefinitionInterface)((Object)promptDefinition)).getValueProvider()).getValue();
                }
                catch (ValueProviderException ex) {
                    throw new PromptValueNotFoundException(promptDefinition);
                }
            }
            if (pv == PROMPT_VALUE_NOT_FOUND) {
                throw new PromptValueNotFoundException(promptDefinition);
            }
        }
        if (pv == PROMPT_VALUE_NOT_FOUND) {
            pv = this.values.get(promptDefinition);
        }
        if (pv == null && promptDefinition.isRequired() || pv == UNSET) {
            throw new PromptValueNotFoundException(promptDefinition);
        }
        return pv;
    }

    @Override
    public Object getPromptValue(PromptDefinitionInterface promptDefinition) throws PromptValueNotFoundException {
        Object pv = PROMPT_VALUE_NOT_FOUND;
        pv = this.getPossiblyAnnotatedPromptValue(promptDefinition);
        if ((pv = this.getUnannotatedValueCopy(pv)) == null && promptDefinition.isRequired() || pv == UNSET) {
            throw new PromptValueNotFoundException(promptDefinition);
        }
        return pv;
    }

    @Override
    public int getPromptValueAsInt(PromptDefinitionInterface promptDefinition) throws PromptValueNotFoundException {
        return (Integer)this.getPromptValue(promptDefinition);
    }

    @Override
    public double getPromptValueAsDouble(PromptDefinitionInterface promptDefinition) throws PromptValueNotFoundException {
        return (Double)this.getPromptValue(promptDefinition);
    }

    @Override
    public String getPromptValueAsString(PromptDefinitionInterface promptDefinition) throws PromptValueNotFoundException {
        return (String)this.getPromptValue(promptDefinition);
    }

    @Override
    public Date getPromptValueAsDate(PromptDefinitionInterface promptDefinition) throws PromptValueNotFoundException {
        return (Date)this.getPromptValue(promptDefinition);
    }

    @Override
    public List getPromptValueAsList(PromptDefinitionInterface promptDefinition) throws PromptValueNotFoundException {
        Object value = this.getPromptValue(promptDefinition);
        if (value instanceof List) {
            return (List)value;
        }
        ArrayList<Object> newList = new ArrayList<Object>(1);
        newList.add(value);
        return newList;
    }

    public boolean isPromptValueMissing(PromptDefinitionInterface promptDefinition) throws PromptValueNotFoundException {
        Object value = this.getPromptValue(promptDefinition);
        return value instanceof MissingValues;
    }

    @Override
    public void setPromptValue(PromptDefinitionInterface promptDefinition, List value) throws InvalidPromptValueException {
        this.setPromptValue(promptDefinition, value, Locale.US);
    }

    @Override
    public void setPromptValue(PromptDefinitionInterface promptDefinition, String value) throws InvalidPromptValueException {
        this.setPromptValue(promptDefinition, value, Locale.US);
    }

    @Override
    public void setPromptValue(PromptDefinitionInterface promptDefinition, Date value) throws InvalidPromptValueException {
        this.setPromptValue(promptDefinition, value, Locale.US);
    }

    @Override
    public void setPromptValue(PromptDefinitionInterface promptDefinition, double value) throws InvalidPromptValueException {
        this.setPromptValue(promptDefinition, new Double(value), Locale.US);
    }

    public void setPromptValue(PromptDefinitionInterface promptDefinition, int value) throws InvalidPromptValueException {
        this.setPromptValue(promptDefinition, new Integer(value), Locale.US);
    }

    @Override
    public void setPromptValue(PromptDefinitionInterface promptDefinition, Object value) throws InvalidPromptValueException {
        this.setPromptValue(promptDefinition, value, Locale.US);
    }

    @Override
    public void setPromptValue(PromptDefinitionInterface promptDefinition, Object value, Locale inputLocale) throws InvalidPromptValueException {
        Object oldValue;
        if (promptDefinition == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullPromptDefinition.ex.txt", inputLocale));
        }
        if (promptDefinition.isFixed()) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource(RB_KEY, "cannotSetFixedPromptValue.ex.fmt", inputLocale), (Object)promptDefinition.getPromptName()));
        }
        PromptValuesInterface targetPromptValues = this.findPromptValuesForPromptDefinition(promptDefinition);
        if (targetPromptValues == null) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource(RB_KEY, "promptValuesNotFound.ex.fmt", inputLocale), (Object)promptDefinition.getPromptName()));
        }
        if (targetPromptValues != this) {
            targetPromptValues.setPromptValue(promptDefinition, value, inputLocale);
            return;
        }
        if (PromptUtil.isPromptValuesEqual(value, null) && promptDefinition.isRequired()) {
            this.clearPromptValue(promptDefinition);
            return;
        }
        if (this.values == null) {
            this.values = new HashMap();
        }
        Object annotatedValue = null;
        if (this.isValueAnnotated(value)) {
            annotatedValue = value;
            value = this.getUnannotatedValueCopy(value);
        }
        boolean newValue = true;
        boolean newEvent = true;
        if (value == UNSET) {
            if (this.values.containsKey(promptDefinition) && (oldValue = (Object)this.values.get(promptDefinition)) == UNSET) {
                newValue = false;
            }
        } else {
            DataTypeInterface promptDataType = promptDefinition.getPromptDataType();
            try {
                value = promptDataType.coerceValue(value, inputLocale);
            }
            catch (IllegalArgumentException iae) {
                String msg = iae.getMessage();
                InvalidPromptValueException ipve = new InvalidPromptValueException(promptDefinition, msg, inputLocale, null);
                ipve.initCause(iae);
                throw ipve;
            }
            catch (Exception e) {
                throw new InvalidPromptValueException(promptDefinition, value, inputLocale, null);
            }
            boolean isValidValue = promptDefinition.isPromptValueValid(value);
            if (!isValidValue) {
                Collection<ValidationEntry> reasons = promptDefinition.getPromptValueValidationErrors(value, inputLocale);
                throw new InvalidPromptValueException(promptDefinition, promptDefinition.getPromptDataType().getDisplayString(value, inputLocale), inputLocale, reasons);
            }
            if (annotatedValue != null) {
                this.updateAnnotatedValues(annotatedValue, value, inputLocale);
            }
            this.executeScriptForValidation(promptDefinition, value, inputLocale);
            if (this.values.containsKey(promptDefinition)) {
                boolean[] retVal;
                boolean isCollection;
                Object oldAnnotatedValue = null;
                Object oldValue2 = this.values.get(promptDefinition);
                if (this.isValueAnnotated(oldValue2)) {
                    oldAnnotatedValue = oldValue2;
                    oldValue2 = this.getUnannotatedValueCopy(oldAnnotatedValue);
                }
                if (annotatedValue != null && oldAnnotatedValue == null || annotatedValue == null && oldAnnotatedValue != null) {
                    newEvent = true;
                    newValue = true;
                } else if (annotatedValue != null && oldAnnotatedValue != null) {
                    isCollection = PromptUtil.testForCollection(oldAnnotatedValue);
                    if (annotatedValue instanceof Collection && !isCollection) {
                        retVal = this.testCollectionForEqual((Collection)annotatedValue, oldAnnotatedValue);
                        newValue = retVal[0];
                        newEvent = retVal[1];
                    } else if (PromptUtil.isPromptValuesEqual(annotatedValue, oldAnnotatedValue)) {
                        newValue = false;
                    }
                } else {
                    isCollection = PromptUtil.testForCollection(oldValue2);
                    if (isCollection && null == value && ((Collection)oldValue2).isEmpty()) {
                        newEvent = false;
                    } else if (value instanceof Collection && !isCollection) {
                        retVal = this.testCollectionForEqual((Collection)value, oldValue2);
                        newValue = retVal[0];
                        newEvent = retVal[1];
                    } else if (PromptUtil.isPromptValuesEqual(value, oldValue2)) {
                        newValue = false;
                    }
                }
            }
        }
        if (newValue) {
            List combinations;
            oldValue = null;
            if (this.isPromptValueAvailable(promptDefinition)) {
                try {
                    oldValue = this.getPromptValue(promptDefinition);
                }
                catch (PromptValueNotFoundException isValidValue) {
                    // empty catch block
                }
            }
            if (annotatedValue != null) {
                this.values.put(promptDefinition, annotatedValue);
            } else {
                this.values.put(promptDefinition, value);
            }
            this.executeScriptForValueChanged(promptDefinition, oldValue);
            if (newEvent) {
                this.firePromptValueChanged(promptDefinition, oldValue, value, inputLocale);
            }
            if (promptDefinition instanceof ModalGroupDefinition) {
                this.clearPromptValuesForModalGroupDefinition((ModalGroupDefinition)promptDefinition);
            }
            if ((combinations = this.getPromptDefinitionCombinations(promptDefinition)) != null && combinations.size() != 0) {
                int n = combinations.size();
                for (int i = 0; i < n; ++i) {
                    PromptDefinitionInterface targetDefinition = (PromptDefinitionInterface)combinations.get(i);
                    this.setPromptValue(targetDefinition, value, inputLocale);
                }
            }
            if ((combinations = this.getCombinationsForGroups(promptDefinition)) != null && combinations.size() != 0) {
                int n = combinations.size();
                for (int i = 0; i < n; ++i) {
                    PromptDefinitionInterface targetDefinition = (PromptDefinitionInterface)combinations.get(i);
                    this.setPromptValue(targetDefinition, value, inputLocale);
                }
            }
            if (this.userContext != null && promptDefinition.isStickyDefaultAllowed()) {
                this.userContext.setStickyValue(promptDefinition, value);
            }
        }
    }

    private void executeScriptForValidation(PromptDefinitionInterface promptDefinition, Object newValue, Locale inputLocale) throws InvalidPromptValueException {
        ScriptCommand command;
        ScriptHolder scriptHolder = this.getScriptHolder(promptDefinition, PromptAction.VALIDATION);
        if (null != scriptHolder && null != (command = ScriptCommandFactory.newScriptCommand(scriptHolder, null))) {
            Object output;
            this.getLogger2().debug("Running a validation script for the prompt:", promptDefinition.getPromptName());
            this.getLogger2().debug("The prompt action is:", PromptAction.VALIDATION.toString());
            ValidationContext vc = ScriptCommandFactory.newValidationContext(this, null);
            Object[] args = new Object[]{vc, newValue, promptDefinition.getPromptID(), null, inputLocale};
            ResultContainer rc = null;
            try {
                rc = command.execute(args);
            }
            catch (Exception e) {
                InvalidPromptValueException ipve = new InvalidPromptValueException(promptDefinition, newValue, inputLocale, null);
                if (null != rc) {
                    ipve.setLogOutput(rc.getExecutionLog());
                }
                throw ipve;
            }
            if (null != rc && rc.getStatus() == 1) {
                InvalidPromptValueException ipve = new InvalidPromptValueException(promptDefinition, newValue, inputLocale, null);
                ipve.initCause(rc.getException());
                ipve.setLogOutput(rc.getExecutionLog());
                throw ipve;
            }
            if (null != rc && null != (output = rc.getOutput()) && output.toString().trim().length() > 0) {
                ValidationEntry ve = new ValidationEntry(90112L, output.toString().trim());
                ArrayList<ValidationEntry> reasons = new ArrayList<ValidationEntry>();
                reasons.add(ve);
                InvalidPromptValueException ipve = new InvalidPromptValueException(promptDefinition, newValue, inputLocale, reasons);
                ipve.setLogOutput(rc.getExecutionLog());
                throw ipve;
            }
        }
    }

    private void executeScriptForValueChanged(PromptDefinitionInterface promptDefinition, Object oldValue) {
        ScriptCommand command;
        ScriptHolder scriptHolder = this.getScriptHolder(promptDefinition, PromptAction.VALUE_CHANGED);
        if (null != scriptHolder && null != (command = ScriptCommandFactory.newScriptCommand(scriptHolder, null))) {
            this.getLogger2().debug("Running a VALUE_CHANGED script inside clearPromptValue() for the prompt:", promptDefinition.getPromptName());
            ValueChangeContext vc = ScriptCommandFactory.newValueChangeContext(this, null);
            Object[] args = new Object[]{vc, null, promptDefinition.getPromptID(), oldValue};
            ResultContainer rc = command.execute(args);
            if (null != rc && rc.getStatus() == 1) {
                IllegalStateException ise = new IllegalStateException(RB.getStringResource("PromptValues.script.fail.txt"), rc.getException());
                throw ise;
            }
        }
    }

    private ScriptHolder getScriptHolder(PromptDefinitionInterface promptDefinition, PromptAction action) {
        if (promptDefinition instanceof PromptDefinitionV2Interface) {
            return ((PromptDefinitionV2Interface)promptDefinition).getScript(action);
        }
        return null;
    }

    private List getCombinationsForGroups(PromptDefinitionInterface prompt) {
        ArrayList<PromptGroupInterface> subgroups = new ArrayList<PromptGroupInterface>();
        subgroups.add(this.getPromptGroup());
        this.getPromptGroup().getPromptDefinitionsAndSubgroups(subgroups, true, false, true);
        ArrayList<PromptDefinitionInterface> combinations = new ArrayList<PromptDefinitionInterface>();
        for (PromptGroupInterface group : subgroups) {
            if (!(group instanceof PromptGroupV2Interface)) continue;
            PromptGroupV2Interface groupV2 = (PromptGroupV2Interface)group;
            List<PromptDefinitionInterface> currentPromptCombinations = groupV2.getPromptDefinitionCombinations(prompt);
            combinations.addAll(currentPromptCombinations);
        }
        return combinations;
    }

    private boolean[] testCollectionForEqual(Collection value, Object oldValue) {
        boolean[] retVal = new boolean[]{false, true};
        if (value.size() == 1) {
            Object input = value.iterator().next();
            boolean bl = retVal[0] = !PromptUtil.isPromptValuesEqual(input, oldValue);
            if (!retVal[0]) {
                retVal[1] = false;
            }
        } else if (value.size() > 1 && (null == oldValue || UNSET == oldValue)) {
            retVal[0] = true;
            retVal[1] = true;
        } else if (value.isEmpty() && (null == oldValue || UNSET == oldValue)) {
            retVal[0] = true;
            retVal[1] = false;
        } else if (value.size() > 1) {
            retVal[0] = true;
            retVal[1] = true;
        }
        return retVal;
    }

    private void clearPromptValuesForModalGroupDefinition(ModalGroupDefinition definition) {
        PromptGroupInterface pg;
        if (definition != null && (pg = this.promptGroup.findPromptSubgroup(definition)) instanceof ModalGroupInterface) {
            List choices;
            Object selectedModalChoiceValue = null;
            if (this.isPromptValueAvailable(definition)) {
                try {
                    selectedModalChoiceValue = this.getPromptValue(definition);
                }
                catch (PromptValueNotFoundException promptValueNotFoundException) {
                    // empty catch block
                }
            }
            if ((choices = definition.getModalChoiceGroups((ModalGroupInterface)pg)) != null) {
                for (Object o : choices) {
                    if (!(o instanceof ModalChoiceGroupInterface)) continue;
                    ModalChoiceGroupInterface choiceGroup = (ModalChoiceGroupInterface)o;
                    if (selectedModalChoiceValue != null && PromptUtil.isPromptValuesEqual(choiceGroup.getValue(), selectedModalChoiceValue)) continue;
                    List<?> defs = choiceGroup.getPromptDefinitionsAndSubgroups(null, true, true, false);
                    for (PromptDefinitionInterface childDef : defs) {
                        if (childDef.isFixed() || childDef instanceof PromptDefinitionV2Interface && !((PromptDefinitionV2Interface)childDef).isValueClearedForNonSelectedModalChoiceGroup()) continue;
                        this.clearPromptValue(childDef);
                    }
                }
            }
        }
    }

    @Override
    public String getPromptValueAsString(PromptDefinitionInterface promptDefinition, Locale locale) throws PromptValueNotFoundException {
        Object value = this.getPromptValue(promptDefinition);
        DataTypeInterface promptDataType = promptDefinition.getPromptDataType();
        return promptDataType.getValueAsString(value, locale);
    }

    @Override
    public boolean isPromptValueSet(PromptDefinitionInterface promptDefinition) {
        if (this.values != null && this.values.containsKey(promptDefinition)) {
            Object v = this.values.get(promptDefinition);
            if (v == UNSET) {
                return false;
            }
            return v != null || !promptDefinition.isRequired();
        }
        PromptValuesInterface targetPromptValues = this.findPromptValuesForPromptDefinition(promptDefinition);
        if (targetPromptValues != this) {
            if (targetPromptValues == null) {
                return false;
            }
            return targetPromptValues.isPromptValueSet(promptDefinition);
        }
        return false;
    }

    @Override
    public boolean isPromptValueAvailable(PromptDefinitionInterface promptDefinition) {
        if (this.values != null && this.values.containsKey(promptDefinition)) {
            Object v = this.values.get(promptDefinition);
            if (v == UNSET) {
                return false;
            }
            return v != null || !promptDefinition.isRequired();
        }
        PromptValuesInterface targetPromptValues = this.findPromptValuesForPromptDefinition(promptDefinition);
        if (targetPromptValues != this) {
            if (targetPromptValues == null) {
                return false;
            }
            return targetPromptValues.isPromptValueAvailable(promptDefinition);
        }
        if (this.userContext != null && promptDefinition.isStickyDefaultAllowed() && this.userContext.isStickyValueSet(promptDefinition)) {
            return true;
        }
        if (!(!promptDefinition.isDefaultValueSet() || promptDefinition.isRequired() && PromptUtil.isPromptValuesEqual(null, promptDefinition.getDefaultValue()))) {
            return true;
        }
        return promptDefinition instanceof ValueProviderDefinitionInterface && ((ValueProviderDefinitionInterface)((Object)promptDefinition)).getValueProvider() instanceof ValueProviderValueRetrievalInterface;
    }

    @Override
    public void clearPromptValue(PromptDefinitionInterface promptDefinition) {
        if (promptDefinition == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullPromptDefinition.ex.txt"));
        }
        if (promptDefinition.isFixed()) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource(RB_KEY, "cannotClearFixedPromptValue.ex.fmt"), (Object)promptDefinition.getPromptName()));
        }
        PromptValuesInterface targetPromptValues = this.findPromptValuesForPromptDefinition(promptDefinition);
        if (targetPromptValues != this && targetPromptValues != null) {
            targetPromptValues.clearPromptValue(promptDefinition);
            return;
        }
        Object oldValue = null;
        if (this.isPromptValueAvailable(promptDefinition)) {
            try {
                oldValue = this.getPromptValue(promptDefinition);
            }
            catch (PromptValueNotFoundException promptValueNotFoundException) {
                // empty catch block
            }
        }
        Object newValue = null;
        boolean change = false;
        if (this.values != null && this.values.containsKey(promptDefinition)) {
            this.values.remove(promptDefinition);
            change = true;
        } else if (this.isPromptValueAvailable(promptDefinition)) {
            change = true;
        }
        if (change) {
            PromptDefinitionInterface targetDefinition;
            int i;
            int n;
            List combinations;
            if (this.userContext != null) {
                this.userContext.clearStickyValue(promptDefinition);
            }
            this.executeScriptForValueChanged(promptDefinition, oldValue);
            this.firePromptValueChanged(promptDefinition, oldValue, null, null);
            if (promptDefinition instanceof ModalGroupDefinition) {
                this.clearPromptValuesForModalGroupDefinition((ModalGroupDefinition)promptDefinition);
            }
            if ((combinations = this.getPromptDefinitionCombinations(promptDefinition)) != null && combinations.size() != 0) {
                n = combinations.size();
                for (i = 0; i < n; ++i) {
                    targetDefinition = (PromptDefinitionInterface)combinations.get(i);
                    if (!this.isPromptValueSet(targetDefinition)) continue;
                    this.clearPromptValue(targetDefinition);
                }
            }
            if ((combinations = this.getCombinationsForGroups(promptDefinition)) != null && combinations.size() != 0) {
                n = combinations.size();
                for (i = 0; i < n; ++i) {
                    targetDefinition = (PromptDefinitionInterface)combinations.get(i);
                    if (!this.isPromptValueSet(targetDefinition)) continue;
                    this.clearPromptValue(targetDefinition);
                }
            }
        }
    }

    @Override
    public Map getPromptValues(PromptGroupInterface promptGroup, boolean recursive, boolean includeDefaultAndStickyValues) {
        return null;
    }

    @Override
    public Map getPromptValues() {
        HashMap<PromptDefinitionInterface, Object> returnedValues = new HashMap<PromptDefinitionInterface, Object>();
        if (this.values != null) {
            returnedValues.putAll(this.values);
        }
        List<PromptDefinitionInterface> promptDefinitions = this.getPromptGroup().getPromptDefinitions(true);
        for (PromptDefinitionInterface promptDefinition : promptDefinitions) {
            if (returnedValues.containsKey(promptDefinition)) continue;
            if (this.userContext != null && promptDefinition.isStickyDefaultAllowed() && this.userContext.isStickyValueSet(promptDefinition)) {
                returnedValues.put(promptDefinition, this.userContext.getStickyValue(promptDefinition));
                continue;
            }
            if (promptDefinition.isDefaultValueSet()) {
                returnedValues.put(promptDefinition, promptDefinition.getDefaultValue());
                continue;
            }
            if (!(promptDefinition instanceof ValueProviderDefinitionInterface) || !(((ValueProviderDefinitionInterface)((Object)promptDefinition)).getValueProvider() instanceof ValueProviderValueRetrievalInterface)) continue;
            try {
                returnedValues.put(promptDefinition, ((ValueProviderValueRetrievalInterface)((ValueProviderDefinitionInterface)((Object)promptDefinition)).getValueProvider()).getValue());
            }
            catch (ValueProviderException valueProviderException) {}
        }
        Set entries = returnedValues.entrySet();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (entry.getValue() != UNSET) continue;
            iter.remove();
        }
        return returnedValues;
    }

    @Override
    public void setPromptValues(Map definitionToValueMap, Locale inputLocale) throws InvalidPromptValueException {
        for (PromptDefinitionInterface definition : definitionToValueMap.keySet()) {
            this.setPromptValue(definition, definitionToValueMap.get(definition), inputLocale);
        }
    }

    @Override
    public MutableUserInfoInterface getMutableUserInfo() {
        if (this.mutableUserInfo == null) {
            this.mutableUserInfo = new UserInfo();
        }
        return this.mutableUserInfo;
    }

    @Override
    public void addPromptValueChangeListener(PromptValueChangeListener listener) {
        List delegates = this.getPromptValuesDelegates();
        if (delegates != null) {
            for (PromptValuesInterface promptValues : delegates) {
                promptValues.addPromptValueChangeListener(listener);
            }
        }
        this.listenerList.add(PromptValueChangeListener.class, listener);
    }

    @Override
    public void removePromptValueChangeListener(PromptValueChangeListener listener) {
        List delegates = this.getPromptValuesDelegates();
        if (delegates != null) {
            for (PromptValuesInterface promptValues : delegates) {
                promptValues.removePromptValueChangeListener(listener);
            }
        }
        this.listenerList.remove(PromptValueChangeListener.class, listener);
    }

    private void firePromptValueChanged(PromptDefinitionInterface promptDefinition, Object oldValue, Object newValue, Locale locale) {
        Object[] listeners = this.listenerList.getListenerList();
        PromptValueChangeEvent event = new PromptValueChangeEvent(promptDefinition, oldValue, newValue);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PromptValueChangeListener.class) continue;
            ((PromptValueChangeListener)listeners[i + 1]).promptValueChanged(event);
        }
    }

    @Override
    public PromptValueChangeListener[] getPromptValueChangeListeners() {
        return (PromptValueChangeListener[])this.listenerList.getListeners(PromptValueChangeListener.class);
    }

    @Override
    public boolean isPromptValueValid(PromptDefinitionInterface promptDefinition) {
        PromptValuesInterface targetPromptValues = this.findPromptValuesForPromptDefinition(promptDefinition);
        if (targetPromptValues != this) {
            return targetPromptValues.isPromptValueValid(promptDefinition);
        }
        Object value = null;
        if (this.isPromptValueAvailable(promptDefinition)) {
            try {
                value = this.getPromptValue(promptDefinition);
                return promptDefinition.isPromptValueValid(value) && (!promptDefinition.isRequired() || value != null);
            }
            catch (PromptValueNotFoundException e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
            }
        } else {
            return !promptDefinition.isRequired();
        }
        return false;
    }

    @Override
    public boolean isAllPromptValuesValid() {
        List<PromptDefinitionInterface> promptDefinitions = this.promptGroup.getPromptDefinitions(true);
        for (PromptDefinitionInterface pdi : promptDefinitions) {
            if (this.isPromptValueValid(pdi)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAllRequiredPromptsValid() {
        List<PromptDefinitionInterface> promptDefinitions = this.promptGroup.getPromptDefinitions(true);
        for (PromptDefinitionInterface pdi : promptDefinitions) {
            if (!pdi.isRequired() || this.isPromptValueAvailable(pdi) && this.isPromptValueValid(pdi)) continue;
            return false;
        }
        return true;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(String promptName, boolean recursive) {
        List delegates;
        PromptDefinitionInterface pdi;
        if (recursive) {
            List visualOrderList = PromptUtil.getVisualOrderOfDefinitions(this, false);
            for (PromptDefinitionInterface prompt : visualOrderList) {
                if (!Util.equal((Object)prompt.getPromptName(), (Object)promptName)) continue;
                return prompt;
            }
        }
        if ((pdi = this.promptGroup.getPromptDefinition(promptName, recursive)) == null && (delegates = this.getPromptValuesDelegates()) != null) {
            Iterator iter = delegates.iterator();
            while (iter.hasNext() && pdi == null) {
                PromptValuesInterface delegatePV = (PromptValuesInterface)iter.next();
                if (delegatePV == null) continue;
                pdi = delegatePV.getPromptDefinition(promptName, recursive);
            }
        }
        return pdi;
    }

    @Override
    public void clearPromptValuesDelegates() {
        this.promptValuesDelegates = null;
    }

    @Override
    public void addPromptValuesDelegate(PromptValuesInterface promptValues) {
        if (this.promptValuesDelegates == null) {
            this.promptValuesDelegates = new ArrayList();
        }
        if (!this.promptValuesDelegates.contains(promptValues)) {
            this.promptValuesDelegates.add(promptValues);
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PromptValueChangeListener.class) continue;
            promptValues.addPromptValueChangeListener((PromptValueChangeListener)listeners[i + 1]);
        }
    }

    @Override
    public void removePromptValuesDelegate(PromptValuesInterface promptValues) {
        if (this.promptValuesDelegates == null) {
            return;
        }
        if (this.promptValuesDelegates.contains(promptValues)) {
            this.promptValuesDelegates.remove(promptValues);
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PromptValueChangeListener.class) continue;
            promptValues.removePromptValueChangeListener((PromptValueChangeListener)listeners[i + 1]);
        }
    }

    @Override
    public List getPromptValuesDelegates() {
        if (this.promptValuesDelegates == null) {
            return null;
        }
        return ListFactory.newList((Collection)this.promptValuesDelegates);
    }

    @Override
    public PromptValuesInterface findPromptValuesForPromptDefinition(PromptDefinitionInterface promptDefinition) {
        FindPromptValuesByPromptDefinitionVisitor visitor = new FindPromptValuesByPromptDefinitionVisitor(promptDefinition);
        this.acceptPromptValuesVisitor(visitor);
        return visitor.getPromptValues();
    }

    @Override
    public void acceptPromptValuesVisitor(PromptValuesVisitorInterface visitor) {
        List delegates;
        visitor.accept(this);
        if (visitor.shouldContinue() && (delegates = this.getPromptValuesDelegates()) != null) {
            Iterator iterator = delegates.iterator();
            while (iterator.hasNext() && visitor.shouldContinue()) {
                PromptValuesInterface promptValues = (PromptValuesInterface)iterator.next();
                promptValues.acceptPromptValuesVisitor(visitor);
            }
        }
    }

    @SASScope
    public PromptGroupInterface rollupPromptGroups(PromptGroupInterface startingGroup) {
        PromptGroupInterface rolledUpGroup = startingGroup.copy(null);
        PromptUtil.copyDefinitionsAndSubgroups(rolledUpGroup, startingGroup);
        List delegates = this.getPromptValuesDelegates();
        if (delegates != null) {
            for (PromptValuesInterface promptValues : delegates) {
                PromptUtil.copyDefinitionsAndSubgroups(rolledUpGroup, promptValues.getPromptGroup());
            }
        }
        return rolledUpGroup;
    }

    @Override
    @SASScope
    public void addPromptDefinitionCombination(PromptDefinitionInterface promptDefinitionToCombine1, PromptDefinitionInterface promptDefinitionToCombine2) {
        if (this.combinations == null) {
            this.combinations = new ArrayList(2);
        }
        this.combinations.add(new PromptDefinitionCombination(promptDefinitionToCombine1, promptDefinitionToCombine2));
    }

    @Override
    @SASScope
    public void removePromptDefinitionCombination(PromptDefinitionInterface promptDefinitionToCombine1, PromptDefinitionInterface promptDefinitionToCombine2) {
        if (this.combinations == null) {
            return;
        }
        this.combinations.remove((Object)new PromptDefinitionCombination(promptDefinitionToCombine1, promptDefinitionToCombine2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SASScope
    public List getPromptDefinitionCombinations(PromptDefinitionInterface promptDefinition) {
        if (this.combinations == null) {
            return null;
        }
        ArrayList<PromptDefinitionInterface> combinationMatches = null;
        List list = this.combinations;
        synchronized (list) {
            int n = this.combinations.size();
            for (int i = 0; i < n; ++i) {
                PromptDefinitionInterface otherDefinition;
                PromptDefinitionCombination possibleMatch = (PromptDefinitionCombination)((Object)this.combinations.get(i));
                if (!possibleMatch.isCombinedWith(promptDefinition)) continue;
                if (combinationMatches == null) {
                    combinationMatches = new ArrayList<PromptDefinitionInterface>();
                }
                if (combinationMatches.contains(otherDefinition = possibleMatch.getOtherDefinition(promptDefinition))) continue;
                combinationMatches.add(otherDefinition);
            }
        }
        return combinationMatches;
    }

    @Override
    @SASScope
    public List getAdditionalCascadeDependencies() {
        if (this.additionalCascadeDependencies != null) {
            return ListFactory.newList((Collection)this.additionalCascadeDependencies);
        }
        return Collections.EMPTY_LIST;
    }

    @SASScope
    public void setAdditionalCascadeDependencies(List additionalCascadeDependencies) {
        this.additionalCascadeDependencies = additionalCascadeDependencies != null ? ListFactory.newList((Collection)additionalCascadeDependencies) : Collections.EMPTY_LIST;
    }

    @Override
    @SASScope
    public boolean isValueAnnotated(PromptDefinitionInterface prompt) {
        try {
            Object value = this.getPossiblyAnnotatedPromptValue(prompt);
            if (value instanceof AnnotatedValueInterface) {
                return true;
            }
            if (value instanceof Collection) {
                Collection collectionValue = (Collection)value;
                for (Object partialValue : collectionValue) {
                    if (!(partialValue instanceof AnnotatedValueInterface)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (PromptValueNotFoundException e) {
            return false;
        }
    }

    @Override
    @SASScope
    public void clearValueAnnotations(PromptDefinitionInterface prompt) throws PromptValueNotFoundException {
        PromptValuesInterface targetPromptValues = this.findPromptValuesForPromptDefinition(prompt);
        if (targetPromptValues != this) {
            if (targetPromptValues == null) {
                throw new PromptValueNotFoundException(prompt);
            }
            targetPromptValues.clearValueAnnotations(prompt);
            return;
        }
        ArrayList value = this.getPossiblyAnnotatedPromptValue(prompt);
        if (value instanceof AnnotatedValueInterface) {
            value = ((AnnotatedValueInterface)value).getValue();
        }
        if (value instanceof Collection) {
            Collection collectionValue = value;
            ArrayList copyCollection = new ArrayList(collectionValue.size());
            for (Object partialValue : collectionValue) {
                if (partialValue instanceof AnnotatedValueInterface) {
                    partialValue = ((AnnotatedValueInterface)partialValue).getValue();
                }
                copyCollection.add(partialValue);
            }
            value = copyCollection;
        }
        this.values.put(prompt, value);
    }

    private boolean isValueAnnotated(Object value) {
        if (value instanceof AnnotatedValueInterface) {
            return true;
        }
        if (value instanceof Collection) {
            Collection pvCollection = (Collection)value;
            for (Object pvCollectionValue : pvCollection) {
                if (!(pvCollectionValue instanceof AnnotatedValueInterface)) continue;
                return true;
            }
        }
        return false;
    }

    private Object getUnannotatedValueCopy(Object value) {
        if (value instanceof AnnotatedValueInterface) {
            value = ((AnnotatedValueInterface)value).getValue();
        }
        if (value instanceof Collection) {
            Collection pvCollection = (Collection)value;
            ArrayList pvCopy = new ArrayList(pvCollection.size());
            for (Object pvCollectionValue : pvCollection) {
                if (pvCollectionValue instanceof AnnotatedValueInterface) {
                    pvCollectionValue = ((AnnotatedValueInterface)pvCollectionValue).getValue();
                }
                pvCopy.add(pvCollectionValue);
            }
            return pvCopy;
        }
        return value;
    }

    private void updateAnnotatedValues(Object annotatedValue, Object value, Locale locale) {
        if (annotatedValue instanceof MutableAnnotatedValueInterface) {
            ((MutableAnnotatedValueInterface)annotatedValue).setValue(value, locale);
        }
        if (annotatedValue instanceof Collection && value instanceof Collection) {
            Collection avCollection = (Collection)annotatedValue;
            Collection vCollection = (Collection)value;
            Iterator avCollectionIterator = avCollection.iterator();
            Iterator vCollectionIterator = vCollection.iterator();
            while (avCollectionIterator.hasNext() && vCollectionIterator.hasNext()) {
                Object avCollectionValue = avCollectionIterator.next();
                Object vCollectionValue = vCollectionIterator.next();
                if (!(avCollectionValue instanceof MutableAnnotatedValueInterface)) continue;
                ((MutableAnnotatedValueInterface)avCollectionValue).setValue(vCollectionValue, locale);
            }
        }
    }

    public String getDefinitionElementName() {
        return "PromptValues";
    }

    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        ArrayList userInfoList;
        super.consumeRelatedObjects(roHolder);
        ArrayList list = roHolder.consumeObjects("Group");
        if (!list.isEmpty() && list.get(0) instanceof PromptGroupInterface) {
            this.setPromptGroup((PromptGroupInterface)list.get(0), false);
            this.getLogger2().debug("Consumed a prompt group");
        }
        if (this.getPromptGroup() == null) {
            PromptGroup group = new PromptGroup();
            this.setPromptGroup(group, false);
        }
        if ((userInfoList = roHolder.consumeObjects("UserInfo")) != null && userInfoList.size() > 0) {
            Map userInfoMap = MapText.convertMapTextListToMap((List)userInfoList);
            MutableUserInfoInterface userInfo = this.getMutableUserInfo();
            for (String key : userInfoMap.keySet()) {
                String value = (String)userInfoMap.get(key);
                userInfo.put(key, value);
            }
        }
        this.combinations = roHolder.consumeObjects("Combinations");
        ArrayList valuesList = roHolder.consumeObjects("DefinitionReferencesAndValues");
        int n = valuesList.size();
        for (int i = 0; i < n; ++i) {
            PromptDefinitionReference promptDefRef = (PromptDefinitionReference)((Object)valuesList.get(i));
            PromptDefinitionInterface promptToSetValueOn = promptDefRef.getPromptDefinition();
            try {
                if (!this.getPromptGroup().hasPromptDefinition(promptDefRef.getPromptDefinition())) {
                    FindPromptValuesByPromptDefinitionIDVisitor byIDVisitor = new FindPromptValuesByPromptDefinitionIDVisitor(promptDefRef.getPromptDefinition().getPromptID());
                    this.acceptPromptValuesVisitor(byIDVisitor);
                    if (byIDVisitor.getPromptDefinition() != null) {
                        promptToSetValueOn = byIDVisitor.getPromptDefinition();
                    } else {
                        this.getPromptGroup().addPromptDefinition(promptToSetValueOn);
                    }
                }
                if (!promptDefRef.hasValueBeenSet()) continue;
                boolean isFixed = promptToSetValueOn.isFixed();
                if (isFixed && promptToSetValueOn instanceof MutablePromptDefinitionInterface) {
                    ((MutablePromptDefinitionInterface)promptToSetValueOn).setFixed(false);
                }
                this.setPromptValue(promptToSetValueOn, promptDefRef.getValue());
                if (!isFixed || !(promptToSetValueOn instanceof MutablePromptDefinitionInterface)) continue;
                ((MutablePromptDefinitionInterface)promptToSetValueOn).setFixed(true);
                continue;
            }
            catch (InvalidPromptValueException e) {
                e.printStackTrace();
            }
        }
        ArrayList delegatesList = roHolder.consumeObjects("PromptValuesDelegates");
        if (delegatesList != null) {
            int n2 = delegatesList.size();
            for (int i = 0; i < n2; ++i) {
                this.addPromptValuesDelegate((PromptValuesInterface)delegatesList.get(i));
            }
        }
    }

    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        String promptGroupPersistId = provider.consumeAttr("promptGroupRef");
        if (promptGroupPersistId != null) {
            PromptGroupInterface group = (PromptGroupInterface)provider.getReadingContext().getObject(promptGroupPersistId, PromptGroupInterface.class);
            this.setPromptGroup(group, false);
        }
    }

    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        List delegates;
        List combinationList;
        List userInfoList;
        super.writeDefinition(element, writingContext);
        List list = null;
        Map writingContextOptionsMap = writingContext.getOptionsMap();
        if (writingContextOptionsMap != null && writingContextOptionsMap.containsKey("writeExternal")) {
            list = new ArrayList<PromptGroupInterface>();
            list.add(this.getPromptGroup());
            this.getLogger2().debug("writeDefinition(), writing prompt group");
            PromptValues.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"Group");
            list.clear();
        }
        if (writingContext.hasBeenWritten((PersistenceInterface)this.getPromptGroup())) {
            String promptDefPersistId = writingContext.getPersistenceID((PersistenceInterface)this.getPromptGroup());
            XmlUtil.setAttr((Element)element, (String)"promptGroupRef", (String)promptDefPersistId);
        }
        if ((userInfoList = MapText.convertUserInfoToMapTextList((UserInfoInterface)this.mutableUserInfo)) != null) {
            PromptValues.writeRelatedObjects((List)userInfoList, (Node)element, (PromptsWritingContext)writingContext, (String)"UserInfo");
        }
        if ((combinationList = this.getWritableCombinations()) != null && combinationList.size() > 0) {
            PromptValues.writeRelatedObjects((List)combinationList, (Node)element, (PromptsWritingContext)writingContext, (String)"Combinations");
        }
        boolean writeRefsToAllDefinitions = false;
        if (writingContextOptionsMap != null && writingContextOptionsMap.containsKey(PROMPT_VALUES_XML_WRITE_ALL_DEFINITIONS)) {
            writeRefsToAllDefinitions = true;
        }
        this.getLogger2().debug("Writing prompt values to DOM.");
        if (writeRefsToAllDefinitions) {
            if (null == list) {
                list = new ArrayList();
            }
            this.getAllWritableValues(list);
        } else {
            list = this.getWritableValues();
        }
        if (null != list && !list.isEmpty()) {
            PromptValues.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"DefinitionReferencesAndValues");
        }
        if ((delegates = this.getPromptValuesDelegates()) != null && delegates.size() != 0) {
            PromptValues.writeRelatedObjects((List)delegates, (Node)element, (PromptsWritingContext)writingContext, (String)"PromptValuesDelegates");
        }
    }

    protected List getWritableValues() {
        ArrayList<PromptDefinitionReference> list = new ArrayList<PromptDefinitionReference>();
        if (null != this.values && !this.values.isEmpty()) {
            for (PromptDefinitionInterface key : this.values.keySet()) {
                Object value;
                UserInfoInterface userInfo = key.getUserInfo();
                if (userInfo != null && userInfo.contains("IDENTITYDRIVEN") || key instanceof ObjectDefinitionInterface || !this.values.containsKey(key) || (value = this.values.get(key)) == UNSET) continue;
                PromptDefinitionReference promptDefRef = new PromptDefinitionReference(key, value);
                list.add(promptDefRef);
            }
        }
        return list;
    }

    protected void getAllWritableValues(List allDefinitionReferences) {
        List<PromptDefinitionInterface> definitions = this.getPromptGroup().getPromptDefinitions(true);
        int n = definitions.size();
        for (int i = 0; i < n; ++i) {
            PromptDefinitionInterface key = definitions.get(i);
            UserInfoInterface userInfo = key.getUserInfo();
            if (userInfo != null && userInfo.contains("IDENTITYDRIVEN")) continue;
            Object value = "DO_NOT_PERSIST_VALUE";
            if (this.isPromptValueSet(key)) {
                try {
                    value = this.getPromptValue(key);
                }
                catch (PromptValueNotFoundException e) {
                    e.printStackTrace();
                }
            }
            PromptDefinitionReference promptDefRef = new PromptDefinitionReference(key, value);
            allDefinitionReferences.add(promptDefRef);
        }
    }

    protected List getWritableCombinations() {
        if (this.combinations != null) {
            return ListFactory.newList((Collection)this.combinations);
        }
        return Collections.EMPTY_LIST;
    }
}

