/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.CollectionType;
import com.sas.models.VersionInterface;
import com.sas.prompts.ConfigurePromptVisitor;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.FindPromptValuesByPromptDefinitionIDVisitor;
import com.sas.prompts.FindPromptValuesByPromptDefinitionNameVisitor;
import com.sas.prompts.FindPromptValuesByPromptIDVisitor;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.MutableIdentifiablePromptInterface;
import com.sas.prompts.PromptComponentModelInterface;
import com.sas.prompts.PromptGroupPanelModelInterface;
import com.sas.prompts.PromptPropertiesPanelModelInterface;
import com.sas.prompts.PromptSourceVisitorInterface;
import com.sas.prompts.PromptUtilFixAllPromptValuesVisitor;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValueValidatorInterface;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.PromptViewInterface;
import com.sas.prompts.RB;
import com.sas.prompts.SimplePromptValueValidator;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.DateDefinitionInterface;
import com.sas.prompts.definitions.ModalGroupDefinition;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionV2Interface;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.definitions.SelectableDefinitionV2Interface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionSupport;
import com.sas.prompts.definitions.ValueRetrieverDefinitionInterface;
import com.sas.prompts.groups.HorizontalGroup;
import com.sas.prompts.groups.ModalChoiceGroupInterface;
import com.sas.prompts.groups.ModalGroupInterface;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.PromptGroupV2Interface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.groups.TransparentGroupInterface;
import com.sas.prompts.groups.shared.SharedPromptGroupInterface;
import com.sas.prompts.util.MapText;
import com.sas.prompts.util.PromptContentHandler;
import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInitializationInterface;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.ValueType;
import com.sas.text.Message;
import com.sas.uiconfig.ApplicationContext;
import com.sas.util.DatePeriod;
import com.sas.util.ListFactory;
import com.sas.util.LocalizableString;
import com.sas.util.MutableUserInfoInterface;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.SupportedSpecialValuesInterface;
import com.sas.util.Util;
import com.sas.util.ValidateArg;
import com.sas.util.ValueItem;
import com.sas.util.anno.NotNull;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@SASScope
public class PromptUtil {
    public static final String RB_KEY = "PromptUtil.";

    private PromptUtil() {
    }

    public static String getVersion(PromptGroupInterface promptGroup, VersionInterface promptObject) {
        if (promptObject.getVersion() != null) {
            return promptObject.getVersion();
        }
        return null;
    }

    public static boolean isPromptValuesEqual(Object value1, Object value2) {
        return PromptUtil.isPromptValuesEqual(value1, value2, false);
    }

    public static boolean isPromptValuesEqual(Object value1, Object value2, boolean ignoreWhitespaceAtEndOfStrings) {
        if (ignoreWhitespaceAtEndOfStrings) {
            if (value1 instanceof String) {
                value1 = Strings.trimRight((String)((String)value1));
            }
            if (value2 instanceof String) {
                value2 = Strings.trimRight((String)((String)value2));
            }
        }
        if (Util.equal((Object)value1, (Object)value2)) {
            return true;
        }
        if (PromptUtil.testForCollection(value1) && PromptUtil.testCollectionForEqual((Collection)value1, value2, ignoreWhitespaceAtEndOfStrings)) {
            return true;
        }
        if (PromptUtil.testForCollection(value2) && PromptUtil.testCollectionForEqual((Collection)value2, value1, ignoreWhitespaceAtEndOfStrings)) {
            return true;
        }
        if (PromptUtil.testForArray(value1) && PromptUtil.testArrayForEqual((Object[])value1, value2, ignoreWhitespaceAtEndOfStrings)) {
            return true;
        }
        return PromptUtil.testForArray(value2) && PromptUtil.testArrayForEqual((Object[])value2, value1, ignoreWhitespaceAtEndOfStrings);
    }

    static boolean testForCollection(Object value1) {
        boolean retVal = false;
        if (null != value1 && value1 instanceof Collection) {
            retVal = true;
        }
        return retVal;
    }

    private static boolean testCollectionForEqual(Collection value, Object value2, boolean ignoreWhitespaceAtEndOfStrings) {
        boolean retVal = false;
        if (value == null && value2 == null) {
            return true;
        }
        if (value.size() == 1) {
            Object input = value.iterator().next();
            retVal = PromptUtil.isPromptValuesEqual(input, value2, ignoreWhitespaceAtEndOfStrings);
        } else if (value.isEmpty() && null == value2) {
            retVal = true;
        } else if (PromptUtil.testForCollection(value2) && value.size() == ((Collection)value2).size()) {
            Iterator iter = value.iterator();
            Iterator iter2 = ((Collection)value2).iterator();
            while (iter.hasNext()) {
                if (!PromptUtil.isPromptValuesEqual(iter.next(), iter2.next(), ignoreWhitespaceAtEndOfStrings)) {
                    retVal = false;
                    break;
                }
                retVal = true;
            }
        }
        return retVal;
    }

    private static boolean testForArray(Object value1) {
        boolean retVal = false;
        if (null != value1 && value1.getClass().isArray() && value1 instanceof Object[]) {
            retVal = true;
        }
        return retVal;
    }

    private static boolean testArrayForEqual(Object[] value, Object value2, boolean ignoreWhitespaceAtEndOfStrings) {
        boolean retVal = false;
        if (value == null && value2 == null) {
            return true;
        }
        if (value.length == 1) {
            retVal = PromptUtil.isPromptValuesEqual(value[0], value2, ignoreWhitespaceAtEndOfStrings);
        } else if (value.length == 0 && null == value2) {
            retVal = true;
        } else if (PromptUtil.testForArray(value2) && value.length == ((Object[])value2).length) {
            for (int i = 0; i < value.length; ++i) {
                if (!PromptUtil.isPromptValuesEqual(value[i], ((Object[])value2)[i], ignoreWhitespaceAtEndOfStrings)) {
                    retVal = false;
                    break;
                }
                retVal = true;
            }
        }
        return retVal;
    }

    public static boolean isValueSupported(SupportedSpecialValuesInterface supportedSpecialValues, Object value) {
        if (value instanceof MissingValues) {
            if (supportedSpecialValues instanceof ValueProviderDefinitionInterface && ((ValueProviderDefinitionInterface)supportedSpecialValues).getValueProvider() != null) {
                return true;
            }
            if (supportedSpecialValues instanceof ValueRetrieverDefinitionInterface && ((ValueRetrieverDefinitionInterface)supportedSpecialValues).getValueRetrieverConfiguration() != null) {
                return true;
            }
        }
        return PromptUtil.isValueSupported(supportedSpecialValues.getSupportedSpecialValues(), value);
    }

    public static boolean isValueSupported(SupportedSpecialValues supportedValues, Object value) {
        if (value instanceof MissingValues) {
            return supportedValues == null ? false : supportedValues.isMissingValuesSupported();
        }
        if (value == SpecialValues.ALL) {
            return supportedValues == null ? false : supportedValues.isAllSupported();
        }
        if (value == SpecialValues.OTHER) {
            return supportedValues == null ? false : supportedValues.isOtherSupported();
        }
        return false;
    }

    public static boolean isValueAllowedIfSpecial(SupportedSpecialValues supportedValues, Object value) {
        if (value instanceof MissingValues) {
            return supportedValues == null ? false : supportedValues.isMissingValuesSupported();
        }
        if (value == SpecialValues.ALL) {
            return supportedValues == null ? false : supportedValues.isAllSupported();
        }
        if (value == SpecialValues.OTHER) {
            return supportedValues == null ? false : supportedValues.isOtherSupported();
        }
        return true;
    }

    public static String getPromptGroupLabel(PromptGroupInterface parentGroup, PromptGroupInterface promptGroup, Locale locale) {
        String label = null;
        List path = PromptUtil.getPathToPromptGroup(parentGroup, promptGroup);
        if (path.isEmpty()) {
            throw new IllegalArgumentException("The prompt group label cannot be retrieved as the prompt group is not a subgroup of the parent group.");
        }
        PromptGroupInterface group2 = null;
        for (PromptGroupInterface group2 : path) {
            if (label == null) {
                label = PromptUtil.replaceNull(group2.getPromptGroupLabel(locale));
                continue;
            }
            label = label + " > " + PromptUtil.replaceNull(group2.getPromptGroupLabel(locale));
        }
        return PromptUtil.replaceNull(label);
    }

    public static String getPromptGroupLabel(PromptGroupPanelModelInterface parentGroup, PromptGroupPanelModelInterface promptGroup) {
        String label = null;
        List path = PromptUtil.getPathToPromptGroup(parentGroup, promptGroup);
        for (PromptGroupPanelModelInterface group : path) {
            if (label == null) {
                label = PromptUtil.replaceNull(group.getLabel());
                continue;
            }
            label = label + " > " + PromptUtil.replaceNull(group.getLabel());
        }
        return PromptUtil.replaceNull(label);
    }

    private static String replaceNull(String text) {
        if (text == null) {
            return "";
        }
        return text;
    }

    public static List getPathToPromptDefinition(PromptGroupInterface parentGroup, PromptDefinitionInterface promptDefinition) {
        ArrayList path = new ArrayList();
        PromptUtil.getPathToPromptDefinition(parentGroup, promptDefinition, path);
        return path;
    }

    private static void getPathToPromptDefinition(PromptGroupInterface parentGroup, PromptDefinitionInterface promptDefinition, List path) {
        path.add(parentGroup);
        List<PromptGroupInterface> groups = parentGroup.getPromptSubgroups(false);
        List<PromptDefinitionInterface> definitions = parentGroup.getPromptDefinitions(false);
        if (definitions.contains(promptDefinition)) {
            return;
        }
        for (PromptGroupInterface childGroup : groups) {
            definitions = childGroup.getPromptDefinitions(true);
            if (!definitions.contains(promptDefinition)) continue;
            PromptUtil.getPathToPromptDefinition(childGroup, promptDefinition, path);
            return;
        }
        if (null != promptDefinition) {
            String errMsg = Message.format((String)RB.getStringResource("DefinitionNotInGroup.log"), (Object)promptDefinition.getPromptName(), (Object)parentGroup.getPromptGroupLabel(Locale.getDefault()));
            throw new IllegalArgumentException(errMsg);
        }
    }

    public static List getPathToPromptGroup(PromptGroupInterface parentGroup, PromptGroupInterface promptGroup) {
        ArrayList path = new ArrayList();
        PromptUtil.getPathToPromptGroup(parentGroup, promptGroup, path);
        return path;
    }

    private static void getPathToPromptGroup(PromptGroupInterface parentGroup, PromptGroupInterface promptGroup, List path) {
        if (Util.equal((Object)parentGroup, (Object)promptGroup)) {
            path.add(promptGroup);
        } else {
            path.add(parentGroup);
            List<PromptGroupInterface> groups = parentGroup.getPromptSubgroups(false);
            for (PromptGroupInterface childGroup : groups) {
                if (Util.equal((Object)childGroup, (Object)promptGroup)) {
                    path.add(promptGroup);
                    return;
                }
                if (!PromptUtil.hasPromptSubgroup(childGroup, promptGroup, true)) continue;
                PromptUtil.getPathToPromptGroup(childGroup, promptGroup, path);
                return;
            }
            if (path.isEmpty()) {
                LoggerFactoryInterface logFactory = null;
                LoggerRepository2.getLogger((String)PromptUtil.class.getName(), logFactory).warn("The \"parentGroup\" does not contain this \"promptGroup\".");
            }
        }
    }

    public static List getPathToPromptGroup(PromptGroupPanelModelInterface parentGroup, PromptGroupPanelModelInterface promptGroup) {
        ArrayList path = new ArrayList();
        PromptUtil.getPathToPromptGroup(parentGroup, promptGroup, path);
        return path;
    }

    private static void getPathToPromptGroup(PromptGroupPanelModelInterface parentGroup, PromptGroupPanelModelInterface promptGroup, List path) {
        if (!Util.equal((Object)parentGroup, (Object)promptGroup)) {
            path.add(parentGroup);
            List groups = parentGroup.getObjects(3);
            for (PromptGroupPanelModelInterface childGroup : groups) {
                if (Util.equal((Object)childGroup, (Object)promptGroup)) {
                    path.add(promptGroup);
                    return;
                }
                if (!PromptUtil.hasPromptSubgroup(childGroup, promptGroup, true)) continue;
                PromptUtil.getPathToPromptGroup(childGroup, promptGroup, path);
                return;
            }
            throw new IllegalArgumentException("The prompt group label cannot be retreived as the prompt group is not a subgroup of the parent group.");
        }
        path.add(promptGroup);
    }

    public static boolean hasPromptSubgroup(PromptGroupInterface parentGroup, PromptGroupInterface promptGroup, boolean recursive) {
        if (null != promptGroup) {
            List<PromptGroupInterface> subgroups = parentGroup.getPromptSubgroups(recursive);
            for (PromptGroupInterface g : subgroups) {
                if (!Util.equal((Object)g, (Object)promptGroup)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPromptSubgroup(PromptGroupPanelModelInterface parentGroup, PromptGroupPanelModelInterface promptGroup, boolean recursive) {
        if (null != promptGroup) {
            List subgroups = parentGroup.getObjects(3);
            for (PromptGroupPanelModelInterface g : subgroups) {
                if (Util.equal((Object)g, (Object)promptGroup)) {
                    return true;
                }
                if (!recursive || !PromptUtil.hasPromptSubgroup(g, promptGroup, recursive)) continue;
                return true;
            }
        }
        return false;
    }

    public static Map convertMapToNameValueMap(Map definitionValueMap) {
        HashMap nameValueMap = new HashMap();
        Set entries = definitionValueMap.entrySet();
        for (Map.Entry entry : entries) {
            nameValueMap.put(((PromptDefinitionInterface)entry.getKey()).getPromptName(), entry.getValue());
        }
        return nameValueMap;
    }

    public static void pruneEmptyGroups(PromptGroupInterface promptGroup) {
        List<PromptGroupInterface> promptSubgroups = promptGroup.getPromptSubgroups(false);
        int n = promptSubgroups.size();
        for (int i = 0; i < n; ++i) {
            PromptGroupInterface item = promptSubgroups.get(i);
            if (!(item instanceof PromptGroupInterface) || item instanceof ModalChoiceGroupInterface) continue;
            PromptUtil.pruneEmptyGroups(item);
            if (PromptUtil.hasPromptsInGroup(item)) continue;
            promptGroup.removePromptSubgroup(item);
        }
    }

    public static boolean pruneDuplicateDefintionsByName(PromptGroupInterface promptGroup) {
        return PromptUtil.pruneDuplicateDefintionsByName(promptGroup, LoggerRepository2.getLogger((String)PromptUtil.class.getName(), null));
    }

    public static boolean pruneDuplicateDefintionsByName(PromptGroupInterface promptGroup, LoggerFactoryInterface logFactory) {
        if (logFactory != null) {
            return PromptUtil.pruneDuplicateDefintionsByName(promptGroup, logFactory.makeNewLoggerInstance(PromptUtil.class.getName()));
        }
        return PromptUtil.pruneDuplicateDefintionsByName(promptGroup, LoggerRepository2.getLogger((String)PromptUtil.class.getName(), null));
    }

    public static boolean pruneDuplicateDefintionsByName(PromptGroupInterface promptGroup, CommonLoggerInterface logger) {
        ArrayList nameList = new ArrayList();
        return PromptUtil.pruneDuplicateDefintionsByName(promptGroup, promptGroup, nameList, logger);
    }

    public static Map getDuplicateDefintionsByName(PromptGroupInterface promptGroup) {
        return PromptUtil.getDuplicateDefintionsByName(promptGroup, false);
    }

    public static Map getDuplicateDefintionsByName(PromptGroupInterface promptGroup, boolean ignoreCaseOfName) {
        HashMap nameMap = new HashMap();
        HashMap duplicates = new HashMap();
        return PromptUtil.getDuplicateDefintionsByName(promptGroup, promptGroup, nameMap, duplicates, ignoreCaseOfName);
    }

    public static Map getDuplicateMacrosByName(PromptValuesInterface promptValues, Locale locale) {
        return PromptUtil.getDuplicateMacrosByName(promptValues, locale, false);
    }

    public static Map getDuplicateMacrosByName(PromptValuesInterface promptValues, Locale locale, boolean ignoreCaseOfName) {
        if (promptValues != null) {
            return PromptUtil.getDuplicateMacrosByName(promptValues, promptValues.getPromptGroup(), locale, ignoreCaseOfName);
        }
        return Collections.EMPTY_MAP;
    }

    private static boolean pruneDuplicateDefintionsByName(PromptGroupInterface topGroup, PromptGroupInterface promptGroup, List nameList, CommonLoggerInterface logger) {
        boolean retVal;
        block13: {
            block11: {
                String name;
                ModalGroupInterface modalGroup;
                block12: {
                    retVal = false;
                    if (!(promptGroup instanceof ModalGroupInterface)) break block11;
                    modalGroup = (ModalGroupInterface)promptGroup;
                    name = modalGroup.getChoiceDefinition().getPromptName();
                    if (nameList.contains(name)) break block12;
                    nameList.add(name);
                    List<PromptGroupInterface> subgroups = modalGroup.getPromptSubgroups(false);
                    List namesToAdd = new ArrayList();
                    for (PromptGroupInterface subgroup : subgroups) {
                        ArrayList newNameList = new ArrayList();
                        newNameList.addAll(nameList);
                        retVal |= PromptUtil.pruneDuplicateDefintionsByName(topGroup, subgroup, newNameList, logger);
                        namesToAdd = (List)Util.orCollections(namesToAdd, newNameList);
                    }
                    nameList = (List)Util.orCollections((Collection)nameList, namesToAdd);
                    break block13;
                }
                List path = PromptUtil.getPathToPromptGroup(topGroup, promptGroup);
                if (path == null || path.size() <= 1) break block13;
                PromptGroupInterface pg = (PromptGroupInterface)path.get(path.size() - 2);
                pg.removePromptSubgroup(modalGroup);
                retVal = true;
                if (logger == null) break block13;
                StringBuffer pathToDef = new StringBuffer();
                for (PromptGroupInterface pg2 : path) {
                    if (pathToDef.length() != 0) {
                        pathToDef.append(".");
                    }
                    pathToDef.append("[").append(pg2.getPromptGroupLabels().getText(null)).append("]");
                }
                logger.info("Modal Group named \"" + name + "\" has been removed from its parent group, the path to the modal group is : " + pathToDef.toString());
                break block13;
            }
            List<?> promptsAndSubgroups = promptGroup.getPromptDefinitionsAndSubgroups();
            ArrayList groupList = new ArrayList();
            int size = promptsAndSubgroups.size();
            for (int i = 0; i < size; ++i) {
                Object item = promptsAndSubgroups.get(i);
                if (item instanceof PromptDefinitionInterface) {
                    String name = ((PromptDefinitionInterface)item).getPromptName();
                    if (!nameList.contains(name)) {
                        nameList.add(name);
                        continue;
                    }
                    promptGroup.removePromptDefinition((PromptDefinitionInterface)item);
                    retVal = true;
                    if (logger == null) continue;
                    List path = PromptUtil.getPathToPromptGroup(topGroup, promptGroup);
                    StringBuffer pathToDef = new StringBuffer();
                    if (path != null) {
                        for (PromptGroupInterface pg : path) {
                            if (pathToDef.length() != 0) {
                                pathToDef.append(".");
                            }
                            pathToDef.append("[").append(pg.getPromptGroupLabels().getText(null)).append("]");
                        }
                    }
                    logger.info("Definition named \"" + name + "\" has been removed from its parent group, the path to the prompt is : " + pathToDef.toString());
                    continue;
                }
                if (item instanceof TransparentGroupInterface) {
                    retVal |= PromptUtil.pruneDuplicateDefintionsByName(topGroup, (TransparentGroupInterface)item, nameList, logger);
                    continue;
                }
                if (!(item instanceof PromptGroupInterface)) continue;
                groupList.add(item);
            }
            for (Object item : groupList) {
                retVal |= PromptUtil.pruneDuplicateDefintionsByName(topGroup, (PromptGroupInterface)item, nameList, logger);
            }
        }
        return retVal;
    }

    private static Map getDuplicateDefintionsByName(PromptGroupInterface topGroup, PromptGroupInterface promptGroup, Map nameMap, Map duplicates, boolean ignoreCaseOfName) {
        if (promptGroup instanceof ModalGroupInterface) {
            ModalGroupInterface modalGroup = (ModalGroupInterface)promptGroup;
            String name = modalGroup.getChoiceDefinition().getPromptName();
            if (name != null && ignoreCaseOfName) {
                name = name.toLowerCase();
            }
            if (!nameMap.containsKey(name)) {
                nameMap.put(name, modalGroup.getChoiceDefinition());
            } else if (duplicates.containsKey(name)) {
                ((Collection)duplicates.get(name)).add(modalGroup.getChoiceDefinition());
            } else {
                ArrayList<Object> defs = new ArrayList<Object>();
                defs.add(nameMap.get(name));
                defs.add(modalGroup.getChoiceDefinition());
                duplicates.put(name, defs);
            }
            List<PromptGroupInterface> subgroups = modalGroup.getPromptSubgroups(false);
            HashMap namesToAdd = new HashMap();
            for (PromptGroupInterface subgroup : subgroups) {
                HashMap newNameMap = new HashMap();
                newNameMap.putAll(nameMap);
                duplicates = PromptUtil.getDuplicateDefintionsByName(topGroup, subgroup, newNameMap, duplicates, ignoreCaseOfName);
                namesToAdd.putAll(newNameMap);
            }
            nameMap.putAll(namesToAdd);
        } else {
            List<?> promptsAndSubgroups = promptGroup.getPromptDefinitionsAndSubgroups();
            ArrayList groupList = new ArrayList();
            int size = promptsAndSubgroups.size();
            for (int i = 0; i < size; ++i) {
                Object item = promptsAndSubgroups.get(i);
                if (item instanceof PromptDefinitionInterface) {
                    String name = ((PromptDefinitionInterface)item).getPromptName();
                    if (name != null && ignoreCaseOfName) {
                        name = name.toLowerCase();
                    }
                    if (!nameMap.containsKey(name)) {
                        nameMap.put(name, item);
                        continue;
                    }
                    if (duplicates.containsKey(name)) {
                        ((Collection)duplicates.get(name)).add(item);
                        continue;
                    }
                    ArrayList<Object> defs = new ArrayList<Object>();
                    defs.add(nameMap.get(name));
                    defs.add(item);
                    duplicates.put(name, defs);
                    continue;
                }
                if (item instanceof TransparentGroupInterface) {
                    duplicates = PromptUtil.getDuplicateDefintionsByName(topGroup, (TransparentGroupInterface)item, nameMap, duplicates, ignoreCaseOfName);
                    continue;
                }
                if (!(item instanceof PromptGroupInterface)) continue;
                groupList.add(item);
            }
            for (Object item : groupList) {
                duplicates = PromptUtil.getDuplicateDefintionsByName(topGroup, (PromptGroupInterface)item, nameMap, duplicates, ignoreCaseOfName);
            }
        }
        return duplicates;
    }

    private static Map getDuplicateMacrosByName(PromptValuesInterface promptValues, PromptGroupInterface promptGroup, Locale locale, boolean ignoreCaseOfName) {
        HashMap<String, PromptDefinitionInterface> nameMap = new HashMap<String, PromptDefinitionInterface>();
        LinkedHashMap duplicates = new LinkedHashMap();
        List promptsWithValues = PromptUtil.getVisualOrderOfDefinitions(promptValues, true);
        for (Object item : promptsWithValues) {
            PromptDefinitionInterface promptDefinition;
            if (!(item instanceof PromptDefinitionInterface) || (promptDefinition = (PromptDefinitionInterface)item).getPromptName() == null || !promptValues.isPromptValueAvailable(promptDefinition)) continue;
            try {
                Object promptValue = promptValues.getPromptValue(promptDefinition);
                Map macroVariableValues = promptDefinition.getPromptDataType().getMacroVariableValues((MacroVariableOptionInterface)promptDefinition, promptValue, locale);
                Set entries = macroVariableValues.entrySet();
                for (Map.Entry entry : entries) {
                    String entryKeyLower = (String)entry.getKey();
                    if (entryKeyLower != null && ignoreCaseOfName) {
                        entryKeyLower = entryKeyLower.toLowerCase();
                    }
                    if (!nameMap.containsKey(entryKeyLower)) {
                        nameMap.put(entryKeyLower, promptDefinition);
                        continue;
                    }
                    if (duplicates.containsKey(entryKeyLower)) {
                        ((Collection)duplicates.get(entryKeyLower)).add(item);
                        continue;
                    }
                    ArrayList<Object> defs = new ArrayList<Object>();
                    defs.add(nameMap.get(entryKeyLower));
                    defs.add(item);
                    duplicates.put(entryKeyLower, defs);
                }
            }
            catch (PromptValueNotFoundException promptValueNotFoundException) {
            }
        }
        return duplicates;
    }

    public static List getPromptsVisibleFromGroup(PromptGroupInterface rootGroup, PromptGroupInterface group) {
        ArrayList<PromptDefinitionInterface> prompts = Collections.EMPTY_LIST;
        if (rootGroup != null && group != null) {
            prompts = new ArrayList<PromptDefinitionInterface>();
            List pathToGroup = PromptUtil.getPathToPromptGroup(rootGroup, group);
            for (PromptGroupInterface g : pathToGroup) {
                prompts.addAll(g.getPromptDefinitions(false));
                if (g != group && g instanceof ModalGroupInterface) continue;
                List<PromptGroupInterface> subgroups = g.getPromptSubgroups(false);
                for (PromptGroupInterface subgroup : subgroups) {
                    if (pathToGroup.contains(subgroup)) continue;
                    prompts.addAll(subgroup.getPromptDefinitions(true));
                }
            }
        }
        return prompts;
    }

    public static List getRequiredPromptsWithoutValues(PromptValuesInterface promptValues) {
        ArrayList<PromptDefinitionInterface> defsToReturn = new ArrayList<PromptDefinitionInterface>();
        if (promptValues != null) {
            List promptDefinitions = PromptUtil.getVisualOrderOfDefinitions(promptValues, false);
            for (PromptDefinitionInterface pdi : promptDefinitions) {
                if (!pdi.isRequired() || promptValues.isPromptValueAvailable(pdi)) continue;
                defsToReturn.add(pdi);
            }
        }
        return defsToReturn;
    }

    public static List getRequiredPromptsWithoutValues(PromptPropertiesPanelModelInterface model) {
        ArrayList<PromptComponentModelInterface> defsToReturn = new ArrayList<PromptComponentModelInterface>();
        if (model != null) {
            List promptDefinitions = PromptUtil.getVisualOrderOfDefinitions(model, false);
            for (PromptComponentModelInterface pcmi : promptDefinitions) {
                if (!pcmi.getPromptDefinition().isRequired() || pcmi.isPromptValueAvailable()) continue;
                defsToReturn.add(pcmi);
            }
        }
        return defsToReturn;
    }

    public static List getPromptsWithoutValues(PromptValuesInterface promptValues) {
        ArrayList<PromptDefinitionInterface> defsToReturn = new ArrayList<PromptDefinitionInterface>();
        if (promptValues != null) {
            List promptDefinitions = PromptUtil.getVisualOrderOfDefinitions(promptValues, false);
            for (PromptDefinitionInterface pdi : promptDefinitions) {
                if (!pdi.isRequired() || promptValues.isPromptValueAvailable(pdi)) continue;
                defsToReturn.add(pdi);
            }
        }
        return defsToReturn;
    }

    public static Map getCurrentPromptValues(PromptValuesInterface promptValues, boolean includeOnlyPromptsWithValuesAvailable) {
        PromptGroupInterface promptGroup = promptValues.getPromptGroup();
        List defs = PromptUtil.getVisualOrderOfDefinitions(promptValues, promptGroup, includeOnlyPromptsWithValuesAvailable);
        HashMap<PromptDefinitionInterface, Object> values = new HashMap<PromptDefinitionInterface, Object>();
        for (PromptDefinitionInterface prompt : defs) {
            if (!promptValues.isPromptValueAvailable(prompt)) continue;
            try {
                values.put(prompt, promptValues.getPromptValue(prompt));
            }
            catch (PromptValueNotFoundException promptValueNotFoundException) {}
        }
        return values;
    }

    public static List getVisualOrderOfDefinitions(PromptValuesInterface promptValues, boolean includeOnlyPromptsWithValuesAvailable) {
        PromptGroupInterface promptGroup = promptValues.getPromptGroup();
        return PromptUtil.getVisualOrderOfDefinitions(promptValues, promptGroup, includeOnlyPromptsWithValuesAvailable);
    }

    public static List getVisualOrderOfDefinitions(PromptValuesInterface promptValues, PromptGroupInterface promptGroup, boolean includeOnlyPromptsWithValuesAvailable) {
        ArrayList<Object> returnList = new ArrayList<Object>();
        List<?> promptsAndSubgroups = promptGroup.getPromptDefinitionsAndSubgroups();
        ArrayList groupList = new ArrayList();
        int size = promptsAndSubgroups.size();
        for (int i = 0; i < size; ++i) {
            Object item = promptsAndSubgroups.get(i);
            if (item instanceof PromptDefinitionInterface) {
                if (!includeOnlyPromptsWithValuesAvailable) {
                    returnList.add(item);
                    continue;
                }
                if (!promptValues.isPromptValueAvailable((PromptDefinitionInterface)item)) continue;
                returnList.add(item);
                continue;
            }
            if (item instanceof ModalGroupInterface) {
                ModalGroupInterface modalGroup = (ModalGroupInterface)item;
                PromptDefinitionInterface def = modalGroup.getChoiceDefinition();
                if (promptValues.isPromptValueAvailable(def)) {
                    returnList.add(def);
                    try {
                        ModalChoiceGroupInterface choiceGroup = modalGroup.getModalChoiceGroupForValue(promptValues.getPromptValue(def));
                        if (choiceGroup == null) continue;
                        returnList.addAll(PromptUtil.getVisualOrderOfDefinitions(promptValues, choiceGroup, includeOnlyPromptsWithValuesAvailable));
                    }
                    catch (PromptValueNotFoundException promptValueNotFoundException) {}
                    continue;
                }
                if (includeOnlyPromptsWithValuesAvailable) continue;
                returnList.add(def);
                continue;
            }
            if (item instanceof TransparentGroupInterface) {
                returnList.addAll(PromptUtil.getVisualOrderOfDefinitions(promptValues, (TransparentGroupInterface)item, includeOnlyPromptsWithValuesAvailable));
                continue;
            }
            if (!(item instanceof PromptGroupInterface)) continue;
            groupList.add(item);
        }
        for (Object item : groupList) {
            returnList.addAll(PromptUtil.getVisualOrderOfDefinitions(promptValues, (PromptGroupInterface)item, includeOnlyPromptsWithValuesAvailable));
        }
        return returnList;
    }

    public static List getVisualOrderOfDefinitions(PromptPropertiesPanelModelInterface model, boolean includeOnlyPromptsWithValuesAvailable) {
        PromptGroupPanelModelInterface promptGroup = model.getRootGroupModel();
        return PromptUtil.getVisualOrderOfDefinitions(model, promptGroup, includeOnlyPromptsWithValuesAvailable);
    }

    public static List getVisualOrderOfDefinitions(PromptPropertiesPanelModelInterface model, PromptGroupPanelModelInterface promptGroup, boolean includeOnlyPromptsWithValuesAvailable) {
        ArrayList returnList = new ArrayList();
        if (promptGroup != null) {
            List promptsAndSubgroups = promptGroup.getObjects(1);
            ArrayList groupList = new ArrayList();
            for (Object item : promptsAndSubgroups) {
                if (item instanceof PromptComponentModelInterface) {
                    if (!includeOnlyPromptsWithValuesAvailable) {
                        returnList.add(item);
                        continue;
                    }
                    if (!((PromptComponentModelInterface)item).isPromptValueAvailable()) continue;
                    returnList.add(item);
                    continue;
                }
                if (!(item instanceof PromptGroupPanelModelInterface)) continue;
                PromptGroupPanelModelInterface pgm = (PromptGroupPanelModelInterface)item;
                if (pgm.getGroupType().isModal()) {
                    List comps = pgm.getObjects(2);
                    if (comps == null || comps.size() <= 0) continue;
                    PromptComponentModelInterface modalComp = (PromptComponentModelInterface)comps.get(0);
                    if (modalComp.isPromptValueAvailable()) {
                        returnList.add(modalComp);
                        PromptGroupPanelModelInterface choiceGroup = pgm.getSelectedModalChoiceGroup(modalComp);
                        if (choiceGroup == null) continue;
                        returnList.addAll(PromptUtil.getVisualOrderOfDefinitions(model, choiceGroup, includeOnlyPromptsWithValuesAvailable));
                        continue;
                    }
                    if (includeOnlyPromptsWithValuesAvailable) continue;
                    returnList.add(modalComp);
                    continue;
                }
                if (pgm.getGroupType().isTransparent()) {
                    returnList.addAll(PromptUtil.getVisualOrderOfDefinitions(model, (PromptGroupPanelModelInterface)item, includeOnlyPromptsWithValuesAvailable));
                    continue;
                }
                groupList.add(item);
            }
            for (Object item : groupList) {
                returnList.addAll(PromptUtil.getVisualOrderOfDefinitions(model, (PromptGroupPanelModelInterface)item, includeOnlyPromptsWithValuesAvailable));
            }
        }
        return returnList;
    }

    public static boolean hasPromptsInGroup(PromptGroupInterface promptGroup) {
        List<PromptDefinitionInterface> promptDefinitions = promptGroup.getPromptDefinitions(false);
        if (promptDefinitions.size() > 0) {
            return true;
        }
        List<?> promptDefinitionsAndSubgroups = promptGroup.getPromptDefinitionsAndSubgroups();
        int n = promptDefinitionsAndSubgroups.size();
        for (int i = 0; i < n; ++i) {
            List<?> subPromptDefinitionsAndSubgroups;
            Object item = promptDefinitionsAndSubgroups.get(i);
            if (!(item instanceof PromptGroupInterface) || (subPromptDefinitionsAndSubgroups = ((PromptGroupInterface)item).getPromptDefinitionsAndSubgroups()).size() == 0 || !PromptUtil.hasPromptsInGroup((PromptGroupInterface)item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPromptGroupTransparent(PromptGroupInterface promptGroup) {
        return promptGroup instanceof TransparentGroup || promptGroup instanceof PromptGroupV2Interface && ((PromptGroupV2Interface)promptGroup).isTransparent();
    }

    public static PromptGroupInterface rollupPromptGroups(PromptValuesInterface promptValues, PromptGroupInterface startingGroup) {
        return PromptUtil.rollupPromptGroups(promptValues, startingGroup, true);
    }

    public static PromptGroupInterface rollupPromptGroups(PromptValuesInterface promptValues, PromptGroupInterface startingGroup, boolean removeHiddenObjects) {
        PromptGroupInterface rolledUpGroup = startingGroup.copy(null);
        if (!(rolledUpGroup instanceof SharedPromptGroupInterface)) {
            PromptUtil.copyDefinitionsAndSubgroups(rolledUpGroup, startingGroup, removeHiddenObjects);
            List delegates = promptValues.getPromptValuesDelegates();
            if (delegates != null) {
                for (PromptValuesInterface subPromptValues : delegates) {
                    if (PromptUtil.isPromptGroupTransparent(rolledUpGroup) && !PromptUtil.isPromptGroupTransparent(subPromptValues.getPromptGroup())) {
                        PromptGroup newRoot = new PromptGroup();
                        newRoot.setPromptGroupLabels(rolledUpGroup.getPromptGroupLabels());
                        newRoot.addPromptSubgroup(rolledUpGroup);
                        rolledUpGroup = newRoot;
                    }
                    PromptUtil.copyDefinitionsAndSubgroups(rolledUpGroup, subPromptValues.getPromptGroup(), removeHiddenObjects);
                }
            }
        }
        return rolledUpGroup;
    }

    public static PromptGroupInterface rollupAndPrunePromptGroups(PromptValuesInterface promptValues, PromptGroupInterface startingGroup) {
        return PromptUtil.rollupAndPrunePromptGroups(promptValues, startingGroup, true);
    }

    public static PromptGroupInterface rollupAndPrunePromptGroups(PromptValuesInterface promptValues, PromptGroupInterface startingGroup, boolean removeHiddenObjects) {
        PromptGroupInterface rolledUpGroups = PromptUtil.rollupPromptGroups(promptValues, startingGroup, removeHiddenObjects);
        PromptUtil.pruneEmptyGroups(rolledUpGroups);
        return rolledUpGroups;
    }

    public static void copyDefinitionsAndSubgroups(PromptGroupInterface rolledUpGroup, PromptGroupInterface startingGroup) {
        PromptUtil.copyDefinitionsAndSubgroups(rolledUpGroup, startingGroup, true);
    }

    public static void copyDefinitionsAndSubgroups(PromptGroupInterface rolledUpGroup, PromptGroupInterface startingGroup, boolean removeHiddenObjects) {
        List<?> definitionsAndSubgroups = startingGroup.getPromptDefinitionsAndSubgroups();
        for (Object definitionOrSubgroup : definitionsAndSubgroups) {
            if (definitionOrSubgroup instanceof PromptDefinitionInterface) {
                PromptDefinitionInterface promptDefinition = (PromptDefinitionInterface)definitionOrSubgroup;
                if (promptDefinition.isHidden() && removeHiddenObjects) continue;
                rolledUpGroup.addPromptDefinition(promptDefinition);
                continue;
            }
            if (definitionOrSubgroup instanceof PromptGroupInterface) {
                PromptGroupInterface promptDefinitionGroup = (PromptGroupInterface)definitionOrSubgroup;
                if (promptDefinitionGroup.isPromptGroupHidden() && removeHiddenObjects) continue;
                PromptGroupInterface newGroup = promptDefinitionGroup.copy(null);
                if (!(newGroup instanceof SharedPromptGroupInterface)) {
                    PromptUtil.copyDefinitionsAndSubgroups(newGroup, promptDefinitionGroup, removeHiddenObjects);
                }
                rolledUpGroup.addPromptSubgroup(newGroup);
                continue;
            }
            throw new IllegalStateException("Groups should only contain definitions or other groups");
        }
    }

    public static void printPromptGroup(String prefix, PromptGroupInterface promptGroup) {
        List<?> promptDefinitionsAndSubgroups = promptGroup.getPromptDefinitionsAndSubgroups();
        int n = promptDefinitionsAndSubgroups.size();
        for (int i = 0; i < n; ++i) {
            Object item = promptDefinitionsAndSubgroups.get(i);
            if (item instanceof PromptDefinitionInterface) {
                System.out.print(prefix + "Prompt");
                if (((PromptDefinitionInterface)item).isHidden()) {
                    System.out.print("(hidden)");
                }
                System.out.println(": " + ((PromptDefinitionInterface)item).getPromptName());
                continue;
            }
            if (!(item instanceof PromptGroupInterface)) continue;
            System.out.print(prefix + "Group");
            if (item instanceof TransparentGroup) {
                System.out.print("(tranparent)");
            }
            if (item instanceof HorizontalGroup) {
                System.out.print("(horizontal)");
            }
            if (((PromptGroupInterface)item).isPromptGroupHidden()) {
                System.out.print("(hidden)");
            }
            System.out.println(": " + ((PromptGroupInterface)item).getPromptGroupLabel(Locale.getDefault()));
            PromptUtil.printPromptGroup(prefix + "   ", (PromptGroupInterface)item);
        }
    }

    public static String formatErrorMessages(Collection<ValidationEntry> promptValueValidationErrors) {
        String text = "";
        if (promptValueValidationErrors != null) {
            StringBuilder buf = new StringBuilder();
            boolean firstPass = false;
            Iterator<ValidationEntry> iter = promptValueValidationErrors.iterator();
            while (iter.hasNext()) {
                String msg = iter.next().getMessage();
                if (!firstPass) {
                    buf.append(msg);
                    firstPass = true;
                    continue;
                }
                buf.append("\n").append(msg);
            }
            text = buf.toString();
        }
        return text;
    }

    private static PersistenceInterface parseXML(InputSource source, LoggerFactoryInterface logFactory, PromptsReadingContext readingContext) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        PromptContentHandler handler;
        ValidateArg.notNull((Object)source, (String)"source");
        PersistenceInterface retVal = null;
        Map optionsMap = readingContext.getOptionsMap();
        SAXParser parser = null;
        if (optionsMap != null && optionsMap.containsKey("_SAS_SAX_Parser")) {
            parser = (SAXParser)optionsMap.get("_SAS_SAX_Parser");
        }
        if (parser == null) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            parser = factory.newSAXParser();
        }
        if (null != (handler = PromptContentHandler.newHandler2((LoggerFactoryInterface)logFactory, (PromptsReadingContext)readingContext))) {
            try {
                parser.parse(source, (DefaultHandler)handler);
                retVal = handler.getObject();
            }
            catch (SAXException e) {
                CommonLoggerInterface logger = LoggerRepository2.getLogger((String)PromptUtil.class.getName(), (LoggerFactoryInterface)logFactory);
                logger.error("Error with element location: " + handler.getElementLocation());
                logger.error(e.getMessage(), (Throwable)e);
                logger.info("If an ArrayIndexOutOfBoundsException occured, it means there are not enough objects left on the stack.");
                throw e;
            }
        }
        return retVal;
    }

    public static PersistenceInterface newObjectFromXML(Reader reader, LoggerFactoryInterface logFactory, PromptsReadingContext readingContext) throws SAXException, IOException, ParserConfigurationException {
        PromptsReadingContext myReadingContext = null;
        myReadingContext = null == readingContext ? PersistenceFactory.newReadingContext((LoggerFactoryInterface)logFactory) : readingContext;
        InputSource source = new InputSource(reader);
        PersistenceInterface retVal = PromptUtil.parseXML(source, logFactory, myReadingContext);
        if (null == readingContext) {
            myReadingContext.destroy();
        }
        return retVal;
    }

    public static List getAncestorGroups(PromptGroupInterface rootPromptGroup, PromptDefinitionInterface definition) {
        boolean result;
        ValidateArg.notNull((Object)rootPromptGroup, (String)"rootPromptGroup");
        ValidateArg.notNull((Object)definition, (String)"definition");
        ArrayList<PromptGroupInterface> retVal = new ArrayList<PromptGroupInterface>();
        CommonLoggerInterface logger = LoggerRepository2.getLogger((String)PromptUtil.class.getName(), null);
        if (logger.isDebugEnabled()) {
            logger.debug("getAncestorGroups() for this group and this definition...");
            logger.debug(rootPromptGroup.toString());
            logger.debug(definition.toString());
        }
        if (!(result = PromptUtil.processGroup(retVal, rootPromptGroup, definition))) {
            logger.debug("Definition not found in root group. Searching subgroups.");
            retVal.add(rootPromptGroup);
            result = PromptUtil.processSubGroups(retVal, rootPromptGroup, definition, logger);
        }
        if (!result) {
            retVal.clear();
        }
        logger.debug("Returning list of size:", Integer.toString(retVal.size()));
        return retVal;
    }

    private static boolean processSubGroups(List ancestors, PromptGroupInterface input, PromptDefinitionInterface definition, CommonLoggerInterface logger) {
        PromptGroupInterface group;
        boolean result = false;
        List<?> allGroups = input.getPromptDefinitionsAndSubgroups(null, false, false, true);
        int n = allGroups.size();
        for (int i = 0; i < n && !(result = PromptUtil.processGroup(ancestors, group = (PromptGroupInterface)allGroups.get(i), definition)); ++i) {
            ancestors.add(group);
            result = PromptUtil.processSubGroups(ancestors, group, definition, logger);
            if (logger.isDebugEnabled()) {
                logger.debug(group.toString() + " result is ", Boolean.toString(result));
            }
            if (result) continue;
            ancestors.remove(group);
        }
        return result;
    }

    private static boolean foundIt(PromptDefinitionInterface desired, Object test) {
        return desired.equals(test);
    }

    private static boolean processGroup(List ancestors, PromptGroupInterface group, PromptDefinitionInterface definition) {
        List<PromptDefinitionInterface> defs = group.getPromptDefinitions(false);
        int n = defs.size();
        for (int i = 0; i < n; ++i) {
            PromptDefinitionInterface item = defs.get(i);
            if (item instanceof PromptDefinitionInterface) {
                if (!PromptUtil.foundIt(definition, item)) continue;
                ancestors.add(group);
                return true;
            }
            if (!(item instanceof PromptGroupInterface)) continue;
            ancestors.add(group);
            boolean result = PromptUtil.processGroup(ancestors, (PromptGroupInterface)((Object)item), definition);
            if (result) continue;
            ancestors.remove(group);
        }
        return false;
    }

    public static boolean isPromptDefinitionInModalGroup(PromptDefinitionInterface prompt, PromptGroupInterface rootGroup) {
        List groups = PromptUtil.getAncestorGroups(rootGroup, prompt);
        if (groups != null && !groups.isEmpty()) {
            for (PromptGroupInterface group : groups) {
                if (!(group instanceof ModalGroupInterface)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSpecialValuesAvailable(SupportedSpecialValues values) {
        return values != null && (values.isAllSupported() || !values.isMissingValuesHiddenIfSupported() && values.isMissingValuesSupported() || values.isOtherSupported());
    }

    public static boolean isGroupShareable(PromptGroupInterface parentGroup, PromptGroupInterface group) {
        ValidateArg.notNull((Object)group, (String)"group");
        List path = PromptUtil.getPathToPromptGroup(parentGroup, group);
        Iterator pathIter = path.iterator();
        while (pathIter.hasNext()) {
            if (!(pathIter.next() instanceof SharedPromptGroupInterface)) continue;
            return false;
        }
        boolean retVal = false;
        List list = group.getReferencedResources(PromptDefinitionInterface.class, true);
        if (!list.isEmpty()) {
            List<PromptDefinitionInterface> definitionList = group.getPromptDefinitions(true);
            for (Object element : list) {
                if (!(element instanceof PromptDefinitionInterface)) continue;
                if (definitionList.contains(element)) {
                    retVal = true;
                    continue;
                }
                retVal = false;
                break;
            }
        } else {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isPromptDefinitionShareable(PromptDefinitionInterface definition) {
        List list;
        ValidateArg.notNull((Object)definition, (String)"definition");
        boolean retVal = false;
        try {
            list = definition.getReferencedResources(PromptDefinitionInterface.class, true);
        }
        catch (IllegalStateException e) {
            return false;
        }
        if (list.isEmpty()) {
            retVal = true;
        }
        return retVal;
    }

    public static final boolean isRequiredPromptPresent(PromptGroupInterface promptGroup) {
        if (promptGroup != null) {
            List<?> promptDefinitionsAndSubgroups = promptGroup.getPromptDefinitionsAndSubgroups();
            int n = promptDefinitionsAndSubgroups.size();
            for (int i = 0; i < n; ++i) {
                Object item = promptDefinitionsAndSubgroups.get(i);
                if (!(item instanceof PromptDefinitionInterface ? ((PromptDefinitionInterface)item).isRequired() : item instanceof PromptGroupInterface && PromptUtil.isRequiredPromptPresent((PromptGroupInterface)item))) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean isRequiredPromptPresent(PromptPropertiesPanelModelInterface model) {
        if (model != null) {
            return PromptUtil.isRequiredPromptPresent(model.getRootGroupModel());
        }
        return false;
    }

    public static final boolean isRequiredPromptPresent(PromptGroupPanelModelInterface group) {
        if (group != null) {
            List views = group.getObjects(1);
            for (Object o : views) {
                PromptGroupPanelModelInterface subgroup;
                PromptComponentModelInterface view;
                if (!(o instanceof PromptComponentModelInterface ? (view = (PromptComponentModelInterface)o).getPromptDefinition().isRequired() : PromptUtil.isRequiredPromptPresent(subgroup = (PromptGroupPanelModelInterface)o))) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean isPromptPresentAndVisible(PromptValuesInterface promptValues) {
        if (promptValues != null && promptValues.getPromptGroup() != null) {
            PromptGroupInterface pg = promptValues.getPromptGroup();
            List<PromptDefinitionInterface> defsAndGroups = pg.getPromptDefinitions(true);
            for (PromptDefinitionInterface element : defsAndGroups) {
                if (!(element instanceof PromptDefinitionInterface) || element.isHidden()) continue;
                return true;
            }
            List delegates = promptValues.getPromptValuesDelegates();
            if (delegates != null && !delegates.isEmpty()) {
                for (PromptValuesInterface delegate : delegates) {
                    boolean ret = PromptUtil.isPromptPresentAndVisible(delegate);
                    if (!ret) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static final boolean isRequiredPromptPresent(PromptGroupInterface promptGroup, PromptValuesInterface promptValues) {
        if (promptGroup != null && promptValues != null) {
            List<?> promptDefinitionsAndSubgroups = promptGroup.getPromptDefinitionsAndSubgroups();
            int n = promptDefinitionsAndSubgroups.size();
            for (int i = 0; i < n; ++i) {
                Object item = promptDefinitionsAndSubgroups.get(i);
                if (item instanceof PromptDefinitionInterface) {
                    if (!((PromptDefinitionInterface)item).isRequired()) continue;
                    return true;
                }
                if (item instanceof ModalGroupInterface) {
                    PromptDefinitionInterface def = ((ModalGroupInterface)item).getChoiceDefinition();
                    if (!promptValues.isPromptValueAvailable(def)) continue;
                    try {
                        ModalChoiceGroupInterface choiceGroup;
                        Object val = promptValues.getPromptValue(def);
                        if (val != null && (choiceGroup = ((ModalGroupInterface)item).getModalChoiceGroupForValue(val)) != null && PromptUtil.isRequiredPromptPresent(choiceGroup, promptValues)) {
                            return true;
                        }
                    }
                    catch (PromptValueNotFoundException promptValueNotFoundException) {}
                    continue;
                }
                if (!(item instanceof PromptGroupInterface) || !PromptUtil.isRequiredPromptPresent((PromptGroupInterface)item, promptValues)) continue;
                return true;
            }
        }
        return false;
    }

    public static ValueProviderDefinitionInterface getPromptDefinitionContainingValueProvider(PromptGroupInterface promptGroup, ValueProviderInterface valueProvider) {
        ValueProviderDefinitionInterface definition = null;
        List<PromptDefinitionInterface> promptDefinitions = promptGroup.getPromptDefinitions(true);
        int size = promptDefinitions.size();
        for (int i = 0; i < size; ++i) {
            ValueProviderDefinitionInterface vpDefinition;
            ValueProviderInterface promptValueProvider;
            PromptDefinitionInterface promptDefinition = promptDefinitions.get(i);
            if (!(promptDefinition instanceof ValueProviderDefinitionInterface) || (promptValueProvider = (vpDefinition = (ValueProviderDefinitionInterface)((Object)promptDefinition)).getValueProvider()) == null || valueProvider != promptValueProvider) continue;
            definition = vpDefinition;
            break;
        }
        return definition;
    }

    public static void validatePromptValues(PromptValuesInterface promptValues) throws InvalidPromptValueException {
        PromptUtil.validatePromptValues(promptValues, new SimplePromptValueValidator());
    }

    public static void validatePromptValues(PromptValuesInterface promptValues, PromptValueValidatorInterface validator) throws InvalidPromptValueException {
        PromptGroupInterface promptGroup = promptValues.getPromptGroup();
        List dependencyOrder = PromptUtil.getPromptDefinitionsOrderedByDependencies(promptGroup, promptValues);
        Map valuesMap = promptValues.getPromptValues();
        for (PromptDefinitionInterface prompt : dependencyOrder) {
            if (prompt instanceof ModalGroupDefinition) {
                PromptGroupInterface group;
                Object value = valuesMap.get(prompt);
                List pathToPrompt = PromptUtil.getPathToPromptDefinition(promptValues.getPromptGroup(), prompt);
                if (pathToPrompt.size() <= 0 || !((group = (PromptGroupInterface)pathToPrompt.get(pathToPrompt.size() - 1)) instanceof ModalGroupInterface)) continue;
                ModalGroupInterface modalGroup = (ModalGroupInterface)group;
                List<PromptGroupInterface> subgroups = modalGroup.getPromptSubgroups(false);
                Iterator<PromptGroupInterface> subgroupIterator = subgroups.iterator();
                boolean valid = false;
                while (subgroupIterator.hasNext()) {
                    ModalChoiceGroupInterface subgroup = (ModalChoiceGroupInterface)subgroupIterator.next();
                    String subgroupValue = subgroup.getValue();
                    if (!PromptUtil.isPromptValuesEqual(subgroupValue, value)) continue;
                    valid = true;
                    break;
                }
                if (valid) continue;
                throw new InvalidPromptValueException(prompt, value, Locale.US, null);
            }
            validator.validateValue(prompt, valuesMap.get(prompt));
        }
    }

    public static void validatePromptValues(PromptValuesInterface promptValues, Locale locale) throws InvalidPromptValueException {
        PromptUtil.validatePromptValues(promptValues, new SimplePromptValueValidator(locale));
    }

    public static void validateDynamicPromptValues(PromptValuesInterface promptValues, DynamicPromptValueContextInterface context, Locale locale) throws InvalidPromptValueException {
        try {
            Class<?> validator = Class.forName("com.sas.prompts.util.iquery.DynamicPromptValueValidator");
            Constructor<?> constructor = validator.getConstructor(DynamicPromptValueContextInterface.class, Locale.class);
            PromptValueValidatorInterface validatorInstance = (PromptValueValidatorInterface)constructor.newInstance(context, locale);
            PromptUtil.validatePromptValues(promptValues, validatorInstance);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Collection validateValuesInValueProvider(ValueProviderInterface valueProvider, DynamicPromptValueContextInterface context, PromptDefinitionInterface definition, boolean returnOnFirstInvalidValue, Locale locale) throws ValueProviderException {
        Object values;
        List errors = Collections.EMPTY_LIST;
        if (valueProvider != null && definition != null && (values = PromptUtil.getValuesForValueProvider(valueProvider, context, locale)) instanceof Collection) {
            Collection collection = (Collection)values;
            for (ValueItem item : collection) {
                Object value = item.getValue();
                Collection<ValidationEntry> col = PromptUtil.validateValueFromValueProvider(definition, value, locale);
                if (col == null || col.isEmpty()) continue;
                errors.add(col);
                if (!returnOnFirstInvalidValue) continue;
                break;
            }
        }
        return errors;
    }

    private static Object getValuesForValueProvider(ValueProviderInterface valueProvider, DynamicPromptValueContextInterface context, Locale locale) throws ValueProviderException {
        Object values = null;
        values = valueProvider instanceof DynamicValueProviderInterface ? ((DynamicValueProviderInterface)valueProvider).getValues(locale, context, ValueType.LIST, 0, -1) : valueProvider.getValues(locale, ValueType.LIST, 0, -1);
        return values;
    }

    public static Map getInvalidValuesInValueProvider(ValueProviderInterface valueProvider, DynamicPromptValueContextInterface context, PromptDefinitionInterface definition, boolean returnOnFirstInvalidValue, Locale locale) throws ValueProviderException {
        Object values;
        LinkedHashMap<Object, Collection<ValidationEntry>> invalidValues = Collections.EMPTY_MAP;
        if (valueProvider != null && definition != null && (values = PromptUtil.getValuesForValueProvider(valueProvider, context, locale)) instanceof Collection) {
            Collection collection = (Collection)values;
            for (ValueItem item : collection) {
                Object value = item.getValue();
                Collection<ValidationEntry> col = PromptUtil.validateValueFromValueProvider(definition, value, locale);
                if (col == null || col.isEmpty()) continue;
                if (invalidValues == null || invalidValues == Collections.EMPTY_MAP) {
                    invalidValues = returnOnFirstInvalidValue ? new LinkedHashMap(1) : new LinkedHashMap<ValueItem, Collection<ValidationEntry>>();
                }
                invalidValues.put(item, col);
                if (!returnOnFirstInvalidValue) continue;
                break;
            }
        }
        return invalidValues;
    }

    public static void removeInvalidValuesInStaticValueProvider(StaticValueProvider valueProvider, DynamicPromptValueContextInterface context, PromptDefinitionInterface definition, Locale locale) throws ValueProviderException {
        PromptUtil.removeInvalidValuesInStaticValueProvider(valueProvider, context, definition, null, locale);
    }

    public static void removeInvalidValuesInStaticValueProvider(StaticValueProvider valueProvider, DynamicPromptValueContextInterface context, PromptDefinitionInterface definition, CommonLoggerInterface logger, Locale locale) throws ValueProviderException {
        Map invalidValues = PromptUtil.getInvalidValuesInValueProvider((ValueProviderInterface)valueProvider, context, definition, false, locale);
        if (invalidValues != null && !invalidValues.isEmpty()) {
            Set entries = invalidValues.entrySet();
            for (Map.Entry entry : entries) {
                if (logger != null) {
                    String msg = Message.format((String)RB.getStringResource(RB_KEY, "valueRemoved.fmt.txt"), entry.getKey(), (Object)PromptUtil.formatErrorMessages((Collection)entry.getValue()));
                    logger.info(msg);
                }
                valueProvider.removeValue(entry.getKey(), locale);
            }
        }
    }

    public static Collection<ValidationEntry> validateValueFromValueProvider(PromptDefinitionInterface definition, Object value, Locale locale) {
        Collection<ValidationEntry> errors = null;
        if (value == null) {
            errors = PromptUtil.addError(errors, 1L, RB.getStringResource(RB_KEY, "nullNotAllowed.txt", locale));
        } else if (definition != null) {
            SelectableDefinitionInterface selectable = null;
            if (definition instanceof SelectableDefinitionInterface) {
                selectable = (SelectableDefinitionInterface)definition;
            }
            boolean relative = false;
            boolean minRelative = false;
            boolean maxRelative = false;
            if (value instanceof DatePeriod && ((DatePeriod)value).isRelativeDate()) {
                relative = true;
            }
            if (definition instanceof DateDefinitionInterface) {
                DateDefinitionInterface dateDefinition = (DateDefinitionInterface)definition;
                if (dateDefinition.getMinimum() instanceof DatePeriod && ((DatePeriod)dateDefinition.getMinimum()).isRelativeDate()) {
                    minRelative = true;
                }
                if (dateDefinition.getMaximum() instanceof DatePeriod && ((DatePeriod)dateDefinition.getMaximum()).isRelativeDate()) {
                    maxRelative = true;
                }
            }
            if (selectable != null) {
                boolean valid = false;
                valid = selectable instanceof SelectableDefinitionV2Interface ? ((SelectableDefinitionV2Interface)selectable).validIndividualValue(value, locale) : selectable.validIndividualValue(value);
                if (!valid) {
                    Collection<ValidationEntry> reasons = selectable.getIndivdualPromptValueValidationErrors(value, locale);
                    boolean bothRelativeOrAbsolute = false;
                    if (relative) {
                        if (minRelative) {
                            bothRelativeOrAbsolute = true;
                        }
                    } else if (!minRelative) {
                        bothRelativeOrAbsolute = true;
                    }
                    if (bothRelativeOrAbsolute && !PromptUtil.validateErrorCode(reasons, 4L) || !PromptUtil.validateErrorCode(reasons, 6L)) {
                        errors = PromptUtil.addErrors(errors, reasons);
                    }
                    bothRelativeOrAbsolute = false;
                    if (relative) {
                        if (maxRelative) {
                            bothRelativeOrAbsolute = true;
                        }
                    } else if (!maxRelative) {
                        bothRelativeOrAbsolute = true;
                    }
                    if (bothRelativeOrAbsolute && !PromptUtil.validateErrorCode(reasons, 2L) || !PromptUtil.validateErrorCode(reasons, 6L)) {
                        errors = PromptUtil.addErrors(errors, reasons);
                    }
                }
            } else {
                boolean valid = false;
                valid = definition instanceof PromptDefinitionV2Interface ? ((PromptDefinitionV2Interface)definition).isPromptValueValid(value, locale) : definition.isPromptValueValid(value);
                if (!valid) {
                    Collection<ValidationEntry> reasons = definition.getPromptValueValidationErrors(value, locale);
                    if (!relative || !PromptUtil.validateErrorCode(reasons, 6L)) {
                        errors = PromptUtil.addErrors(errors, reasons);
                    }
                }
            }
        }
        if (errors == null) {
            return Collections.emptyList();
        }
        return errors;
    }

    private static boolean validateErrorCode(Collection errors, long errorCode) {
        Iterator iter;
        if (errors != null && !errors.isEmpty() && (iter = errors.iterator()).hasNext()) {
            ValidationEntry entry = (ValidationEntry)iter.next();
            long ec = entry.getErrorCode();
            return (ec & errorCode) == ec;
        }
        return true;
    }

    public static Collection<ValidationEntry> validatePromptGroup(PromptGroupInterface group, Locale locale) {
        List<PromptGroupInterface> choiceGroups;
        Collection<ValidationEntry> errors = new ArrayList<ValidationEntry>();
        if (group != null && group instanceof ModalGroupInterface && (choiceGroups = group.getPromptSubgroups(false)) != null) {
            HashMap<String, ModalChoiceGroupInterface> valuesMap = new HashMap<String, ModalChoiceGroupInterface>();
            for (PromptGroupInterface choiceGroup : choiceGroups) {
                if (choiceGroup instanceof ModalChoiceGroupInterface) {
                    ModalChoiceGroupInterface mcg = (ModalChoiceGroupInterface)choiceGroup;
                    String value = mcg.getValue();
                    if (!valuesMap.containsKey(value)) {
                        valuesMap.put(value, mcg);
                        continue;
                    }
                    errors = PromptUtil.addError(errors, 4L, Message.format((String)RB.getStringResource(RB_KEY, "duplicateModalChoiceGroupValue.fmt.txt", locale), (Object)value));
                    continue;
                }
                errors = PromptUtil.addError(errors, 1L, RB.getStringResource(RB_KEY, "invalidSubgroupForModalGroup.txt", locale));
            }
        }
        return errors;
    }

    public static Map validatePromptGroup(PromptGroupInterface group, boolean includeDefinitionsAndSubgroups, Locale locale) {
        HashMap<PromptGroupInterface, Collection<ValidationEntry>> errors = new HashMap<PromptGroupInterface, Collection<ValidationEntry>>();
        Collection<ValidationEntry> e = PromptUtil.validatePromptGroup(group, locale);
        if (e != null && !e.isEmpty()) {
            errors.put(group, e);
        }
        if (includeDefinitionsAndSubgroups) {
            List<?> defsAndGroups = group.getPromptDefinitionsAndSubgroups();
            for (Object o : defsAndGroups) {
                if (o instanceof PromptDefinitionInterface) {
                    e = ((PromptDefinitionInterface)o).validateDefinition(locale);
                } else if (o instanceof PromptGroupInterface) {
                    e = PromptUtil.validatePromptGroup((PromptGroupInterface)o, locale);
                }
                if (e == null || e.isEmpty()) continue;
                errors.put((PromptGroupInterface)o, e);
            }
        }
        return errors;
    }

    private static void copyDefinitionsAndSubGroups(PromptGroupInterface destinationGroup, PromptGroupInterface group) {
        List<?> definitionsAndSubgroups = group.getPromptDefinitionsAndSubgroups();
        for (Object definitionOrSubgroup : definitionsAndSubgroups) {
            if (definitionOrSubgroup instanceof PromptDefinitionInterface) {
                PromptDefinitionInterface promptDefinition = (PromptDefinitionInterface)definitionOrSubgroup;
                destinationGroup.addPromptDefinition(promptDefinition);
                continue;
            }
            if (!(definitionOrSubgroup instanceof PromptGroupInterface)) continue;
            PromptGroupInterface promptDefinitionGroup = (PromptGroupInterface)definitionOrSubgroup;
            PromptGroupInterface newGroup = promptDefinitionGroup.copy(null);
            PromptUtil.copyDefinitionsAndSubgroups(newGroup, promptDefinitionGroup);
            destinationGroup.addPromptSubgroup(newGroup);
        }
    }

    public static Collection validatePromptGroupWithObjectsToAdd(PromptGroupInterface group, List objectsToAdd, Locale locale) {
        Collection<Object> errors = Collections.EMPTY_LIST;
        if (group != null) {
            PromptGroupInterface destinationGroup = group.copy(null);
            PromptUtil.copyDefinitionsAndSubGroups(destinationGroup, group);
            if (objectsToAdd != null) {
                for (Object element : objectsToAdd) {
                    if (element instanceof PromptGroupInterface) {
                        try {
                            destinationGroup.addPromptSubgroup((PromptGroupInterface)element);
                        }
                        catch (IllegalArgumentException ex) {
                            errors = PromptUtil.addError(errors, 1L, ex.getMessage());
                        }
                        continue;
                    }
                    if (!(element instanceof PromptDefinitionInterface)) continue;
                    try {
                        destinationGroup.addPromptDefinition((PromptDefinitionInterface)element);
                    }
                    catch (IllegalArgumentException ex) {
                        errors = PromptUtil.addError(errors, 2L, ex.getMessage());
                    }
                }
            }
            errors = PromptUtil.addErrors(errors, PromptUtil.validatePromptGroup(destinationGroup, locale));
        }
        return errors;
    }

    public static Collection getAllPromptsWithUnsetDependencies(PromptValuesInterface promptValues, DynamicPromptValueContextInterface dynamicValueContext) {
        ArrayList disabledPrompts = new ArrayList();
        PromptUtil.getAllPromptsWithUnsetDependencies(promptValues, dynamicValueContext, disabledPrompts);
        return disabledPrompts;
    }

    private static void getAllPromptsWithUnsetDependencies(PromptValuesInterface promptValues, DynamicPromptValueContextInterface dynamicValueContext, Collection disabledPrompts) {
        PromptGroupInterface promptGroup = promptValues.getPromptGroup();
        List<PromptDefinitionInterface> allPrompts = null;
        allPrompts = promptGroup.getPromptDefinitions(true);
        for (PromptDefinitionInterface definition : allPrompts) {
            if (PromptUtil.isAllDependentPromptValuesSet(promptValues, definition, dynamicValueContext)) continue;
            disabledPrompts.add(definition);
        }
    }

    public static boolean isAllDependentPromptValuesSet(PromptValuesInterface promptValues, PromptDefinitionInterface promptDefinition, DynamicPromptValueContextInterface dynamicValueContext) {
        Collection deps = PromptUtil.getAllDependentPrompts(promptDefinition, true, dynamicValueContext);
        if (deps != null && !deps.isEmpty()) {
            for (PromptDefinitionInterface depPrompt : deps) {
                if (promptValues.isPromptValueAvailable(depPrompt)) continue;
                return false;
            }
        }
        return true;
    }

    public static Collection getAllDependentPrompts(PromptDefinitionInterface prompt) {
        return PromptUtil.getAllDependentPrompts(prompt, false, null);
    }

    public static Collection getAllDependentPrompts(PromptDefinitionInterface prompt, boolean recursive, DynamicPromptValueContextInterface dynamicValueContext) {
        ArrayList dependencies = new ArrayList();
        PromptUtil.getAllDependentPrompts(prompt, prompt, recursive, dynamicValueContext, dependencies);
        return dependencies;
    }

    private static void getAllDependentPrompts(PromptDefinitionInterface initialPrompt, PromptDefinitionInterface prompt, boolean recursive, DynamicPromptValueContextInterface dynamicValueContext, Collection dependencies) {
        Collection<PromptDefinitionInterface> directDependencies = prompt.getDependentPrompts(Locale.US, dynamicValueContext);
        Collection<PromptDefinitionInterface> additionalDependencies = prompt.getAdditionalCascadeDependencies();
        ArrayList<PromptDefinitionInterface> allDeps = new ArrayList<PromptDefinitionInterface>();
        if (directDependencies != null) {
            allDeps.addAll(directDependencies);
        }
        if (additionalDependencies != null) {
            allDeps.addAll(additionalDependencies);
        }
        if (!allDeps.isEmpty()) {
            ArrayList depsToAdd = new ArrayList();
            for (Object e : allDeps) {
                if (dependencies.contains(e) || initialPrompt == e) continue;
                dependencies.add(e);
                depsToAdd.add(e);
            }
            if (recursive) {
                for (PromptDefinitionInterface promptDefinitionInterface : depsToAdd) {
                    PromptUtil.getAllDependentPrompts(initialPrompt, promptDefinitionInterface, recursive, dynamicValueContext, dependencies);
                }
            }
        }
    }

    public static Collection getAllDependentPrompts(PromptComponentModelInterface promptComponent) {
        return PromptUtil.getAllDependentPrompts(promptComponent, false);
    }

    public static Collection getAllDependentPrompts(PromptComponentModelInterface promptComponent, boolean recursive) {
        return PromptUtil.getAllDependentPrompts(promptComponent, promptComponent.getDynamicPromptValuesContext(), recursive);
    }

    public static Collection getAllDependentPrompts(PromptViewInterface promptComponent, DynamicPromptValueContextInterface context) {
        return PromptUtil.getAllDependentPrompts(promptComponent, context, false);
    }

    public static boolean isAllDependentPromptValuesSet(PromptViewInterface view, DynamicPromptValueContextInterface context) {
        boolean ret = PromptUtil.isAllDependentPromptValuesSet(PromptUtil.getAllDependentPrompts(view, context));
        return ret;
    }

    public static boolean isAllDependentPromptValuesSet(Collection dependentViews) {
        if (dependentViews != null) {
            for (PromptViewInterface view : dependentViews) {
                if (view.getPromptValue() != null) continue;
                return false;
            }
        }
        return true;
    }

    public static Collection getAllDependentPrompts(PromptViewInterface promptComponent, DynamicPromptValueContextInterface context, boolean recursive) {
        ArrayList dependencies = new ArrayList();
        PromptUtil.getAllDependentPrompts(promptComponent, promptComponent, context, recursive, dependencies);
        return dependencies;
    }

    private static void getAllDependentPrompts(PromptViewInterface initialView, PromptViewInterface promptComponent, DynamicPromptValueContextInterface context, boolean recursive, Collection dependencies) {
        Collection directDependencies = context.getDependentPromptViews(promptComponent);
        if (directDependencies != null && !directDependencies.isEmpty()) {
            ArrayList depsToAdd = new ArrayList();
            for (Object element : directDependencies) {
                if (dependencies.contains(element) || initialView == element) continue;
                dependencies.add(element);
                depsToAdd.add(element);
            }
            if (recursive) {
                for (PromptViewInterface dep : depsToAdd) {
                    PromptUtil.getAllDependentPrompts(initialView, dep, context, recursive, dependencies);
                }
            }
        }
    }

    public static List getPromptDefinitionsOrderedByDependencies(PromptGroupInterface promptGroup) {
        return PromptUtil.getPromptDefinitionsOrderedByDependencies(promptGroup, null);
    }

    public static List getPromptDefinitionsOrderedByDependencies(PromptGroupInterface promptGroup, PromptValuesInterface promptValues) {
        ArrayList orderedPrompts = new ArrayList();
        List allPrompts = null;
        allPrompts = promptValues != null ? PromptUtil.getVisualOrderOfDefinitions(promptValues, promptGroup, false) : promptGroup.getPromptDefinitions(true);
        PromptUtil.addPromptDefinitionsOrderedByDependencies(allPrompts, orderedPrompts, promptGroup);
        return orderedPrompts;
    }

    private static void addPromptDefinitionsOrderedByDependencies(List allPrompts, List orderedPrompts, PromptGroupInterface promptGroup) {
        boolean change = true;
        while (!allPrompts.isEmpty() && change) {
            change = false;
            Iterator allPromptsIterator = allPrompts.iterator();
            while (allPromptsIterator.hasNext()) {
                PromptDefinitionInterface prompt = (PromptDefinitionInterface)allPromptsIterator.next();
                Collection dependencies = PromptUtil.getAllDependentPrompts(prompt);
                if (dependencies != null && !dependencies.isEmpty() && !PromptUtil.isAllDependenciesInList(dependencies, orderedPrompts)) continue;
                change = true;
                orderedPrompts.add(prompt);
                allPromptsIterator.remove();
            }
        }
        if (!allPrompts.isEmpty()) {
            orderedPrompts.addAll(allPrompts);
        }
    }

    private static void addPromptDefinitionsOrderedByDependencies(List allPrompts, List orderedPrompts, PromptGroupPanelModelInterface promptGroupPanel) {
        boolean change = true;
        while (!allPrompts.isEmpty() && change) {
            change = false;
            Iterator allPromptsIterator = allPrompts.iterator();
            while (allPromptsIterator.hasNext()) {
                PromptComponentModelInterface promptComp = (PromptComponentModelInterface)allPromptsIterator.next();
                Collection dependencies = PromptUtil.getAllDependentPrompts(promptComp);
                if (dependencies != null && !dependencies.isEmpty() && !PromptUtil.isAllDependenciesInList(dependencies, orderedPrompts)) continue;
                orderedPrompts.add(promptComp);
                allPromptsIterator.remove();
                change = true;
            }
        }
        if (!allPrompts.isEmpty()) {
            orderedPrompts.addAll(allPrompts);
        }
    }

    private static boolean isAllDependenciesInList(Collection dependencies, List orderedPrompts) {
        for (Object dependency : dependencies) {
            if (orderedPrompts.contains(dependency)) continue;
            return false;
        }
        return true;
    }

    public static List getOrderToSetPromptValues(PromptGroupInterface promptGroup) {
        ArrayList orderedPrompts = new ArrayList();
        List allPrompts = PromptUtil.getOrderOfDefs(promptGroup);
        PromptUtil.addPromptDefinitionsOrderedByDependencies(allPrompts, orderedPrompts, promptGroup);
        return orderedPrompts;
    }

    public static List getOrderToSetPromptValues(PromptGroupPanelModelInterface promptGroupPanel) {
        return PromptUtil.getOrderToSetPromptValues(promptGroupPanel, true);
    }

    public static List getOrderToSetPromptValues(PromptGroupPanelModelInterface promptGroupPanel, boolean includeSubGroups) {
        ArrayList orderedPrompts = new ArrayList();
        List allPrompts = PromptUtil.getOrderOfDefs(promptGroupPanel, includeSubGroups);
        PromptUtil.addPromptDefinitionsOrderedByDependencies(allPrompts, orderedPrompts, promptGroupPanel);
        return orderedPrompts;
    }

    private static List getOrderOfDefs(PromptGroupInterface promptGroup) {
        ArrayList<Object> returnList = new ArrayList<Object>();
        List<?> promptsAndSubgroups = promptGroup.getPromptDefinitionsAndSubgroups();
        ArrayList groupList = new ArrayList();
        int size = promptsAndSubgroups.size();
        for (int i = 0; i < size; ++i) {
            Object item = promptsAndSubgroups.get(i);
            if (item instanceof PromptDefinitionInterface) {
                returnList.add(item);
                continue;
            }
            if (item instanceof ModalGroupInterface) {
                ModalGroupInterface modalGroup = (ModalGroupInterface)item;
                PromptDefinitionInterface def = modalGroup.getChoiceDefinition();
                returnList.add(def);
                List<PromptGroupInterface> choiceGroups = modalGroup.getPromptSubgroups(false);
                Iterator<PromptGroupInterface> iter = choiceGroups.iterator();
                while (iter.hasNext()) {
                    returnList.addAll(PromptUtil.getOrderOfDefs((ModalChoiceGroupInterface)iter.next()));
                }
                continue;
            }
            if (item instanceof TransparentGroupInterface) {
                returnList.addAll(PromptUtil.getOrderOfDefs((TransparentGroupInterface)item));
                continue;
            }
            if (!(item instanceof PromptGroupInterface)) continue;
            groupList.add(item);
        }
        Iterator iter = groupList.iterator();
        while (iter.hasNext()) {
            returnList.addAll(PromptUtil.getOrderOfDefs((PromptGroupInterface)iter.next()));
        }
        return returnList;
    }

    private static List getOrderOfDefs(PromptGroupPanelModelInterface promptGroupPanel) {
        return PromptUtil.getOrderOfDefs(promptGroupPanel, true);
    }

    private static List getOrderOfDefs(PromptGroupPanelModelInterface promptGroupPanel, boolean includeSubGroups) {
        ArrayList returnList = new ArrayList();
        List promptsAndSubgroups = null;
        promptsAndSubgroups = includeSubGroups ? promptGroupPanel.getObjects(1) : promptGroupPanel.getObjects(2);
        ArrayList groupList = new ArrayList();
        int size = promptsAndSubgroups.size();
        for (int i = 0; i < size; ++i) {
            Object item = promptsAndSubgroups.get(i);
            if (item instanceof PromptComponentModelInterface) {
                returnList.add(item);
                continue;
            }
            if (!(item instanceof PromptGroupPanelModelInterface)) continue;
            PromptGroupPanelModelInterface pgp = (PromptGroupPanelModelInterface)item;
            if (pgp.getGroupType().isModal()) {
                List comps = pgp.getObjects(2);
                returnList.addAll(comps);
                if (comps == null || comps.size() != 1) continue;
                List choiceGroups = pgp.getModalGroups((PromptComponentModelInterface)comps.get(0));
                Iterator iter = choiceGroups.iterator();
                while (iter.hasNext()) {
                    returnList.addAll(PromptUtil.getOrderOfDefs((PromptGroupPanelModelInterface)iter.next()));
                }
                continue;
            }
            if (pgp.getGroupType().isTransparent()) {
                returnList.addAll(PromptUtil.getOrderOfDefs(pgp));
                continue;
            }
            groupList.add(item);
        }
        Iterator iter = groupList.iterator();
        while (iter.hasNext()) {
            returnList.addAll(PromptUtil.getOrderOfDefs((PromptGroupPanelModelInterface)iter.next()));
        }
        return returnList;
    }

    public static void initializeValueProviders(PromptGroupInterface promptGroup, Map options) {
        List<PromptDefinitionInterface> defs;
        if (promptGroup != null && (defs = promptGroup.getPromptDefinitions(true)) != null) {
            for (PromptDefinitionInterface promptDefinition : defs) {
                if (!(promptDefinition instanceof ValueProviderDefinitionInterface) || !(((ValueProviderDefinitionInterface)((Object)promptDefinition)).getValueProvider() instanceof ValueProviderInitializationInterface)) continue;
                options.put("PROMPT_DEFINITION", promptDefinition);
                ((ValueProviderInitializationInterface)((ValueProviderDefinitionInterface)((Object)promptDefinition)).getValueProvider()).initialize(options);
            }
            options.remove("PROMPT_DEFINITION");
        }
    }

    public static List expandPromptValue(PromptDefinitionInterface definition, Object value, Locale locale) throws ValueProviderException {
        ValueProviderInterface valueProvider;
        if ((value == SpecialValues.ALL || value == SpecialValues.OTHER) && definition instanceof ValueProviderDefinitionInterface && (valueProvider = ((ValueProviderDefinitionInterface)((Object)definition)).getValueProvider()) instanceof StaticValueProvider) {
            StaticValueProvider staticValueProvider = (StaticValueProvider)valueProvider;
            List valueItems = (List)staticValueProvider.getValues(locale);
            ArrayList<Object> justTheValues = new ArrayList<Object>(valueItems.size());
            for (ValueItem valueItem : valueItems) {
                if (valueItem.getValue() == SpecialValues.ALL || valueItem.getValue() == SpecialValues.OTHER) continue;
                justTheValues.add(valueItem.getValue());
            }
            return justTheValues;
        }
        if (value instanceof List) {
            return (List)value;
        }
        ArrayList<Object> newList = new ArrayList<Object>(1);
        newList.add(value);
        return newList;
    }

    public static Collection findPromptSubgroups(PromptGroupInterface rootGroup, PromptDefinitionInterface promptDefinition) {
        if (rootGroup != null && promptDefinition != null) {
            ArrayList<PromptGroupInterface> groups = new ArrayList<PromptGroupInterface>();
            List<?> defsAndGroups = rootGroup.getPromptDefinitionsAndSubgroups();
            if (defsAndGroups.contains(promptDefinition)) {
                groups.add(rootGroup);
            }
            int n = defsAndGroups.size();
            for (int i = 0; i < n; ++i) {
                Collection subgroups;
                Object item = defsAndGroups.get(i);
                if (!(item instanceof PromptGroupInterface) || (subgroups = PromptUtil.findPromptSubgroups((PromptGroupInterface)item, promptDefinition)) == null || subgroups.isEmpty()) continue;
                groups.addAll(subgroups);
            }
            return groups;
        }
        return Collections.EMPTY_LIST;
    }

    public static PromptViewInterface findPromptView(PromptPropertiesPanelModelInterface model, PromptDefinitionInterface def) {
        return PromptUtil.findPromptView(model.getRootGroupModel(), def);
    }

    public static PromptViewInterface findPromptView(PromptGroupPanelModelInterface group, PromptDefinitionInterface def) {
        if (group != null) {
            List defsAndGroup = group.getObjects(1);
            for (Object o : defsAndGroup) {
                PromptViewInterface oo;
                if (o instanceof PromptViewInterface && ((PromptViewInterface)o).getPromptDefinition() == def) {
                    return (PromptViewInterface)o;
                }
                if (!(o instanceof PromptGroupPanelModelInterface) || (oo = PromptUtil.findPromptView((PromptGroupPanelModelInterface)o, def)) == null) continue;
                return oo;
            }
        }
        return null;
    }

    public static Collection findPromptViews(PromptPropertiesPanelModelInterface model, PromptDefinitionInterface def) {
        return PromptUtil.findPromptViews(model.getRootGroupModel(), def);
    }

    public static Collection findPromptViews(PromptGroupPanelModelInterface group, PromptDefinitionInterface def) {
        if (group != null) {
            List returnList = ListFactory.newList();
            List defsAndGroup = group.getObjects(1);
            for (Object o : defsAndGroup) {
                Collection col;
                if (o instanceof PromptViewInterface && ((PromptViewInterface)o).getPromptDefinition() == def) {
                    returnList.add(o);
                    continue;
                }
                if (!(o instanceof PromptGroupPanelModelInterface) || (col = PromptUtil.findPromptViews((PromptGroupPanelModelInterface)o, def)) == null || col.isEmpty()) continue;
                returnList.addAll(col);
            }
            return returnList;
        }
        return Collections.EMPTY_LIST;
    }

    public static Collection findGroupPanels(PromptGroupPanelModelInterface rootGroup, PromptDefinitionInterface promptDefinition) {
        if (rootGroup != null && promptDefinition != null) {
            ArrayList<PromptGroupPanelModelInterface> groups = new ArrayList<PromptGroupPanelModelInterface>();
            List defsAndGroups = rootGroup.getObjects(1);
            int n = defsAndGroups.size();
            for (int i = 0; i < n; ++i) {
                Collection subgroups;
                Object item = defsAndGroups.get(i);
                if (item instanceof PromptViewInterface && ((PromptViewInterface)item).getPromptDefinition() == promptDefinition) {
                    groups.add(rootGroup);
                }
                if (!(item instanceof PromptGroupPanelModelInterface) || (subgroups = PromptUtil.findGroupPanels((PromptGroupPanelModelInterface)item, promptDefinition)) == null || subgroups.isEmpty()) continue;
                groups.addAll(subgroups);
            }
            return groups;
        }
        return Collections.EMPTY_LIST;
    }

    public static Collection findGroupPanels(PromptGroupPanelModelInterface rootGroup, PromptComponentModelInterface promptComponent) {
        if (rootGroup != null && promptComponent != null) {
            ArrayList<PromptGroupPanelModelInterface> groups = new ArrayList<PromptGroupPanelModelInterface>();
            List defsAndGroups = rootGroup.getObjects(1);
            int n = defsAndGroups.size();
            for (int i = 0; i < n; ++i) {
                Collection subgroups;
                Object item = defsAndGroups.get(i);
                if (item instanceof PromptViewInterface && item == promptComponent) {
                    groups.add(rootGroup);
                }
                if (!(item instanceof PromptGroupPanelModelInterface) || (subgroups = PromptUtil.findGroupPanels((PromptGroupPanelModelInterface)item, promptComponent)) == null || subgroups.isEmpty()) continue;
                groups.addAll(subgroups);
            }
            return groups;
        }
        return Collections.EMPTY_LIST;
    }

    public static Collection<ValidationEntry> addError(Collection<ValidationEntry> errors, long errorCode, String textReason) {
        if (errors == null || errors.isEmpty()) {
            errors = new ArrayList<ValidationEntry>(1);
        }
        if (!PromptUtil.containError(errors, errorCode)) {
            errors.add(new ValidationEntry(errorCode, textReason));
        }
        return errors;
    }

    public static Collection<ValidationEntry> addErrors(Collection<ValidationEntry> errors, Collection<ValidationEntry> errorsToAdd) {
        if (errors == null || errors.isEmpty()) {
            errors = new ArrayList<ValidationEntry>(1);
        }
        if (errorsToAdd != null && !errorsToAdd.isEmpty()) {
            for (ValidationEntry entry : errorsToAdd) {
                if (PromptUtil.containError(errors, entry.getErrorCode())) continue;
                errors.add(entry);
            }
        }
        return errors;
    }

    private static boolean containError(Collection<ValidationEntry> errors, long errorCode) {
        if (errors != null && !errors.isEmpty()) {
            for (ValidationEntry error : errors) {
                if (error.getErrorCode() != errorCode) continue;
                return true;
            }
        }
        return false;
    }

    public static Map getMacroVariableValues(PromptValuesInterface promptValues, Map context) {
        return PromptUtil.getMacroVariableValues(promptValues, context, true);
    }

    public static Map getMacroVariableValues(PromptValuesInterface promptValues, Map context, boolean searchDelegates) {
        return PromptUtil.getMacroVariableValues(promptValues, context, searchDelegates, Locale.US);
    }

    public static Map getMacroVariableValues(PromptValuesInterface promptValues, Map context, boolean searchDelegates, Locale locale) {
        List delegates;
        LinkedHashMap outputMap = new LinkedHashMap();
        List definitions = PromptUtil.getVisualOrderOfDefinitions(promptValues, false);
        for (PromptDefinitionInterface definition : definitions) {
            try {
                Map macroValues = null;
                if (promptValues.isPromptValueAvailable(definition)) {
                    Object value = promptValues.getPromptValue(definition);
                    macroValues = definition.getPromptDataType().getMacroVariableValues((MacroVariableOptionInterface)definition, value, locale);
                } else {
                    macroValues = definition.getPromptDataType().getUnsetMacroVariableValues((MacroVariableOptionInterface)definition);
                }
                ArrayList keys = new ArrayList(macroValues.keySet());
                Collections.sort(keys);
                for (String key : keys) {
                    Object vvalue = macroValues.get(key);
                    outputMap.put(key, vvalue);
                }
            }
            catch (PromptValueNotFoundException value) {
            }
        }
        if (searchDelegates && (delegates = promptValues.getPromptValuesDelegates()) != null) {
            for (PromptValuesInterface delegatePromptValues : delegates) {
                Map delegateMap = PromptUtil.getMacroVariableValues(delegatePromptValues, context, searchDelegates, locale);
                outputMap.putAll(delegateMap);
            }
        }
        return outputMap;
    }

    public static void applyPromptGroupToPromptValues(PromptValuesInterface promptValues, PromptGroupInterface promptGroupToApply) {
        List<PromptDefinitionInterface> definitionsInPromptValuesGroup;
        PromptGroupInterface promptValuesGroup = promptValues.getPromptGroup();
        if (promptValues.getMutableUserInfo() != null && promptValues.getMutableUserInfo().contains("_SAS_INTERNAL_ORDER_UNIMPORTANT")) {
            definitionsInPromptValuesGroup = promptValuesGroup.getPromptDefinitions(true);
            if (definitionsInPromptValuesGroup != null && definitionsInPromptValuesGroup.size() > 0) {
                for (PromptDefinitionInterface definition : definitionsInPromptValuesGroup) {
                    if (promptGroupToApply.hasPromptDefinition(definition) || !promptValues.isPromptValueSet(definition)) continue;
                    promptValues.clearPromptValue(definition);
                }
            }
            promptValuesGroup.removeAll();
        } else {
            definitionsInPromptValuesGroup = promptValuesGroup.getPromptDefinitions(true);
            if (definitionsInPromptValuesGroup != null && definitionsInPromptValuesGroup.size() > 0) {
                for (PromptDefinitionInterface definition : definitionsInPromptValuesGroup) {
                    if (promptGroupToApply.hasPromptDefinition(definition)) continue;
                    if (promptValues.isPromptValueSet(definition)) {
                        promptValues.clearPromptValue(definition);
                    }
                    promptValuesGroup.removePromptDefinition(definition);
                }
            }
        }
        List<PromptDefinitionInterface> definitionsInGroupToApply = promptGroupToApply.getPromptDefinitions(true);
        if (definitionsInGroupToApply != null && definitionsInGroupToApply.size() > 0) {
            for (PromptDefinitionInterface definition : definitionsInGroupToApply) {
                if (promptValuesGroup.hasPromptDefinition(definition)) continue;
                promptValuesGroup.addPromptDefinition(definition);
            }
        }
    }

    public static void mergePromptValuesByPromptDefinitionID(PromptValuesInterface sourceValues, PromptValuesInterface targetValues, List ignoredDefinitionsList, List errorDefinitionsList) {
        Map sourceDefinitionsAndValues = sourceValues.getPromptValues();
        for (PromptDefinitionInterface sourceDefinition : sourceDefinitionsAndValues.keySet()) {
            String sourcePromptID = sourceDefinition.getPromptID();
            FindPromptValuesByPromptDefinitionIDVisitor visitor = new FindPromptValuesByPromptDefinitionIDVisitor(sourcePromptID);
            targetValues.acceptPromptValuesVisitor(visitor);
            if (visitor.getPromptDefinition() != null && !visitor.getPromptDefinition().isFixed()) {
                Object sourceValue = sourceDefinitionsAndValues.get(sourceDefinition);
                try {
                    targetValues.setPromptValue(visitor.getPromptDefinition(), sourceValue);
                }
                catch (InvalidPromptValueException e) {
                    if (errorDefinitionsList == null) continue;
                    errorDefinitionsList.add(visitor.getPromptDefinition());
                }
                continue;
            }
            if (ignoredDefinitionsList == null) continue;
            ignoredDefinitionsList.add(sourceDefinition);
        }
    }

    public static void populatePromptValuesWithDefaultValues(PromptValuesInterface promptValues, Map definitionsWithErrorsMaps) {
        PromptUtilFixAllPromptValuesVisitor visitor = new PromptUtilFixAllPromptValuesVisitor(definitionsWithErrorsMaps);
        promptValues.acceptPromptValuesVisitor(visitor);
    }

    public static void addLocalizedPropertiesFromValueProvider(PropertyList list, ValueProviderDefinitionSupport support, Locale locale) {
        MultiLocaleProperties vp;
        PropertyList vpList;
        if (null != support.getValueProvider() && support.getValueProvider() instanceof MultiLocaleProperties && null != (vpList = (vp = (MultiLocaleProperties)support.getValueProvider()).getLocalizableProperties(locale))) {
            list.addProperty("ValueProvider", vpList);
        }
    }

    public static void setLocalizedPropertiesOnValueProvider(PropertyMap map, ValueProviderDefinitionSupport support, Locale locale) {
        if (null != support.getValueProvider() && support.getValueProvider() instanceof MultiLocaleProperties && map.containsNestedProperty("ValueProvider")) {
            PropertyMap subMap = map.getNestedProperties("ValueProvider");
            MultiLocaleProperties vp = (MultiLocaleProperties)support.getValueProvider();
            vp.setLocalizableProperties(locale, subMap);
        }
    }

    public static Map getConflictingPromptsBasedOnMacroVariableName(PromptGroupInterface rootGroup, PromptDefinitionInterface prompt) {
        return PromptUtil.getConflictingPromptsBasedOnMacroVariableName(rootGroup, prompt, false, false);
    }

    public static Map getConflictingPromptsBasedOnMacroVariableName(PromptGroupInterface rootGroup, PromptDefinitionInterface prompt, boolean ignoreNameCase, boolean alwaysComparePromptsWithSameID) {
        PromptValues promptValues = new PromptValues(rootGroup);
        List visibleDefinitions = PromptUtil.getVisualOrderOfDefinitions(promptValues, rootGroup, false);
        return PromptUtil.getConflictingPromptsBasedOnMacroVariableName(visibleDefinitions, prompt, ignoreNameCase, alwaysComparePromptsWithSameID);
    }

    public static Map getConflictingPromptsBasedOnMacroVariableName(Collection visibleDefinitions, PromptDefinitionInterface prompt) {
        return PromptUtil.getConflictingPromptsBasedOnMacroVariableName(visibleDefinitions, prompt, false, false);
    }

    public static Map getConflictingPromptsBasedOnMacroVariableName(Collection visibleDefinitions, PromptDefinitionInterface prompt, boolean ignoreNameCase, boolean alwaysComparePromptsWithSameID) {
        Collection possibleNames = PromptUtil.getPossiblePromptMacroVariablesNames(prompt);
        if (ignoreNameCase) {
            possibleNames = PromptUtil.lowercaseStringCollection(possibleNames);
        }
        HashMap<PromptDefinitionInterface, Collection> conflicts = new HashMap<PromptDefinitionInterface, Collection>();
        for (PromptDefinitionInterface definition : visibleDefinitions) {
            ArrayList<String> conflictList;
            String nameWithoutDigits;
            boolean doCompare = false;
            if (definition != prompt) {
                if (alwaysComparePromptsWithSameID) {
                    doCompare = true;
                } else {
                    boolean sameID = definition.getPromptID().equals(prompt.getPromptID());
                    if (!sameID) {
                        doCompare = true;
                    }
                }
            }
            if (!doCompare) continue;
            Collection possibleNamesFromGroup = PromptUtil.getPossiblePromptMacroVariablesNames(definition);
            if (ignoreNameCase) {
                possibleNamesFromGroup = PromptUtil.lowercaseStringCollection(possibleNamesFromGroup);
            }
            if (!Collections.disjoint(possibleNames, possibleNamesFromGroup)) {
                conflicts.put(definition, Util.andCollections((Collection)possibleNames, (Collection)possibleNamesFromGroup));
            }
            String promptMacroVarName = prompt.getMacroVariableBaseName();
            String definitionMacroVarName = definition.getMacroVariableBaseName();
            if (ignoreNameCase) {
                if (promptMacroVarName != null) {
                    promptMacroVarName = promptMacroVarName.toLowerCase();
                }
                if (definitionMacroVarName != null) {
                    definitionMacroVarName = definitionMacroVarName.toLowerCase();
                }
            }
            if (definition.getPromptDataType() instanceof CollectionType) {
                if (!PromptUtil.endsInDigit(promptMacroVarName) || !Util.equal((Object)(nameWithoutDigits = PromptUtil.trimDigitsFromEnd(promptMacroVarName)), (Object)definitionMacroVarName)) continue;
                conflictList = new ArrayList<String>(1);
                conflictList.add(nameWithoutDigits);
                conflicts.put(definition, conflictList);
                continue;
            }
            if (!(prompt.getPromptDataType() instanceof CollectionType) || !PromptUtil.endsInDigit(definitionMacroVarName) || !Util.equal((Object)(nameWithoutDigits = PromptUtil.trimDigitsFromEnd(definitionMacroVarName)), (Object)promptMacroVarName)) continue;
            conflictList = new ArrayList(1);
            conflictList.add(nameWithoutDigits);
            conflicts.put(definition, conflictList);
        }
        return conflicts;
    }

    private static boolean endsInDigit(String input) {
        char lastChar;
        return input != null && input.length() > 0 && Character.isDigit(lastChar = input.charAt(input.length() - 1));
    }

    private static String trimDigitsFromEnd(String input) {
        if (input == null) {
            return "";
        }
        StringBuffer output = new StringBuffer(input);
        while (PromptUtil.endsInDigit(output.toString())) {
            if (output.length() <= 0) continue;
            output.deleteCharAt(output.length() - 1);
        }
        return output.toString();
    }

    private static Collection lowercaseStringCollection(Collection items) {
        ArrayList<String> newItems = new ArrayList<String>(items.size());
        for (String item : items) {
            item = item.toLowerCase();
            newItems.add(item);
        }
        return newItems;
    }

    public static Collection getPossiblePromptMacroVariablesNames(PromptDefinitionInterface prompt) {
        String promptName = prompt.getPromptName();
        Collection possibleExtensions = prompt.getPromptDataType().getPossibleMacroVariableExtensions();
        ArrayList<String> possibleNames = new ArrayList<String>(possibleExtensions.size());
        for (String extension : possibleExtensions) {
            possibleNames.add(promptName + extension);
        }
        return possibleNames;
    }

    public static Map setPromptValuesByNameValuePair(PromptValuesInterface targetPromptValues, PromptGroupInterface promptGroup, Map promptNameToValueMap) {
        return PromptUtil.setPromptValuesByNameValuePair(targetPromptValues, promptGroup, promptNameToValueMap, false);
    }

    public static Map setPromptValuesByNameValuePair(PromptValuesInterface targetPromptValues, PromptGroupInterface promptGroup, Map promptNameToValueMap, boolean ignoreCaseOfPromptNames) {
        HashMap<String, Exception> errorMap = new HashMap<String, Exception>();
        if (ignoreCaseOfPromptNames) {
            HashMap newPromptNameToValueMap = new HashMap(promptNameToValueMap.size());
            for (String name : promptNameToValueMap.keySet()) {
                String lowercaseName = name.toLowerCase();
                newPromptNameToValueMap.put(lowercaseName, promptNameToValueMap.get(name));
            }
            promptNameToValueMap.clear();
            promptNameToValueMap.putAll(newPromptNameToValueMap);
        }
        List<PromptDefinitionInterface> promptDefinitions = promptGroup.getPromptDefinitions(false);
        Collection selectionGroupDefinitions = PromptUtil.getModalGroupDefinitions(promptGroup);
        promptDefinitions.addAll(selectionGroupDefinitions);
        for (PromptDefinitionInterface prompt : promptDefinitions) {
            String promptName = prompt.getPromptName();
            if (ignoreCaseOfPromptNames) {
                promptName = promptName.toLowerCase();
            }
            if (!promptNameToValueMap.containsKey(promptName)) continue;
            try {
                boolean setValue = true;
                if (prompt.isFixed()) {
                    try {
                        if (targetPromptValues.isPromptValueAvailable(prompt) && PromptUtil.isPromptValuesEqual(targetPromptValues.getPromptValue(prompt), promptNameToValueMap.get(promptName))) {
                            setValue = false;
                        }
                    }
                    catch (PromptValueNotFoundException promptValueNotFoundException) {
                        // empty catch block
                    }
                }
                if (setValue) {
                    targetPromptValues.setPromptValue(prompt, promptNameToValueMap.get(promptName));
                }
            }
            catch (InvalidPromptValueException ipve) {
                errorMap.put(promptName, ipve);
            }
            catch (IllegalArgumentException iae) {
                errorMap.put(promptName, iae);
            }
            promptNameToValueMap.remove(promptName);
        }
        List<PromptGroupInterface> promptSubgroups = promptGroup.getPromptSubgroups(false);
        for (PromptGroupInterface subgroup : promptSubgroups) {
            if (subgroup instanceof ModalGroupInterface) {
                ModalGroupInterface modalGroup = (ModalGroupInterface)subgroup;
                if (modalGroup.getChoiceDefinition() != null) {
                    try {
                        String value = (String)targetPromptValues.getPromptValue(modalGroup.getChoiceDefinition());
                        subgroup = PromptUtil.getModalChoiceGroupByValue(modalGroup, value);
                    }
                    catch (PromptValueNotFoundException pvnfe) {
                        subgroup = null;
                    }
                } else {
                    subgroup = null;
                }
            }
            if (subgroup == null) continue;
            Map partialErrorMap = PromptUtil.setPromptValuesByNameValuePair(targetPromptValues, subgroup, promptNameToValueMap, ignoreCaseOfPromptNames);
            errorMap.putAll(partialErrorMap);
        }
        return errorMap;
    }

    public static ModalChoiceGroupInterface getModalChoiceGroupByValue(ModalGroupInterface modalGroup, String value) {
        List<PromptGroupInterface> promptSubgroups = modalGroup.getPromptSubgroups(false);
        for (PromptGroupInterface subgroup : promptSubgroups) {
            if (subgroup instanceof ModalChoiceGroupInterface) {
                ModalChoiceGroupInterface modalChoiceGroup = (ModalChoiceGroupInterface)subgroup;
                if (!Util.equal((Object)value, (Object)modalChoiceGroup.getValue())) continue;
                return modalChoiceGroup;
            }
            throw new IllegalStateException("ModalGroups should only contain ModalChoiceGroups");
        }
        return null;
    }

    private static Collection getModalGroupDefinitions(PromptGroupInterface promptGroup) {
        Collection modalGroups = PromptUtil.getModalGroups(promptGroup);
        if (modalGroups.size() > 0) {
            ArrayList<PromptDefinitionInterface> modalGroupDefinitions = new ArrayList<PromptDefinitionInterface>(modalGroups.size());
            for (ModalGroupInterface modalGroup : modalGroups) {
                modalGroupDefinitions.add(modalGroup.getChoiceDefinition());
            }
            return modalGroupDefinitions;
        }
        return Collections.EMPTY_LIST;
    }

    private static Collection getModalGroups(PromptGroupInterface promptGroup) {
        ArrayList<PromptGroupInterface> selectionGroups = Collections.EMPTY_LIST;
        List<PromptGroupInterface> groups = promptGroup.getPromptSubgroups(false);
        for (PromptGroupInterface subgroup : groups) {
            if (!(subgroup instanceof ModalGroupInterface)) continue;
            if (selectionGroups == Collections.EMPTY_LIST) {
                selectionGroups = new ArrayList<PromptGroupInterface>();
            }
            selectionGroups.add(subgroup);
        }
        return selectionGroups;
    }

    public static PromptDefinitionInterface findPromptDefinitionByName(PromptValuesInterface promptValues, String promptName, boolean recursiveIntoGroups, boolean searchDelegates, boolean ignoreCaseOfName) {
        if (ignoreCaseOfName && promptName != null) {
            promptName = promptName.toLowerCase();
        }
        if (recursiveIntoGroups) {
            List visualOrderList = PromptUtil.getVisualOrderOfDefinitions(promptValues, false);
            for (PromptDefinitionInterface prompt : visualOrderList) {
                String currentPromptName = prompt.getPromptName();
                if (ignoreCaseOfName && currentPromptName != null) {
                    currentPromptName = currentPromptName.toLowerCase();
                }
                if (!Util.equal((Object)currentPromptName, (Object)promptName)) continue;
                return prompt;
            }
        }
        Object pdi = null;
        FindPromptValuesByPromptDefinitionNameVisitor visitor = new FindPromptValuesByPromptDefinitionNameVisitor(promptName, ignoreCaseOfName, recursiveIntoGroups);
        promptValues.acceptPromptValuesVisitor(visitor);
        return visitor.getPromptDefinition();
    }

    public static List<PromptDefinitionInterface> findPromptDefinitionsByName(PromptGroupInterface promptGroup, String promptName, boolean recursiveIntoGroups, boolean ignoreCaseOfName) {
        if (ignoreCaseOfName && promptName != null) {
            promptName = promptName.toLowerCase();
        }
        ArrayList<PromptDefinitionInterface> ret = new ArrayList<PromptDefinitionInterface>();
        List<PromptDefinitionInterface> defs = promptGroup.getPromptDefinitions(recursiveIntoGroups);
        for (PromptDefinitionInterface prompt : defs) {
            String currentPromptName = prompt.getPromptName();
            if (ignoreCaseOfName && currentPromptName != null) {
                currentPromptName = currentPromptName.toLowerCase();
            }
            if (!Util.equal((Object)currentPromptName, (Object)promptName)) continue;
            ret.add(prompt);
        }
        return ret;
    }

    public static void applyPromptDefinitionInterfaceAttributes(PromptDefinitionInterface sourcePrompt, MutablePromptDefinitionInterface targetPrompt) {
        targetPrompt.setDefaultValue(sourcePrompt.getDefaultValue());
        targetPrompt.setFixed(sourcePrompt.isFixed());
        targetPrompt.setHidden(sourcePrompt.isHidden());
        targetPrompt.setMacroVariableBaseName(sourcePrompt.getMacroVariableBaseName());
        targetPrompt.setMacroVariableOutputLevel(sourcePrompt.getMacroVariableOutputLevel());
        targetPrompt.setPromptDescriptions(sourcePrompt.getPromptDescriptions());
        targetPrompt.setPromptLabels(sourcePrompt.getPromptLabels());
        targetPrompt.setPromptName(sourcePrompt.getPromptName());
        targetPrompt.setStickyDefaultAllowed(sourcePrompt.isStickyDefaultAllowed());
        targetPrompt.setUserInfo(sourcePrompt.getUserInfo());
    }

    public static Map updatePromptAttributesForDependencies(PromptDefinitionInterface changedPrompt, PromptValuesInterface promptValues) {
        if (!promptValues.isPromptValueAvailable(changedPrompt)) {
            return null;
        }
        try {
            Object value = promptValues.getPromptValue(changedPrompt);
            ConfigurePromptVisitor visitor = new ConfigurePromptVisitor(changedPrompt, value);
            promptValues.acceptPromptValuesVisitor(visitor);
            PromptUtil.possiblyClearPromptValuesForHiddenGroups(visitor.getConfiguredObjects(), promptValues, promptValues.getPromptGroup());
            return visitor.getConfiguredObjects();
        }
        catch (PromptValueNotFoundException promptValueNotFoundException) {
            return null;
        }
    }

    private static void possiblyClearPromptValuesForHiddenGroups(Map clearedPrompts, PromptValuesInterface promptValues, PromptGroupInterface startGroup) {
        if (startGroup.isPromptGroupHidden() && startGroup instanceof PromptGroupV2Interface && ((PromptGroupV2Interface)startGroup).isClearPromptValuesWhenHidden()) {
            PromptUtil.clearAllPromptValuesInGroup(clearedPrompts, promptValues, startGroup, true);
        } else {
            List<PromptGroupInterface> groups = startGroup.getPromptSubgroups(false);
            Iterator<PromptGroupInterface> groupsIterator = groups.iterator();
            while (groupsIterator.hasNext()) {
                PromptUtil.possiblyClearPromptValuesForHiddenGroups(clearedPrompts, promptValues, groupsIterator.next());
            }
        }
    }

    private static void clearAllPromptValuesInGroup(Map clearedPrompts, PromptValuesInterface promptValues, PromptGroupInterface group, boolean recursive) {
        List<PromptDefinitionInterface> prompts = group.getPromptDefinitions(recursive);
        for (PromptDefinitionInterface prompt : prompts) {
            if (!promptValues.isPromptValueSet(prompt)) continue;
            promptValues.clearPromptValue(prompt);
            clearedPrompts.put(prompt, "value");
        }
    }

    public static List<PersistenceInterface> getUserInfoAsText(MutableUserInfoInterface uii) {
        ArrayList<PersistenceInterface> list = new ArrayList<PersistenceInterface>();
        if (null != uii && !uii.isEmpty()) {
            for (String key : uii.getKeys()) {
                String text = uii.get(key);
                MapText mapText = new MapText();
                mapText.setKey(key);
                mapText.setText(text);
                list.add((PersistenceInterface)mapText);
            }
        }
        return list;
    }

    public static PromptDefinitionInterface findPromptDefinitionByID(PromptValuesInterface promptValues, String promptID) {
        ValidateArg.notNull((Object)promptValues, (String)"promptValues");
        FindPromptValuesByPromptIDVisitor visitor = new FindPromptValuesByPromptIDVisitor(promptID);
        promptValues.acceptPromptValuesVisitor(visitor);
        return visitor.getPromptDefinition();
    }

    public static PromptGroupInterface findPromptGroupByID(PromptValuesInterface promptValues, String promptID) {
        ValidateArg.notNull((Object)promptValues, (String)"promptValues");
        FindPromptValuesByPromptIDVisitor visitor = new FindPromptValuesByPromptIDVisitor(promptID);
        promptValues.acceptPromptValuesVisitor(visitor);
        return visitor.getPromptGroup();
    }

    @NotNull
    public static void resetPromptGroupID(PromptGroupV2Interface group) {
        ValidateArg.notNull((Object)group, (String)"group");
        ((MutableIdentifiablePromptInterface)((Object)group)).setPromptID("_SAS_PROMPT_ID_RESET");
        List<PromptDefinitionInterface> list = group.getPromptDefinitions(false);
        for (PromptDefinitionInterface prompt : list) {
            ((MutablePromptDefinitionInterface)prompt).setPromptID("_SAS_PROMPT_ID_RESET");
        }
        List<PromptGroupInterface> groups = group.getPromptSubgroups(false);
        for (PromptGroupInterface group1 : groups) {
            if (!(group1 instanceof PromptGroupV2Interface)) continue;
            PromptUtil.resetPromptGroupID((PromptGroupV2Interface)group1);
        }
    }

    public static String getDelegatedText(@NotNull LocalizableString localizableString, @NotNull Locale locale, ApplicationContext applicationContext) {
        ValidateArg.notNull((Object)localizableString, (String)"localizableString");
        String text = localizableString.getText(locale);
        if (null != text && null != applicationContext && null != applicationContext.getResourceBundleDelegate()) {
            ValidateArg.notNull((Object)locale, (String)"locale");
            String delText = applicationContext.getResourceBundleDelegate().getText(text, locale);
            if (null != delText) {
                text = delText;
            }
        }
        return text;
    }

    public static void addDynamicAggregatePrompts(PromptValuesInterface promptValues, Map options, boolean searchPassedInPromptValuesForDelegates, boolean searchFoundPromptValuesForDelegates) {
        try {
            Class<?> visitorClass = Class.forName("com.sas.prompts.definitions.remote.DynamicPromptSourceVisitor");
            PromptSourceVisitorInterface visitorInstance = (PromptSourceVisitorInterface)visitorClass.newInstance();
            PromptUtil.addAggregatePrompts(promptValues, visitorInstance, options, searchPassedInPromptValuesForDelegates, searchFoundPromptValuesForDelegates);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Map<PromptValuesInterface, List> getDynamicAggregatePrompts(PromptValuesInterface promptValues, Map options, boolean searchPassedInPromptValuesForDelegates, boolean searchFoundPromptValuesForDelegates) {
        try {
            Class<?> visitorClass = Class.forName("com.sas.prompts.definitions.remote.DynamicPromptSourceVisitor");
            PromptSourceVisitorInterface visitorInstance = (PromptSourceVisitorInterface)visitorClass.newInstance();
            return PromptUtil.getAggregatePrompts(promptValues, visitorInstance, options, searchPassedInPromptValuesForDelegates, searchFoundPromptValuesForDelegates);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static List<PromptValuesInterface> getAggregatePrompts(PromptValuesInterface promptValues, PromptSourceVisitorInterface visitor, Map options) {
        ArrayList<PromptValuesInterface> newDelegates = new ArrayList<PromptValuesInterface>();
        List<PromptDefinitionInterface> prompts = promptValues.getPromptGroup().getPromptDefinitions(true);
        for (PromptDefinitionInterface prompt : prompts) {
            PromptValuesInterface promptValuesToAdd = visitor.getPromptsFromSource(prompt, options);
            if (promptValuesToAdd == null) continue;
            newDelegates.add(promptValuesToAdd);
        }
        return newDelegates;
    }

    public static Map<PromptValuesInterface, List> getAggregatePrompts(PromptValuesInterface promptValues, PromptSourceVisitorInterface visitor, Map options, boolean searchPassedInPromptValuesForDelegates, boolean searchFoundPromptValuesForDelegates) {
        List delegates;
        LinkedHashMap<PromptValuesInterface, List> pvToDelegateMap = new LinkedHashMap<PromptValuesInterface, List>();
        List<PromptValuesInterface> newDelegates = PromptUtil.getAggregatePrompts(promptValues, visitor, options);
        for (PromptValuesInterface delegateToAdd : newDelegates) {
            if (pvToDelegateMap.containsKey(promptValues)) {
                List delegateList = pvToDelegateMap.get(promptValues);
                delegateList.add(delegateToAdd);
            } else {
                ArrayList<PromptValuesInterface> newDelegateList = new ArrayList<PromptValuesInterface>(1);
                newDelegateList.add(delegateToAdd);
                pvToDelegateMap.put(promptValues, newDelegateList);
            }
            if (!searchFoundPromptValuesForDelegates) continue;
            Map<PromptValuesInterface, List> partialAggregatePromptsMap = PromptUtil.getAggregatePrompts(delegateToAdd, visitor, options, searchPassedInPromptValuesForDelegates, searchFoundPromptValuesForDelegates);
            PromptUtil.mergeDelegateMaps(pvToDelegateMap, partialAggregatePromptsMap);
        }
        if (searchPassedInPromptValuesForDelegates && (delegates = promptValues.getPromptValuesDelegates()) != null) {
            Iterator delegatesIterator = delegates.iterator();
            while (delegatesIterator.hasNext()) {
                Map<PromptValuesInterface, List> partialAggregatePromptsMap = PromptUtil.getAggregatePrompts((PromptValuesInterface)delegatesIterator.next(), visitor, options, searchPassedInPromptValuesForDelegates, searchFoundPromptValuesForDelegates);
                PromptUtil.mergeDelegateMaps(pvToDelegateMap, partialAggregatePromptsMap);
            }
        }
        return pvToDelegateMap;
    }

    private static void mergeDelegateMaps(Map<PromptValuesInterface, List> map1, Map<PromptValuesInterface, List> map2) {
        for (PromptValuesInterface map2pv : map2.keySet()) {
            if (map1.containsKey(map2pv)) {
                List map1DelegateList = map1.get(map2pv);
                map1DelegateList.addAll(map2.get(map2pv));
                continue;
            }
            map1.put(map2pv, map2.get(map2pv));
        }
    }

    public static void addAggregatePrompts(PromptValuesInterface promptValues, PromptSourceVisitorInterface visitor, Map options, boolean searchPassedInPromptValuesForDelegates, boolean searchFoundPromptValuesForDelegates) {
        Map<PromptValuesInterface, List> pvToDelegateListMap = PromptUtil.getAggregatePrompts(promptValues, visitor, options, searchPassedInPromptValuesForDelegates, searchFoundPromptValuesForDelegates);
        for (PromptValuesInterface pv : pvToDelegateListMap.keySet()) {
            List pvDelegateList = pvToDelegateListMap.get(pv);
            Iterator pvDelegateListIterator = pvDelegateList.iterator();
            while (pvDelegateListIterator.hasNext()) {
                PromptUtil.addPromptValuesDelegate(promptValues, (PromptValuesInterface)pvDelegateListIterator.next());
            }
        }
    }

    private static void addPromptValuesDelegate(PromptValuesInterface mainPromptValues, PromptValuesInterface delegatePromptValues) {
        boolean alreadyADelegate = false;
        List delegates = mainPromptValues.getPromptValuesDelegates();
        if (delegates != null) {
            alreadyADelegate = delegates.contains(delegatePromptValues);
        }
        if (!alreadyADelegate) {
            mainPromptValues.addPromptValuesDelegate(delegatePromptValues);
        }
    }
}

