/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeInterface;
import com.sas.prompts.definitions.MutablePromptDefinitionV2Interface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.util.AttributeConfigurationInterface;
import com.sas.util.AttributeConfigurationUtil;
import com.sas.util.ValidateArg;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.PromptObjectFactory;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

@SASScope
public final class PromptConfigurationFactory
extends AttributeConfigurationUtil {
    public static final String VALUE_PROVIDER_PREFIX = "_valueProvider.";

    private PromptConfigurationFactory() {
    }

    public static PromptDefinitionInterface createPrompt(Map<String, ?> options, Map<String, ?> context) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        ValidateArg.notNull(options, (String)"options");
        String promptType = (String)options.get("promptType");
        MutablePromptDefinitionV2Interface prompt = null;
        if (null != promptType) {
            prompt = (MutablePromptDefinitionV2Interface)PromptObjectFactory.getInstance().newObject(promptType);
            if (prompt != null) {
                prompt.configureAttributes(options, context);
                return prompt;
            }
            throw new IllegalArgumentException("Unable to create prompt for specified type : " + promptType);
        }
        throw new IllegalArgumentException("No value for the key 'promptType' was found in the options parameter. ");
    }

    public static PromptGroupInterface createPromptGroup(Map<String, ?> options, Map<String, ?> context) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        ValidateArg.notNull(options, (String)"options");
        PromptGroupInterface promptGroup = null;
        String promptGroupType = null;
        if (options.containsKey("promptGroupType")) {
            promptGroupType = (String)options.get("promptGroupType");
        }
        if ((promptGroup = promptGroupType != null ? (PromptGroupInterface)PromptObjectFactory.getInstance().newObject(promptGroupType) : new PromptGroup()) instanceof AttributeConfigurationInterface) {
            ((AttributeConfigurationInterface)promptGroup).configureAttributes(options, context);
        }
        return promptGroup;
    }

    public static ValueProviderInterface createValueProvider(ValueProviderInterface existingValueProvider, Map<String, ?> options, Map<String, ?> context) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (options.containsKey("_valueProvider.valueProviderType")) {
            String valueProviderType = (String)options.get("_valueProvider.valueProviderType");
            String existingType = "";
            if (existingValueProvider != null) {
                existingType = existingValueProvider.getClass().getName();
            }
            if (!existingType.equals(valueProviderType)) {
                existingValueProvider = (ValueProviderInterface)PromptObjectFactory.getInstance().newObject(valueProviderType);
            }
            if (existingValueProvider instanceof AttributeConfigurationInterface) {
                ((AttributeConfigurationInterface)existingValueProvider).configureAttributes(options, context);
            } else {
                throw new IllegalStateException("Attempted to configure value provider that does not implement AttributeConfigurationInterface");
            }
        }
        return existingValueProvider;
    }

    public static Date getDateOption(DataTypeInterface dataType, String optionName, Map options, Map context) {
        Object value = options.get(optionName);
        if (value instanceof Date) {
            return (Date)value;
        }
        Locale locale = PromptConfigurationFactory.getLocaleOption(context);
        return (Date)dataType.coerceValue(value, locale);
    }

    public static Locale getLocaleOption(Map<String, ?> context) {
        Locale locale = Locale.getDefault();
        if (context != null && context.containsKey("__SAS_Locale")) {
            locale = XmlUtil.xmlToLocale((String)((String)context.get("__SAS_Locale")));
        }
        return locale;
    }
}

