/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts;

import com.sas.codepolicy.SASScope;
import com.sas.prompts.IdentifiablePromptInterface;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.PromptValuesVisitorInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.PromptGroupV2Interface;
import java.util.List;

@SASScope
final class FindPromptValuesByPromptIDVisitor
implements PromptValuesVisitorInterface {
    private String promptID;
    private PromptValuesInterface promptValues;
    private IdentifiablePromptInterface promptObject;
    private boolean isADefinition = false;

    public FindPromptValuesByPromptIDVisitor(String promptID) {
        this.promptID = promptID;
    }

    @Override
    public void accept(PromptValuesInterface promptValues) {
        List<PromptDefinitionInterface> definitions = promptValues.getPromptGroup().getPromptDefinitions(true);
        for (PromptDefinitionInterface definition : definitions) {
            if (!definition.getPromptID().equals(this.promptID)) continue;
            this.promptValues = promptValues;
            this.promptObject = definition;
            this.isADefinition = true;
            break;
        }
        List<PromptGroupInterface> groups = promptValues.getPromptGroup().getPromptSubgroups(true);
        groups.add(promptValues.getPromptGroup());
        for (PromptGroupInterface group : groups) {
            if (!(group instanceof PromptGroupV2Interface) || !((PromptGroupV2Interface)group).getPromptID().equals(this.promptID)) continue;
            this.promptValues = promptValues;
            this.promptObject = (PromptGroupV2Interface)group;
            this.isADefinition = false;
            break;
        }
    }

    @Override
    public boolean shouldContinue() {
        return this.promptValues == null;
    }

    PromptValuesInterface getPromptValues() {
        return this.promptValues;
    }

    PromptDefinitionInterface getPromptDefinition() {
        if (this.isADefinition) {
            return (PromptDefinitionInterface)this.promptObject;
        }
        return null;
    }

    PromptGroupInterface getPromptGroup() {
        if (!this.isADefinition) {
            return (PromptGroupInterface)((Object)this.promptObject);
        }
        return null;
    }

    public boolean isADefinition() {
        return this.isADefinition;
    }
}

