/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts;

import com.sas.codepolicy.SASScope;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.PromptValuesVisitorInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import java.util.List;

@SASScope
public class FindPromptValuesByPromptDefinitionNameVisitor
implements PromptValuesVisitorInterface {
    private String promptDefinitionName;
    private boolean ignoreCaseOfName;
    private boolean recurseIntoGroups;
    private PromptValuesInterface promptValues;
    private PromptDefinitionInterface promptDefinition;

    public FindPromptValuesByPromptDefinitionNameVisitor(String promptDefinitionName) {
        this(promptDefinitionName, false, true);
    }

    public FindPromptValuesByPromptDefinitionNameVisitor(String promptDefinitionName, boolean ignoreCaseOfName, boolean recurseIntoGroups) {
        this.promptDefinitionName = promptDefinitionName;
        this.ignoreCaseOfName = ignoreCaseOfName;
        this.recurseIntoGroups = recurseIntoGroups;
        if (ignoreCaseOfName && promptDefinitionName != null) {
            this.promptDefinitionName = promptDefinitionName.toLowerCase();
        }
    }

    @Override
    public void accept(PromptValuesInterface promptValues) {
        List<PromptDefinitionInterface> definitions = promptValues.getPromptGroup().getPromptDefinitions(this.recurseIntoGroups);
        int n = definitions.size();
        for (int i = 0; i < n; ++i) {
            PromptDefinitionInterface definition = definitions.get(i);
            String promptName = definition.getPromptName();
            if (this.ignoreCaseOfName && promptName != null) {
                promptName = promptName.toLowerCase();
            }
            if (promptName == null || !promptName.equals(this.promptDefinitionName)) continue;
            this.promptValues = promptValues;
            this.promptDefinition = definition;
            break;
        }
    }

    @Override
    public boolean shouldContinue() {
        return this.promptValues == null;
    }

    public PromptValuesInterface getPromptValues() {
        return this.promptValues;
    }

    public PromptDefinitionInterface getPromptDefinition() {
        return this.promptDefinition;
    }
}

