/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts;

import com.sas.codepolicy.SASScope;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DefaultPromptGroupPanelModel;
import com.sas.prompts.DynamicPromptValueContext;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.PromptComponentModelInterface;
import com.sas.prompts.PromptGroupPanelModelInterface;
import com.sas.prompts.PromptPropertiesPanelModelInterface;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.util.ListFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

@SASScope
public class DefaultPromptPropertiesPanelModel
implements PromptPropertiesPanelModelInterface {
    private PromptValuesInterface _promptValues;
    private DataProviderInterface _dataProvider;
    private PromptGroupPanelModelInterface _rootGroupModel = null;
    private Locale _locale;
    private DynamicPromptValueContext dynamicPromptValueContext;

    public DefaultPromptPropertiesPanelModel(PromptValuesInterface promptValues, Locale locale) {
        this(promptValues, null, locale);
    }

    public DefaultPromptPropertiesPanelModel(PromptValuesInterface promptValues, DataProviderInterface dataProvider, Locale locale) {
        this._promptValues = promptValues;
        this._dataProvider = dataProvider;
        this._locale = locale;
    }

    @Override
    public PromptGroupPanelModelInterface getRootGroupModel() {
        return this._rootGroupModel;
    }

    public PromptValuesInterface getPromptValues() {
        return this._promptValues;
    }

    public DataProviderInterface getDataProvider() {
        return this._dataProvider;
    }

    @Override
    public Locale getLocale() {
        return this._locale;
    }

    public synchronized void initialize() throws Exception {
        PromptGroup rootGroup = new PromptGroup();
        PromptValuesInterface promptValues = this.getPromptValues();
        if (promptValues == null) {
            return;
        }
        Collection rootPvGroups = DefaultPromptPropertiesPanelModel.extractRootGroups(promptValues);
        if (!DefaultPromptPropertiesPanelModel.isEmptyOrNull(rootPvGroups)) {
            for (PromptGroupInterface rpg : rootPvGroups) {
                rootGroup.addPromptSubgroup(rpg);
            }
        }
        PromptGroupInterface pgi = promptValues.getPromptGroup();
        PromptGroupInterface pgCopy = PromptUtil.rollupAndPrunePromptGroups(promptValues, pgi, false);
        this.dynamicPromptValueContext = new DynamicPromptValueContext(promptValues, pgCopy, this.getPromptValues() != null ? ((PromptValues)promptValues).getPromptUserContext() : null, this._dataProvider);
        DefaultPromptGroupPanelModel rootGroupModel = new DefaultPromptGroupPanelModel(pgCopy, promptValues, this.getLocale());
        rootGroupModel.setParentModel(this);
        rootGroupModel.setDynamicPromptValueContext(this.getDynamicPromptValueContext());
        rootGroupModel.initialize();
        this._rootGroupModel = rootGroupModel;
        this.calculatePromptViewDependencies(this._rootGroupModel);
    }

    private Collection findDependencies(PromptComponentModelInterface panelModel, PromptGroupPanelModelInterface groupPanelModel) {
        PromptDefinitionInterface promptDefinition = panelModel.getPromptDefinition();
        ArrayList dependentPromptViews = new ArrayList();
        List c = promptDefinition.getDependentPrompts(this.getLocale(), this.getDynamicPromptValueContext());
        c = ListFactory.newList(c);
        Collection<PromptDefinitionInterface> additional = promptDefinition.getAdditionalCascadeDependencies();
        if (additional != null && !additional.isEmpty()) {
            c.addAll(additional);
        }
        this.findDependeciesRecursive(this.getRootGroupModel(), panelModel, c, dependentPromptViews);
        return dependentPromptViews;
    }

    private void findDependeciesRecursive(PromptGroupPanelModelInterface groupModel, PromptComponentModelInterface componentModel, Collection dependentDefinitions, List dependentPromptViews) {
        List componentsAndGroups = groupModel.getObjects(1);
        for (Object o : componentsAndGroups) {
            if (o instanceof PromptComponentModelInterface) {
                PromptComponentModelInterface component = (PromptComponentModelInterface)o;
                if (!dependentDefinitions.contains(component.getPromptDefinition()) || dependentPromptViews.contains(component)) continue;
                dependentPromptViews.add(component);
                continue;
            }
            if (!(o instanceof PromptGroupPanelModelInterface)) continue;
            PromptGroupPanelModelInterface group = (PromptGroupPanelModelInterface)o;
            this.findDependeciesRecursive(group, componentModel, dependentDefinitions, dependentPromptViews);
        }
    }

    private void calculatePromptViewDependencies(PromptGroupPanelModelInterface panelModel) {
        List componentsAndGroups = panelModel.getObjects(1);
        DynamicPromptValueContextInterface context = this.getDynamicPromptValueContext();
        for (Object o : componentsAndGroups) {
            if (o instanceof PromptComponentModelInterface) {
                PromptComponentModelInterface component = (PromptComponentModelInterface)o;
                Collection depCollections = this.findDependencies(component, panelModel);
                if (!(context instanceof DynamicPromptValueContext)) continue;
                ((DynamicPromptValueContext)context).add(component, depCollections);
                continue;
            }
            if (!(o instanceof PromptGroupPanelModelInterface)) continue;
            PromptGroupPanelModelInterface group = (PromptGroupPanelModelInterface)o;
            this.calculatePromptViewDependencies(group);
        }
    }

    protected static Collection extractRootGroups(PromptValuesInterface valueStore) {
        PromptGroupInterface localNodeRootGroup;
        List rval = null;
        List valueStoreDelegates = valueStore.getPromptValuesDelegates();
        if (!DefaultPromptPropertiesPanelModel.isEmptyOrNull(valueStoreDelegates)) {
            rval = DefaultPromptPropertiesPanelModel.nonNullList(rval, valueStoreDelegates.size() + 1);
            for (PromptValuesInterface delegate : valueStoreDelegates) {
                if (delegate.getPromptGroup() == null) continue;
                rval.add(delegate.getPromptGroup());
            }
        }
        if ((localNodeRootGroup = valueStore.getPromptGroup()) != null) {
            rval = DefaultPromptPropertiesPanelModel.nonNullList(rval, 1);
            rval.add(0, localNodeRootGroup);
        }
        return DefaultPromptPropertiesPanelModel.nonNullList(rval, 0);
    }

    protected static boolean isEmptyOrNull(Collection c) {
        return c == null || c.isEmpty();
    }

    protected static List nonNullList(List list, int initialCapacity) {
        return list == null ? ListFactory.newList((int)initialCapacity) : list;
    }

    public DynamicPromptValueContextInterface getDynamicPromptValueContext() {
        return this.dynamicPromptValueContext;
    }

    @Override
    public boolean isAllRequiredPromptsValid() {
        if (this.getPromptValues() != null) {
            return this.getPromptValues().isAllRequiredPromptsValid();
        }
        return true;
    }
}

