/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts;

import com.sas.codepolicy.SASScope;
import com.sas.prompts.DefaultPromptComponentModel;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.PromptComponentModelInterface;
import com.sas.prompts.PromptGroupPanelModelInterface;
import com.sas.prompts.PromptPropertiesPanelModelInterface;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.ModalGroupDefinition;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.ModalChoiceGroupInterface;
import com.sas.prompts.groups.ModalGroupInterface;
import com.sas.prompts.groups.PromptGroupEnum;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroupInterface;
import com.sas.util.ListFactory;
import com.sas.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope
public class DefaultPromptGroupPanelModel
implements PromptGroupPanelModelInterface {
    PromptPropertiesPanelModelInterface _parentModel;
    private PromptGroupInterface _promptGroup;
    private PromptValuesInterface _promptValues;
    private List _componentAndSubGroupModels = ListFactory.newList();
    private Map _modalGroupModels = new HashMap();
    private List _promptComponentModels = ListFactory.newList();
    private List _subGroupModels = ListFactory.newList();
    private Locale _locale;
    private String _label;
    private DynamicPromptValueContextInterface dynamicPromptValueContext;
    private PromptGroupEnum _type;

    public DefaultPromptGroupPanelModel(PromptGroupInterface promptGroup, PromptValuesInterface promptValues, Locale locale) {
        this._promptGroup = promptGroup;
        this._promptValues = promptValues;
        this._locale = locale;
        this._type = PromptGroupEnum.valueOf(this._promptGroup);
    }

    public PromptGroupInterface getPromptGroup() {
        return this._promptGroup;
    }

    @Override
    public PromptGroupEnum getGroupType() {
        return this._type;
    }

    public PromptValuesInterface getValues() {
        return this._promptValues;
    }

    @Override
    public PromptPropertiesPanelModelInterface getEmbeddingPropertiesPanelModel() {
        return this._parentModel;
    }

    protected void setParentModel(PromptPropertiesPanelModelInterface parentModel) {
        this._parentModel = parentModel;
    }

    private List getPromptComponentModels() {
        return ListFactory.newList((Collection)this._promptComponentModels);
    }

    private List getPromptComponentsAndSubgroups() {
        return ListFactory.newList((Collection)this._componentAndSubGroupModels);
    }

    private List getSubGroupModels() {
        return ListFactory.newList((Collection)this._subGroupModels);
    }

    @Override
    public List getObjects(int key) {
        if (key == 1) {
            return this.getPromptComponentsAndSubgroups();
        }
        if (key == 2) {
            return this.getPromptComponentModels();
        }
        if (key == 3) {
            return this.getSubGroupModels();
        }
        throw new IllegalArgumentException("Invalid key, needs to be PROMPT_COMPONENTS_AND_SUBGROUP_MODELS, or PROMPT_COMPONENTS or SUBGROUP_MODELS.");
    }

    protected PromptValuesInterface getPromptValues() {
        return this._promptValues;
    }

    @Override
    public Locale getLocale() {
        return this._locale;
    }

    protected synchronized void initialize() throws Exception {
        PromptGroupInterface promptGroup = this.getPromptGroup();
        this._componentAndSubGroupModels.clear();
        List subGroups = promptGroup.getPromptSubgroups(false);
        if (subGroups == null) {
            subGroups = Collections.EMPTY_LIST;
        }
        List<PromptDefinitionInterface> promptDefs = promptGroup.getPromptDefinitions(false);
        List promptComponentModels = ListFactory.newList((int)promptDefs.size());
        List<?> allItems = promptGroup.getPromptDefinitionsAndSubgroups();
        List subGroupModels = ListFactory.newList((int)subGroups.size());
        if (promptGroup instanceof ModalGroupInterface) {
            ModalGroupDefinition def = (ModalGroupDefinition)((ModalGroupInterface)promptGroup).getChoiceDefinition();
            PromptComponentModelInterface promptComponentModel = null;
            promptComponentModel = this.newPromptComponentModel(((ModalGroupInterface)promptGroup).getChoiceDefinition());
            promptComponentModels.add(promptComponentModel);
            this._componentAndSubGroupModels.add(promptComponentModel);
            List modalGroupList = def.getModalChoiceGroups((ModalGroupInterface)promptGroup);
            List modalGroupPanelModelList = ListFactory.newList((int)modalGroupList.size());
            for (PromptGroupInterface modalChoiceGroup : modalGroupList) {
                PromptGroupPanelModelInterface modalChoiceGroupModel = this.newSubGroupModel(modalChoiceGroup);
                modalGroupPanelModelList.add(modalChoiceGroupModel);
                this._componentAndSubGroupModels.add(modalChoiceGroupModel);
                subGroupModels.add(modalChoiceGroupModel);
            }
            if (promptComponentModel != null) {
                this._modalGroupModels.put(promptComponentModel, modalGroupPanelModelList);
            }
        }
        for (Object obj : allItems) {
            if (obj instanceof PromptDefinitionInterface && !(obj instanceof ModalGroupDefinition)) {
                PromptComponentModelInterface promptComponentModel = this.newPromptComponentModel((PromptDefinitionInterface)obj);
                promptComponentModels.add(promptComponentModel);
                this._componentAndSubGroupModels.add(promptComponentModel);
                continue;
            }
            if (!(obj instanceof PromptGroupInterface) || obj instanceof ModalChoiceGroupInterface) continue;
            PromptGroupInterface subGroup = (PromptGroupInterface)obj;
            PromptGroupPanelModelInterface groupModel = this.newSubGroupModel(subGroup);
            subGroupModels.add(groupModel);
            this._componentAndSubGroupModels.add(groupModel);
            if (!(subGroup instanceof TransparentGroupInterface)) continue;
            promptComponentModels.addAll(groupModel.getObjects(2));
            subGroupModels.addAll(groupModel.getObjects(3));
        }
        this._subGroupModels.clear();
        this._subGroupModels.addAll(subGroupModels);
        this._promptComponentModels.clear();
        this._promptComponentModels.addAll(promptComponentModels);
        this._label = promptGroup.getPromptGroupLabel(this._locale);
    }

    @Override
    public String getLabel() {
        return this._label;
    }

    protected PromptComponentModelInterface newPromptComponentModel(PromptDefinitionInterface promptDefinition) throws Exception {
        DefaultPromptComponentModel promptComponentModel = new DefaultPromptComponentModel(promptDefinition, this.getPromptValues(), this.getLocale());
        promptComponentModel.setDynamicPromptValuesContext(this.getDynamicPromptValueContext());
        promptComponentModel.initialize();
        return promptComponentModel;
    }

    protected PromptGroupPanelModelInterface newSubGroupModel(PromptGroupInterface subGroup) throws Exception {
        DefaultPromptGroupPanelModel groupModel = new DefaultPromptGroupPanelModel(subGroup, this.getPromptValues(), this.getLocale());
        groupModel.setParentModel(this.getEmbeddingPropertiesPanelModel());
        groupModel.setDynamicPromptValueContext(this.getDynamicPromptValueContext());
        groupModel.initialize();
        return groupModel;
    }

    @Override
    public boolean isHiddenGroup() {
        return this._promptGroup.isPromptGroupHidden();
    }

    public String getModalChoiceGroupValue() {
        if (this._promptGroup instanceof ModalChoiceGroupInterface) {
            return ((ModalChoiceGroupInterface)this._promptGroup).getValue();
        }
        return null;
    }

    @Override
    public List getModalGroups(PromptComponentModelInterface promptComponent) {
        if (this._modalGroupModels.size() > 0) {
            return (List)this._modalGroupModels.get(promptComponent);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public PromptGroupPanelModelInterface getSelectedModalChoiceGroup(PromptComponentModelInterface promptComponent) {
        if (promptComponent != null && promptComponent.isPromptValueAvailable() && promptComponent.getPromptDefinition() instanceof ModalGroupDefinition) {
            Object value = promptComponent.getPromptValue();
            List modalGroups = this.getModalGroups(promptComponent);
            if (modalGroups != null && !modalGroups.isEmpty()) {
                for (PromptGroupPanelModelInterface modalGroup : modalGroups) {
                    if (modalGroup.getGroupType() != PromptGroupEnum.ModalChoice || !Util.equal((Object)value, (Object)((ModalChoiceGroupInterface)((DefaultPromptGroupPanelModel)modalGroup).getPromptGroup()).getValue())) continue;
                    return modalGroup;
                }
            }
        }
        return null;
    }

    public DynamicPromptValueContextInterface getDynamicPromptValueContext() {
        return this.dynamicPromptValueContext;
    }

    public void setDynamicPromptValueContext(DynamicPromptValueContextInterface dynamicPromptValueContext) {
        this.dynamicPromptValueContext = dynamicPromptValueContext;
    }
}

