/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.restsupport.query;

import com.sas.commons.expr.Expression;
import com.sas.commons.expr.SortKey;
import com.sas.commons.restsupport.query.QueryOptions;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class QueryResult<T>
implements Serializable {
    public static final long UKNOWN_COUNT_VALUE = -1L;
    private static final long serialVersionUID = 1L;
    private QueryOptions request;
    private List<T> resultList;
    private long count;

    public QueryResult(@NonNull QueryOptions request, @NonNull List<T> resultList, int count) {
        this.request = request;
        this.resultList = resultList;
        this.count = count;
    }

    @NonNull
    public QueryOptions getQueryOptions() {
        return this.request;
    }

    public long getStart() {
        return this.request.getStart();
    }

    public int getLimit() {
        return this.request.getLimit();
    }

    @Nullable
    public Expression getFilter() {
        return this.request.getFilter();
    }

    @Nullable
    public List<SortKey> getSortKeys() {
        return this.request.getSortKeys();
    }

    @Nullable
    public Locale getLocale() {
        return this.request.getLocale();
    }

    @NonNull
    public List<T> getResultList() {
        if (this.resultList == null) {
            return Collections.emptyList();
        }
        return this.resultList;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public int hashCode() {
        return new HashCodeBuilder(47, 17).append((Object)this.request).append(this.resultList).append(this.count).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        QueryResult rhs = (QueryResult)obj;
        return new EqualsBuilder().append((Object)this.request, (Object)rhs.request).append(this.resultList, rhs.resultList).append(this.count, rhs.count).isEquals();
    }

    public String toString() {
        return this.request.toString() + "\n" + this.resultList.size() + " objects returned out of " + this.count;
    }
}

