/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Error;
import com.sas.launcher.client.Function;
import com.sas.launcher.client.Host;
import com.sas.launcher.client.KerberosSPN;
import com.sas.launcher.client.LauncherRuntimeException;
import com.sas.launcher.client.Objects;
import com.sas.launcher.client.Optional;
import com.sas.launcher.client.Port;
import com.sas.launcher.client.Predicate;
import com.sas.launcher.client.Server;
import com.sas.launcher.client.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TKServer
implements Server {
    private static final Logger logger = LoggerFactory.getLogger(TKServer.class);
    private static final String DEFAULT_GSSAPI_SERVICE_CLASS = "sas-launcher";
    private final Host host;
    private final Port port;
    private final Boolean gridEnabled;
    private final Boolean sslEnabled;
    private final KerberosSPN spn;

    private TKServer(final Builder builder) {
        try {
            this.host = Optional.ofNullable(builder.host).orElseThrow(new Supplier<Throwable>(){

                @Override
                public Throwable get() {
                    return new LauncherRuntimeException(Error.Type.INVALID_HOSTNAME.toError(builder.host));
                }
            });
            this.port = Optional.ofNullable(builder.port).filter(new Predicate<Port>(){

                @Override
                public boolean test(Port port) {
                    return !port.equals(Port.create(0));
                }
            }).orElseThrow(new Supplier<Throwable>(){

                @Override
                public Throwable get() {
                    return new LauncherRuntimeException(Error.Type.INVALID_PORT.toError(Optional.ofNullable(builder.port).map(new Function<Port, Integer>(){

                        @Override
                        public Integer apply(Port port) {
                            return port.getPort();
                        }
                    }).orElse(null)));
                }
            });
            this.gridEnabled = Optional.ofNullable(builder.gridEnabled).orElse(false);
            this.sslEnabled = Optional.ofNullable(builder.sslEnabled).orElse(false);
            this.spn = Optional.ofNullable(builder.spn).orElse(KerberosSPN.create(DEFAULT_GSSAPI_SERVICE_CLASS, this.host));
        }
        catch (Throwable cause) {
            logger.debug("Failed to create Launcher Server object: " + cause.getMessage(), cause);
            throw new LauncherRuntimeException(Error.Type.INVALID_SERVER.toError(new Object[0]), cause);
        }
    }

    static Server create(Host host, Port port, Boolean sslEnabled) {
        return TKServer.builder(host, port, sslEnabled).build();
    }

    static Builder builder(Host host, Port port, Boolean sslEnabled) {
        return new Builder(host, port, sslEnabled);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TKServer tkServer = (TKServer)o;
        return Objects.equals(this.host, tkServer.host) && Objects.equals(this.port, tkServer.port);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public String toString() {
        return "TKServer{host=" + this.host + ", port=" + this.port + ", gridEnabled=" + this.gridEnabled + ", sslEnabled=" + this.sslEnabled + ", spn=" + this.spn + '}';
    }

    @Override
    public Host getHost() {
        return this.host;
    }

    @Override
    public Port getPort() {
        return this.port;
    }

    @Override
    public Boolean isGridEnabled() {
        return this.gridEnabled;
    }

    @Override
    public Boolean isSSLEnabled() {
        return this.sslEnabled;
    }

    @Override
    public KerberosSPN getSPN() {
        return this.spn;
    }

    static class Builder {
        private final Host host;
        private final Port port;
        private final Boolean sslEnabled;
        private Boolean gridEnabled;
        private KerberosSPN spn;

        private Builder(Host host, Port port, Boolean sslEnabled) {
            this.host = host;
            this.port = port;
            this.sslEnabled = sslEnabled;
        }

        Builder gridEnabled(Boolean gridEnabled) {
            this.gridEnabled = gridEnabled;
            return this;
        }

        Builder spn(KerberosSPN spn) {
            this.spn = spn;
            return this;
        }

        Server build() {
            return new TKServer(this);
        }
    }
}

