/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.LaunchType;
import com.sas.launcher.client.Packet;
import com.sas.launcher.client.ServerProperties;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;

final class StatusPacket
extends Packet {
    private static final Charset charset = Charset.forName("UTF-8");
    private final ByteBuffer payload;

    private StatusPacket(LaunchType launchType, String uuid, ServerProperties properties) {
        ByteBuffer uuidBuffer = charset.encode(uuid);
        ByteBuffer propertiesBuffer = this.writeMap(properties.toMap());
        ByteBuffer payload = ByteBuffer.allocate(8 + uuidBuffer.limit() + 4 + 4 + propertiesBuffer.limit());
        payload.putInt(launchType.getId());
        payload.putInt(uuidBuffer.limit());
        payload.put(uuidBuffer.array(), 0, uuidBuffer.limit());
        payload.putInt(properties.count());
        payload.putInt(propertiesBuffer.limit());
        payload.put(propertiesBuffer.array(), 0, propertiesBuffer.limit());
        this.payload = payload;
    }

    static StatusPacket create(LaunchType launchType, String uuid, ServerProperties properties) {
        return new StatusPacket(launchType, uuid, properties);
    }

    private ByteBuffer writeMap(Map<String, String> map) {
        Integer totalSize = 0;
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            ByteBuffer key = charset.encode(entry.getKey());
            ByteBuffer value = charset.encode(entry.getValue());
            Integer size = 8 + key.limit() + value.limit();
            ByteBuffer data = ByteBuffer.allocate(size);
            data.putInt(key.limit());
            data.putInt(value.limit());
            data.put(key.array(), 0, key.limit());
            data.put(value.array(), 0, value.limit());
            data.clear();
            buffers.add(data);
            totalSize = totalSize + size;
        }
        ByteBuffer result = ByteBuffer.allocate(totalSize);
        for (ByteBuffer buffer : buffers) {
            result.put(buffer.array(), 0, buffer.limit());
        }
        result.clear();
        return result;
    }

    @Override
    public ByteBuffer getPayload() {
        ByteBuffer payload = ByteBuffer.allocate(this.payload.limit());
        payload.put(this.payload.array(), 0, this.payload.limit());
        payload.clear();
        return payload.asReadOnlyBuffer();
    }

    public String toString() {
        return "StatusPacket{payload=" + this.payload + '}';
    }
}

