/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Consumer;
import com.sas.launcher.client.Function;
import com.sas.launcher.client.GridArmCorrelator;
import com.sas.launcher.client.GridFlags;
import com.sas.launcher.client.GridHostList;
import com.sas.launcher.client.GridInitOptions;
import com.sas.launcher.client.GridJobName;
import com.sas.launcher.client.GridJobOptions;
import com.sas.launcher.client.GridProvider;
import com.sas.launcher.client.GridResources;
import com.sas.launcher.client.Host;
import com.sas.launcher.client.Objects;
import com.sas.launcher.client.Optional;
import com.sas.launcher.client.Port;
import com.sas.launcher.client.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class ServerProperties {
    private static final String GRID_PROVIDER = "grid.init.provider";
    private static final String GRID_SERVER_HOST = "grid.init.serverHost";
    private static final String GRID_SERVER_PORT = "grid.init.serverPort";
    private static final String GRID_INIT_OPTIONS = "grid.init.options";
    private static final String GRID_JOB_OPTIONS = "grid.job.options";
    private static final String GRID_JOB_NAME = "grid.job.jobName";
    private static final String GRID_RESOURCES = "grid.job.resources";
    private static final String GRID_ARM_CORRELATOR = "grid.job.armCorrelator";
    private static final String GRID_HOST_LIST = "grid.job.hostList";
    private static final String GRID_BATCH_JOB = "grid.job.batchJob";
    private static final String GRID_RESTARTABLE = "grid.job.restartable";
    private final GridProvider gridProvider;
    private final Host gridServerHost;
    private final Port gridServerPort;
    private final GridInitOptions gridInitOptions;
    private final GridJobOptions gridJobOptions;
    private final GridJobName gridJobName;
    private final GridResources gridResources;
    private final GridArmCorrelator gridArmCorrelator;
    private final GridHostList gridHostList;
    private final GridFlags gridFlags;

    private ServerProperties(Builder builder) {
        this.gridProvider = null;
        this.gridServerHost = null;
        this.gridServerPort = null;
        this.gridInitOptions = null;
        this.gridJobOptions = null;
        this.gridJobName = null;
        this.gridResources = null;
        this.gridArmCorrelator = null;
        this.gridHostList = null;
        this.gridFlags = null;
    }

    private ServerProperties(GridBuilder gridBuilder) {
        this.gridProvider = gridBuilder.gridProvider;
        this.gridServerHost = gridBuilder.gridServerHost;
        this.gridServerPort = gridBuilder.gridServerPort;
        this.gridInitOptions = gridBuilder.gridInitOptions;
        this.gridJobOptions = gridBuilder.gridJobOptions;
        this.gridJobName = gridBuilder.gridJobName;
        this.gridResources = gridBuilder.gridResources;
        this.gridArmCorrelator = gridBuilder.gridArmCorrelator;
        this.gridHostList = gridBuilder.gridHostList;
        this.gridFlags = gridBuilder.gridFlagsBuilder.build();
    }

    static ServerProperties create() {
        return ServerProperties.builder().build();
    }

    static Builder builder() {
        return new Builder();
    }

    static ServerProperties fromMap(Map<String, String> map) {
        Builder builder = ServerProperties.builder();
        if (map.get(GRID_PROVIDER) != null) {
            return builder.grid(GridProvider.fromString(map.get(GRID_PROVIDER))).serverHost(Optional.ofNullable(map.get(GRID_SERVER_HOST)).map(new Function<String, Host>(){

                @Override
                public Host apply(String host) {
                    return Host.create(host);
                }
            }).orElse(null)).serverPort(Optional.ofNullable(map.get(GRID_SERVER_PORT)).map(new Function<String, Port>(){

                @Override
                public Port apply(String port) {
                    return Port.create(port);
                }
            }).orElse(null)).initOptions(Optional.ofNullable(map.get(GRID_INIT_OPTIONS)).map(new Function<String, GridInitOptions>(){

                @Override
                public GridInitOptions apply(String gridInitOptions) {
                    return GridInitOptions.create(gridInitOptions);
                }
            }).orElse(null)).jobOptions(Optional.ofNullable(map.get(GRID_JOB_OPTIONS)).map(new Function<String, GridJobOptions>(){

                @Override
                public GridJobOptions apply(String gridJobOptions) {
                    return GridJobOptions.create(gridJobOptions);
                }
            }).orElse(null)).jobName(Optional.ofNullable(map.get(GRID_JOB_NAME)).map(new Function<String, GridJobName>(){

                @Override
                public GridJobName apply(String gridJobName) {
                    return GridJobName.create(gridJobName);
                }
            }).orElse(null)).resources(Optional.ofNullable(map.get(GRID_RESOURCES)).map(new Function<String, GridResources>(){

                @Override
                public GridResources apply(String gridResources) {
                    return GridResources.create(gridResources);
                }
            }).orElse(null)).armCorrelator(Optional.ofNullable(map.get(GRID_ARM_CORRELATOR)).map(new Function<String, GridArmCorrelator>(){

                @Override
                public GridArmCorrelator apply(String gridArmCorrelator) {
                    return GridArmCorrelator.create(gridArmCorrelator);
                }
            }).orElse(null)).hostList(Optional.ofNullable(map.get(GRID_HOST_LIST)).map(new Function<String, GridHostList>(){

                @Override
                public GridHostList apply(String gridHostList) {
                    return GridHostList.create(gridHostList);
                }
            }).orElse(null)).batchJob(Optional.ofNullable(map.get(GRID_BATCH_JOB)).map(new Function<String, Boolean>(){

                @Override
                public Boolean apply(String gridBatchJob) {
                    return Boolean.parseBoolean(gridBatchJob);
                }
            }).orElse(null)).restartable(Optional.ofNullable(map.get(GRID_RESTARTABLE)).map(new Function<String, Boolean>(){

                @Override
                public Boolean apply(String gridRestartable) {
                    return Boolean.parseBoolean(gridRestartable);
                }
            }).orElse(null)).build();
        }
        return builder.build();
    }

    Optional<GridProvider> getGridProvider() {
        return Optional.ofNullable(this.gridProvider);
    }

    Optional<Host> getGridServerHost() {
        return Optional.ofNullable(this.gridServerHost);
    }

    Optional<Port> getGridServerPort() {
        return Optional.ofNullable(this.gridServerPort);
    }

    Optional<GridInitOptions> getGridInitOptions() {
        return Optional.ofNullable(this.gridInitOptions);
    }

    Optional<GridJobOptions> getGridJobOptions() {
        return Optional.ofNullable(this.gridJobOptions);
    }

    Optional<GridJobName> getGridJobName() {
        return Optional.ofNullable(this.gridJobName);
    }

    Optional<GridResources> getGridResources() {
        return Optional.ofNullable(this.gridResources);
    }

    Optional<GridArmCorrelator> getGridArmCorrelator() {
        return Optional.ofNullable(this.gridArmCorrelator);
    }

    Optional<GridHostList> getGridHostList() {
        return Optional.ofNullable(this.gridHostList);
    }

    Boolean isGridBatchJob() {
        return Optional.ofNullable(this.gridFlags).map(new Function<GridFlags, Boolean>(){

            @Override
            public Boolean apply(GridFlags gridFlags) {
                return gridFlags.isBatchJob();
            }
        }).orElse(false);
    }

    Boolean isGridRestartable() {
        return Optional.ofNullable(this.gridFlags).map(new Function<GridFlags, Boolean>(){

            @Override
            public Boolean apply(GridFlags gridFlags) {
                return gridFlags.isRestartable();
            }
        }).orElse(false);
    }

    Map<String, String> toMap() {
        final HashMap<String, String> map = new HashMap<String, String>();
        Optional.ofNullable(this.gridProvider).ifPresent(new Consumer<GridProvider>(){

            @Override
            public void accept(GridProvider gridProvider) {
                map.put(ServerProperties.GRID_PROVIDER, gridProvider.getCanonicalName());
            }
        });
        Optional.ofNullable(this.gridServerHost).ifPresent(new Consumer<Host>(){

            @Override
            public void accept(Host gridServerHost) {
                map.put(ServerProperties.GRID_SERVER_HOST, gridServerHost.getName());
            }
        });
        Optional.ofNullable(this.gridServerPort).ifPresent(new Consumer<Port>(){

            @Override
            public void accept(Port gridServerPort) {
                map.put(ServerProperties.GRID_SERVER_PORT, gridServerPort.getPortString());
            }
        });
        Optional.ofNullable(this.gridInitOptions).ifPresent(new Consumer<GridInitOptions>(){

            @Override
            public void accept(GridInitOptions gridInitOptions) {
                map.put(ServerProperties.GRID_INIT_OPTIONS, gridInitOptions.getOptions().orElse(null));
            }
        });
        Optional.ofNullable(this.gridJobOptions).ifPresent(new Consumer<GridJobOptions>(){

            @Override
            public void accept(GridJobOptions gridJobOptions) {
                map.put(ServerProperties.GRID_JOB_OPTIONS, gridJobOptions.getOptions().orElse(null));
            }
        });
        Optional.ofNullable(this.gridJobName).ifPresent(new Consumer<GridJobName>(){

            @Override
            public void accept(GridJobName gridJobName) {
                map.put(ServerProperties.GRID_JOB_NAME, gridJobName.getJobName().orElse(null));
            }
        });
        Optional.ofNullable(this.gridResources).ifPresent(new Consumer<GridResources>(){

            @Override
            public void accept(GridResources gridResources) {
                map.put(ServerProperties.GRID_RESOURCES, gridResources.getResources().orElse(null));
            }
        });
        Optional.ofNullable(this.gridArmCorrelator).ifPresent(new Consumer<GridArmCorrelator>(){

            @Override
            public void accept(GridArmCorrelator gridArmCorrelator) {
                map.put(ServerProperties.GRID_ARM_CORRELATOR, gridArmCorrelator.getArmCorrelator().orElse(null));
            }
        });
        Optional.ofNullable(this.gridHostList).ifPresent(new Consumer<GridHostList>(){

            @Override
            public void accept(GridHostList gridHostList) {
                map.put(ServerProperties.GRID_HOST_LIST, gridHostList.getHostList().orElse(null));
            }
        });
        Optional.ofNullable(this.gridFlags).map(new Function<GridFlags, Boolean>(){

            @Override
            public Boolean apply(GridFlags gridFlags) {
                return gridFlags.isBatchJob();
            }
        }).filter(new Predicate<Boolean>(){

            @Override
            public boolean test(Boolean isBatchJob) {
                return isBatchJob;
            }
        }).ifPresent(new Consumer<Boolean>(){

            @Override
            public void accept(Boolean isBatchJob) {
                map.put(ServerProperties.GRID_BATCH_JOB, isBatchJob.toString());
            }
        });
        Optional.ofNullable(this.gridFlags).map(new Function<GridFlags, Boolean>(){

            @Override
            public Boolean apply(GridFlags gridFlags) {
                return gridFlags.isRestartable();
            }
        }).filter(new Predicate<Boolean>(){

            @Override
            public boolean test(Boolean isRestartable) {
                return isRestartable;
            }
        }).ifPresent(new Consumer<Boolean>(){

            @Override
            public void accept(Boolean isRestartable) {
                map.put(ServerProperties.GRID_RESTARTABLE, isRestartable.toString());
            }
        });
        return map;
    }

    Integer count() {
        return this.toMap().size();
    }

    Iterable<Property> all() {
        ArrayList<Property> serverProperties = new ArrayList<Property>();
        for (Map.Entry<String, String> entry : this.toMap().entrySet()) {
            serverProperties.add(Property.create(entry.getKey(), entry.getValue()));
        }
        return serverProperties;
    }

    public String toString() {
        return "ServerProperties{gridProvider=" + (Object)((Object)this.gridProvider) + ", gridServerHost=" + this.gridServerHost + ", gridServerPort=" + this.gridServerPort + ", gridInitOptions=" + this.gridInitOptions + ", gridJobOptions=" + this.gridJobOptions + ", gridJobName=" + this.gridJobName + ", gridResources=" + this.gridResources + ", gridArmCorrelator=" + this.gridArmCorrelator + ", gridHostList=" + this.gridHostList + ", gridFlags=" + this.gridFlags + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerProperties that = (ServerProperties)o;
        return this.gridProvider == that.gridProvider && Objects.equals(this.gridServerHost, that.gridServerHost) && Objects.equals(this.gridServerPort, that.gridServerPort) && Objects.equals(this.gridInitOptions, that.gridInitOptions) && Objects.equals(this.gridJobOptions, that.gridJobOptions) && Objects.equals(this.gridJobName, that.gridJobName) && Objects.equals(this.gridResources, that.gridResources) && Objects.equals(this.gridArmCorrelator, that.gridArmCorrelator) && Objects.equals(this.gridHostList, that.gridHostList) && Objects.equals(this.gridFlags, that.gridFlags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.gridProvider, this.gridServerHost, this.gridServerPort, this.gridInitOptions, this.gridJobOptions, this.gridJobName, this.gridResources, this.gridArmCorrelator, this.gridHostList, this.gridFlags});
    }

    static class Property {
        private final String name;
        private final String value;

        private Property(String name, String value) {
            this.name = name;
            this.value = value;
        }

        private static Property create(String name, String value) {
            return new Property(name, value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Property property = (Property)o;
            return Objects.equals(this.name, property.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return "Property{name='" + this.name + '\'' + ", value='" + this.value + '\'' + '}';
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }
    }

    static class GridBuilder {
        private final Builder builder;
        private final GridProvider gridProvider;
        private final GridFlags.Builder gridFlagsBuilder;
        private Host gridServerHost;
        private Port gridServerPort;
        private GridInitOptions gridInitOptions;
        private GridJobOptions gridJobOptions;
        private GridJobName gridJobName;
        private GridResources gridResources;
        private GridArmCorrelator gridArmCorrelator;
        private GridHostList gridHostList;

        private GridBuilder(Builder builder, GridProvider gridProvider) {
            this.builder = builder;
            this.gridProvider = gridProvider;
            this.gridFlagsBuilder = GridFlags.builder();
        }

        GridBuilder serverHost(Host gridServerHost) {
            this.gridServerHost = gridServerHost;
            return this;
        }

        GridBuilder serverPort(Port gridServerPort) {
            this.gridServerPort = gridServerPort;
            return this;
        }

        GridBuilder initOptions(GridInitOptions gridInitOptions) {
            this.gridInitOptions = gridInitOptions;
            return this;
        }

        GridBuilder jobOptions(GridJobOptions gridJobOptions) {
            this.gridJobOptions = gridJobOptions;
            return this;
        }

        GridBuilder jobName(GridJobName gridJobName) {
            this.gridJobName = gridJobName;
            return this;
        }

        GridBuilder resources(GridResources gridResources) {
            this.gridResources = gridResources;
            return this;
        }

        GridBuilder armCorrelator(GridArmCorrelator gridArmCorrelator) {
            this.gridArmCorrelator = gridArmCorrelator;
            return this;
        }

        GridBuilder hostList(GridHostList gridHostList) {
            this.gridHostList = gridHostList;
            return this;
        }

        GridBuilder batchJob(Boolean gridBatchJob) {
            this.gridFlagsBuilder.batchJob(gridBatchJob);
            return this;
        }

        GridBuilder restartable(Boolean restartable) {
            this.gridFlagsBuilder.restartable(restartable);
            return this;
        }

        ServerProperties build() {
            return new ServerProperties(this);
        }
    }

    static class Builder {
        private Builder() {
        }

        GridBuilder grid(GridProvider gridProvider) {
            return new GridBuilder(this, gridProvider);
        }

        public ServerProperties build() {
            return new ServerProperties(this);
        }
    }
}

