/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Error;
import com.sas.launcher.client.LauncherRuntimeException;
import com.sas.launcher.client.OperatingSystem;
import com.sas.launcher.client.Packet;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServerInfoPacket
extends Packet {
    private static final Logger logger = LoggerFactory.getLogger(ServerInfoPacket.class);
    private static final String OPERATING_SYSTEM_KEY = "operating.system";
    private final OperatingSystem operatingSystem;
    private final ByteBuffer payload;

    private ServerInfoPacket(InputStream stream) {
        try {
            DataInputStream dataStream = new DataInputStream(stream);
            Integer payloadSize = dataStream.readInt();
            byte[] data = new byte[payloadSize.intValue()];
            dataStream.read(data, 0, payloadSize);
            ByteBuffer buffer = ByteBuffer.wrap(data);
            Map<String, Object> properties = this.readMap(buffer);
            if (!properties.containsKey(OPERATING_SYSTEM_KEY)) {
                throw new LauncherRuntimeException(Error.Type.FAILED_TO_DETERMINE_LAUNCHER_SERVER_OPERATING_SYSTEM.toError(new Object[0]));
            }
            String operatingSystem = StringUtils.deleteWhitespace((String)((String)properties.get(OPERATING_SYSTEM_KEY)));
            this.operatingSystem = OperatingSystem.fromString(operatingSystem);
            buffer.clear();
            this.payload = buffer;
        }
        catch (IOException cause) {
            logger.debug("Failed to read server info packet: " + cause.getMessage(), (Throwable)cause);
            throw new LauncherRuntimeException(Error.Type.PACKET_READ_ERROR.toError(new Object[0]), (Throwable)cause);
        }
    }

    static ServerInfoPacket fromPacketPayload(InputStream stream) {
        return new ServerInfoPacket(stream);
    }

    private static String readString(ByteBuffer buffer) {
        Integer stringSize = buffer.getInt();
        byte[] string = new byte[stringSize.intValue()];
        buffer.get(string, 0, stringSize);
        return new String(string);
    }

    private Map<String, Object> readMap(ByteBuffer buffer) {
        Integer mapSize = buffer.getInt();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < mapSize; ++i) {
            String key = ServerInfoPacket.readString(buffer);
            if (OPERATING_SYSTEM_KEY.equals(key)) {
                String value = ServerInfoPacket.readString(buffer);
                map.put(key, value);
                continue;
            }
            Integer valueSize = buffer.getInt();
            byte[] value = new byte[valueSize.intValue()];
            buffer.get(value, 0, valueSize);
        }
        return map;
    }

    OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    @Override
    ByteBuffer getPayload() {
        return this.payload.asReadOnlyBuffer();
    }

    public String toString() {
        return "ServerInfoPacket{operatingSystem=" + (Object)((Object)this.operatingSystem) + ", payload=" + this.payload + '}';
    }
}

