/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.FileStreamFactory;
import com.sas.launcher.client.Function;
import com.sas.launcher.client.Optional;
import com.sas.launcher.client.Password;
import com.sas.launcher.client.SSLObjectFactory;
import com.sas.launcher.client.SSLObjectUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

class SSLSocketFactoryBuilder {
    static final String SSL_PROTOCOL_DEFAULT = "TLSv1.2";
    private final SSLObjectFactory sslObjectFactory;
    private final SSLObjectUtils sslObjectUtils;
    private final FileStreamFactory fileStreamFactory;

    private SSLSocketFactoryBuilder(SSLObjectFactory sslObjectFactory, SSLObjectUtils sslObjectUtils, FileStreamFactory fileStreamFactory) {
        this.sslObjectFactory = sslObjectFactory;
        this.sslObjectUtils = sslObjectUtils;
        this.fileStreamFactory = fileStreamFactory;
    }

    static SSLSocketFactoryBuilder create(SSLObjectFactory sslObjectFactory, SSLObjectUtils sslObjectUtils, FileStreamFactory fileStreamFactory) {
        return new SSLSocketFactoryBuilder(sslObjectFactory, sslObjectUtils, fileStreamFactory);
    }

    Instance getInstance() {
        return new Instance();
    }

    class Instance {
        private String sslProtocol = "TLSv1.2";
        private String sslTrustManagerAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        private String sslTrustStoreType = KeyStore.getDefaultType();
        private String sslTrustStorePath = null;
        private Password sslTrustStorePassword = null;

        private Instance() {
        }

        Instance sslProtocol(String sslProtocol) {
            this.sslProtocol = sslProtocol;
            return this;
        }

        Instance sslTrustManagerAlgorithm(String sslTrustManagerAlgorithm) {
            this.sslTrustManagerAlgorithm = sslTrustManagerAlgorithm;
            return this;
        }

        Instance sslTrustStoreType(String sslTrustStoreType) {
            this.sslTrustStoreType = sslTrustStoreType;
            return this;
        }

        Instance sslTrustStorePath(String sslTrustStorePath) {
            this.sslTrustStorePath = sslTrustStorePath;
            return this;
        }

        Instance sslTrustStorePassword(Password sslTrustStorePassword) {
            this.sslTrustStorePassword = sslTrustStorePassword;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SSLSocketFactory build() throws IOException, NoSuchAlgorithmException, KeyStoreException, CertificateException, KeyManagementException {
            SSLContext sslContext = SSLSocketFactoryBuilder.this.sslObjectFactory.getSSLContext(this.sslProtocol);
            TrustManagerFactory trustManagerFactory = SSLSocketFactoryBuilder.this.sslObjectFactory.getTrustManagerFactory(this.sslTrustManagerAlgorithm);
            KeyStore trustStore = SSLSocketFactoryBuilder.this.sslObjectFactory.getKeyStore(this.sslTrustStoreType);
            if (this.sslTrustStorePath != null) {
                try (FileInputStream fileInputStream = SSLSocketFactoryBuilder.this.fileStreamFactory.getInputStream(this.sslTrustStorePath);){
                    char[] sslTrustStorePasswordArray = Optional.ofNullable(this.sslTrustStorePassword).map(new Function<Password, String>(){

                        @Override
                        public String apply(Password password) {
                            return password.unseal();
                        }
                    }).map(new Function<String, char[]>(){

                        @Override
                        public char[] apply(String password) {
                            return password.toCharArray();
                        }
                    }).orElse(null);
                    SSLSocketFactoryBuilder.this.sslObjectUtils.keyStoreLoad(trustStore, fileInputStream, sslTrustStorePasswordArray);
                }
            }
            SSLSocketFactoryBuilder.this.sslObjectUtils.trustFactoryManagerInit(trustManagerFactory, trustStore);
            SSLSocketFactoryBuilder.this.sslObjectUtils.sslContextInit(sslContext, SSLSocketFactoryBuilder.this.sslObjectUtils.getTrustManagerFactoryTrustManagers(trustManagerFactory));
            return SSLSocketFactoryBuilder.this.sslObjectUtils.getSSLContextSocketFactory(sslContext);
        }
    }
}

