/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Error;
import com.sas.launcher.client.LauncherRuntimeException;
import com.sas.launcher.client.Packet;
import com.sas.launcher.client.ProductCode;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.constant.Constable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ProductPacket
extends Packet {
    private static final Logger logger = LoggerFactory.getLogger(ProductPacket.class);
    private static final String PRODUCT_CODE_KEY = "product.code";
    private static final String PRODUCT_LICENSED_KEY = "product.licensed";
    private final ProductCode productCode;
    private final Boolean licensed;
    private final ByteBuffer payload;

    private ProductPacket(InputStream stream) {
        try {
            DataInputStream dataStream = new DataInputStream(stream);
            Integer payloadSize = dataStream.readInt();
            byte[] data = new byte[payloadSize.intValue()];
            dataStream.read(data, 0, payloadSize);
            ByteBuffer buffer = ByteBuffer.wrap(data);
            Map<String, Object> properties = this.readMap(buffer);
            this.productCode = ProductCode.create((Integer)properties.get(PRODUCT_CODE_KEY));
            this.licensed = properties.containsKey(PRODUCT_LICENSED_KEY) && properties.get(PRODUCT_LICENSED_KEY) instanceof Boolean ? (Boolean)properties.get(PRODUCT_LICENSED_KEY) : Boolean.valueOf(false);
            buffer.clear();
            this.payload = buffer;
        }
        catch (IOException cause) {
            logger.debug("Failed to read product packet: " + cause.getMessage(), (Throwable)cause);
            throw new LauncherRuntimeException(Error.Type.PACKET_READ_ERROR.toError(new Object[0]), (Throwable)cause);
        }
    }

    static ProductPacket fromPacketPayload(InputStream stream) {
        return new ProductPacket(stream);
    }

    private static String readString(ByteBuffer buffer) {
        Integer stringSize = buffer.getInt();
        byte[] string = new byte[stringSize.intValue()];
        buffer.get(string, 0, stringSize);
        return new String(string);
    }

    private static Integer readInteger(ByteBuffer buffer) {
        buffer.getInt();
        return buffer.getInt();
    }

    private static Boolean readBoolean(ByteBuffer buffer) {
        buffer.getInt();
        Integer value = buffer.getInt();
        return value == 1;
    }

    ProductCode getProductCode() {
        return this.productCode;
    }

    public String toString() {
        return "ProductPacket{productCode=" + this.productCode + ", licensed=" + this.licensed + ", payload=" + this.payload + '}';
    }

    Boolean getLicensed() {
        return this.licensed;
    }

    private Map<String, Object> readMap(ByteBuffer buffer) {
        Integer mapSize = buffer.getInt();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < mapSize; ++i) {
            Constable value;
            String key = ProductPacket.readString(buffer);
            if (PRODUCT_CODE_KEY.equals(key)) {
                value = ProductPacket.readInteger(buffer);
                map.put(key, value);
                continue;
            }
            if (PRODUCT_LICENSED_KEY.equals(key)) {
                value = ProductPacket.readBoolean(buffer);
                map.put(key, value);
                continue;
            }
            Integer valueSize = buffer.getInt();
            byte[] value2 = new byte[valueSize.intValue()];
            buffer.get(value2, 0, valueSize);
        }
        return map;
    }

    @Override
    ByteBuffer getPayload() {
        return this.payload.asReadOnlyBuffer();
    }
}

