/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Packet;
import com.sas.launcher.client.ProductCode;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

final class ProductInfoRequestPacket
extends Packet {
    private static final Charset charset = Charset.forName("UTF-8");
    private static final String PRODUCT_CODE_KEY = "product.code";
    private final ByteBuffer payload;

    private ProductInfoRequestPacket(ProductCode productCode) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put(PRODUCT_CODE_KEY, productCode.getValue());
        ByteBuffer properties = this.writeMap(requestMap);
        ByteBuffer payload = ByteBuffer.allocate(8 + properties.limit());
        payload.putInt(requestMap.size());
        payload.put(properties.array(), 0, properties.limit());
        this.payload = payload;
    }

    static ProductInfoRequestPacket create(ProductCode productCode) {
        return new ProductInfoRequestPacket(productCode);
    }

    public String toString() {
        return "ProductInfoRequestPacket{payload=" + this.payload + '}';
    }

    private ByteBuffer writeMap(Map<String, Object> map) {
        Integer totalSize = 0;
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            ByteBuffer key = charset.encode(entry.getKey());
            ByteBuffer value = ByteBuffer.allocate(0);
            if (PRODUCT_CODE_KEY.equals(entry.getKey())) {
                value = ByteBuffer.allocate(4);
                value.putInt((Integer)entry.getValue());
            }
            Integer size = 4 + key.limit() + 4 + value.limit();
            ByteBuffer data = ByteBuffer.allocate(size);
            data.putInt(key.limit());
            data.put(key.array(), 0, key.limit());
            data.putInt(value.limit());
            data.put(value.array(), 0, value.limit());
            data.clear();
            buffers.add(data);
            totalSize = totalSize + size;
        }
        ByteBuffer result = ByteBuffer.allocate(totalSize);
        for (ByteBuffer buffer : buffers) {
            result.put(buffer.array(), 0, buffer.limit());
        }
        result.clear();
        return result;
    }

    @Override
    public ByteBuffer getPayload() {
        ByteBuffer payload = ByteBuffer.allocate(this.payload.limit());
        payload.put(this.payload.array(), 0, this.payload.limit());
        payload.clear();
        return payload.asReadOnlyBuffer();
    }
}

